/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMw!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0004\u00131\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u001455\tAC\u0003\u0002\u0016-\u0005a1oY1mC2|wmZ5oO*\u0011q\u0003G\u0001\tif\u0004Xm]1gK*\t\u0011$A\u0002d_6L!a\u0007\u000b\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\u0006;%!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001I\u0005\u0005\u0002\u0005\nA!\\1j]R\u0011!%\n\t\u0003\u001b\rJ!\u0001\n\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006M}\u0001\raJ\u0001\u0005CJ<7\u000fE\u0002\u000eQ)J!!\u000b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-rcBA\u0007-\u0013\tic\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u000f\u0011\u0019\u0011\u0014\u0002\"\u0001\u0003g\u0005Y\u0001O]5oi\"+\u0017\rZ3s)\r\u0011C'\u000f\u0005\u0006kE\u0002\rAN\u0001\u0012g\"|w\u000fR3uC&dW\rZ*uCR\u001c\bCA\u00078\u0013\tAdBA\u0004C_>dW-\u00198\t\u000bi\n\u0004\u0019\u0001\u001c\u0002\u001dU\u001cXm\u00147e\u0007>t7/^7fe\")A(\u0003C\u0001{\u000591m\u001c8tk6,GC\u0004\u0012?!z\u001bW-a@\u0003\u0014\t]!1\u0004\u0005\u0006\u007fm\u0002\r\u0001Q\u0001\tG>t7/^7feB!\u0011I\u0013'M\u001b\u0005\u0011%BA D\u0015\t!U)A\u0004dY&,g\u000e^:\u000b\u0005\u00151%BA$I\u0003\u0019\t\u0007/Y2iK*\t\u0011*A\u0002pe\u001eL!a\u0013\"\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\ri\u0001&\u0014\t\u0003\u001b9K!a\u0014\b\u0003\t\tKH/\u001a\u0005\u0006#n\u0002\rAU\u0001\u0007i>\u0004\u0018nY:\u0011\u0007M[&F\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011qKB\u0001\u0007yI|w\u000e\u001e \n\u0003=I!A\u0017\b\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0005\u0019&\u001cHO\u0003\u0002[\u001d!)ql\u000fa\u0001A\u0006)1m\\;oiB\u0011Q\"Y\u0005\u0003E:\u0011A\u0001T8oO\")Am\u000fa\u0001A\u00069A/[7f_V$\b\"\u00024<\u0001\u00049\u0017AB2p]\u001aLw\r\u0005\u0002iS6\t\u0011B\u0002\u0003k\u0013\u0001Y'AE\"p]N,X.\u001a:QKJ47i\u001c8gS\u001e\u001c\"!\u001b7\u0011\u0005!i\u0017B\u00018\u0003\u0005)\u0001VM\u001d4D_:4\u0017n\u001a\u0005\tM%\u0014\t\u0011)A\u0005O!)Q$\u001bC\u0001cR\u0011qM\u001d\u0005\u0006MA\u0004\ra\n\u0005\bi&\u0014\r\u0011\"\u0001v\u00031Q8nQ8o]\u0016\u001cGo\u00149u+\u00051\bcA<{U5\t\u0001PC\u0001z\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0003wb\u00141$\u0011:hk6,g\u000e^!dG\u0016\u0004H/\u001b8h\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007BB?jA\u0003%a/A\u0007{W\u000e{gN\\3di>\u0003H\u000f\t\u0005\b\u007f&\u0014\r\u0011\"\u0001v\u0003M\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148o\u00149u\u0011\u001d\t\u0019!\u001bQ\u0001\nY\fACY8piN$(/\u00199TKJ4XM]:PaR\u0004\u0003\u0002CA\u0004S\n\u0007I\u0011A;\u0002\u0011Q|\u0007/[2PaRDq!a\u0003jA\u0003%a/A\u0005u_BL7m\u00149uA!A\u0011qB5C\u0002\u0013\u0005Q/\u0001\u0006he>,\b/\u00133PaRDq!a\u0005jA\u0003%a/A\u0006he>,\b/\u00133PaR\u0004\u0003\"CA\fS\n\u0007I\u0011AA\r\u000311W\r^2i'&TXm\u00149u+\t\tY\u0002\u0005\u0003xu\u0006u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0005Y\u0006twM\u0003\u0002\u0002(\u0005!!.\u0019<b\u0013\u0011\tY#!\t\u0003\u000f%sG/Z4fe\"A\u0011qF5!\u0002\u0013\tY\"A\u0007gKR\u001c\u0007nU5{K>\u0003H\u000f\t\u0005\n\u0003gI'\u0019!C\u0001\u0003k\tqC]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;\u0016\u0005\u0005]\u0002cA<\u0002:%\u0019\u00111\b=\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0005\u0002@%\u0004\u000b\u0011BA\u001c\u0003a\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H\u000f\t\u0005\n\u0003\u0007J'\u0019!C\u0001\u00033\t1c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaRD\u0001\"a\u0012jA\u0003%\u00111D\u0001\u0015g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0011\t\u0013\u0005-\u0013N1A\u0005\u0002\u0005e\u0011!\u00048v[RC'/Z1eg>\u0003H\u000f\u0003\u0005\u0002P%\u0004\u000b\u0011BA\u000e\u00039qW/\u001c+ie\u0016\fGm](qi\u0002B\u0011\"a\u0015j\u0005\u0004%\t!!\u0007\u0002\u001d9,XNR3uG\",'o](qi\"A\u0011qK5!\u0002\u0013\tY\"A\bok64U\r^2iKJ\u001cx\n\u001d;!\u0011%\tY&\u001bb\u0001\n\u0003\t)$\u0001\boK^\u001cuN\\:v[\u0016\u0014x\n\u001d;\t\u0011\u0005}\u0013\u000e)A\u0005\u0003o\tqB\\3x\u0007>t7/^7fe>\u0003H\u000f\t\u0005\t\u0003GJ'\u0019!C\u0001k\u0006\t2m\u001c8tk6,'oQ8oM&<w\n\u001d;\t\u000f\u0005\u001d\u0014\u000e)A\u0005m\u0006\u00112m\u001c8tk6,'oQ8oM&<w\n\u001d;!\u0011%\tY'\u001bb\u0001\n\u0003\t)$A\bqe&tG/T3ue&\u001c7o\u00149u\u0011!\ty'\u001bQ\u0001\n\u0005]\u0012\u0001\u00059sS:$X*\u001a;sS\u000e\u001cx\n\u001d;!\u0011%\t\u0019(\u001bb\u0001\n\u0003\t)$\u0001\u000btQ><H)\u001a;bS2,Gm\u0015;biN|\u0005\u000f\u001e\u0005\t\u0003oJ\u0007\u0015!\u0003\u00028\u0005)2\u000f[8x\t\u0016$\u0018-\u001b7fIN#\u0018\r^:PaR\u0004\u0003\"CA>S\n\u0007I\u0011AA?\u0003\u001dy\u0007\u000f^5p]N,\"!a \u0011\u0007]\f\t)C\u0002\u0002\u0004b\u0014\u0011b\u00149uS>t7+\u001a;\t\u0011\u0005\u001d\u0015\u000e)A\u0005\u0003\u007f\n\u0001b\u001c9uS>t7\u000f\t\u0005\tu%\u0014\r\u0011\"\u0001\u0002\fV\ta\u0007C\u0004\u0002\u0010&\u0004\u000b\u0011\u0002\u001c\u0002\u001fU\u001cXm\u00147e\u0007>t7/^7fe\u0002B\u0011\"a%j\u0005\u0004%\t!a#\u0002\u0019A\u0014\u0018N\u001c;NKR\u0014\u0018nY:\t\u000f\u0005]\u0015\u000e)A\u0005m\u0005i\u0001O]5oi6+GO]5dg\u0002B\u0011\"a'j\u0005\u0004%\t!!(\u0002\u000bA\u0014x\u000e]:\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u0016QE\u0001\u0005kRLG.\u0003\u0003\u0002*\u0006\r&A\u0003)s_B,'\u000f^5fg\"A\u0011QV5!\u0002\u0013\ty*\u0001\u0004qe>\u00048\u000f\t\u0005\n\u0003cK'\u0019!C\u0001\u0003g\u000b!B\\;n)\"\u0014X-\u00193t+\t\t)\fE\u0002\u000e\u0003oK1!!/\u000f\u0005\rIe\u000e\u001e\u0005\t\u0003{K\u0007\u0015!\u0003\u00026\u0006Ya.^7UQJ,\u0017\rZ:!\u0011%\t\t-\u001bb\u0001\n\u0003\t\u0019-A\u0003u_BL7-F\u0001+\u0011\u001d\t9-\u001bQ\u0001\n)\na\u0001^8qS\u000e\u0004\u0003\"CAfS\n\u0007I\u0011AAg\u0003-qW/\\'fgN\fw-Z:\u0016\u0003\u0001Dq!!5jA\u0003%\u0001-\u0001\u0007ok6lUm]:bO\u0016\u001c\b\u0005C\u0005\u0002V&\u0014\r\u0011\"\u0001\u00024\u0006\t\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197\t\u0011\u0005e\u0017\u000e)A\u0005\u0003k\u000b!C]3q_J$\u0018N\\4J]R,'O^1mA!AQ'\u001bb\u0001\n\u0003\tY\tC\u0004\u0002`&\u0004\u000b\u0011\u0002\u001c\u0002%MDwn\u001e#fi\u0006LG.\u001a3Ti\u0006$8\u000f\t\u0005\n\u0003GL'\u0019!C\u0001\u0003K\f!\u0002Z1uK\u001a{'/\\1u+\t\t9\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\u0011\ti/!\n\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003c\fYO\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"A\u0011Q_5!\u0002\u0013\t9/A\u0006eCR,gi\u001c:nCR\u0004\u0003\"CA}S\n\u0007I\u0011AAF\u0003)A\u0017\u000eZ3IK\u0006$WM\u001d\u0005\b\u0003{L\u0007\u0015!\u00037\u0003-A\u0017\u000eZ3IK\u0006$WM\u001d\u0011\t\u000f\t\u00051\b1\u0001\u0003\u0004\u0005\tBo\u001c;bY6+7o]1hKN\u0014V-\u00193\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u00051\u0011\r^8nS\u000eTAA!\u0004\u0002$\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tE!q\u0001\u0002\u000b\u0003R|W.[2M_:<\u0007b\u0002B\u000bw\u0001\u0007!1A\u0001\u000fi>$\u0018\r\u001c\"zi\u0016\u001c(+Z1e\u0011\u001d\u0011Ib\u000fa\u0001\u0005\u0007\t\u0001B[8j]RKW.\u001a\u0005\u0007\u0005;Y\u0004\u0019\u00011\u0002\u001bQ,7\u000f^*uCJ$H+[7f\u0011\u001d\u0011\t#\u0003C\u0001\u0005G\t\u0001\u0004\u001d:j]R|E\u000eZ\"p]N,X.\u001a:Qe><'/Z:t)E\u0011#Q\u0005B\u0015\u0005[\u0011\tD!\u000e\u0003:\tu\"\u0011\t\u0005\t\u0005O\u0011y\u00021\u0001\u00026\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005W\u0011y\u00021\u0001a\u0003%\u0011\u0017\u0010^3t%\u0016\fG\rC\u0004\u00030\t}\u0001\u0019\u00011\u0002\u001b1\f7\u000f\u001e\"zi\u0016\u001c(+Z1e\u0011\u001d\u0011\u0019Da\bA\u0002\u0001\fA\"\\3tg\u0006<Wm\u001d*fC\u0012DqAa\u000e\u0003 \u0001\u0007\u0001-\u0001\tmCN$X*Z:tC\u001e,7OU3bI\"9!1\bB\u0010\u0001\u0004\u0001\u0017aB:uCJ$Xj\u001d\u0005\b\u0005\u007f\u0011y\u00021\u0001a\u0003\u0015)g\u000eZ't\u0011!\t\u0019Oa\bA\u0002\u0005\u001d\bb\u0002B#\u0013\u0011\u0005!qI\u0001\u0019aJLg\u000e\u001e(fo\u000e{gn];nKJ\u0004&o\\4sKN\u001cHc\u0005\u0012\u0003J\t-#Q\nB(\u0005#\u0012\u0019F!\u0016\u0003X\te\u0003\u0002\u0003B\u0014\u0005\u0007\u0002\r!!.\t\u000f\t-\"1\ta\u0001A\"9!q\u0006B\"\u0001\u0004\u0001\u0007b\u0002B\u001a\u0005\u0007\u0002\r\u0001\u0019\u0005\b\u0005o\u0011\u0019\u00051\u0001a\u0011\u001d\u0011YDa\u0011A\u0002\u0001DqAa\u0010\u0003D\u0001\u0007\u0001\r\u0003\u0005\u0002d\n\r\u0003\u0019AAt\u0011\u001d\u0011YFa\u0011A\u0002\u0001\fA\u0003]3sS>$\u0017n\u0019&pS:$\u0016.\\3J]6\u001b\bb\u0002B0\u0013\u0011%!\u0011M\u0001\u0013aJLg\u000e\u001e\"bg&\u001c\u0007K]8he\u0016\u001c8\u000fF\t#\u0005G\u0012)Ga\u001a\u0003j\t-$Q\u000eB8\u0005cB\u0001Ba\n\u0003^\u0001\u0007\u0011Q\u0017\u0005\b\u0005W\u0011i\u00061\u0001a\u0011\u001d\u0011yC!\u0018A\u0002\u0001DqAa\r\u0003^\u0001\u0007\u0001\rC\u0004\u00038\tu\u0003\u0019\u00011\t\u000f\tm\"Q\fa\u0001A\"9!q\bB/\u0001\u0004\u0001\u0007\u0002CAr\u0005;\u0002\r!a:\t\u000f\tU\u0014\u0002\"\u0003\u0003x\u0005)\u0002O]5oi\u0016CH/\u001a8eK\u0012\u0004&o\\4sKN\u001cHc\u0004\u0012\u0003z\tm$Q\u0010B@\u0005\u0003\u0013\u0019I!\"\t\u000f\t-\"1\u000fa\u0001A\"9!q\u0006B:\u0001\u0004\u0001\u0007b\u0002B\u001a\u0005g\u0002\r\u0001\u0019\u0005\b\u0005o\u0011\u0019\b1\u0001a\u0011\u001d\u0011YDa\u001dA\u0002\u0001DqAa\u0010\u0003t\u0001\u0007\u0001\rC\u0004\u0003\\\tM\u0004\u0019\u00011\u0007\r\t%\u0015\u0002\u0001BF\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g)\"\u0014X-\u00193\u0014\t\t\u001d%Q\u0012\t\u0005\u0003?\u0011y)\u0003\u0003\u0003\u0012\u0006\u0005\"A\u0002+ie\u0016\fG\rC\u0006\u0003\u0016\n\u001d%\u0011!Q\u0001\n\u0005U\u0016\u0001\u0003;ie\u0016\fG-\u00133\t\u0015\te%q\u0011B\u0001B\u0003%!&\u0001\u0003oC6,\u0007b\u0003BO\u0005\u000f\u0013\t\u0011)A\u0005\u0005?\u000baa\u001d;sK\u0006l\u0007C\u0002BQ\u0005KcE*\u0004\u0002\u0003$*\u0011q\bB\u0005\u0005\u0005O\u0013\u0019KA\u0006LC\u001a\\\u0017m\u0015;sK\u0006l\u0007\"\u00034\u0003\b\n\u0005\t\u0015!\u0003h\u0011-\u0011\tAa\"\u0003\u0002\u0003\u0006IAa\u0001\t\u0017\tU!q\u0011B\u0001B\u0003%!1\u0001\u0005\f\u0005c\u00139I!A!\u0002\u0013\u0011\u0019,A\bd_:\u001cX/\\3s)&lWm\\;u!\u0011\u0011)A!.\n\t\t]&q\u0001\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000fu\u00119\t\"\u0001\u0003<R\u0001\"Q\u0018B`\u0005\u0003\u0014\u0019M!2\u0003H\n%'1\u001a\t\u0004Q\n\u001d\u0005\u0002\u0003BK\u0005s\u0003\r!!.\t\u000f\te%\u0011\u0018a\u0001U!A!Q\u0014B]\u0001\u0004\u0011y\n\u0003\u0004g\u0005s\u0003\ra\u001a\u0005\t\u0005\u0003\u0011I\f1\u0001\u0003\u0004!A!Q\u0003B]\u0001\u0004\u0011\u0019\u0001\u0003\u0005\u00032\ne\u0006\u0019\u0001BZ\u0011!\u0011yMa\"\u0005B\tE\u0017a\u0001:v]R\t!\u0005")
public final class ConsumerPerformance {
    public static Logger logger() {
        return ConsumerPerformance$.MODULE$.logger();
    }

    public static void printNewConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat, long l7) {
        ConsumerPerformance$.MODULE$.printNewConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat, l7);
    }

    public static void printOldConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printOldConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2, AtomicLong atomicLong3, long l3) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2, atomicLong3, l3);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default, so this option is deprecated and will be removed in a future release.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder printMetricsOpt = this.parser().accepts("print-metrics", "Print out the metrics. This only applies to new consumer.");
        private final OptionSpecBuilder showDetailedStatsOpt = this.parser().accepts("show-detailed-stats", "If set, stats are reported for each reporting interval as configured by reporting-interval");
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final boolean printMetrics;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSpecBuilder printMetricsOpt() {
            return this.printMetricsOpt;
        }

        public OptionSpecBuilder showDetailedStatsOpt() {
            return this.showDetailedStatsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public boolean printMetrics() {
            return this.printMetrics;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            this.printMetrics = this.options().has((OptionSpec)this.printMetricsOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.consumerConfigOpt()))) : new Properties();
            if (this.useOldConsumer()) {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            } else {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    Console$.MODULE$.err().println("The --new-consumer option is deprecated and will be removed in a future major release.The new consumer is used by default if the --bootstrap-server option is provided.");
                }
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter = this.stream.iterator();
                while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = iter.next();
                    ++messagesRead;
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                    if (this.config.showDetailedStats()) {
                        ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                    }
                    lastReportTime = currentTimeMillis;
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
                this.consumerTimeout.set(true);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

