/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.TopicDeletionManager$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0002{W&\u0011QE\t\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Y\u0001\u0001\"B\u0002'\u0001\u0004)\u0002\"\u0002\u000e'\u0001\u0004Y\u0002\"B\u0010'\u0001\u0004\u0001\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0019\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003QI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\u000f\t{w\u000e\\3b]\"1\u0011\t\u0001Q\u0001\na\nQ#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007\u0005C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002#Q|\u0007/[2t)>\u0014U\rR3mKR,G-F\u0001F!\r15*T\u0007\u0002\u000f*\u0011\u0001*S\u0001\b[V$\u0018M\u00197f\u0015\tQ%\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001T$\u0003\u0007M+G\u000f\u0005\u0002O#:\u0011\u0011bT\u0005\u0003!*\ta\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\u0019\u0019FO]5oO*\u0011\u0001K\u0003\u0005\u0007+\u0002\u0001\u000b\u0011B#\u0002%Q|\u0007/[2t)>\u0014U\rR3mKR,G\r\t\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003U\u0001\u0018M\u001d;ji&|gn\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012!\u0017\t\u0004\r.S\u0006CA.d\u001b\u0005a&BA/_\u0003\u0019\u0019w.\\7p]*\u0011Qa\u0018\u0006\u0003A\u0006\fa!\u00199bG\",'\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e9\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00024\u0001A\u0003%\u0011,\u0001\fqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3!\u0011\u001dA\u0007A1A\u0005\u0002\u0011\u000b1\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007B\u00026\u0001A\u0003%Q)\u0001\u000fu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0011\t\u000b1\u0004A\u0011A7\u0002\t%t\u0017\u000e\u001e\u000b\u0004]F4\bCA\u0005p\u0013\t\u0001(B\u0001\u0003V]&$\b\"\u0002:l\u0001\u0004\u0019\u0018\u0001G5oSRL\u0017\r\u001c+pa&\u001c7\u000fV8CK\u0012+G.\u001a;fIB\u0019A/^'\u000e\u0003%K!\u0001T%\t\u000b]\\\u0007\u0019A:\u0002E%t\u0017\u000e^5bYR{\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0011\u0015I\b\u0001\"\u0001{\u0003A!(/\u001f+pa&\u001cG)\u001a7fi&|g\u000eF\u0001o\u0011\u0015a\b\u0001\"\u0001{\u0003\u0015\u0011Xm]3u\u0011\u0015q\b\u0001\"\u0001\u0000\u0003a)g.];fk\u0016$v\u000e]5dg\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004]\u0006\u0005\u0001BBA\u0002{\u0002\u00071/\u0001\u0004u_BL7m\u001d\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0003]\u0011Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000fF\u0002o\u0003\u0017A\u0011\"a\u0001\u0002\u0006A\u0005\t\u0019A:\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005\u0019b-Y5m%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019a.a\u0005\t\u0011\u0005U\u0011Q\u0002a\u0001\u0003/\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0005iV\fI\u0002E\u0002\u0017\u00037I1!!\b\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\ta$\\1sWR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u00079\f)\u0003C\u0004\u0002\u0004\u0005}\u0001\u0019A:\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005a\u0012n\u001d+pa&\u001c\u0017J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BA\u0017\u0003c\u00012!CA\u0018\u0013\ty$\u0002C\u0004\u00024\u0005\u001d\u0002\u0019A'\u0002\u000bQ|\u0007/[2\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\u0011\ti#a\u000f\t\u000f\u0005M\u0012Q\u0007a\u0001\u001b\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013AF5t!\u0006\u0014H/\u001b;j_:$vNQ3EK2,G/\u001a3\u0015\t\u00055\u00121\t\u0005\b\u0003\u000b\ni\u00041\u0001[\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\u0011\ti#!\u0014\t\u000f\u0005M\u0012q\ta\u0001\u001b\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\rq\u0017Q\u000b\u0005\t\u0003+\ty\u00051\u0001\u0002\u0018!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0013AG5t)>\u0004\u0018nY#mS\u001eL'\r\\3G_J$U\r\\3uS>tG\u0003BA\u0017\u0003;Bq!a\r\u0002X\u0001\u0007Q\nC\u0004\u0002b\u0001!I!a\u0019\u000235\f'o\u001b+pa&\u001cgi\u001c:EK2,G/[8o%\u0016$(/\u001f\u000b\u0004]\u0006\u0015\u0004bBA\u001a\u0003?\u0002\r!\u0014\u0005\b\u0003S\u0002A\u0011BA6\u0003M\u0019w.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\rq\u0017Q\u000e\u0005\b\u0003g\t9\u00071\u0001N\u0011\u001d\t\t\b\u0001C\u0005\u0003g\nqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0004]\u0006U\u0004bBA\u0002\u0003_\u0002\ra\u001d\u0005\b\u0003s\u0002A\u0011BA>\u0003Q\u0019H/\u0019:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019a.! \t\u0011\u0005}\u0014q\u000fa\u0001\u0003/\tAD]3qY&\u001c\u0017m\u001d$peR{\u0007/[2t)>\u0014U\rR3mKR,G\rC\u0004\u0002\u0004\u0002!I!!\"\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u00079\f9\tC\u0004X\u0003\u0003\u0003\r!!#\u0011\u0007Q,(\f\u0003\u0004\u0002\u000e\u0002!IA_\u0001\u0010e\u0016\u001cX/\\3EK2,G/[8og\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111S\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u0003+S3a]ALW\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u0013Ut7\r[3dW\u0016$'bAAR\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0016Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    public final ControllerEventManager kafka$controller$TopicDeletionManager$$eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Set initialTopicsToBeDeleted$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " since delete topic is disabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}));
                }
                {
                    this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                }
            });
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq());
        }
    }

    public void tryTopicDeletion() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.resumeDeletions();
        }
    }

    public void reset() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion failed for replicas ", ". Halting deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halted deletion of topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion successfully completed for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final scala.collection.immutable.Set failedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying delete topic for topic ", " since replicas ", " were not successfully deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), OfflinePartition$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges$default$3());
        this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), NonExistentPartition$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicPartition x$2) {
                String string = x$2.topic();
                String string2 = this.topic$2;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        });
        this.zkClient.deleteTopicZNode(topic);
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        Set partitions = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        topics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion(this.$outer.controllerContext().partitionsForTopic(topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).keys().foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(PartitionAndReplica p) {
                        String string = p.topic();
                        String string2 = this.topic$3;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                });
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion started for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                });
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                    public final void apply(AbstractResponse stopReplicaResponseObj, int replicaId) {
                        this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived(this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controller, stopReplicaResponseObj, replicaId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead Replicas (", ") found for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$3 = topic$3;
                        }
                    });
                    this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                }
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicsQueuedForDeletion$1.mkString(",")}));
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            });
        }
        topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " successfully completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionAndReplica x$4) {
                            return x$4.replica();
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicPartition apply(PartitionAndReplica x$5) {
                            return x$5.topicPartition();
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    this.$outer.info((Function0<String>)new Serializable(this, replicaIds, partitions, topic){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Set replicaIds$1;
                        private final scala.collection.immutable.Set partitions$1;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion for replicas ", " for partition ", " of topic ", " in progress"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                        }
                        {
                            this.replicaIds$1 = replicaIds$1;
                            this.partitions$1 = partitions$1;
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " (re)started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not retrying deletion of topic ", " at this time since it is marked ineligible for deletion"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        this.kafka$controller$TopicDeletionManager$$eventManager = eventManager;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Topic Deletion Manager ", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controller.config().brokerId())})));
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

