/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tmd\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q\u0001$\u0001\u0003oC6,\u0007CA\b\u0016\u001d\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011ac\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\t\u0012BA\u0007\u001a\u0013\tQ2D\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$'B\u0001\u000f\u0005\u0003\u0015)H/\u001b7t\u0011%q\u0002A!A!\u0002\u0013yR%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u0013\"\u00059\u0011%o\\6fe\u0016sG\rU8j]RL!A\b\u0006\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!C\u0015\n\u0005)\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u0005/\u0013\ty#A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0011E\u0002!\u0011!Q\u0001\nI\nQ!];pi\u0006\u0004\"!C\u001a\n\u0005Q\u0012!a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011!1\u0004A!A!\u0002\u00139\u0014\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\tI\u0001(\u0003\u0002:\u0005\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo\u001d\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000furt\bQ!C\u0007B\u0011\u0011\u0002\u0001\u0005\u0006\u001bi\u0002\rA\u0004\u0005\u0006=i\u0002\ra\b\u0005\u0006Oi\u0002\r\u0001\u000b\u0005\u0006Yi\u0002\r!\f\u0005\u0006ci\u0002\rA\r\u0005\u0006mi\u0002\raN\u0003\u0005\u000b\u0002\u0001aIA\u0002S\u000bF\u0003\"aR-\u000f\u0005!{eBA%O\u001d\tQU*D\u0001L\u0015\tae!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0004\u0006!\nA\t!U\u0001\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\r\u0005\u0002\n%\u001a)\u0011A\u0001E\u0001'N\u0011!\u000b\u0016\t\u0003!UK!AV\t\u0003\r\u0005s\u0017PU3g\u0011\u0015Y$\u000b\"\u0001Y)\u0005\tf!\u0002.S\u0001\tY&\u0001\u0004$fi\u000eD'+Z9vKN$8cA-U9B\u0011Q\f\u0019\b\u0003\u0013yK!a\u0018\u0002\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&\u0011!,\u0019\u0006\u0003?\nA\u0001bY-\u0003\u0006\u0004%\t\u0001Z\u0001\u000bk:$WM\u001d7zS:<W#A3\u0011\u0005\u0019\u001chBA4r\u001b\u0005A'BA5k\u0003!\u0011X-];fgR\u001c(BA6m\u0003\u0019\u0019w.\\7p]*\u0011Q!\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sQ\u0006aa)\u001a;dQJ+\u0017/^3ti&\u0011A/\u001e\u0002\b\u0005VLG\u000eZ3s\u0015\t\u0011\b\u000e\u0003\u0005x3\n\u0005\t\u0015!\u0003f\u0003-)h\u000eZ3sYfLgn\u001a\u0011\t\u000bmJF\u0011A=\u0015\u0005id\bCA>Z\u001b\u0005\u0011\u0006\"B2y\u0001\u0004)\u0007\"\u0002@Z\t\u0003y\u0018aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u0003\u00012\u0001EA\u0002\u0013\r\t)!\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\tI!\u0017C\u0001\u0003\u0017\taa\u001c4gg\u0016$H\u0003BA\u0007\u0003'\u00012\u0001EA\b\u0013\r\t\t\"\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u0016\u0005\u001d\u0001\u0019AA\f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0007\u0002\u001c5\t!.C\u0002\u0002\u001e)\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\"e#\t%a\t\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005!A.\u00198h\u0015\t\ty#\u0001\u0003kCZ\f\u0017b\u0001\f\u0002*\u00199\u0011Q\u0007*\u0001\u0005\u0005]\"!\u0004)beRLG/[8o\t\u0006$\u0018mE\u0003\u00024Q\u000bI\u0004E\u0002^\u0003wI1!!\u000eb\u0011)\u0019\u00171\u0007BC\u0002\u0013\u0005\u0011qH\u000b\u0003\u0003\u0003\u0002b!a\u0011\u0002J\u00055cbA4\u0002F%\u0019\u0011q\t5\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\t)$a\u0013\u000b\u0007\u0005\u001d\u0003\u000e\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019F[\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005]\u0013\u0011\u000b\u0002\b%\u0016\u001cwN\u001d3t\u0011)9\u00181\u0007B\u0001B\u0003%\u0011\u0011\t\u0005\bw\u0005MB\u0011AA/)\u0011\ty&!\u0019\u0011\u0007m\f\u0019\u0004C\u0004d\u00037\u0002\r!!\u0011\t\u0011\u0005\u0015\u00141\u0007C\u0001\u0003O\nQ!\u001a:s_J,\"!!\u001b\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001ck\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA:\u0003[\u0012a!\u0012:s_J\u001c\b\u0002CA<\u0003g!\t!!\u001f\u0002\u0013Q|'+Z2pe\u0012\u001cXCAA>!\u0011\ty%! \n\t\u0005}\u0014\u0011\u000b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\u0005\r\u00151\u0007C\u0001\u0003\u000b\u000bQ\u0002[5hQ^\u000bG/\u001a:nCJ\\WCAA\u0007\u0011!\tI)a\r\u0005\u0002\u0005\u0015\u0015A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0003\u001b\u000b\u0019\u0004\"\u0001\u0002\u0010\u0006IQ\r_2faRLwN\\\u000b\u0003\u0003#\u0003R\u0001EAJ\u0003/K1!!&\u0012\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011TAR\u001d\u0011\tY*a(\u000f\u0007)\u000bi*C\u0001\u0013\u0013\r\t\t+E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)+a*\u0003\u0013QC'o\\<bE2,'bAAQ#!A\u0011\u0011EA\u001a\t\u0003\n\u0019#\u0002\u0004\u0002.\u0002\u0001\u0011q\u0016\u0002\u0003!\u0012\u00032aRA\u001a\u0011%\t\u0019\f\u0001b\u0001\n\u0013\t),A\u0005sKBd\u0017nY1JIV\u0011\u0011q\u0017\t\u0004!\u0005e\u0016bAA^#\t\u0019\u0011J\u001c;\t\u0011\u0005}\u0006\u0001)A\u0005\u0003o\u000b!B]3qY&\u001c\u0017-\u00133!\u0011%\t\u0019\r\u0001b\u0001\n\u0013\t)-\u0001\u0005nCb\u0014\u0015\u0010^3t+\t\t9\r\u0005\u0003\u0002(\u0005%\u0017\u0002BAf\u0003S\u0011q!\u00138uK\u001e,'\u000f\u0003\u0005\u0002P\u0002\u0001\u000b\u0011BAd\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b\u0005C\u0005\u0002T\u0002\u0011\r\u0011\"\u0003\u0002F\u0006Ia-\u001a;dQNK'0\u001a\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002H\u0006Qa-\u001a;dQNK'0\u001a\u0011\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006)a-\u001a;dQR!\u0011q\\Ay!\u0019\t\t/a:\u0002l6\u0011\u00111\u001d\u0006\u0004\u0003K\f\u0012AC2pY2,7\r^5p]&!\u0011\u0011^Ar\u0005\r\u0019V-\u001d\t\b!\u00055\u0018qCAX\u0013\r\ty/\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005M\u0018\u0011\u001ca\u0001\r\u0006aa-\u001a;dQJ+\u0017/^3ti\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\u0018\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002|\n\u0005!1\u0001B\u0004!\r\u0001\u0012Q`\u0005\u0004\u0003\u007f\f\"\u0001B+oSRD\u0001\"!\u0006\u0002v\u0002\u0007\u0011q\u0003\u0005\t\u0005\u000b\t)\u00101\u0001\u0002\u000e\u0005Ya-\u001a;dQ>3gm]3u\u0011!\u0011I!!>A\u0002\u0005=\u0016!\u00049beRLG/[8o\t\u0006$\u0018\rC\u0004\u0003\u000e\u0001!\tAa\u0004\u0002-!\fg\u000e\u001a7f\u001f\u001a47/\u001a;PkR|eMU1oO\u0016$B!!\u0004\u0003\u0012!A\u0011Q\u0003B\u0006\u0001\u0004\t9\u0002C\u0004\u0003\u0016\u0001!\tAa\u0006\u00025!\fg\u000e\u001a7f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000bJ\u0014xN]:\u0015\t\u0005m(\u0011\u0004\u0005\t\u00057\u0011\u0019\u00021\u0001\u0003\u001e\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005e%qDA\f\u0013\u0011\u0011\t#a*\u0003\u0011%#XM]1cY\u0016DqA!\n\u0001\t\u0003\u00119#A\fck&dG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiR!!\u0011\u0006B\u001c!\u001d\u0001\u0012Q\u001eB\u0016\u0005c\u0001\u0002\"!9\u0003.\u0005]\u0011qW\u0005\u0005\u0005_\t\u0019OA\u0002NCB\u0004b!!9\u00034\u0005]\u0011\u0002\u0002B\u001b\u0003G\u00141aU3u\u0011!\u0011IDa\tA\u0002\tm\u0012!D1mYB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0002b\u0006\u001d(Q\b\t\b!\u00055\u0018q\u0003B !\rI!\u0011I\u0005\u0004\u0005\u0007\u0012!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007b\u0002B$\u0001\u0011\u0005!\u0011J\u0001\u0016M\u0016$8\r[#q_\u000eD7O\u0012:p[2+\u0017\rZ3s)\u0011\u0011YEa\u0015\u0011\u0011\u0005\u0005(QFA\f\u0005\u001b\u00022a\u001aB(\u0013\r\u0011\t\u0006\u001b\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011!\u0011YB!\u0012A\u0002\t-\u0002b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\u000e[\u0006L(-\u001a+sk:\u001c\u0017\r^3\u0015\t\tm#1\u000e\t\u0007\u0005;\u0012yFa\u0019\u000f\u0005!s\u0016b\u0001B1C\n!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N\u0004\u0002\"!9\u0003.\u0005]!Q\r\t\u0004\u0013\t\u001d\u0014b\u0001B5\u0005\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007\u0002\u0003B7\u0005+\u0002\rAa\u0013\u0002\u001b\u0019,Go\u00195fI\u0016\u0003xn\u00195t\u0011\u001d\u0011\t\b\u0001C\u0001\u0005g\n\u0011CY;jY\u00124U\r^2i%\u0016\fX/Z:u)\u0011\u0011)Ha\u001e\u0011\u000b\tu#q\f$\t\u0011\te$q\u000ea\u0001\u0005w\tA\u0002]1si&$\u0018n\u001c8NCB\u0004")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    public final ReplicaManager kafka$server$ReplicaAlterLogDirsThread$$replicaMgr;
    public final ReplicationQuotaManager kafka$server$ReplicaAlterLogDirsThread$$quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        org.apache.kafka.common.requests.FetchRequest request = (org.apache.kafka.common.requests.FetchRequest)fetchRequest.underlying().build();
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)new Serializable(this, partitionData){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
            private final ObjectRef partitionData$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responsePartitionData) {
                this.$outer.kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(responsePartitionData, this.partitionData$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionData$1 = partitionData$1;
            }
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch data for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray()).mkString(",")})));
        }
        return (Seq)((Seq)partitionData.elem).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> x0$2) {
                Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition key = (TopicPartition)tuple2._1();
                    FetchResponse.PartitionData value2 = (FetchResponse.PartitionData)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData((FetchResponse.PartitionData<Records>)value2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica futureReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Partition partition = (Partition)this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        if (fetchOffset != futureReplica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset())})));
        }
        partition.appendRecordsToFollowerOrFutureReplica(records, true);
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset().messageOffset()), partitionData.highWatermark());
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset());
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.kafka$server$ReplicaAlterLogDirsThread$$quota.record(records.sizeInBytes());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica futureReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Replica currentReplica = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
        long logEndOffset2 = currentReplica.logEndOffset().messageOffset();
        if (logEndOffset2 < futureReplica.logEndOffset().messageOffset()) {
            this.warn((Function0<String>)new Serializable(this, topicPartition, futureReplica, logEndOffset2){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica futureReplica$1;
                private final long logEndOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's latest offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.futureReplica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)this.logEndOffset$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.futureReplica$1 = futureReplica$1;
                    this.logEndOffset$1 = logEndOffset$1;
                }
            });
            partition.truncateTo(logEndOffset2, true);
            l = logEndOffset2;
        } else {
            long currentReplicaStartOffset = currentReplica.logStartOffset();
            this.warn((Function0<String>)new Serializable(this, topicPartition, futureReplica, currentReplicaStartOffset){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica futureReplica$1;
                private final long currentReplicaStartOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's start offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.futureReplica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToLong((long)this.currentReplicaStartOffset$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.futureReplica$1 = futureReplica$1;
                    this.currentReplicaStartOffset$1 = currentReplicaStartOffset$1;
                }
            });
            long offsetToFetch = Math.max(currentReplicaStartOffset, futureReplica.logEndOffset().messageOffset());
            if (currentReplicaStartOffset > futureReplica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(currentReplicaStartOffset, true);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        if (partitions.nonEmpty()) {
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    @Override
    public Tuple2<Map<TopicPartition, Object>, Set<TopicPartition>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions2) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions2.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$3) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$3;
                if (tuple2 != null) {
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    boolean bl = state.isTruncatingLog();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            public final Tuple2<TopicPartition, Option<LeaderEpochFileCache>> apply(Tuple2<TopicPartition, PartitionFetchState> x0$4) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.$outer.kafka$server$ReplicaAlterLogDirsThread$$epochCacheOpt$1(tp));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Option<LeaderEpochFileCache>> x0$5) {
                Tuple2<TopicPartition, Option<LeaderEpochFileCache>> tuple2 = x0$5;
                if (tuple2 != null) {
                    Option epochCacheOpt2 = (Option)tuple2._2();
                    boolean bl = epochCacheOpt2.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(LeaderEpochFileCache x$3) {
                            return x$3.latestEpoch() != -1;
                        }
                    });
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
            scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
            scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Option<LeaderEpochFileCache>> x0$6) {
                    Tuple2<TopicPartition, Option<LeaderEpochFileCache>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Option epochCacheOpt2 = (Option)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochFileCache)epochCacheOpt2.get()).latestEpoch()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new Tuple2((Object)result, (Object)partitionsWithoutEpoch2.keys().toSet());
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return (Map)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2 tuple2;
                Tuple2<TopicPartition, Object> tuple22 = x0$7;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicPartition tp = (TopicPartition)tuple22._1();
                int epoch = tuple22._2$mcI$sp();
                try {
                    Tuple2.mcIJ.sp sp2;
                    Tuple2<Object, Object> tuple23 = this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(tp).endOffsetFor(epoch);
                    if (tuple23 == null) throw new MatchError(tuple23);
                    int leaderEpoch = tuple23._1$mcI$sp();
                    long leaderOffset = tuple23._2$mcJ$sp();
                    Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(leaderEpoch, leaderOffset);
                    int leaderEpoch2 = sp3._1$mcI$sp();
                    long leaderOffset2 = sp3._2$mcJ$sp();
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch2, leaderOffset2));
                    return tuple2;
                }
                catch (Throwable throwable) {
                    this.$outer.warn((Function0<String>)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when getting EpochEndOffset for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$1;

                        public final Throwable apply() {
                            return this.t$1;
                        }
                        {
                            this.t$1 = t$1;
                        }
                    });
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)throwable), -1, -1L));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1)new Serializable(this, fetchOffsets, partitionsWithError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;
            private final HashMap fetchOffsets$1;
            private final scala.collection.mutable.Set partitionsWithError$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<TopicPartition, EpochEndOffset> x0$8) {
                SetLike setLike;
                Tuple2<TopicPartition, EpochEndOffset> tuple2 = x0$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica futureReplica = this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
                    Partition partition = (Partition)this.$outer.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getPartition(topicPartition).get();
                    if (epochOffset.hasError()) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicPartition, epochOffset){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition topicPartition$2;
                            private final EpochEndOffset epochOffset$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the current replica reported an error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2, this.epochOffset$1.error()}));
                            }
                            {
                                this.topicPartition$2 = topicPartition$2;
                                this.epochOffset$1 = epochOffset$1;
                            }
                        });
                        setLike = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                        return setLike;
                    } else {
                        OffsetTruncationState offsetTruncationState = this.$outer.getOffsetTruncationState(topicPartition, epochOffset, futureReplica, true);
                        partition.truncateTo(offsetTruncationState.offset(), true);
                        setLike = this.fetchOffsets$1.put((Object)topicPartition, (Object)offsetTruncationState);
                    }
                    return setLike;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    this.$outer.info((Function0<String>)new Serializable(this, topicPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}));
                        }
                        {
                            this.topicPartition$2 = topicPartition$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                        public static final long serialVersionUID = 0L;
                        private final KafkaStorageException e$1;

                        public final KafkaStorageException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    setLike = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                }
                return setLike;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffsets$1 = fetchOffsets$1;
                this.partitionsWithError$1 = partitionsWithError$1;
            }
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        BoxedUnit boxedUnit;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaAlterLogDirsThread $outer;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$9) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$9;
                if (tuple2 != null) {
                    PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                    boolean bl = partitionFetchState.isReadyForFetch() && !this.$outer.kafka$server$ReplicaAlterLogDirsThread$$quota.isQuotaExceeded();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).reduceLeftOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final Tuple2<TopicPartition, PartitionFetchState> apply(Tuple2<TopicPartition, PartitionFetchState> left, Tuple2<TopicPartition, PartitionFetchState> right) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2;
                block3: {
                    block2: {
                        if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater((Object)((TopicPartition)right._1()).topic())) break block2;
                        String string = ((TopicPartition)left._1()).topic();
                        String string2 = ((TopicPartition)right._1()).topic();
                        if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                    }
                    tuple2 = left;
                    return tuple2;
                }
                tuple2 = right;
                return tuple2;
            }
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)maxPartitionOpt.get();
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            TopicPartition topicPartition = (TopicPartition)tuple22._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)topicPartition, (Object)partitionFetchState);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            PartitionFetchState partitionFetchState2 = (PartitionFetchState)tuple23._2();
            try {
                long logStartOffset2 = this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplicaOrException(topicPartition2, Request$.MODULE$.FutureLocalReplicaId()).logStartOffset();
                boxedUnit = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.fetchSize())));
            }
            catch (KafkaStorageException kafkaStorageException) {
                boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition2);
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    public final void kafka$server$ReplicaAlterLogDirsThread$$processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> apply(Tuple2<TopicPartition, FetchPartitionData> x0$1) {
                Tuple2<TopicPartition, FetchPartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    FetchPartitionData data = (FetchPartitionData)tuple2._2();
                    java.util.List abortedTransactions = (java.util.List)data.abortedTransactions().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final java.util.List<FetchResponse.AbortedTransaction> apply(List<FetchResponse.AbortedTransaction> x$1) {
                            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava();
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                    long lastStableOffset2 = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    }));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset2, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public final Option kafka$server$ReplicaAlterLogDirsThread$$epochCacheOpt$1(TopicPartition tp) {
        return this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr.getReplica(tp, Request$.MODULE$.FutureLocalReplicaId()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<LeaderEpochFileCache> apply(Replica x$2) {
                return x$2.epochs();
            }
        });
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.brokerConfig = brokerConfig2;
        this.kafka$server$ReplicaAlterLogDirsThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaAlterLogDirsThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig2.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig2.brokerId();
        this.maxBytes = brokerConfig2.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig2.replicaFetchMaxBytes();
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.underlying().fetchData()).asScala()).apply((Object)topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData<Records> underlying;

        public FetchResponse.PartitionData<Records> underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            MemoryRecords memoryRecords;
            BaseRecords baseRecords = this.underlying().records;
            MemoryRecords memoryRecords2 = MemoryRecords.EMPTY;
            if (!(baseRecords != null ? !baseRecords.equals(memoryRecords2) : memoryRecords2 != null)) {
                memoryRecords = (MemoryRecords)this.underlying().records;
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(this.underlying().records.sizeInBytes());
                ((FileRecords)this.underlying().records).readInto(buffer, 0);
                memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
            }
            return memoryRecords;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData<Records> underlying) {
            this.underlying = underlying;
        }
    }
}

