/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidatorTest$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012\u0001\u0002;j[\u0016,\u0012A\u0006\t\u0003/\u0005j\u0011\u0001\u0007\u0006\u00033i\tQ!\u001e;jYNT!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\t)QD\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u0019\u0005\u0011!\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019\u0015\u0003!\u0002\"!C\u0015\n\u0005)R!\u0001B+oSRD#!\n\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=z\u0012!\u00026v]&$\u0018BA\u0019/\u0005\u0011!Vm\u001d;\t\u000bM\u0002A\u0011\u0002\u001b\u0002?\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0002)k!)aG\ra\u0001o\u0005)Q.Y4jGB\u0011\u0011\u0002O\u0005\u0003s)\u0011AAQ=uK\")1\b\u0001C\u0001O\u0005\u0001C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3\u0011\u0015i\u0004\u0001\"\u0001(\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u000b\u0004F\u0001\u001f-\u0011\u0015\u0001\u0005\u0001\"\u0003B\u0003\r\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:$\"\u0001\u000b\"\t\u000b\r{\u0004\u0019A\u001c\u0002\u0017Q\f'oZ3u\u001b\u0006<\u0017n\u0019\u0005\u0006\u000b\u0002!\taJ\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u0012A\t\f\u0005\u0006\u0011\u0002!\taJ\u0001(i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i_V$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007\u000b\u0002HY!)1\n\u0001C\u0005\u0019\u000613\r[3dW2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\u0005!j\u0005\"\u0002\u001cK\u0001\u00049\u0004\"B(\u0001\t\u00039\u0013\u0001\n;fgRLeN^1mS\u0012|eMZ:fiJ\u000bgnZ3B]\u0012\u0014VmY8sI\u000e{WO\u001c;)\u00059c\u0003\"\u0002*\u0001\t\u0013\u0019\u0016\u0001I1tg\u0016\u0014H/\u00138wC2LGMQ1uG\"\u001cu.\u001e8u\u001fZ,'O]5eKN$2\u0001\u000b+Z\u0011\u0015)\u0016\u000b1\u0001W\u0003=a\u0017m\u001d;PM\u001a\u001cX\r\u001e#fYR\f\u0007CA\u0005X\u0013\tA&BA\u0002J]RDQAW)A\u0002Y\u000bQaY8v]RDQ\u0001\u0018\u0001\u0005\nu\u000bQE^1mS\u0012\fG/\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5D_VtGo\u0014<feJLG-Z:\u0015\u0007!rv\fC\u0003V7\u0002\u0007a\u000bC\u0003[7\u0002\u0007a\u000bC\u0003b\u0001\u0011\u0005q%A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u0013\u0004F\u00011-\u0011\u0015!\u0007\u0001\"\u0001(\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\t\u0019G\u0006C\u0003h\u0001\u0011%\u0001.\u0001\ndQ\u0016\u001c7NT8o\u0007>l\u0007O]3tg\u0016$GC\u0001\u0015j\u0011\u00151d\r1\u00018\u0011\u0015Y\u0007\u0001\"\u0001(\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\tQG\u0006C\u0003o\u0001\u0011\u0005q%A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007\u000b\u0002nY!)\u0011\u000f\u0001C\u0005e\u0006\u00112\r[3dWJ+7m\\7qe\u0016\u001c8/[8o)\tA3\u000fC\u00037a\u0002\u0007q\u0007C\u0003v\u0001\u0011\u0005q%A\nuKN$(+Z2p[B\u0014Xm]:j_:4&\u0007\u000b\u0002uY!)\u0001\u0010\u0001C\u0001O\u0005\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,2Q\t9H\u0006C\u0003|\u0001\u0011%A0A\u0011dQ\u0016\u001c7n\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c$s_64\u0006\u0007\u0006\u0002){\")aP\u001fa\u0001o\u00059Ao\\'bO&\u001c\u0007BBA\u0001\u0001\u0011\u0005q%\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013\u0004FA@-\u0011\u0019\t9\u0001\u0001C\u0001O\u0005\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3Q\r\t)\u0001\f\u0005\u0007\u0003\u001b\u0001A\u0011A\u0014\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u000b\u0004fAA\u0006Y!9\u00111\u0003\u0001\u0005\n\u0005U\u0011aD2iK\u000e\\7i\\7qe\u0016\u001c8/\u001a3\u0015\u0007!\n9\u0002\u0003\u00047\u0003#\u0001\ra\u000e\u0005\u0007\u00037\u0001A\u0011A\u0014\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u0013\u0004fAA\rY!1\u0011\u0011\u0005\u0001\u0005\u0002\u001d\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\b\u0003?a\u0013QEA\u0014\u0003!)\u0007\u0010]3di\u0016$7EAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00185\u00051QM\u001d:peNLA!a\r\u0002.\tI\u0012J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0019\t9\u0004\u0001C\u0001O\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0004\u000261\n)#a\n\t\r\u0005u\u0002\u0001\"\u0001(\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\u001d\tY\u0004LA\u0013\u0003OAa!a\u0011\u0001\t\u00039\u0013!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u0013\u0004fBA!Y\u0005\u0015\u0012q\u0005\u0005\u0007\u0003\u0013\u0002A\u0011A\u0014\u0002SQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi:{gnQ8naJ,7o]3eQ\r\t9\u0005\f\u0005\u0007\u0003\u001f\u0002A\u0011A\u0014\u0002MQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,G\rK\u0002\u0002N1Ba!!\u0016\u0001\t\u00039\u0013a\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\u0005MC\u0006\u0003\u0004\u0002\\\u0001!\taJ\u0001,i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a\u0011\u0011\f\u0017\t\r\u0005\u0005\u0004\u0001\"\u0001(\u0003!\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\r\ty\u0006\f\u0005\u0007\u0003O\u0002A\u0011A\u0014\u0002QQ,7\u000f\u001e*fY\u0006$\u0018N^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007\u0005\u0015D\u0006\u0003\u0004\u0002n\u0001!\taJ\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\r\tY\u0007\f\u0005\u0007\u0003g\u0002A\u0011A\u0014\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001a\u0011\u0011\u000f\u0017\t\r\u0005e\u0004\u0001\"\u0001(\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000b4i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005]D\u0006\u0003\u0004\u0002\u0000\u0001!\taJ\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We\r{W\u000e\u001d:fgN,G\rK\u0002\u0002~1Ba!!\"\u0001\t\u00039\u0013a\n;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^!mY><X\r\u001a$s_6\u001cE.[3oiNDs!a!-\u0003K\tIi\t\u0002\u0002\fB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012j\taA]3d_J$\u0017\u0002BAK\u0003\u001f\u0013a#\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c\u0005\u0007\u00033\u0003A\u0011A\u0014\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u000e{W\u000e\u001d:fgN,G\rK\u0002\u0002\u00182Ba!a(\u0001\t\u00039\u0013A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa9{gnQ8naJ,7o]3eQ\r\ti\n\f\u0005\u0007\u0003K\u0003A\u0011A\u0014\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006gQ8naJ,7o]3eQ\r\t\u0019\u000b\f\u0005\u0007\u0003W\u0003A\u0011A\u0014\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg+\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001a\u0011\u0011\u0016\u0017\t\r\u0005E\u0006\u0001\"\u0001(\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005=F\u0006\u0003\u0004\u00028\u0002!\taJ\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3!!.-\u0011\u0019\ti\f\u0001C\u0001O\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vNV\u0019D_6\u0004(/Z:tK\u0012D3!a/-\u0011\u0019\t\u0019\r\u0001C\u0001O\u0005!D/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001a$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:eg:{G\u000fU3s[&$H/\u001a3)\u000f\u0005\u0005G&!\n\u0002H\u000e\u0012\u0011\u0011\u001a\t\u0005\u0003W\tY-\u0003\u0003\u0002N\u00065\"\u0001J+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\r\u0005E\u0007\u0001\"\u0001(\u0003E\"Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8PM&#W-\u001c9pi\u0016tGOU3d_J$7OT8u!\u0016\u0014X.\u001b;uK\u0012Ds!a4-\u0003K\t9\r\u0003\u0004\u0002X\u0002!\taJ\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D3!!6-\u0011\u0019\ti\u000e\u0001C\u0001O\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3!a7-\u0011\u0019\t\u0019\u000f\u0001C\u0001O\u0005aB/Z:u\u0013:4\u0018\r\\5e\u0013:tWM]'bO&\u001cg+\u001a:tS>t\u0007fBAqY\u0005\u0015\u0012\u0011\u0012\u0005\u0007\u0003S\u0004A\u0011A\u0014\u0002WQ,7\u000f^\"p[B\u0014Xm]:fI\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012Ds!a:-\u0003K\tI\t\u0003\u0004\u0002p\u0002!\taJ\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007fBAwY\u0005\u0015\u0012\u0011\u0012\u0005\u0007\u0003k\u0004A\u0011A\u0014\u0002[Q,7\u000f\u001e*fG>l\u0007O]3tg\u0016$')\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rK\u0004\u0002t2\n)#!#\t\u000f\u0005m\b\u0001\"\u0003\u0002~\u0006\tC/Z:u\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fIR)\u0001&a@\u0003\u0010!A!\u0011AA}\u0001\u0004\u0011\u0019!A\u0006t_V\u00148-Z\"pI\u0016\u001c\u0007\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\u0007\t%A!A\u0004nKN\u001c\u0018mZ3\n\t\t5!q\u0001\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eD\u0001B!\u0005\u0002z\u0002\u0007!1A\u0001\fi\u0006\u0014x-\u001a;D_\u0012,7\rC\u0004\u0003\u0016\u0001!IAa\u0006\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3t)!\u0011IBa\b\u0003$\t5\u0002\u0003BAG\u00057IAA!\b\u0002\u0010\niQ*Z7pef\u0014VmY8sINDqA!\t\u0003\u0014\u0001\u0007q'\u0001\u0006nC\u001eL7MV1mk\u0016D!B!\n\u0003\u0014A\u0005\t\u0019\u0001B\u0014\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002\n\u0005SI1Aa\u000b\u000b\u0005\u0011auN\\4\t\u0011\t=\"1\u0003a\u0001\u0005c\tQaY8eK\u000e\u0004B!!$\u00034%!!QGAH\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007b\u0002B\u001d\u0001\u0011\u0005!1H\u0001\rG\",7m[(gMN,Go\u001d\u000b\u0006Q\tu\"\u0011\t\u0005\t\u0005\u007f\u00119\u00041\u0001\u0003\u001a\u00059!/Z2pe\u0012\u001c\b\u0002\u0003B\"\u0005o\u0001\rAa\n\u0002\u0015\t\f7/Z(gMN,G\u000fC\u0004\u0003H\u0001!IA!\u0013\u00029I,7m\u001c:eg^KG\u000f[%om\u0006d\u0017\u000eZ%o]\u0016\u0014X*Y4jGR!!\u0011\u0004B&\u0011!\u0011iE!\u0012A\u0002\t\u001d\u0012!D5oSRL\u0017\r\\(gMN,G\u000fC\u0004\u0003R\u0001!\tAa\u0015\u0002/5\f\u0017PY3DQ\u0016\u001c7NQ1tKRKW.Z:uC6\u0004H#\u0002\u0015\u0003V\t]\u0003\u0002CA\u0013\u0005\u001f\u0002\rAa\n\t\u0011\te#q\na\u0001\u00057\nQAY1uG\"\u0004B!!$\u0003^%!!qLAH\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\t\r\u0004\u0001\"\u0001\u0003f\u0005)b/\u00197jI\u0006$X\rT8h\u0003B\u0004XM\u001c3US6,Gc\u0002\u0015\u0003h\t-$q\u000e\u0005\t\u0005S\u0012\t\u00071\u0001\u0003(\u0005)R\r\u001f9fGR,G\rT8h\u0003B\u0004XM\u001c3US6,\u0007\u0002\u0003B7\u0005C\u0002\rAa\n\u0002+\u0015D\b/Z2uK\u0012\u0014\u0015m]3US6,7\u000f^1na\"A!\u0011\fB1\u0001\u0004\u0011Y\u0006C\u0004\u0003t\u0001!\tA!\u001e\u00027Y,'/\u001b4z%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t)%A#q\u000fBA\u0005\u000b\u00139\t\u0003\u0005\u0003z\tE\u0004\u0019\u0001B>\u0003\u0015\u0019H/\u0019;t!\u0011\tiI! \n\t\t}\u0014q\u0012\u0002\u0016%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t\u0011\u001d\u0011\u0019I!\u001dA\u0002Y\u000b1C\\;n\u0007>tg/\u001a:uK\u0012\u0014VmY8sIND\u0001Ba\u0010\u0003r\u0001\u0007!\u0011\u0004\u0005\t\u0005\u0013\u0013\t\b1\u0001\u0003\f\u0006Q1m\\7qe\u0016\u001c8/\u001a3\u0011\u0007%\u0011i)C\u0002\u0003\u0010*\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0014\u0002\t\n\u0011\"\u0003\u0003\u0016\u000692M]3bi\u0016\u0014VmY8sIN$C-\u001a4bk2$HEM\u000b\u0003\u0005/SCAa\n\u0003\u001a.\u0012!1\u0014\t\u0005\u0005;\u00139+\u0004\u0002\u0003 *!!\u0011\u0015BR\u0003%)hn\u00195fG.,GMC\u0002\u0003&*\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IKa(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;

    public Time time() {
        return this.time;
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$1, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$9 = 0;
        CompressionType x$10 = CompressionType.GZIP;
        long x$11 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$9, x$11, x$10);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$2, -1L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records2, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$3, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, lastOffsetDelta, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final int lastOffsetDelta$1;
            private final int count$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(this.lastOffsetDelta$1, this.count$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffsetDelta$1 = lastOffsetDelta$1;
                this.count$1 = count$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }

    public void kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records2.buffer().putInt(57, count);
        records2.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true);
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$1;
                private final long producerId$1;
                private final short producerEpoch$1;
                private final int baseSequence$1;
                private final boolean isTransactional$1;
                private final int partitionLeaderEpoch$1;
                public final IntRef i$1;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$2) {
                            return x$2.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$1, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$1, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$1, (long)batch.baseSequence());
                    Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
                    Assert.assertEquals((long)this.partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkNonCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$1.apply(this.$outer.i$1.elem)), (long)record.timestamp());
                            ++this.$outer.i$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$1 = timestampSeq$1;
                    this.producerId$1 = producerId$1;
                    this.producerEpoch$1 = producerEpoch$1;
                    this.baseSequence$1 = baseSequence$1;
                    this.isTransactional$1 = isTransactional$1;
                    this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                    this.i$1 = i$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records2, false);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true);
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$2;
                private final long producerId$2;
                private final short producerEpoch$2;
                private final int baseSequence$2;
                private final int partitionLeaderEpoch$2;
                public final IntRef i$2;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$4) {
                            return x$4.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$2, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$2, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$2, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkRecompression$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$2.apply(this.$outer.i$2.elem)), (long)record.timestamp());
                            ++this.$outer.i$2.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$2 = timestampSeq$2;
                    this.producerId$2 = producerId$2;
                    this.producerEpoch$2 = producerEpoch$2;
                    this.baseSequence$2 = baseSequence$2;
                    this.partitionLeaderEpoch$2 = partitionLeaderEpoch$2;
                    this.i$2 = i$2;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records2;
        byte x$12 = 0;
        CompressionType x$13 = CompressionType.GZIP;
        long x$14 = this.createRecords$default$2();
        MemoryRecords x$15 = records2 = this.createRecords(x$12, x$14, x$13);
        kafka.common.LongRef x$16 = new kafka.common.LongRef(0L);
        Time x$17 = this.time();
        long x$18 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$19 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$20 = DefaultCompressionCodec$.MODULE$;
        byte x$21 = toMagic;
        boolean x$22 = false;
        TimestampType x$23 = TimestampType.CREATE_TIME;
        long x$24 = 1000L;
        int x$25 = -1;
        boolean x$26 = true;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$15, x$16, x$17, x$18, (CompressionCodec)x$19, (CompressionCodec)x$20, x$22, x$21, x$23, x$24, x$25, x$26);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
                Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records2;
        long timestamp = System.currentTimeMillis();
        byte x$27 = 1;
        CompressionType x$28 = CompressionType.GZIP;
        long x$29 = timestamp;
        MemoryRecords x$30 = records2 = this.createRecords(x$27, x$29, x$28);
        kafka.common.LongRef x$31 = new kafka.common.LongRef(0L);
        Time x$32 = this.time();
        long x$33 = timestamp;
        DefaultCompressionCodec$ x$34 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$35 = DefaultCompressionCodec$.MODULE$;
        byte x$36 = 2;
        boolean x$37 = false;
        TimestampType x$38 = TimestampType.CREATE_TIME;
        long x$39 = 1000L;
        int x$40 = -1;
        boolean x$41 = true;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$30, x$31, x$32, x$33, (CompressionCodec)x$34, (CompressionCodec)x$35, x$37, x$36, x$38, x$39, x$40, x$41);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long timestamp$1;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(this.timestamp$1, (RecordBatch)batch);
                Assert.assertEquals((long)this.timestamp$1, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
            }
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            MemoryRecords records2;
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords x$42 = records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            kafka.common.LongRef x$43 = new kafka.common.LongRef(0L);
            Time x$44 = this.time();
            long x$45 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$46 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$47 = DefaultCompressionCodec$.MODULE$;
            byte x$48 = magic;
            boolean x$49 = false;
            TimestampType x$50 = TimestampType.CREATE_TIME;
            long x$51 = 1000L;
            int x$52 = partitionLeaderEpoch2;
            boolean x$53 = true;
            LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$42, x$43, x$44, x$45, (CompressionCodec)x$46, (CompressionCodec)x$47, x$49, x$48, x$50, x$51, x$52, x$53);
            MemoryRecords validatedRecords = validatedResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$3;
                private final long producerId$3;
                private final short producerEpoch$3;
                private final int baseSequence$3;
                private final int partitionLeaderEpoch$3;
                public final IntRef i$3;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$3.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$6) {
                            return x$6.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$3, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$3, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$3, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$3.apply(this.$outer.i$3.elem)), (long)record.timestamp());
                            ++this.$outer.i$3.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$3 = timestampSeq$3;
                    this.producerId$3 = producerId$3;
                    this.producerEpoch$3 = producerEpoch$3;
                    this.baseSequence$3 = baseSequence$3;
                    this.partitionLeaderEpoch$3 = partitionLeaderEpoch$3;
                    this.i$3 = i$3;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, true);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, true);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$54 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$55 = new kafka.common.LongRef(0L);
        Time x$56 = this.time();
        long x$57 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$58 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$59 = DefaultCompressionCodec$.MODULE$;
        byte x$60 = 1;
        boolean x$61 = false;
        TimestampType x$62 = TimestampType.CREATE_TIME;
        long x$63 = 1000L;
        int x$64 = -1;
        boolean x$65 = true;
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$54, x$55, x$56, x$57, (CompressionCodec)x$58, (CompressionCodec)x$59, x$61, x$60, x$62, x$63, x$64, x$65);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$66 = records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$67 = new kafka.common.LongRef(0L);
        Time x$68 = this.time();
        long x$69 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$70 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$71 = DefaultCompressionCodec$.MODULE$;
        byte x$72 = 1;
        boolean x$73 = false;
        TimestampType x$74 = TimestampType.CREATE_TIME;
        long x$75 = 1000L;
        int x$76 = -1;
        boolean x$77 = true;
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$66, x$67, x$68, x$69, (CompressionCodec)x$70, (CompressionCodec)x$71, x$73, x$72, x$74, x$75, x$76, x$77);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$78 = 0;
        CompressionType x$79 = CompressionType.NONE;
        long x$80 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$78, x$80, x$79);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$81 = records2;
        kafka.common.LongRef x$82 = new kafka.common.LongRef((long)offset);
        Time x$83 = this.time();
        long x$84 = System.currentTimeMillis();
        NoCompressionCodec$ x$85 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$86 = NoCompressionCodec$.MODULE$;
        byte x$87 = 0;
        boolean x$88 = false;
        TimestampType x$89 = TimestampType.CREATE_TIME;
        long x$90 = 1000L;
        int x$91 = -1;
        boolean x$92 = true;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$81, x$82, x$83, x$84, (CompressionCodec)x$85, (CompressionCodec)x$86, x$88, x$87, x$89, x$90, x$91, x$92).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$93 = 0;
        CompressionType x$94 = CompressionType.GZIP;
        long x$95 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$93, x$95, x$94);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$96 = 0;
        CompressionType x$97 = CompressionType.NONE;
        long x$98 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$96, x$98, x$97);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$99 = 0;
        CompressionType x$100 = CompressionType.NONE;
        long x$101 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$99, x$101, x$100);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$102 = 0;
        CompressionType x$103 = CompressionType.GZIP;
        long x$104 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$102, x$104, x$103);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$105 = 0;
        CompressionType x$106 = CompressionType.GZIP;
        long x$107 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$105, x$107, x$106);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true);
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true);
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, false);
        List batches = TestUtils.toList((Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$108 = 1;
        CompressionType x$109 = CompressionType.NONE;
        long x$110 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$108, x$110, x$109);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$111 = 1;
        CompressionType x$112 = CompressionType.GZIP;
        long x$113 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$111, x$113, x$112);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidInnerMagicVersion() {
        int offset = 1234567;
        MemoryRecords records2 = this.recordsWithInvalidInnerMagic(offset);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)SnappyCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40));
        if (tuple5 != null) {
            Tuple5 tuple52;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple53._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple53._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
            ByteBuffer buffer = ByteBuffer.allocate(61);
            DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (long)0L, (long)5L, (int)partitionLeaderEpoch2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)isTransactional2, (boolean)false);
            buffer.flip();
            MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    public void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(Record entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(long initialOffset) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$8) {
                return x$8.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$2;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$2.elem, record);
                ++this.offset$2.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$2 = offset$2;
            }
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected base timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected max timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, expectedLogAppendTime){
            public static final long serialVersionUID = 0L;
            private final long expectedLogAppendTime$1;

            public final void apply(Record record) {
                Assert.assertTrue((boolean)record.isValid());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected timestamp of record ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})), (long)this.expectedLogAppendTime$1, (long)record.timestamp());
            }
            {
                this.expectedLogAppendTime$1 = expectedLogAppendTime$1;
            }
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records2, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not valid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records2.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temp bytes too small, orig=", " actual=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)originalSize), BoxesRunTime.boxToLong((long)tempBytes)})), (tempBytes > (long)originalSize ? 1 : 0) != 0);
        } else if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)tempBytes);
        }
    }
}

