/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001A\u0002\u0013\u0005\u0011$\u0001\u0004m_\u001e$\u0015N]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n!\u0002\\8h\t&\u0014x\fJ3r)\t)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bb\u0002\u0017#\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004B\u0002\u0018\u0001A\u0003&!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005a1\u000f^1uK6\u000bg.Y4feV\t!\u0007\u0005\u0002\u0017g%\u0011AG\u0001\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000fY\u0002\u0001\u0019!C\u0001o\u0005\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002}A\u0011q(R\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019%B\u0001#\u000f\u0003\u0019\t\u0007/Y2iK&\u0011a\t\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019A\u0005\u0001)A\u0005}\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006Q\u0001O]8ek\u000e,'/\u00133\u0016\u00031\u0003\"AJ'\n\u00059;#\u0001\u0002'p]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u00039s_\u0012,8-\u001a:JI\u0002BqA\u0015\u0001C\u0002\u0013\u00051+\u0001\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001bX#\u0001+\u0011\u0005\u0019*\u0016B\u0001,(\u0005\rIe\u000e\u001e\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002'5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\t\u000fi\u0003!\u0019!C\u00017\u0006!A/[7f+\u0005a\u0006CA/a\u001b\u0005q&BA0A\u0003\u0015)H/\u001b7t\u0013\t\tgL\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006)A/[7fA!)Q\r\u0001C\u0001M\u0006)1/\u001a;VaR\tQ\u0005\u000b\u0002eQB\u0011\u0011n[\u0007\u0002U*\u00111BD\u0005\u0003Y*\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u00031\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0004\bCA5r\u0013\t\u0011(NA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005a-\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007FA:w!\tIw/\u0003\u0002yU\n!A+Z:u\u0011\u0015Q\b\u0001\"\u0001g\u0003\u0019\"Xm\u001d;BaB,g\u000e\u001a+y]6\u000b'o[3s/&$\bNT8Qe>$WoY3s'R\fG/\u001a\u0015\u0003sZDQ! \u0001\u0005\u0002\u0019\fa\u0004^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,wK]1q\u0003J|WO\u001c3)\u0005q4\bBBA\u0001\u0001\u0011\u0005a-A\u0013uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z%om\u0006d\u0017\u000eZ,sCB\f%o\\;oI\"2qP^A\u0003\u0003\u000f\t\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0001\u0015AB3se>\u00148/\u0003\u0003\u0002\u0014\u00055!aG(vi>3wJ\u001d3feN+\u0017/^3oG\u0016,\u0005pY3qi&|g\u000e\u0003\u0004\u0002\u0018\u0001!\tAZ\u0001+i\u0016\u001cHOT8WC2LG-\u0019;j_:|eNR5sgR,e\u000e\u001e:z/\",g\u000eT8bI&tw\rT8hQ\r\t)B\u001e\u0005\u0007\u0003;\u0001A\u0011\u00014\u00027Q,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014HMQ;naN,\u0005o\\2iQ\r\tYB\u001e\u0005\u0007\u0003G\u0001A\u0011\u00014\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u0004\u0003C1\bBBA\u0015\u0001\u0011\u0005a-\u0001\u0018uKN$hj\u001c8NCR\u001c\u0007.\u001b8h)btg)\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uC:{GoQ1dQ\u0016$\u0007fAA\u0014m\"1\u0011q\u0006\u0001\u0005\u0002\u0019\fa\u0004^3tiB\u0013X\r]1sKV\u0003H-\u0019;f\t>,7OT8u\u001bV$\u0018\r^3)\u0007\u00055b\u000f\u0003\u0004\u00026\u0001!\tAZ\u0001\u001fkB$\u0017\r^3Qe>$WoY3s)J\fgn]1di&|gn\u0015;bi\u0016D3!a\rw\u0011\u0019\tY\u0004\u0001C\u0001M\u0006aC/Z:u\u001fV$xJZ*fcV,gnY3BMR,'oQ8oiJ|GNU3d_J$W\t]8dQ\n+X\u000e\u001d\u0015\u0004\u0003s1\bBBA!\u0001\u0011\u0005a-\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\b\u0003\u007f1\u0018QAA#G\t\t9\u0005\u0005\u0003\u0002\f\u0005%\u0013\u0002BA&\u0003\u001b\u0011\u0001$\u00138wC2LG\r\u0016=o'R\fG/Z#yG\u0016\u0004H/[8o\u0011\u0019\ty\u0005\u0001C\u0001M\u0006yC/Z:u)J,hnY1uK\u0006sGMU3m_\u0006$'+Z7pm\u0016\u001cx*\u001e;PMJ\u000bgnZ3T]\u0006\u00048\u000f[8ug\"\u001a\u0011Q\n<\t\r\u0005U\u0003\u0001\"\u0001g\u0003A!Xm\u001d;UC.,7K\\1qg\"|G\u000fK\u0002\u0002TYDa!a\u0017\u0001\t\u00031\u0017a\u0006;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8uQ\r\tIF\u001e\u0005\u0007\u0003C\u0002A\u0011\u00014\u0002;Q,7\u000f\u001e*f[>4X-\u0012=qSJ,G\rU5eg>s'+\u001a7pC\u0012Ds!a\u0018w\u0003\u000b\t)g\t\u0002\u0002hA!\u00111BA5\u0013\u0011\tY'!\u0004\u00035Us7N\\8x]B\u0013x\u000eZ;dKJLE-\u0012=dKB$\u0018n\u001c8\t\r\u0005=\u0004\u0001\"\u0001g\u00035\"Xm\u001d;BG\u000e,\u0007\u000f^!qa\u0016tGmV5uQ>,H\u000f\u0015:pIV\u001cWM]*uCR,wJ\u001c*fa2L7-\u0019\u0015\u0004\u0003[2\bBBA;\u0001\u0011\u0005a-A\u0015uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[*fcV,gnY3HCB\u001cxJ\u001c*fa2L7-\u0019\u0015\u0004\u0003g2\bBBA>\u0001\u0011\u0005a-A\ruKN$H)\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,\u0007fAA=m\"1\u0011\u0011\u0011\u0001\u0005\u0002\u0019\fA\u0002^3tiR\u0013XO\\2bi\u0016D3!a w\u0011\u0019\t9\t\u0001C\u0001M\u00061C/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^!gi\u0016\u0014HK];oG\u0006$\u0018n\u001c8)\u0007\u0005\u0015e\u000f\u0003\u0004\u0002\u000e\u0002!\tAZ\u0001%i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKR\fe\r^3s\u000bZL7\r^5p]\"\u001a\u00111\u0012<\t\r\u0005M\u0005\u0001\"\u0001g\u0003A!Xm\u001d;UeVt7-\u0019;f\u0011\u0016\fG\rK\u0002\u0002\u0012ZDa!!'\u0001\t\u00031\u0017a\f;fgRdu.\u00193Ge>l7K\\1qg\"|GOU3n_Z,7OT8o%\u0016$\u0018-\u001b8fIB\u0013x\u000eZ;dKJ\u001c\bfAALm\"1\u0011q\u0014\u0001\u0005\u0002\u0019\f\u0011\u0005^3tiN[\u0017\u000e]*oCB\u001c\bn\u001c;JM>3gm]3u+:\u001c\u0007.\u00198hK\u0012D3!!(w\u0011\u0019\t)\u000b\u0001C\u0001M\u0006yA/Z:u'R\f'\u000f^(gMN,G\u000fK\u0002\u0002$ZDa!a+\u0001\t\u00031\u0017\u0001\u0007;fgR\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]RKW.Z8vi\":\u0011\u0011\u0016<\u0002\u0006\u0005\u0015\u0004BBAY\u0001\u0011\u0005a-A\fuKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\"\u001a\u0011q\u0016<\t\r\u0005]\u0006\u0001\"\u0001g\u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u0007\u0005Uf\u000f\u0003\u0004\u0002>\u0002!\tAZ\u0001.i\u0016\u001cHoU3rk\u0016t7-\u001a(piZ\u000bG.\u001b3bi\u0016$gi\u001c:He>,\b/T3uC\u0012\fG/\u0019+pa&\u001c\u0007fAA^m\"1\u00111\u0019\u0001\u0005\u0002\u0019\fA\u0004^3ti>cG-\u00129pG\"4uN]\"p]R\u0014x\u000e\u001c*fG>\u0014H\rK\u0004\u0002BZ\f)!a2$\u0005\u0005%\u0007\u0003BA\u0006\u0003\u0017LA!!4\u0002\u000e\t9\u0002K]8ek\u000e,'OR3oG\u0016$W\t_2faRLwN\u001c\u0005\u0007\u0003#\u0004A\u0011\u00014\u0002-Q,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2j]\u001eD3!a4w\u0011\u0019\t9\u000e\u0001C\u0001M\u0006\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\u001d\t)N^A\u0003\u00037\u001c#!!8\u0011\t\u0005-\u0011q\\\u0005\u0005\u0003C\fiAA\u0013Ue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\r\u0016t7-\u001a3Fq\u000e,\u0007\u000f^5p]\"1\u0011Q\u001d\u0001\u0005\u0002\u0019\fQ\u0004^3ti2{\u0017\r\u001a$s_6,U\u000e\u001d;z':\f\u0007o\u001d5pi\u001aKG.\u001a\u0015\u0004\u0003G4\bBBAv\u0001\u0011\u0005a-A\u0011uKN$Hj\\1e\rJ|W\u000e\u0016:v]\u000e\fG/\u001a3T]\u0006\u00048\u000f[8u\r&dW\rK\u0002\u0002jZDa!!=\u0001\t\u00031\u0017a\b;fgRdu.\u00193Ge>l7i\u001c:skB$8K\\1qg\"|GOR5mK\"\u001a\u0011q\u001e<\t\r\u0005]\b\u0001\"\u0001g\u0003m!Xm\u001d;BaB,g\u000eZ#naRL8i\u001c8ue>d')\u0019;dQ\"\u001a\u0011Q\u001f<\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\u0006YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2!\nB\u0001\u0011!\u0011\u0019!a?A\u0002\t\u0015\u0011aD7bW\u00164\u0015\u000e\\3D_J\u0014X\u000f\u001d;\u0011\r\u0019\u00129Aa\u0003&\u0013\r\u0011Ia\n\u0002\n\rVt7\r^5p]F\u0002BA!\u0004\u0003\u00185\u0011!q\u0002\u0006\u0005\u0005#\u0011\u0019\"\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011)BH\u0001\u0004]&|\u0017\u0002\u0002B\r\u0005\u001f\u00111BR5mK\u000eC\u0017M\u001c8fY\"9!Q\u0004\u0001\u0005\n\t}\u0011AE1qa\u0016tG-\u00128e)btW*\u0019:lKJ$\u0002C!\t\u0003.\tE\"1\u0007B\u001f\u0005\u001b\u0012\tF!\u0016\u0011\r\u0019\u0012\u0019Ca\nM\u0013\r\u0011)c\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Y\u0011I#C\u0002\u0003,\t\u0011AbQ8na2,G/\u001a3Uq:DqAa\f\u0003\u001c\u0001\u0007!'A\u0004nCB\u0004\u0018N\\4\t\r)\u0013Y\u00021\u0001M\u0011!\u0011)Da\u0007A\u0002\t]\u0012!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002'\u0005sI1Aa\u000f(\u0005\u0015\u0019\u0006n\u001c:u\u0011!\u0011yDa\u0007A\u0002\t\u0005\u0013aC2p]R\u0014x\u000e\u001c+za\u0016\u0004BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000f\u0002\u0015A\u0002:fG>\u0014H-\u0003\u0003\u0003L\t\u0015#!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"9!q\nB\u000e\u0001\u0004a\u0015AB8gMN,G\u000fC\u0005\u0003T\tm\u0001\u0013!a\u0001)\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\n\u0005/\u0012Y\u0002%AA\u00021\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u000f\tm\u0003\u0001\"\u0003\u0003^\u00051\u0011\r\u001d9f]\u0012$\u0012#\nB0\u0005C\u0012\u0019G!\u001a\u0003j\t-$Q\u000eB<\u0011\u0019\u0001$\u0011\fa\u0001e!1!J!\u0017A\u00021C\u0001B!\u000e\u0003Z\u0001\u0007!q\u0007\u0005\b\u0005O\u0012I\u00061\u0001U\u0003\r\u0019X-\u001d\u0005\b\u0005\u001f\u0012I\u00061\u0001M\u0011%\u00119F!\u0017\u0011\u0002\u0003\u0007A\n\u0003\u0006\u0003p\te\u0003\u0013!a\u0001\u0005c\nq\"[:Ue\u0006t7/Y2uS>t\u0017\r\u001c\t\u0004M\tM\u0014b\u0001B;O\t9!i\\8mK\u0006t\u0007B\u0003B=\u00053\u0002\n\u00111\u0001\u0003r\u0005a\u0011n\u001d$s_6\u001cE.[3oi\"9!1\f\u0001\u0005\n\tuD#D\u0013\u0003\u0000\t\u0005%1\u0011BC\u0005\u000f\u0013\t\n\u0003\u00041\u0005w\u0002\rA\r\u0005\u0007\u0015\nm\u0004\u0019\u0001'\t\u0011\tU\"1\u0010a\u0001\u0005oAqAa\u0014\u0003|\u0001\u0007A\n\u0003\u0005\u0003\n\nm\u0004\u0019\u0001BF\u0003\u0015\u0011\u0017\r^2i!\u0011\u0011\u0019E!$\n\t\t=%Q\t\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000e\u0003\u0005\u0003z\tm\u0004\u0019\u0001B9\u0011\u001d\u0011)\n\u0001C\u0005\u0005/\u000bacY;se\u0016tGo\u00158baNDw\u000e^(gMN,Go]\u000b\u0003\u00053\u0003RAa'\u0003&2k!A!(\u000b\t\t}%\u0011U\u0001\nS6lW\u000f^1cY\u0016T1Aa)(\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0013iJA\u0002TKRD\u0011Ba+\u0001#\u0003%IA!,\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u00122TC\u0001BXU\ra%\u0011W\u0016\u0003\u0005g\u0003BA!.\u0003@6\u0011!q\u0017\u0006\u0005\u0005s\u0013Y,A\u0005v]\u000eDWmY6fI*\u0019!QX\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003B\n]&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\u0019\u0001\u0012\u0002\u0013%!qY\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uI]*\"A!3+\t\tE$\u0011\u0017\u0005\n\u0005\u001b\u0004\u0011\u0013!C\u0005\u0005\u000f\f\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001d\t\u0013\tE\u0007!%A\u0005\n\tM\u0017\u0001H1qa\u0016tG-\u00128e)btW*\u0019:lKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005+T3\u0001\u0016BY\u0011%\u0011I\u000eAI\u0001\n\u0013\u0011i+\u0001\u000fbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c")
public class ProducerStateManagerTest
extends JUnitSuite {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 1, 0L, 1L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 5, 0L, 2L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        this.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), (short)0, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.assertThrows((Function0)new Serializable(this, producerEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short producerEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.producerEpoch$1, 17, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerEpoch$1 = producerEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$17 = this.stateManager();
        long x$18 = this.producerId();
        short x$19 = epoch;
        int x$20 = sequence;
        long x$21 = offset;
        boolean x$22 = false;
        long x$23 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$24 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$17, x$18, x$19, x$20, x$21, x$23, x$24, x$22);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$25 = this.stateManager();
        long x$26 = this.producerId();
        short x$27 = epoch;
        int x$28 = sequence;
        long x$29 = offset;
        boolean x$30 = false;
        long x$31 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$32 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$25, x$26, x$27, x$28, x$29, x$31, x$32, x$30);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = epoch;
        int x$36 = sequence;
        long x$37 = offset;
        boolean x$38 = false;
        long x$39 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$40 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$33, x$34, x$35, x$36, x$37, x$39, x$40, x$38);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
            long lastStableOffset = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
            CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
            long lastStableOffset2 = tuple23._2$mcJ$sp();
            Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
            Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
            Assert.assertEquals((long)2L, (long)lastStableOffset2);
            Assert.assertTrue((boolean)completedTxn2.isAborted());
            Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
            Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
            Assert.assertTrue((boolean)maybeLastEntry.isDefined());
            ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
            Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
            Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
            Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
            this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ProducerStateEntry x$2) {
                    return x$2.firstSeq();
                }
            }));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$41 = this.stateManager();
        long x$42 = this.producerId();
        short x$43 = epoch;
        int x$44 = 0;
        long x$45 = 0L;
        boolean x$46 = true;
        long x$47 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$48 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$41, x$42, x$43, x$44, x$45, x$47, x$46, x$48);
        ProducerStateManager x$49 = this.stateManager();
        long x$50 = this.producerId();
        short x$51 = epoch;
        int x$52 = 1;
        long x$53 = 1L;
        boolean x$54 = true;
        long x$55 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$56 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$49, x$50, x$51, x$52, x$53, x$55, x$54, x$56);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$57 = this.$outer.stateManager();
                long x$58 = this.$outer.producerId();
                short x$59 = this.bumpedEpoch$1;
                int x$60 = 2;
                long x$61 = 2L;
                boolean x$62 = true;
                long x$63 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$64 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$57, x$58, x$59, x$60, x$61, x$63, x$62, x$64);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$65 = this.$outer.stateManager();
                long x$66 = this.$outer.producerId();
                short x$67 = (short)(this.bumpedEpoch$1 + 1);
                int x$68 = 2;
                long x$69 = 2L;
                boolean x$70 = true;
                long x$71 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$72 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$65, x$66, x$67, x$68, x$69, x$71, x$70, x$72);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        ProducerStateManager x$73 = this.stateManager();
        long x$74 = this.producerId();
        short x$75 = bumpedEpoch;
        int x$76 = 0;
        long x$77 = 0L;
        boolean x$78 = true;
        long x$79 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$80 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$73, x$74, x$75, x$76, x$77, x$79, x$78, x$80);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$81 = this.stateManager();
        long x$82 = this.producerId();
        short x$83 = epoch;
        int x$84 = 0;
        long x$85 = 0L;
        boolean x$86 = true;
        long x$87 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$88 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$81, x$82, x$83, x$84, x$85, x$87, x$86, x$88);
        ProducerStateManager x$89 = this.stateManager();
        long x$90 = this.producerId();
        short x$91 = epoch;
        int x$92 = 1;
        long x$93 = 1L;
        boolean x$94 = false;
        long x$95 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$96 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$89, x$90, x$91, x$92, x$93, x$95, x$94, x$96);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$97 = recoveredMapping;
        long x$98 = this.producerId();
        short x$99 = epoch;
        int x$100 = sequence;
        long x$101 = 2L;
        long x$102 = 70001L;
        boolean x$103 = false;
        boolean x$104 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$97, x$98, x$99, x$100, x$101, x$102, x$104, x$103);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$105 = this.stateManager();
            long x$106 = this.producerId();
            short x$107 = epoch;
            int x$108 = outOfOrderSequence;
            long x$109 = 1L;
            long x$110 = 1L;
            boolean x$111 = true;
            boolean x$112 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$105, x$106, x$107, x$108, x$109, x$110, x$112, x$111);
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        }
        catch (Exception exception) {
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
            Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            ProducerStateManager x$113 = this.stateManager();
            long x$114 = this.producerId();
            short x$115 = epoch;
            int x$116 = outOfOrderSequence;
            long x$117 = 1L;
            long x$118 = 1L;
            boolean x$119 = false;
            boolean x$120 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$113, x$114, x$115, x$116, x$117, x$118, x$120, x$119);
            Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            return;
        }
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$121 = this.stateManager();
        long x$122 = this.producerId();
        short x$123 = epoch;
        int x$124 = sequence;
        long x$125 = 99L;
        boolean x$126 = true;
        long x$127 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$128 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$121, x$122, x$123, x$124, x$125, x$127, x$126, x$128);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$3) {
                return x$3.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$5) {
                return x$5.messageOffset();
            }
        }));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$6) {
                return x$6.messageOffset();
            }
        }));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$129 = this.stateManager();
        long x$130 = this.producerId();
        short x$131 = epoch;
        int x$132 = sequence;
        long x$133 = 99L;
        boolean x$134 = true;
        long x$135 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$136 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$129, x$130, x$131, x$132, x$133, x$135, x$134, x$136);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$7) {
                return x$7.messageOffset();
            }
        }));
        ProducerStateManager x$137 = this.stateManager();
        long x$138 = 2L;
        short x$139 = epoch;
        int x$140 = 0;
        long x$141 = 106L;
        boolean x$142 = true;
        long x$143 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$144 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$137, x$138, x$139, x$140, x$141, x$143, x$142, x$144);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$8) {
                return x$8.messageOffset();
            }
        }));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 1, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerStateEntry)maybeEntry.get()).lastDataOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid1, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.assertThrows((Function0)new Serializable(this, epoch, pid2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$2;
            private final long pid2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager recoveredMapping = new ProducerStateManager(this.$outer.partition(), this.$outer.logDir(), this.$outer.maxPidExpirationMs());
                recoveredMapping.truncateAndReload(0L, 1L, this.$outer.time().milliseconds());
                this.$outer.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.pid2$1, this.epoch$2, 1, 4L, 5L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.pid2$1 = pid2$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$145 = this.stateManager();
        long x$146 = this.producerId();
        short x$147 = epoch;
        int x$148 = sequence;
        long x$149 = 99L;
        boolean x$150 = true;
        long x$151 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$152 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$145, x$146, x$147, x$148, x$149, x$151, x$150, x$152);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$9) {
                return x$9.messageOffset();
            }
        }));
        long anotherPid = 2L;
        ProducerStateManager x$153 = this.stateManager();
        long x$154 = anotherPid;
        short x$155 = epoch;
        int x$156 = sequence;
        long x$157 = 105L;
        boolean x$158 = true;
        long x$159 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$160 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$153, x$154, x$155, x$156, x$157, x$159, x$158, x$160);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$10) {
                return x$10.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$11) {
                return x$11.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$12) {
                return x$12.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$13) {
                return x$13.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$14) {
                return x$14.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$15) {
                return x$15.messageOffset();
            }
        }));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$161 = this.stateManager();
        long x$162 = this.producerId();
        short x$163 = epoch;
        int x$164 = sequence;
        long x$165 = 99L;
        boolean x$166 = true;
        long x$167 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$168 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$161, x$162, x$163, x$164, x$165, x$167, x$166, x$168);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$169 = stateManager;
        long x$170 = this.producerId();
        short x$171 = epoch;
        int x$172 = -1;
        long x$173 = 99L;
        boolean x$174 = true;
        long x$175 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$176 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$169, x$170, x$171, x$172, x$173, x$175, x$174, x$176);
        ProducerStateManager x$177 = stateManager;
        long x$178 = this.producerId();
        short x$179 = epoch;
        int x$180 = -1;
        long x$181 = 100L;
        boolean x$182 = true;
        long x$183 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$184 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$177, x$178, x$179, x$180, x$181, x$183, x$182, x$184);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$185 = this.stateManager();
        long x$186 = this.producerId();
        short x$187 = epoch;
        int x$188 = sequence;
        long x$189 = 99L;
        boolean x$190 = true;
        long x$191 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$192 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$185, x$186, x$187, x$188, x$189, x$191, x$190, x$192);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$193 = this.stateManager();
        long x$194 = this.producerId();
        short x$195 = epoch;
        int x$196 = sequence;
        long x$197 = 99L;
        boolean x$198 = true;
        long x$199 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$200 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$193, x$194, x$195, x$196, x$197, x$199, x$198, x$200);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ProducerStateEntry x$16) {
                return x$16.coordinatorEpoch();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw this.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$201 = this.stateManager();
        long x$202 = this.producerId();
        short x$203 = producerEpoch;
        int x$204 = 0;
        long x$205 = 99L;
        boolean x$206 = true;
        long x$207 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$208 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$201, x$202, x$203, x$204, x$205, x$207, x$206, x$208);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                file.truncate(0L);
            }
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.truncate(file.size() / 2L);
            }
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
            }
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    /*
     * WARNING - void declaration
     */
    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);
        try {
            makeFileCorrupt.apply((Object)channel);
        }
        catch (Throwable throwable) {
            void var7_6;
            var7_6.close();
            throw throwable;
        }
        channel.close();
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    public void kafka$log$ProducerStateManagerTest$$append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    public long kafka$log$ProducerStateManagerTest$$append$default$6() {
        return this.time().milliseconds();
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$7() {
        return false;
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$8() {
        return true;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

