/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011\u001dQ\u0003\u00011A\u0005\n-\nA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001L\u0018\u0011\u0005\u0005j\u0013B\u0001\u0018#\u0005\u0011)f.\u001b;\t\u000fAJ\u0013\u0011!a\u0001'\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003\u0014\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u00035\u0001\u0011\u0005S'\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005a\u0003\"B\u001c\u0001\t\u0013A\u0014AE2sK\u0006$XMR3uG\"\u0014V-];fgR$R!O!G\u0011j\u0003\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0011I,\u0017/^3tiNT!A\u0010\r\u0002\r\r|W.\\8o\u0013\t\u00015H\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0003Cm\u0001\u00071)\u0001\tnCb\u0014Vm\u001d9p]N,')\u001f;fgB\u0011\u0011\u0005R\u0005\u0003\u000b\n\u00121!\u00138u\u0011\u00159e\u00071\u0001D\u0003Ei\u0017\r\u001f)beRLG/[8o\u0005f$Xm\u001d\u0005\u0006\u0013Z\u0002\rAS\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u0007\u0003\u0019a$o\\8u}%\t1%\u0003\u0002SE\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\r\u0019V-\u001d\u0006\u0003%\n\u0002\"a\u0016-\u000e\u0003uJ!!W\u001f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")1L\u000ea\u00019\u0006IqN\u001a4tKRl\u0015\r\u001d\t\u0005Au3v,\u0003\u0002_Q\t\u0019Q*\u00199\u0011\u0005\u0005\u0002\u0017BA1#\u0005\u0011auN\\4\t\u000b\r\u0004A\u0011\u00023\u0002%\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u000b\u0005KR,h\u000f\u0005\u0003gWZkW\"A4\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"A\\9\u000f\u0005iz\u0017B\u00019<\u000311U\r^2i%\u0016\fX/Z:u\u0013\t\u00118OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0003anBQa\u00122A\u0002\rCQ!\u00132A\u0002)Cqa\u00172\u0011\u0002\u0003\u0007A\fC\u0003y\u0001\u0011%\u00110\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR)!0a\u0002\u0002\fA\u0019!h_?\n\u0005q\\$!\u0004$fi\u000eD'+Z:q_:\u001cX\rE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003i\u0014A\u0002:fG>\u0014H-C\u0002\u0002\u0006}\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bBBA\u0005o\u0002\u00071)\u0001\u0005mK\u0006$WM]%e\u0011\u0019\tia\u001ea\u0001s\u00059!/Z9vKN$\bBBA\t\u0001\u0011%Q'\u0001\u0007j]&$\bK]8ek\u000e,'\u000f\u0003\u0004\u0002\u0016\u0001!\t!N\u0001/i\u0016\u001cHO\u0011:pW\u0016\u0014(+Z:qK\u000e$8\u000fU1si&$\u0018n\u001c8t\u001fJ$WM]!oINK'0\u001a'j[&$8\u000f\u000b\u0003\u0002\u0014\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}1$A\u0003kk:LG/\u0003\u0003\u0002$\u0005u!\u0001\u0002+fgRDa!a\n\u0001\t\u0003)\u0014A\n;fgR4U\r^2i%\u0016\fX/Z:u-J:\u0016\u000e\u001e5Pm\u0016\u00148/\u001b>fI6+7o]1hK\"\"\u0011QEA\r\u0011\u0019\ti\u0003\u0001C\u0001k\u0005\u0019C/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e,5/&$\bNU3bI\u000e{W.\\5ui\u0016$\u0007\u0006BA\u0016\u00033Aa!a\r\u0001\t\u0003)\u0014\u0001\b;fgR4U\r^2i%\u0016\fX/Z:u)>tuN\u001c*fa2L7-\u0019\u0015\u0005\u0003c\tI\u0002\u0003\u0004\u0002:\u0001!\t!N\u0001(i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gnV5uQ\u000e{gN\\3di&|gNR1jYV\u0014X\r\u000b\u0003\u00028\u0005e\u0001BBA \u0001\u0011\u0005Q'\u0001\u001cuKN$Hi\\<o\u0007>tg/\u001a:tS>tgI]8n\u0005\u0006$8\r[3e)>,fNY1uG\",GMU3ta\u0016\u001cGo](gMN,G\u000f\u000b\u0003\u0002>\u0005e\u0001BBA#\u0001\u0011\u0005Q'A\u0018uKN$8I]3bi\u0016Len\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nV5uQB\u000b'\u000f^5uS>t7/\u00138FeJ|'\u000f\u000b\u0003\u0002D\u0005e\u0001bBA&\u0001\u0011%\u0011QJ\u0001\be\u0016\u001cwN\u001d3t)\u0011\ty%a\u0016\u0011\t-\u001b\u0016\u0011\u000b\t\u0004}\u0006M\u0013bAA+\u007f\n1!+Z2pe\u0012D\u0001\"!\u0017\u0002J\u0001\u0007\u00111L\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\u000b\u0005u\u00131M?\u000f\u0007i\ny&C\u0002\u0002bm\nQBR3uG\"\u0014Vm\u001d9p]N,\u0017b\u0001:\u0002f)\u0019\u0011\u0011M\u001e\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\u0005\u00112\r[3dW\u001a+Go\u00195SKN\u0004xN\\:f)-a\u0013QNA9\u0003k\n9(!\u001f\t\u000f\u0005=\u0014q\ra\u0001\u0015\u0006\u0011R\r\u001f9fGR,G\rU1si&$\u0018n\u001c8t\u0011\u001d\t\u0019(a\u001aA\u0002i\fQBZ3uG\"\u0014Vm\u001d9p]N,\u0007BB$\u0002h\u0001\u00071\t\u0003\u0004C\u0003O\u0002\ra\u0011\u0005\b\u0003w\n9\u00071\u0001D\u0003]qW/\\'fgN\fw-Z:QKJ\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0000\u0001!I!!!\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0011\u0005\r\u0015QQAE\u0003\u001b\u0003B\u0001I/W\u0007\"9\u0011qQA?\u0001\u0004\u0019\u0015!\u00038v[R{\u0007/[2t\u0011\u001d\tY)! A\u0002\r\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bBCAH\u0003{\u0002\n\u00111\u0001\u0002\u0012\u000691m\u001c8gS\u001e\u001c\b\u0003\u0002\u0011^?}Aq!!&\u0001\t\u0013\t9*A\u0006qe>$WoY3ECR\fGCBAM\u0003C\u000bI\u000b\u0005\u0003L'\u0006m\u0005#\u0002\u000b\u0002\u001e~y\u0012bAAP+\tq\u0001K]8ek\u000e,'OU3d_J$\u0007bB%\u0002\u0014\u0002\u0007\u00111\u0015\t\u0005\u0017\u0006\u0015f+C\u0002\u0002(V\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003w\n\u0019\n1\u0001D\u0011%\ti\u000bAI\u0001\n\u0013\ty+\u0001\u000fde\u0016\fG/\u001a)beRLG/[8o\u001b\u0006\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E&f\u0001/\u00024.\u0012\u0011Q\u0017\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003%)hn\u00195fG.,GMC\u0002\u0002@\n\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019-!/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002H\u0002\t\n\u0011\"\u0003\u0002J\u000612M]3bi\u0016$v\u000e]5dg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002L*\"\u0011\u0011SAZ\u0001")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer = null;

    public KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer() {
        return this.kafka$server$FetchRequestTest$$producer;
    }

    private void kafka$server$FetchRequestTest$$producer_$eq(KafkaProducer<String, String> x$1) {
        this.kafka$server$FetchRequestTest$$producer = x$1;
    }

    @Override
    public void tearDown() {
        if (this.kafka$server$FetchRequestTest$$producer() != null) {
            this.kafka$server$FetchRequestTest$$producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final scala.collection.immutable.Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), 0L, this.maxPartitionBytes$1));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$19 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$20 = 5;
        StringSerializer x$21 = new StringSerializer();
        StringSerializer x$22 = new StringSerializer();
        int x$23 = TestUtils$.MODULE$.createProducer$default$2();
        long x$24 = TestUtils$.MODULE$.createProducer$default$3();
        long x$25 = TestUtils$.MODULE$.createProducer$default$4();
        long x$26 = TestUtils$.MODULE$.createProducer$default$6();
        long x$27 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$28 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$29 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$30 = TestUtils$.MODULE$.createProducer$default$10();
        Option<Properties> x$31 = TestUtils$.MODULE$.createProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$19, x$23, x$24, x$25, x$20, x$26, x$27, x$28, x$29, x$30, x$21, x$22, x$31));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1)new Serializable(this, partitionsWithLargeMessages){
            public static final long serialVersionUID = 0L;
            private final Vector partitionsWithLargeMessages$1;

            public final boolean apply(Object elem) {
                return this.partitionsWithLargeMessages$1.contains(elem);
            }
            {
                this.partitionsWithLargeMessages$1 = partitionsWithLargeMessages$1;
            }
        });
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final int apply(FetchResponse.PartitionData<MemoryRecords> partitionData) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$1) {
                        return x$1.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$2) {
                return x$2.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Record x$3) {
                            return x$3.sizeInBytes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)tuple2._2())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$3) {
                        return x$3.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$4) {
                return x$4.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records).sizeInBytes());
            Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$6) {
                    return x$6.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.lastStableOffset > 0L ? 1 : 0) != 0);
            Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$8) {
                    return x$8.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        });
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(nonReplicaId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)partitionData.error);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple22;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        Properties propsOverride = new Properties();
        propsOverride.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        String x$32 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$33 = 5;
        long x$34 = Long.MAX_VALUE;
        StringSerializer x$35 = new StringSerializer();
        ByteArraySerializer x$36 = new ByteArraySerializer();
        Some x$37 = new Some((Object)propsOverride);
        int x$38 = TestUtils$.MODULE$.createProducer$default$2();
        long x$39 = TestUtils$.MODULE$.createProducer$default$3();
        long x$40 = TestUtils$.MODULE$.createProducer$default$4();
        long x$41 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$42 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$43 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$44 = TestUtils$.MODULE$.createProducer$default$10();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$32, x$38, x$39, x$40, x$33, x$34, x$41, x$42, x$43, x$44, x$35, x$36, (Option<Properties>)x$37);
        byte[] bytes = new byte[msgValueLen];
        try {
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, topicPartition2, producer, bytes){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final KafkaProducer producer$1;
                private final byte[] bytes$1;

                public final Future<RecordMetadata> apply(int x$11) {
                    return this.producer$1.send(new ProducerRecord(this.topicPartition$1.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$1.partition()), (Object)"key", (Object)this.bytes$1));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.producer$1 = producer$1;
                    this.bytes$1 = bytes$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var11_24;
            var11_24.close();
            throw throwable;
        }
        producer.close();
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$12) {
                return x$12.get();
            }
        });
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, topicPartition2, leaderId2, msgValueLen, batchSize, version){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final TopicPartition topicPartition$1;
            private final int leaderId$2;
            private final int msgValueLen$1;
            private final int batchSize$1;
            private final short version$1;

            public final Option<FetchResponse<MemoryRecords>> apply(int x$13) {
                return this.$outer.kafka$server$FetchRequestTest$$fetch$1(this.version$1, this.msgValueLen$1 * 1000, true, this.topicPartition$1, this.leaderId$2, this.batchSize$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.leaderId$2 = leaderId$2;
                this.msgValueLen$1 = msgValueLen$1;
                this.batchSize$1 = batchSize$1;
                this.version$1 = version$1;
            }
        });
        Option response = this.kafka$server$FetchRequestTest$$fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No fetch response");
            }
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$45 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$46 = 5;
        StringSerializer x$47 = new StringSerializer();
        StringSerializer x$48 = new StringSerializer();
        long x$49 = 300000L;
        int x$50 = TestUtils$.MODULE$.createProducer$default$2();
        long x$51 = TestUtils$.MODULE$.createProducer$default$3();
        long x$52 = TestUtils$.MODULE$.createProducer$default$4();
        long x$53 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$54 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$55 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$56 = TestUtils$.MODULE$.createProducer$default$10();
        Option<Properties> x$57 = TestUtils$.MODULE$.createProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$45, x$50, x$51, x$52, x$46, x$49, x$53, x$54, x$55, x$56, x$47, x$48, x$57));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String topic = topicPartition2.topic();
            IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            firstBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$15) {
                    return x$15.get();
                }
            });
            secondBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$16) {
                    return x$16.get();
                }
            });
            long x$58 = 3L;
            long x$59 = 3L;
            short x$60 = 1;
            int x$61 = 22;
            byte x$62 = 0;
            this.check$1(x$58, x$60, x$59, x$61, x$62, topicPartition2, leaderId2);
            long x$63 = 15L;
            long x$64 = 15L;
            short x$65 = 1;
            int x$66 = 10;
            byte x$67 = 0;
            this.check$1(x$63, x$65, x$64, x$66, x$67, topicPartition2, leaderId2);
            long x$68 = 3L;
            long x$69 = 3L;
            short x$70 = 3;
            int x$71 = 22;
            byte x$72 = 1;
            this.check$1(x$68, x$70, x$69, x$71, x$72, topicPartition2, leaderId2);
            long x$73 = 15L;
            long x$74 = 15L;
            short x$75 = 3;
            int x$76 = 10;
            byte x$77 = 1;
            this.check$1(x$73, x$75, x$74, x$76, x$77, topicPartition2, leaderId2);
            long x$78 = 3L;
            long x$79 = 0L;
            short x$80 = 4;
            int x$81 = 2;
            byte x$82 = 2;
            this.check$1(x$78, x$80, x$79, x$81, x$82, topicPartition2, leaderId2);
            long x$83 = 15L;
            long x$84 = 10L;
            short x$85 = 4;
            int x$86 = 1;
            byte x$87 = 2;
            this.check$1(x$83, x$85, x$84, x$86, x$87, topicPartition2, leaderId2);
            long x$88 = 10L;
            long x$89 = 10L;
            short x$90 = 4;
            int x$91 = 1;
            byte x$92 = 2;
            this.check$1(x$88, x$90, x$89, x$91, x$92, topicPartition2, leaderId2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1, bar0})), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)new Serializable(this, resp1){
            public static final long serialVersionUID = 0L;
            private final FetchResponse resp1$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test created an incremental fetch session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.resp1$1.sessionId())}));
            }
            {
                this.resp1$1 = resp1$1;
            }
        });
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo0)).error);
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo1)).error);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)bar0)).error);
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get((Object)bar0)).error);
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get((Object)bar0)).error);
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records).records()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1)new Serializable(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final FetchResponse fetchResponse$1;
            private final int maxPartitionBytes$3;
            private final int numMessagesPerPartition$2;
            private final BooleanRef emptyResponseSeen$1;
            private final IntRef responseSize$1;
            private final IntRef responseBufferSize$1;

            public final void apply(TopicPartition tp) {
                FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.fetchResponse$1.responseData().get(tp);
                Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
                Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
                MemoryRecords records2 = (MemoryRecords)partitionData.records;
                this.responseBufferSize$1.elem += records2.sizeInBytes();
                IndexedSeq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).toIndexedSeq();
                Assert.assertTrue((batches.size() < this.numMessagesPerPartition$2 ? 1 : 0) != 0);
                int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MutableRecordBatch x$17) {
                        return x$17.sizeInBytes();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.responseSize$1.elem += batchesSize;
                if (batchesSize == 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertEquals((long)0L, (long)records2.sizeInBytes());
                    this.emptyResponseSeen$1.elem = true;
                } else if (batchesSize != 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertTrue((batchesSize <= this.maxPartitionBytes$3 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.maxPartitionBytes$3, (long)records2.sizeInBytes());
                } else {
                    if (batchesSize != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)batchesSize)})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
                    }
                    if (records2.sizeInBytes() != 0 && this.emptyResponseSeen$1.elem) {
                        throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)records2.sizeInBytes())})), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResponse$1 = fetchResponse$1;
                this.maxPartitionBytes$3 = maxPartitionBytes$3;
                this.numMessagesPerPartition$2 = numMessagesPerPartition$2;
                this.emptyResponseSeen$1 = emptyResponseSeen$1;
                this.responseSize$1 = responseSize$1;
                this.responseBufferSize$1 = responseBufferSize$1;
            }
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.topicConfig$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        });
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(String topic) {
                scala.collection.immutable.Map<Object, Object> partitionToLeader = this.$outer.createTopic(topic, this.numPartitions$1, 2, this.topicConfig$1);
                return (scala.collection.immutable.Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            int leader2 = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$2, partition)), (Object)BoxesRunTime.boxToInteger((int)leader2));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records2 = (Seq)topicPartitions.toSeq().flatMap((Function1)new Serializable(this, numMessagesPerPartition){
            public static final long serialVersionUID = 0L;
            private final int numMessagesPerPartition$1;

            public final IndexedSeq<ProducerRecord<String, String>> apply(TopicPartition tp) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMessagesPerPartition$1).map((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;

                    public final ProducerRecord<String, String> apply(int messageIndex) {
                        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
                        return new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numMessagesPerPartition$1 = numMessagesPerPartition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final RecordMetadata apply(ProducerRecord<String, String> x$18) {
                return (RecordMetadata)this.$outer.kafka$server$FetchRequestTest$$producer().send(x$18).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    public final Option kafka$server$FetchRequestTest$$fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$1, int leaderId$2, int batchSize$1) {
        Some some;
        Socket socket;
        block3: {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))), this.createPartitionMap$default$3())).build(version);
            socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());
            try {
                this.send((AbstractRequest)fetchRequest, ApiKeys.FETCH, socket, this.send$default$4());
                if (closeAfterPartialResponse) {
                    int size2 = new DataInputStream(socket.getInputStream()).readInt();
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch size too small ", ", broker may have run out of memory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})), (size2 > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                    some = None$.MODULE$;
                    break block3;
                }
                some = new Some((Object)FetchResponse.parse((ByteBuffer)this.receive(socket), (short)version));
            }
            catch (Throwable throwable) {
                void var8_8;
                var8_8.close();
                throw throwable;
            }
        }
        socket.close();
        return some;
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$2, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$2), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((List)JavaConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }
}

