/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.GssapiAuthenticationTest$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001dR:tCBL\u0017)\u001e;iK:$\u0018nY1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0004CBL\u0017BA\u0007\u000b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA\u0005\u0010\u0013\t\u0001\"BA\u0005TCNd7+\u001a;va\")!\u0003\u0001C\u0001'\u00051A(\u001b8jiz\"\u0012\u0001\u0006\t\u0003+\u0001i\u0011A\u0001\u0005\b/\u0001\u0011\r\u0011\"\u0011\u0019\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\t\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0002J]RDa\u0001\t\u0001!\u0002\u0013I\u0012A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0011\u0019\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"1A\u0005\u0001Q\u0001\ne\tabY8ogVlWM]\"pk:$\b\u0005C\u0004'\u0001\t\u0007I\u0011\t\r\u0002\u0017M,'O^3s\u0007>,h\u000e\u001e\u0005\u0007Q\u0001\u0001\u000b\u0011B\r\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\t\u000b)\u0002A\u0011K\u0016\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u0001\u0017\u0011\u00055JT\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001B1vi\"T!!\r\u001a\u0002\u0011M,7-\u001e:jifT!a\r\u001b\u0002\r\r|W.\\8o\u0015\t)QG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e/\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000eC\u0004=\u0001\t\u0007I\u0011B\u001f\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u0015;sS:<\u0007BB$\u0001A\u0003%a(A\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0003bB%\u0001\u0005\u0004%IAS\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001L!\ra\u0015KP\u0007\u0002\u001b*\u0011ajT\u0001\nS6lW\u000f^1cY\u0016T!\u0001U\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002S\u001b\n!A*[:u\u0011\u0019!\u0006\u0001)A\u0005\u0017\u0006Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA!9a\u000b\u0001b\u0001\n\u0013A\u0012A\u00038v[RC'/Z1eg\"1\u0001\f\u0001Q\u0001\ne\t1B\\;n)\"\u0014X-\u00193tA!9!\f\u0001b\u0001\n\u0013Y\u0016\u0001C3yK\u000e,Ho\u001c:\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002b\u0005\u0006!Q\u000f^5m\u0013\t\u0019gLA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0019)\u0007\u0001)A\u00059\u0006IQ\r_3dkR|'\u000f\t\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u00031\u0019G.[3oi\u000e{gNZ5h+\u0005I\u0007C\u00016l\u001b\u0005\u0001\u0017B\u00017a\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007]\u0002\u0001\u000b\u0011B5\u0002\u001b\rd\u0017.\u001a8u\u0007>tg-[4!\u0011%\u0001\b\u00011AA\u0002\u0013%\u0011/\u0001\u0006tKJ4XM]!eIJ,\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\n\u000b1A\\3u\u0013\t9HOA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgND\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\u0002\u001dM,'O^3s\u0003\u0012$'o\u0018\u0013fcR\u00111P \t\u00035qL!!`\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fb\f\t\u00111\u0001s\u0003\rAH%\r\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003s\u0003-\u0019XM\u001d<fe\u0006#GM\u001d\u0011\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005)1/\u001a;VaR\t1\u0010\u000b\u0003\u0002\u0006\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005Mq'A\u0003kk:LG/\u0003\u0003\u0002\u0018\u0005E!A\u0002\"fM>\u0014X\rC\u0004\u0002\u001c\u0001!\t%!\u0003\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0007\u0002 A!\u0011qBA\u0011\u0013\u0011\t\u0019#!\u0005\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002\n\u0005!B/Z:u%\u0016\fX/Z:u\u0013N\f%+\u001a9mCfDC!!\n\u0002,A!\u0011qBA\u0017\u0013\u0011\ty#!\u0005\u0003\tQ+7\u000f\u001e\u0005\b\u0003g\u0001A\u0011AA\u0005\u0003\u0011\"Xm\u001d;TKJ4XM\u001d(pi\u001a{WO\u001c3J].+'OY3s_N$\u0015\r^1cCN,\u0007\u0006BA\u0019\u0003WAq!!\u000f\u0001\t\u0013\tY$A\u0016wKJLg-\u001f*fiJL\u0017M\u00197f\r\u0006LG.\u001e:fg\u0012+(/\u001b8h\u0003V$\b.\u001a8uS\u000e\fG/[8o)\rY\u0018Q\b\u0005\b\u0003\u007f\t9\u00041\u0001\u001a\u0003IqW/\\*vG\u000e,7o\u001d4vY\u0006+H\u000f[:\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002\n\u00059c/\u001a:jMftuN\u001c*fiJL\u0017M\u00197f\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013\nab\u0019:fCR,7+\u001a7fGR|'\u000f\u0006\u0002\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002RI\nqA\\3uo>\u00148.\u0003\u0003\u0002V\u0005=#\u0001C*fY\u0016\u001cGo\u001c:")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService kafka$server$GssapiAuthenticationTest$$executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    public ExecutorService kafka$server$GssapiAuthenticationTest$$executor() {
        return this.kafka$server$GssapiAuthenticationTest$$executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        super.setUp();
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$server$GssapiAuthenticationTest$$executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1)new Serializable(this, successfulAuthsPerThread){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            public final int successfulAuthsPerThread$1;

            public final Future<?> apply(int x$1) {
                return this.$outer.kafka$server$GssapiAuthenticationTest$$executor().submit(new Runnable(this){
                    private final /* synthetic */ $anonfun$1 $outer;

                    public void run() {
                        this.$outer.kafka$server$GssapiAuthenticationTest$$anonfun$$$outer().kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.$outer.successfulAuthsPerThread$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GssapiAuthenticationTest kafka$server$GssapiAuthenticationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> x$2) {
                return x$2.get(60L, TimeUnit.SECONDS);
            }
        });
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assert.assertTrue((String)new StringBuilder().append((Object)"Too few authentications: ").append((Object)BoxesRunTime.boxToLong((long)successfulAuths)).toString(), (successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0);
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String jaasConfig = this.clientConfig().getProperty("sasl.jaas.config");
        String invalidServiceConfig = jaasConfig.replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        Selector selector = this.createSelector();
        try {
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = ((Object)BoxesRunTime.boxToInteger((int)actualSuccessfulAuths)).toString();
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, selector, nodeId){
                    public static final long serialVersionUID = 0L;
                    private final Selector selector$1;
                    private final String nodeId$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.selector$1.poll(100L);
                        ChannelState disconnectState = (ChannelState)this.selector$1.disconnected().get(this.nodeId$1);
                        if (disconnectState != null) {
                            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication failed with exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{disconnectState.exception()})), (Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state());
                        }
                        return this.selector$1.isChannelReady(this.nodeId$1) || disconnectState != null;
                    }
                    {
                        this.selector$1 = selector$1;
                        this.nodeId$1 = nodeId$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Client not ready or disconnected within timeout";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                if (selector.isChannelReady(nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        selector.close();
    }

    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, selector, nodeId){
            public static final long serialVersionUID = 0L;
            private final Selector selector$2;
            private final String nodeId$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.selector$2.poll(100L);
                ChannelState disconnectState = (ChannelState)this.selector$2.disconnected().get(this.nodeId$2);
                if (disconnectState != null) {
                    Assert.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
                }
                return disconnectState != null;
            }
            {
                this.selector$2 = selector$2;
                this.nodeId$2 = nodeId$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Client not disconnected within timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private Selector createSelector() {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafkaClientSaslMechanism(), (boolean)true);
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder);
    }

    public GssapiAuthenticationTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 0;
        this.consumerCount = 0;
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GSSAPI"}));
        this.numThreads = 10;
        this.kafka$server$GssapiAuthenticationTest$$executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
    }
}

