/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUd!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\toJLG/\u00192mKV\t\u0011\t\u0005\u0002\u000b\u0005&\u00111i\u0003\u0002\b\u0005>|G.Z1o\u0011!)\u0005A!A!\u0002\u0013\t\u0015!C<sSR\f'\r\\3!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011*\u0017.\\9B!!\nA&W\u001b\u0005\u0011\u0001C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011aS\t\u0003!N\u0003\"AC)\n\u0005I[!a\u0002(pi\"Lgn\u001a\t\u0003\u0015QK!!V\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M/\u0012)\u0001\f\u0001b\u0001\u001f\n\ta\u000bC\u0003\u0017\r\u0002\u0007\u0001\u0004C\u00030\r\u0002\u0007\u0011\u0007C\u00048\rB\u0005\t\u0019A\u001d\t\u000b}2\u0005\u0019A!\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0014aB0mK:<G\u000f\u001b\u0005\nA\u0002\u0001\r\u00111A\u0005\n\u0005\f1b\u00187f]\u001e$\bn\u0018\u0013fcR\u00111E\u0019\u0005\bO}\u000b\t\u00111\u00012\u0011\u0019!\u0007\u0001)Q\u0005c\u0005Aq\f\\3oORD\u0007\u0005\u000b\u0002dW!)q\r\u0001D\tq\u0005IQM\u001c;ssNK'0\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0005k\u0003\u0011awnY6\u0016\u0003-\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u000b1|7m[:\u000b\u0005A\f\u0018AC2p]\u000e,(O]3oi*\u0011!\u000fH\u0001\u0005kRLG.\u0003\u0002u[\ni!+Z3oiJ\fg\u000e\u001e'pG.DaA\u001e\u0001!\u0002\u0013Y\u0017!\u00027pG.\u0004\u0003b\u0002=\u0001\u0001\u0004%\t\"_\u0001\u0005[6\f\u0007/F\u0001{!\tYh0D\u0001}\u0015\tiH$A\u0002oS>L!a ?\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\b\"CA\u0002\u0001\u0001\u0007I\u0011CA\u0003\u0003!iW.\u00199`I\u0015\fHcA\u0012\u0002\b!Aq%!\u0001\u0002\u0002\u0003\u0007!\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002>\u0002\u000b5l\u0017\r\u001d\u0011)\u0007\u0005%1\u0006C\u0004\u0002\u0012\u0001\u0001\u000b\u0015B\u001d\u0002\u0017}k\u0017\r_#oiJLWm\u001d\u0015\u0004\u0003\u001fY\u0003\u0002CA\f\u0001\u0001\u0007I\u0011\u0003\u001d\u0002\u0011}+g\u000e\u001e:jKND\u0011\"a\u0007\u0001\u0001\u0004%\t\"!\b\u0002\u0019}+g\u000e\u001e:jKN|F%Z9\u0015\u0007\r\ny\u0002\u0003\u0005(\u00033\t\t\u00111\u0001:\u0011\u001d\t\u0019\u0003\u0001Q!\ne\n\u0011bX3oiJLWm\u001d\u0011)\u0007\u0005\u00052\u0006\u0003\u0004\u0002*\u0001!\t\u0001Q\u0001\u0007SN4U\u000f\u001c7\t\r\u00055\u0002\u0001\"\u00019\u0003)i\u0017\r_#oiJLWm\u001d\u0005\u0007\u0003c\u0001A\u0011\u0001\u001d\u0002\u000f\u0015tGO]5fg\"1\u0011Q\u0007\u0001\u0005\u0002A\na\u0001\\3oORD\u0007bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0007e\u0016\u001c\u0018N_3\u0015\u0007\u0005\u000bi\u0004C\u0004\u0002@\u0005]\u0002\u0019A\u001d\u0002\u000f9,woU5{K\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013\u0001\u0003:f]\u0006lW\rV8\u0015\u0007\r\n9\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019\u0001\r\u0002\u0003\u0019Dq!!\u0014\u0001\t\u0003\ty%A\u0003gYV\u001c\b\u000eF\u0001$\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\na\u0002Z3mKR,\u0017JZ#ySN$8\u000fF\u0001B\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u001f\nq\u0002\u001e:j[R{g+\u00197jINK'0\u001a\u0005\u0007\u0003;\u0002A\u0011\u0001\u001d\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\b\u0003C\u0002A\u0011AA(\u0003\u0015\u0019Gn\\:f\u0011\u001d\t)\u0007\u0001C\u0001\u0003\u001f\nAb\u00197pg\u0016D\u0015M\u001c3mKJDq!!\u001b\u0001\r\u0003\ty%A\u0006tC:LG/_\"iK\u000e\\\u0007bBA7\u0001\u0019E\u0011qJ\u0001\tiJ,hnY1uK\"9\u0011\u0011\u000f\u0001\u0007\u0002\u0005M\u0014A\u0003;sk:\u001c\u0017\r^3U_R\u00191%!\u001e\t\u000f\u0005]\u0014q\u000ea\u0001c\u00051qN\u001a4tKRDq!a\u001f\u0001\t\u0003\ty%A\u0003sKN,G\u000fC\u0004\u0002\u0000\u0001!\t!!!\u0002\u001dI,G.\u0019;jm\u0016|eMZ:fiR\u0019\u0011(a!\t\u000f\u0005]\u0014Q\u0010a\u0001c!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0015aD2b]\u0006\u0003\b/\u001a8e\u001f\u001a47/\u001a;\u0015\u0007\u0005\u000bY\tC\u0004\u0002x\u0005\u0015\u0005\u0019A\u0019\t\u000f\u0005=\u0005\u0001\"\u0005\u0002P\u0005q1/\u00194f\r>\u00148-Z+o[\u0006\u0004\b\u0002CAJ\u0001\u0011E!!a\u0014\u0002\u0015\u0019|'oY3V]6\f\u0007\u000fC\u0004\u0002\u0018\u0002!\t\"!'\u0002\u00135\f\u0017PY3M_\u000e\\W\u0003BAN\u0003C#B!!(\u00020R!\u0011qTAS!\ra\u0015\u0011\u0015\u0003\b\u0003G\u000b)J1\u0001P\u0005\u0005!\u0006\"CAT\u0003+#\t\u0019AAU\u0003\r1WO\u001c\t\u0006\u0015\u0005-\u0016qT\u0005\u0004\u0003[[!\u0001\u0003\u001fcs:\fW.\u001a \t\u000f%\f)\n1\u0001\u00022B\u0019A.a-\n\u0007\u0005UVN\u0001\u0003M_\u000e\\\u0007bBA]\u0001\u0019E\u00111X\u0001\u000ba\u0006\u00148/Z#oiJLHCBA_\u0003\u0007\fi\rE\u0002K\u0003\u007fK1!!1\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\t\u0003\u000b\f9\f1\u0001\u0002H\u00061!-\u001e4gKJ\u00042a_Ae\u0013\r\tY\r \u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBAh\u0003o\u0003\r!O\u0001\u0002]\"9\u00111\u001b\u0001\u0005\u0012\u0005U\u0017\u0001\u00077be\u001e,7\u000f\u001e'po\u0016\u0014(i\\;oINcw\u000e\u001e$peR9\u0011(a6\u0002\\\u0006}\u0007\u0002CAm\u0003#\u0004\r!a2\u0002\u0007%$\u0007\u0010C\u0004\u0002^\u0006E\u0007\u0019A\u0019\u0002\rQ\f'oZ3u\u0011!\t\t/!5A\u0002\u0005\r\u0018\u0001D:fCJ\u001c\u0007.\u00128uSRL\b\u0003BAs\u0003stA!a:\u0002v:!\u0011\u0011^Az\u001d\u0011\tY/!=\u000e\u0005\u00055(bAAx\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I1!a>\u0003\u0003=Ie\u000eZ3y'\u0016\f'o\u00195UsB,\u0017\u0002BA~\u0003{\u0014\u0011#\u00138eKb\u001cV-\u0019:dQ\u0016sG/\u001b;z\u0015\r\t9P\u0001\u0005\b\u0005\u0003\u0001A\u0011\u0003B\u0002\u0003e\u0019X.\u00197mKN$X\u000b\u001d9fe\n{WO\u001c3TY>$hi\u001c:\u0015\u000fe\u0012)Aa\u0002\u0003\n!A\u0011\u0011\\A\u0000\u0001\u0004\t9\rC\u0004\u0002^\u0006}\b\u0019A\u0019\t\u0011\u0005\u0005\u0018q a\u0001\u0003GDqA!\u0004\u0001\t\u0013\u0011y!A\tj]\u0012,\u0007p\u00157piJ\u000bgnZ3G_J$\u0002B!\u0005\u0003\u0018\te!1\u0004\t\u0006\u0015\tM\u0011(O\u0005\u0004\u0005+Y!A\u0002+va2,'\u0007\u0003\u0005\u0002Z\n-\u0001\u0019AAd\u0011\u001d\tiNa\u0003A\u0002EB\u0001\"!9\u0003\f\u0001\u0007\u00111\u001d\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0003E\u0019w.\u001c9be\u0016Le\u000eZ3y\u000b:$(/\u001f\u000b\bs\t\r\"q\u0005B\u0015\u0011!\u0011)C!\bA\u0002\u0005u\u0016AC5oI\u0016DXI\u001c;ss\"9\u0011Q\u001cB\u000f\u0001\u0004\t\u0004\u0002CAq\u0005;\u0001\r!a9\t\u000f\t5\u0002\u0001\"\u0003\u00030\u0005A\"o\\;oI\u0012{wO\u001c+p\u000bb\f7\r^'vYRL\u0007\u000f\\3\u0015\u000be\u0012\tD!\u000e\t\u000f\tM\"1\u0006a\u0001s\u00051a.^7cKJDqAa\u000e\u0003,\u0001\u0007\u0011(\u0001\u0004gC\u000e$xN\u001d\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0003)!xNU3mCRLg/\u001a\u000b\u0005\u0005\u007f\u0011)\u0005\u0005\u0003\u000b\u0005\u0003J\u0014b\u0001B\"\u0017\t1q\n\u001d;j_:Dq!a\u001e\u0003:\u0001\u0007\u0011gB\u0005\u0003J\t\t\t\u0011#\u0001\u0003L\u0005i\u0011IY:ue\u0006\u001cG/\u00138eKb\u00042A\u0013B'\r!\t!!!A\t\u0002\t=3c\u0001B'\u0013!9qI!\u0014\u0005\u0002\tMCC\u0001B&\u0011)\u00119F!\u0014\u0012\u0002\u0013\u0005!\u0011L\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\tm#\u0011\u000fB:+\t\u0011iFK\u0002:\u0005?Z#A!\u0019\u0011\t\t\r$QN\u0007\u0003\u0005KRAAa\u001a\u0003j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005WZ\u0011AC1o]>$\u0018\r^5p]&!!q\u000eB3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007\u001d\nU#\u0019A(\u0005\ra\u0013)F1\u0001P\u0001")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long kafka$log$AbstractIndex$$_length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public long kafka$log$AbstractIndex$$_length() {
        return this.kafka$log$AbstractIndex$$_length;
    }

    public void kafka$log$AbstractIndex$$_length_$eq(long x$1) {
        this.kafka$log$AbstractIndex$$_length = x$1;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this.kafka$log$AbstractIndex$$_length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                boolean bl;
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                if (this.$outer.kafka$log$AbstractIndex$$_length() == (long)roundedNewSize) {
                    return false;
                }
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                try {
                    int position = this.$outer.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.$outer.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$AbstractIndex$$_length_$eq(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    this.$outer.mmap().position(position);
                    bl = true;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                    throw throwable;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean deleteIfExists() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset2) {
        Option<Object> relativeOffset = this.toRelative(offset2);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow for offset: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.file().getAbsoluteFile()})));
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset2) {
        return this.toRelative(offset2).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset2) {
        long relativeOffset = offset2 - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this.kafka$log$AbstractIndex$$_length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.kafka$log$AbstractIndex$$_length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.kafka$log$AbstractIndex$$_length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }, this, CoreUtils$.MODULE$.swallow$default$3());
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

