/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t'v\u001bB\u0001A\u0005\u0012/A\u0011!bD\u0007\u0002\u0017)\u0011A\"D\u0001\u0005Y\u0006twMC\u0001\u000f\u0003\u0011Q\u0017M^1\n\u0005AY!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\u001b\u0005\u0011\u0011n\\\u0005\u0003-M\u0011\u0011b\u00117pg\u0016\f'\r\\3\u0011\u0005aYR\"A\r\u000b\u0005i!\u0011!B;uS2\u001c\u0018B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001eD\u0001B\b\u0001\u0003\u0002\u0004%\taH\u0001\u0005M&dW-F\u0001!!\t\u0011\u0012%\u0003\u0002#'\t!a)\u001b7f\u0011!!\u0003A!a\u0001\n\u0003)\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0012\u0002\u0002\u0003\u0007\u0001%A\u0002yIEB\u0001b\f\u0001\u0003\u0002\u0003\u0006K\u0001I\u0001\u0006M&dW\r\t\u0015\u0003]E\u0002\"a\n\u001a\n\u0005MB#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011U\u0002!Q1A\u0005\u0002Y\n!BY1tK>3gm]3u+\u00059\u0004CA\u00149\u0013\tI\u0004F\u0001\u0003M_:<\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0017\t\f7/Z(gMN,G\u000f\t\u0005\t{\u0001\u0011)\u0019!C\u0001}\u0005aQ.\u0019=J]\u0012,\u0007pU5{KV\tq\b\u0005\u0002(\u0001&\u0011\u0011\t\u000b\u0002\u0004\u0013:$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u001b5\f\u00070\u00138eKb\u001c\u0016N_3!\u0011!)\u0005A!b\u0001\n\u00031\u0015\u0001C<sSR\f'\r\\3\u0016\u0003\u001d\u0003\"a\n%\n\u0005%C#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\u0006IqO]5uC\ndW\r\t\u0005\u0006\u001b\u0002!\tAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b={\u0006-\u00192\u0011\tA\u0003\u0011\u000bX\u0007\u0002\u0005A\u0011!k\u0015\u0007\u0001\t\u0015!\u0006A1\u0001V\u0005\u0005Y\u0015C\u0001,Z!\t9s+\u0003\u0002YQ\t9aj\u001c;iS:<\u0007CA\u0014[\u0013\tY\u0006FA\u0002B]f\u0004\"AU/\u0005\u000by\u0003!\u0019A+\u0003\u0003YCQA\b'A\u0002\u0001BQ!\u000e'A\u0002]Bq!\u0010'\u0011\u0002\u0003\u0007q\bC\u0003F\u0019\u0002\u0007q\tC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005m\u00059q\f\\3oORD\u0007\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0003-yF.\u001a8hi\"|F%Z9\u0015\u0005\u0019B\u0007bB\u0017f\u0003\u0003\u0005\ra\u000e\u0005\u0007U\u0002\u0001\u000b\u0015B\u001c\u0002\u0011}cWM\\4uQ\u0002B#![\u0019\t\u000b5\u0004a\u0011\u0003 \u0002\u0013\u0015tGO]=TSj,\u0007\"B8\u0001\t#q\u0014\u0001D0xCJlWI\u001c;sS\u0016\u001c\bbB9\u0001\u0005\u0004%\tB]\u0001\u0005Y>\u001c7.F\u0001t!\t!80D\u0001v\u0015\t1x/A\u0003m_\u000e\\7O\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005il\u0011\u0001B;uS2L!\u0001`;\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019q\b\u0001)A\u0005g\u0006)An\\2lA!I\u0011\u0011\u0001\u0001A\u0002\u0013E\u00111A\u0001\u0005[6\f\u0007/\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f5\t1A\\5p\u0013\u0011\ty!!\u0003\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\b\"CA\n\u0001\u0001\u0007I\u0011CA\u000b\u0003!iW.\u00199`I\u0015\fHc\u0001\u0014\u0002\u0018!IQ&!\u0005\u0002\u0002\u0003\u0007\u0011Q\u0001\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u0006\u0005)Q.\\1qA!\u001a\u0011\u0011D\u0019\t\u000f\u0005\u0005\u0002\u0001)Q\u0005\u007f\u0005Yq,\\1y\u000b:$(/[3tQ\r\ty\"\r\u0005\t\u0003O\u0001\u0001\u0019!C\t}\u0005Aq,\u001a8ue&,7\u000fC\u0005\u0002,\u0001\u0001\r\u0011\"\u0005\u0002.\u0005aq,\u001a8ue&,7o\u0018\u0013fcR\u0019a%a\f\t\u00115\nI#!AA\u0002}Bq!a\r\u0001A\u0003&q(A\u0005`K:$(/[3tA!\u001a\u0011\u0011G\u0019\t\r\u0005e\u0002\u0001\"\u0001G\u0003\u0019I7OR;mY\"1\u0011Q\b\u0001\u0005\u0002y\n!\"\\1y\u000b:$(/[3t\u0011\u0019\t\t\u0005\u0001C\u0001}\u00059QM\u001c;sS\u0016\u001c\bBBA#\u0001\u0011\u0005a'\u0001\u0004mK:<G\u000f\u001b\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003\u0019\u0011Xm]5{KR\u0019q)!\u0014\t\u000f\u0005=\u0013q\ta\u0001\u007f\u00059a.Z<TSj,\u0007bBA*\u0001\u0011\u0005\u0011QK\u0001\te\u0016t\u0017-\\3U_R\u0019a%a\u0016\t\u000f\u0005e\u0013\u0011\u000ba\u0001A\u0005\ta\rC\u0004\u0002^\u0001!\t!a\u0018\u0002\u000b\u0019dWo\u001d5\u0015\u0003\u0019Bq!a\u0019\u0001\t\u0003\t)'\u0001\beK2,G/Z%g\u000bbL7\u000f^:\u0015\u0003\u001dCq!!\u001b\u0001\t\u0003\ty&A\bue&lGk\u001c,bY&$7+\u001b>f\u0011\u0019\ti\u0007\u0001C\u0001}\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u001d\t\t\b\u0001C\u0001\u0003?\nQa\u00197pg\u0016Dq!!\u001e\u0001\t\u0003\ty&\u0001\u0007dY>\u001cX\rS1oI2,'\u000fC\u0004\u0002z\u00011\t!a\u0018\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0005\b\u0003{\u0002a\u0011CA0\u0003!!(/\u001e8dCR,\u0007bBAA\u0001\u0019\u0005\u00111Q\u0001\u000biJ,hnY1uKR{Gc\u0001\u0014\u0002\u0006\"9\u0011qQA@\u0001\u00049\u0014AB8gMN,G\u000fC\u0004\u0002\f\u0002!\t!a\u0018\u0002\u000bI,7/\u001a;\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$HcA \u0002\u0014\"9\u0011qQAG\u0001\u00049\u0004bBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u0010G\u0006t\u0017\t\u001d9f]\u0012|eMZ:fiR\u0019q)a'\t\u000f\u0005\u001d\u0015Q\u0013a\u0001o!9\u0011q\u0014\u0001\u0005\u0012\u0005}\u0013AD:bM\u00164uN]2f+:l\u0017\r\u001d\u0005\t\u0003G\u0003A\u0011\u0003\u0002\u0002`\u0005Qam\u001c:dKVsW.\u00199\t\u000f\u0005\u001d\u0006\u0001\"\u0005\u0002*\u0006IQ.Y=cK2{7m[\u000b\u0005\u0003W\u000b\t\f\u0006\u0003\u0002.\u0006}F\u0003BAX\u0003k\u00032AUAY\t\u001d\t\u0019,!*C\u0002U\u0013\u0011\u0001\u0016\u0005\n\u0003o\u000b)\u000b\"a\u0001\u0003s\u000b1AZ;o!\u00159\u00131XAX\u0013\r\ti\f\u000b\u0002\ty\tLh.Y7f}!9\u0011/!*A\u0002\u0005\u0005\u0007c\u0001;\u0002D&\u0019\u0011QY;\u0003\t1{7m\u001b\u0005\b\u0003\u0013\u0004a\u0011CAf\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0007\u0003\u001b\f\u0019.!8\u0011\u0007A\u000by-C\u0002\u0002R\n\u0011!\"\u00138eKb,e\u000e\u001e:z\u0011!\t).a2A\u0002\u0005]\u0017A\u00022vM\u001a,'\u000f\u0005\u0003\u0002\b\u0005e\u0017\u0002BAn\u0003\u0013\u0011!BQ=uK\n+hMZ3s\u0011\u001d\ty.a2A\u0002}\n\u0011A\u001c\u0005\b\u0003G\u0004A\u0011CAs\u0003aa\u0017M]4fgRdun^3s\u0005>,h\u000eZ*m_R4uN\u001d\u000b\b\u007f\u0005\u001d\u00181^Ax\u0011!\tI/!9A\u0002\u0005]\u0017aA5eq\"9\u0011Q^Aq\u0001\u00049\u0014A\u0002;be\u001e,G\u000f\u0003\u0005\u0002r\u0006\u0005\b\u0019AAz\u00031\u0019X-\u0019:dQ\u0016sG/\u001b;z!\u0011\t)P!\u0003\u000f\t\u0005](Q\u0001\b\u0005\u0003s\u0014\u0019A\u0004\u0003\u0002|\n\u0005QBAA\u007f\u0015\r\tyPB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0007\t\u001d!!A\bJ]\u0012,\u0007pU3be\u000eDG+\u001f9f\u0013\u0011\u0011YA!\u0004\u0003#%sG-\u001a=TK\u0006\u00148\r[#oi&$\u0018PC\u0002\u0003\b\tAqA!\u0005\u0001\t#\u0011\u0019\"A\rt[\u0006dG.Z:u+B\u0004XM\u001d\"pk:$7\u000b\\8u\r>\u0014HcB \u0003\u0016\t]!\u0011\u0004\u0005\t\u0003S\u0014y\u00011\u0001\u0002X\"9\u0011Q\u001eB\b\u0001\u00049\u0004\u0002CAy\u0005\u001f\u0001\r!a=\t\u000f\tu\u0001\u0001\"\u0003\u0003 \u0005\t\u0012N\u001c3fqNcw\u000e\u001e*b]\u001e,gi\u001c:\u0015\u0011\t\u0005\"q\u0005B\u0015\u0005W\u0001Ra\nB\u0012\u007f}J1A!\n)\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u001eB\u000e\u0001\u0004\t9\u000eC\u0004\u0002n\nm\u0001\u0019A\u001c\t\u0011\u0005E(1\u0004a\u0001\u0003gDqAa\f\u0001\t\u0013\u0011\t$A\td_6\u0004\u0018M]3J]\u0012,\u00070\u00128uef$ra\u0010B\u001a\u0005o\u0011I\u0004\u0003\u0005\u00036\t5\u0002\u0019AAg\u0003)Ig\u000eZ3y\u000b:$(/\u001f\u0005\b\u0003[\u0014i\u00031\u00018\u0011!\t\tP!\fA\u0002\u0005M\bb\u0002B\u001f\u0001\u0011%!qH\u0001\u0019e>,h\u000e\u001a#po:$v.\u0012=bGRlU\u000f\u001c;ja2,G#B \u0003B\t\u0015\u0003b\u0002B\"\u0005w\u0001\raP\u0001\u0007]Vl'-\u001a:\t\u000f\t\u001d#1\ba\u0001\u007f\u00051a-Y2u_JDqAa\u0013\u0001\t\u0013\u0011i%\u0001\u0006u_J+G.\u0019;jm\u0016$BAa\u0014\u0003VA!qE!\u0015@\u0013\r\u0011\u0019\u0006\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u001d%\u0011\na\u0001o\u001dI!\u0011\f\u0002\u0002\u0002#\u0005!1L\u0001\u000e\u0003\n\u001cHO]1di&sG-\u001a=\u0011\u0007A\u0013iF\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B0'\u0011\u0011iF!\u0019\u0011\u0007\u001d\u0012\u0019'C\u0002\u0003f!\u0012a!\u00118z%\u00164\u0007bB'\u0003^\u0011\u0005!\u0011\u000e\u000b\u0003\u00057B!B!\u001c\u0003^E\u0005I\u0011\u0001B8\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU1!\u0011\u000fBD\u0005\u0013+\"Aa\u001d+\u0007}\u0012)h\u000b\u0002\u0003xA!!\u0011\u0010BB\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014!C;oG\",7m[3e\u0015\r\u0011\t\tK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BC\u0005w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019!&1\u000eb\u0001+\u00121aLa\u001bC\u0002U\u0003")
public abstract class AbstractIndex<K, V>
implements Closeable,
Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long kafka$log$AbstractIndex$$_length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public long kafka$log$AbstractIndex$$_length() {
        return this.kafka$log$AbstractIndex$$_length;
    }

    public void kafka$log$AbstractIndex$$_length_$eq(long x$1) {
        this.kafka$log$AbstractIndex$$_length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this.kafka$log$AbstractIndex$$_length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                boolean bl;
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                if (this.$outer.kafka$log$AbstractIndex$$_length() == (long)roundedNewSize) {
                    return false;
                }
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                try {
                    int position = this.$outer.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.$outer.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$AbstractIndex$$_length_$eq(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    this.$outer.mmap().position(position);
                    bl = true;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                    throw throwable;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean deleteIfExists() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset2) {
        Option<Object> relativeOffset = this.toRelative(offset2);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow for offset: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.file().getAbsoluteFile()})));
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset2) {
        return this.toRelative(offset2).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset2) {
        long relativeOffset = offset2 - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this.kafka$log$AbstractIndex$$_length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.kafka$log$AbstractIndex$$_length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.kafka$log$AbstractIndex$$_length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }, this, CoreUtils$.MODULE$.swallow$default$3());
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

