/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.EOFException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class CoreUtils$
implements Logging {
    public static final CoreUtils$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new CoreUtils$();
    }

    private Logger logger$lzycompute() {
        CoreUtils$ coreUtils$ = this;
        synchronized (coreUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public <A, B> A min(TraversableOnce<A> traversable, A ifEmpty, Ordering<B> cmp) {
        return (A)(traversable.isEmpty() ? ifEmpty : traversable.min(cmp));
    }

    public Runnable runnable(Function0<BoxedUnit> fun) {
        return new Runnable(fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        };
    }

    public Thread newThread(String name, boolean daemon, Function0<BoxedUnit> fun) {
        return new KafkaThread(name, this.runnable(fun), daemon);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        Level level;
        block16: {
            try {
                action.apply$mcV$sp();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                level = logLevel;
                if (Level.ERROR.equals(level)) {
                    BoxedUnit boxedUnit2;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(throwable.getMessage(), throwable);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                }
                if (Level.WARN.equals(level)) {
                    BoxedUnit boxedUnit4;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(throwable.getMessage(), throwable);
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit5 = boxedUnit4;
                }
                if (Level.INFO.equals(level)) {
                    BoxedUnit boxedUnit6;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(throwable.getMessage(), throwable);
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit7 = boxedUnit6;
                }
                if (Level.DEBUG.equals(level)) {
                    BoxedUnit boxedUnit8;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(throwable.getMessage(), throwable);
                        boxedUnit8 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit8 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit9 = boxedUnit8;
                }
                if (!Level.TRACE.equals(level)) break block16;
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(throwable.getMessage(), throwable);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit10 = boxedUnit;
            }
            return;
        }
        throw new MatchError((Object)level);
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils.delete((File)new File(f));
            }
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = ObjectRef.create(null);
        all.foreach((Function1)new Serializable(exception){
            public static final long serialVersionUID = 0L;
            private final ObjectRef exception$1;

            public final void apply(Function0<BoxedUnit> element) {
                try {
                    element.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    if ((Throwable)this.exception$1.elem == null) {
                        this.exception$1.elem = throwable;
                    }
                    ((Throwable)this.exception$1.elem).addSuppressed(throwable);
                }
            }
            {
                this.exception$1 = exception$1;
            }
        });
        if ((Throwable)exception.elem == null) {
            return;
        }
        throw (Throwable)exception.elem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name) {
        try {
            Boolean bl2;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl2 = BoxesRunTime.boxToBoolean((boolean)true);
            }
            boolean bl = BoxesRunTime.unboxToBoolean((Object)bl2);
            return bl;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            }, (Function0<Throwable>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            return false;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n;
        int n2 = channel.read(buffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String s) {
                int lio = s.lastIndexOf(":");
                return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return Predef$.MODULE$.refArrayOps((Object[])keyVals).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className, true, Utils.getContextOrKafkaClassLoader());
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Object x$1) {
                return x$1.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        return Iterator$.MODULE$.continually((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap((Function1)new Serializable(coll){
            public static final long serialVersionUID = 0L;
            private final Iterable coll$1;

            public final Iterable<T> apply(int _) {
                return (Iterable)this.coll$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = coll$1;
            }
        });
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (s.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s.substring(0, s.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
    }

    public int readInt(byte[] bytes, int offset2) {
        return (bytes[offset2] & 0xFF) << 24 | (bytes[offset2 + 1] & 0xFF) << 16 | (bytes[offset2 + 2] & 0xFF) << 8 | bytes[offset2 + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        try {
            return (T)fun.apply();
        }
        finally {
            lock2.unlock();
        }
    }

    public <T> T inReadLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.writeLock(), fun);
    }

    public String JSONEscapeString(String s) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(char x0$1) {
                Object object;
                char c = x0$1;
                switch (c) {
                    default: {
                        if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                            object = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
                            break;
                        }
                        object = BoxesRunTime.boxToCharacter((char)c);
                        break;
                    }
                    case '\t': {
                        object = "\\t";
                        break;
                    }
                    case '\r': {
                        object = "\\r";
                        break;
                    }
                    case '\n': {
                        object = "\\n";
                        break;
                    }
                    case '\f': {
                        object = "\\f";
                        break;
                    }
                    case '\b': {
                        object = "\\b";
                        break;
                    }
                    case '/': {
                        object = "\\/";
                        break;
                    }
                    case '\\': {
                        object = "\\\\";
                        break;
                    }
                    case '\"': {
                        object = "\\\"";
                    }
                }
                return object;
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(T x) {
                return (T)Predef$.MODULE$.identity(x);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<T, Object> apply(Tuple2<T, Traversable<T>> x0$2) {
                Tuple2<T, Traversable<T>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Traversable l = (Traversable)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<T, Object> x0$3) {
                Tuple2<T, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    int l = tuple2._2$mcI$sp();
                    boolean bl = l > 1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).keys();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<EndPoint> listenerListToEndPoints(String listeners2, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        try {
            void var3_4;
            Seq<String> listenerList = this.parseCsvList(listeners2);
            Seq endPoints = (Seq)listenerList.map((Function1)new Serializable(securityProtocolMap){
                public static final long serialVersionUID = 0L;
                private final Map securityProtocolMap$1;

                public final EndPoint apply(String x$5) {
                    return EndPoint$.MODULE$.createEndPoint(x$5, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)this.securityProtocolMap$1));
                }
                {
                    this.securityProtocolMap$1 = securityProtocolMap$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.validate$1(endPoints, listeners2);
            return var3_4;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error creating broker listeners from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listeners2, exception.getMessage()})), exception);
        }
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value2) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value2)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.properties$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        return var2_2;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Option option;
        block4: {
            Object object;
            block3: {
                block2: {
                    Object value2;
                    option = map.get(key);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    object = value2 = some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Object value3 = createValue.apply();
                object = map.putIfAbsent(key, value3).getOrElse((Function0)new Serializable(value3){
                    public static final long serialVersionUID = 0L;
                    private final Object value$1;

                    public final V apply() {
                        return (V)this.value$1;
                    }
                    {
                        this.value$1 = value$1;
                    }
                });
            }
            return (V)object;
        }
        throw new MatchError((Object)option);
    }

    private final void validate$1(Seq endPoints, String listeners$1) {
        Seq portsExcludingZero = (Seq)((TraversableLike)endPoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(EndPoint x$2) {
                return x$2.port();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return x$3 != 0;
            }
        });
        Seq distinctPorts = (Seq)portsExcludingZero.distinct();
        Seq distinctListenerNames = (Seq)((SeqLike)endPoints.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ListenerName apply(EndPoint x$4) {
                return x$4.listenerName();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == portsExcludingZero.size(), (Function0)new Serializable(listeners$1){
            public static final long serialVersionUID = 0L;
            private final String listeners$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Each listener must have a different port, listeners: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listeners$1}));
            }
            {
                this.listeners$1 = listeners$1;
            }
        });
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0)new Serializable(listeners$1){
            public static final long serialVersionUID = 0L;
            private final String listeners$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Each listener must have a different name, listeners: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listeners$1}));
            }
            {
                this.listeners$1 = listeners$1;
            }
        });
    }

    private CoreUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

