/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import kafka.api.BaseConsumerTest;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\b#\u0001\u0011\r\u0011\"\u0001\u0013\u0003\u001d)\u0007o]5m_:,\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\t>,(\r\\3\t\ri\u0001\u0001\u0015!\u0003\u0014\u0003!)\u0007o]5m_:\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\fg\u0016\u0014h/\u001a:D_VtG/F\u0001\u001f!\t!r$\u0003\u0002!+\t\u0019\u0011J\u001c;\t\r\t\u0002\u0001\u0015!\u0003\u001f\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d!\u0003A1A\u0005\u0002\u0015\nQ\u0001^8qS\u000e,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA\u0001\\1oO*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u0019\u0019FO]5oO\"1q\u0006\u0001Q\u0001\n\u0019\na\u0001^8qS\u000e\u0004\u0003bB\u0019\u0001\u0005\u0004%\t!H\u0001\u0005a\u0006\u0014H\u000f\u0003\u00044\u0001\u0001\u0006IAH\u0001\u0006a\u0006\u0014H\u000f\t\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0003\t!\b/F\u00018!\tA\u0004)D\u0001:\u0015\tQ4(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011)\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0019\u0005\u0001)A\u0005o\u0005\u0019A\u000f\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001;\u0005)\u0001/\u0019:ue!1q\t\u0001Q\u0001\ny\ta\u0001]1siJ\u0002\u0003bB%\u0001\u0005\u0004%\tAN\u0001\u0004iB\u0014\u0004BB&\u0001A\u0003%q'\u0001\u0003uaJ\u0002\u0003bB'\u0001\u0005\u0004%\t!J\u0001\u0011aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012Daa\u0014\u0001!\u0002\u00131\u0013!\u00059s_\u0012,8-\u001a:DY&,g\u000e^%eA!9\u0011\u000b\u0001b\u0001\n\u0003)\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0011\u0019\u0019\u0006\u0001)A\u0005M\u0005\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\t\u000bU\u0003A\u0011\t,\u0002\u000bM,G/\u00169\u0015\u0003]\u0003\"\u0001\u0006-\n\u0005e+\"\u0001B+oSRD#\u0001V.\u0011\u0005q{V\"A/\u000b\u0005ys\u0014!\u00026v]&$\u0018B\u00011^\u0005\u0019\u0011UMZ8sK\")!\r\u0001C\u0001-\u0006)B/Z:u'&l\u0007\u000f\\3D_:\u001cX/\u001c9uS>t\u0007FA1e!\taV-\u0003\u0002g;\n!A+Z:u\u0011\u0015A\u0007\u0001\"\u0001W\u0003]!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)Y5m_Z,'\u000f\u000b\u0002hI\u001a!1\u000e\u0001\u0005m\u0005\u0001\"Vm\u001d;D_:\u001cX/\\3s%\u0016\f7o]5h]6,g\u000e\u001e'jgR,g.\u001a:\u0014\u0007)l\u0007\u000f\u0005\u0002(]&\u0011q\u000e\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001C2p]N,X.\u001a:\u000b\u0005U\\\u0014aB2mS\u0016tGo]\u0005\u0003oJ\u0014\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\")QB\u001bC\u0001sR\t!\u0010\u0005\u0002|U6\t\u0001\u0001C\u0004~U\u0002\u0007I\u0011A\u000f\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012D\u0001b 6A\u0002\u0013\u0005\u0011\u0011A\u0001\u0014G\u0006dGn\u001d+p\u0003N\u001c\u0018n\u001a8fI~#S-\u001d\u000b\u0004/\u0006\r\u0001\u0002CA\u0003}\u0006\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007C\u0004\u0002\n)\u0004\u000b\u0015\u0002\u0010\u0002!\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\u0004\u0003\u0002CA\u0007U\u0002\u0007I\u0011A\u000f\u0002\u001d\r\fG\u000e\\:U_J+go\\6fI\"I\u0011\u0011\u00036A\u0002\u0013\u0005\u00111C\u0001\u0013G\u0006dGn\u001d+p%\u00164xn[3e?\u0012*\u0017\u000fF\u0002X\u0003+A\u0011\"!\u0002\u0002\u0010\u0005\u0005\t\u0019\u0001\u0010\t\u000f\u0005e!\u000e)Q\u0005=\u0005y1-\u00197mgR{'+\u001a<pW\u0016$\u0007\u0005C\u0004\u0002\u001e)$\t!a\b\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\r9\u0016\u0011\u0005\u0005\t\u0003G\tY\u00021\u0001\u0002&\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005\u001d\u0012QF\u001c\u000e\u0005\u0005%\"bAA\u0016U\u0005!Q\u000f^5m\u0013\u0011\ty#!\u000b\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u00024)$\t!!\u000e\u0002'=t\u0007+\u0019:uSRLwN\\:SKZ|7.\u001a3\u0015\u0007]\u000b9\u0004\u0003\u0005\u0002$\u0005E\u0002\u0019AA\u0013\u0011\u001d\tY\u0004\u0001C\t\u0003{\t1b]3oIJ+7m\u001c:egRA\u0011qHA8\u0003o\nY\b\u0005\u0004\u0002B\u0005E\u0013q\u000b\b\u0005\u0003\u0007\niE\u0004\u0003\u0002F\u0005-SBAA$\u0015\r\tIEB\u0001\u0007yI|w\u000e\u001e \n\u0003YI1!a\u0014\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002V\t\u00191+Z9\u000b\u0007\u0005=S\u0003\u0005\u0005\u0002Z\u0005}\u00131MA2\u001b\t\tYFC\u0002\u0002^Q\f\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0005\u0003C\nYF\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\u0011\u000bQ\t)'!\u001b\n\u0007\u0005\u001dTCA\u0003BeJ\f\u0017\u0010E\u0002\u0015\u0003WJ1!!\u001c\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005u\u0013\u0011\ba\u0001\u0003c\u0002\u0002\"!\u0017\u0002t\u0005\r\u00141M\u0005\u0005\u0003k\nYFA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\u0005\b\u0003s\nI\u00041\u0001\u001f\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007k\u0005e\u0002\u0019A\u001c\t\u000f\u0005}\u0004\u0001\"\u0005\u0002\u0002\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0012/\u0006\r\u00151RAG\u0003#\u000b)*a(\u00020\u0006E\u0006bB:\u0002~\u0001\u0007\u0011Q\u0011\t\bc\u0006\u001d\u00151MA2\u0013\r\tII\u001d\u0002\t\u0007>t7/^7fe\"9\u0011\u0011PA?\u0001\u0004q\u0002bBAH\u0003{\u0002\rAH\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011%\t\u0019*! \u0011\u0002\u0003\u0007a$\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD!\"a&\u0002~A\u0005\t\u0019AAM\u0003E\u0019H/\u0019:uS:<G+[7fgR\fW\u000e\u001d\t\u0004)\u0005m\u0015bAAO+\t!Aj\u001c8h\u0011)\t\t+! \u0011\u0002\u0003\u0007\u00111U\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+:\u0003\u0019\u0011XmY8sI&!\u0011QVAT\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\"AQ'! \u0011\u0002\u0003\u0007q\u0007C\u0005\u00024\u0006u\u0004\u0013!a\u0001=\u0005qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\bbBA\\\u0001\u0011E\u0011\u0011X\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t+\u0019\tY,a6\u0002lRA\u0011QXAx\u0003g\f)\u0010\u0005\u0004\u0002@\u0006%\u0017QZ\u0007\u0003\u0003\u0003TA!a1\u0002F\u00069Q.\u001e;bE2,'bAAd+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0017\u0011\u0019\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0004r\u0003\u001f\f\u0019.!;\n\u0007\u0005E'O\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\t\u0005U\u0017q\u001b\u0007\u0001\t!\tI.!.C\u0002\u0005m'!A&\u0012\t\u0005u\u00171\u001d\t\u0004)\u0005}\u0017bAAq+\t9aj\u001c;iS:<\u0007c\u0001\u000b\u0002f&\u0019\u0011q]\u000b\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002V\u0006-H\u0001CAw\u0003k\u0013\r!a7\u0003\u0003YCqa]A[\u0001\u0004\t\t\u0010E\u0004r\u0003\u000f\u000b\u0019.!;\t\u000f\u0005e\u0014Q\u0017a\u0001=!I\u00111WA[!\u0003\u0005\rA\b\u0005\b\u0003s\u0004A\u0011CA~\u0003]\u0019XM\u001c3B]\u0012\fu/Y5u\u0003NLhnY\"p[6LG/\u0006\u0004\u0002~\n\u0015!\u0011\u0002\u000b\u0006/\u0006}(1\u0002\u0005\bg\u0006]\b\u0019\u0001B\u0001!\u001d\t\u0018q\u0011B\u0002\u0005\u000f\u0001B!!6\u0003\u0006\u0011A\u0011\u0011\\A|\u0005\u0004\tY\u000e\u0005\u0003\u0002V\n%A\u0001CAw\u0003o\u0014\r!a7\t\u0015\t5\u0011q\u001fI\u0001\u0002\u0004\u0011y!\u0001\u0006pM\u001a\u001cX\r^:PaR\u0004R\u0001\u0006B\t\u0005+I1Aa\u0005\u0016\u0005\u0019y\u0005\u000f^5p]B9!q\u0003B\u000fo\t\rbb\u0001\u000b\u0003\u001a%\u0019!1D\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011yB!\t\u0003\u00075\u000b\u0007OC\u0002\u0003\u001cU\u00012!\u001dB\u0013\u0013\r\u00119C\u001d\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007b\u0002B\u0016\u0001\u0011E!QF\u0001\u000fC^\f\u0017\u000e\u001e*fE\u0006d\u0017M\\2f)\u00159&q\u0006B!\u0011\u001d\u0019(\u0011\u0006a\u0001\u0005c\u0001dAa\r\u00038\tu\u0002cB9\u0002\b\nU\"1\b\t\u0005\u0003+\u00149\u0004\u0002\u0007\u0003:\t=\u0012\u0011!A\u0001\u0006\u0003\tYNA\u0002`IE\u0002B!!6\u0003>\u0011a!q\bB\u0018\u0003\u0003\u0005\tQ!\u0001\u0002\\\n\u0019q\f\n\u001a\t\u000f\t\r#\u0011\u0006a\u0001u\u0006\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\t\u000f\t\u001d\u0003\u0001\"\u0005\u0003J\u0005\tRM\\:ve\u0016tuNU3cC2\fgnY3\u0015\u000b]\u0013YE!\u0018\t\u000fM\u0014)\u00051\u0001\u0003NA2!q\nB*\u00053\u0002r!]AD\u0005#\u00129\u0006\u0005\u0003\u0002V\nMC\u0001\u0004B+\u0005\u0017\n\t\u0011!A\u0003\u0002\u0005m'aA0%gA!\u0011Q\u001bB-\t1\u0011YFa\u0013\u0002\u0002\u0003\u0005)\u0011AAn\u0005\ryF\u0005\u000e\u0005\b\u0005\u0007\u0012)\u00051\u0001{\r\u0019\u0011\t\u0007\u0001\u0005\u0003d\tY2i\\;oi\u000e{gn];nKJ\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.\u001cRAa\u0018n\u0005K\u00022!\u001dB4\u0013\r\u0011IG\u001d\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\t\u000f5\u0011y\u0006\"\u0001\u0003nQ\u0011!q\u000e\t\u0004w\n}\u0003\"\u0003B:\u0005?\u0002\r\u0011\"\u0001\u001e\u00031\u0019XoY2fgN\u001cu.\u001e8u\u0011)\u00119Ha\u0018A\u0002\u0013\u0005!\u0011P\u0001\u0011gV\u001c7-Z:t\u0007>,h\u000e^0%KF$2a\u0016B>\u0011%\t)A!\u001e\u0002\u0002\u0003\u0007a\u0004\u0003\u0005\u0003\u0000\t}\u0003\u0015)\u0003\u001f\u00035\u0019XoY2fgN\u001cu.\u001e8uA!I!1\u0011B0\u0001\u0004%\t!H\u0001\nM\u0006LGnQ8v]RD!Ba\"\u0003`\u0001\u0007I\u0011\u0001BE\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR\u0019qKa#\t\u0013\u0005\u0015!QQA\u0001\u0002\u0004q\u0002\u0002\u0003BH\u0005?\u0002\u000b\u0015\u0002\u0010\u0002\u0015\u0019\f\u0017\u000e\\\"pk:$\b\u0005\u0003\u0006\u0003\u0014\n}\u0003\u0019!C\u0001\u0005+\u000b\u0011\u0002\\1ti\u0016\u0013(o\u001c:\u0016\u0005\t]\u0005#\u0002\u000b\u0003\u0012\te\u0005\u0003BA!\u00057KAA!(\u0002V\tIQ\t_2faRLwN\u001c\u0005\u000b\u0005C\u0013y\u00061A\u0005\u0002\t\r\u0016!\u00047bgR,%O]8s?\u0012*\u0017\u000fF\u0002X\u0005KC!\"!\u0002\u0003 \u0006\u0005\t\u0019\u0001BL\u0011%\u0011IKa\u0018!B\u0013\u00119*\u0001\u0006mCN$XI\u001d:pe\u0002B\u0001B!,\u0003`\u0011\u0005#qV\u0001\u000b_:\u001cu.\u001c9mKR,G#B,\u00032\ne\u0006\u0002\u0003BZ\u0005W\u0003\rA!.\u0002\u000f=4gm]3ugB9\u0011q\u0005B\\o\t\r\u0012\u0002\u0002B\u0010\u0003SA\u0001Ba/\u0003,\u0002\u0007!\u0011T\u0001\nKb\u001cW\r\u001d;j_:4aAa0\u0001\u0011\t\u0005'\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7feN!!Q\u0018Bb!\u0011\u0011)Ma3\u000e\u0005\t\u001d'b\u0001Be\t\u0005)Q\u000f^5mg&!!Q\u001aBd\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0015M\u0014iL!A!\u0002\u0013\t)\tC\u0006\u0003T\nu&\u0011!Q\u0001\n\tU\u0017!\u0005;pa&\u001c7\u000fV8Tk\n\u001c8M]5cKB1\u0011\u0011\tBl\u00057LAA!7\u0002V\t!A*[:u!\u0011\u00119B!8\n\u00075\u0012\t\u0003C\u0004\u000e\u0005{#\tA!9\u0015\r\t\r(Q\u001dBt!\rY(Q\u0018\u0005\bg\n}\u0007\u0019AAC\u0011!\u0011\u0019Na8A\u0002\tU\u0007B\u0003Bv\u0005{\u0003\r\u0011\"\u0003\u0003n\u0006\u0019\u0002/\u0019:uSRLwN\\!tg&<g.\\3oiV\u0011!q\u001e\t\u0006\u0005/\u0011\tpN\u0005\u0005\u0005g\u0014\tCA\u0002TKRD!Ba>\u0003>\u0002\u0007I\u0011\u0002B}\u0003]\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8u?\u0012*\u0017\u000fF\u0002X\u0005wD!\"!\u0002\u0003v\u0006\u0005\t\u0019\u0001Bx\u0011%\u0011yP!0!B\u0013\u0011y/\u0001\u000bqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\t\u0015\u0005\u0005{\u001c\u0019\u0001E\u0002\u0015\u0007\u000bI1aa\u0002\u0016\u0005!1x\u000e\\1uS2,\u0007BCB\u0006\u0005{\u0003\r\u0011\"\u0003\u0004\u000e\u0005\u0011Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o+\t\u0011)\u000e\u0003\u0006\u0004\u0012\tu\u0006\u0019!C\u0005\u0007'\ta\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0004/\u000eU\u0001BCA\u0003\u0007\u001f\t\t\u00111\u0001\u0003V\"I1\u0011\u0004B_A\u0003&!Q[\u0001\u0014i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g\u000e\t\u0005\u000b\u0007;\u0011i\f1A\u0005\n\r}\u0011aE:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$WCAB\u0011!\r!21E\u0005\u0004\u0007K)\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0007S\u0011i\f1A\u0005\n\r-\u0012aF:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$w\fJ3r)\r96Q\u0006\u0005\u000b\u0003\u000b\u00199#!AA\u0002\r\u0005\u0002\"CB\u0019\u0005{\u0003\u000b\u0015BB\u0011\u0003Q\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3eA!\"1qFB\u0002\u0011)\u0011\u0019E!0C\u0002\u0013\u00051qG\u000b\u0003\u0007s\u0011Baa\u000fna\u001a91QHB \u0001\re\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\"CB!\u0005{\u0003\u000b\u0011BB\u001d\u0003I\u0011XMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u0011\t\u0011\r\u0015#Q\u0018C\u0001\u0007\u000f\n!cY8ogVlWM]!tg&<g.\\3oiR\u0011!q\u001e\u0005\t\u0007\u0017\u0012i\f\"\u0001\u0004N\u0005I1/\u001e2tGJL'-\u001a\u000b\u0004/\u000e=\u0003\u0002CB)\u0007\u0013\u0002\rA!6\u0002)9,w\u000fV8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f\u0011!\u0019)F!0\u0005\u0002\r]\u0013aG5t'V\u00147o\u0019:jE\u0016\u0014V-];fgR\u0004&o\\2fgN,G\r\u0006\u0002\u0004\"!A11\fB_\t\u0003\u001a9&\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]\"91q\fB_\t\u00032\u0016A\u00023p/>\u00148\u000eC\u0004\u0004d\u0001!\ta!\u001a\u00025%\u001c\b+\u0019:uSRLwN\\!tg&<g.\\3oiZ\u000bG.\u001b3\u0015\r\r\u00052qMB9\u0011!\u0019Ig!\u0019A\u0002\r-\u0014aC1tg&<g.\\3oiN\u0004b!a0\u0004n\t=\u0018\u0002BB8\u0003\u0003\u0014aAQ;gM\u0016\u0014\b\u0002CA\u0012\u0007C\u0002\rAa<\t\u0013\rU\u0004!%A\u0005\u0012\r]\u0014!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCAB=U\rq21P\u0016\u0003\u0007{\u0002Baa \u0004\n6\u00111\u0011\u0011\u0006\u0005\u0007\u0007\u001b))A\u0005v]\u000eDWmY6fI*\u00191qQ\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\f\u000e\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1q\u0012\u0001\u0012\u0002\u0013E1\u0011S\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007'SC!!'\u0004|!I1q\u0013\u0001\u0012\u0002\u0013E1\u0011T\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HEN\u000b\u0003\u00077SC!a)\u0004|!I1q\u0014\u0001\u0012\u0002\u0013E1\u0011U\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0007GS3aNB>\u0011%\u00199\u000bAI\u0001\n#\u00199(A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$\u0003\bC\u0005\u0004,\u0002\t\n\u0011\"\u0005\u0004.\u0006\t3/\u001a8e\u0003:$\u0017i^1ji\u0006\u001b\u0018P\\2D_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU11qVBZ\u0007k+\"a!-+\t\t=11\u0010\u0003\t\u00033\u001cIK1\u0001\u0002\\\u0012A\u0011Q^BU\u0005\u0004\tY\u000eC\u0005\u0004:\u0002\t\n\u0011\"\u0005\u0004<\u0006A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\r\r]4QXB`\t!\tIna.C\u0002\u0005mG\u0001CAw\u0007o\u0013\r!a7")
public abstract class BaseConsumerTest
extends IntegrationTestHarness {
    private final double epsilon;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String producerClientId;
    private final String consumerClientId;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendAndAwaitAsyncCommit((Consumer)consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records2;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records2 = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records2, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records2 = new ArrayBuffer();
        Consumer<K, V> x$7 = consumer;
        Serializable x$8 = new Serializable(this, numRecords, maxPollRecords, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseConsumerTest $outer;
            private final int numRecords$1;
            private final int maxPollRecords$1;
            private final ArrayBuffer records$2;

            public final boolean apply(ConsumerRecords<K, V> polledRecords) {
                return this.$outer.kafka$api$BaseConsumerTest$$pollAction$1(polledRecords, this.numRecords$1, this.maxPollRecords$1, this.records$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
                this.maxPollRecords$1 = maxPollRecords$1;
                this.records$2 = records$2;
            }
        };
        long x$9 = 60000L;
        Serializable x$10 = new Serializable(this, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final int numRecords$1;
            private final ArrayBuffer records$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out before consuming expected ", " records. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numRecords$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number consumed was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$2.size())}))).toString();
            }
            {
                this.numRecords$1 = numRecords$1;
                this.records$2 = records$2;
            }
        };
        TestUtils$.MODULE$.pollRecordsUntilTrue(x$7, x$8, (Function0<String>)x$10, x$9);
        return records2;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        public class Kafka_api_BaseConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            public final /* synthetic */ BaseConsumerTest $outer;
            private final Consumer consumer$1;
            private final Option offsetsOpt$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Exception exception2 = exception;
                if (exception2 instanceof RetriableCommitFailedException) {
                    this.kafka$api$BaseConsumerTest$RetryCommitCallback$$$outer().kafka$api$BaseConsumerTest$$sendAsyncCommit$1(this, this.consumer$1, this.offsetsOpt$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.isComplete_$eq(true);
                    this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$RetryCommitCallback$$$outer() {
                return this.$outer;
            }

            public Kafka_api_BaseConsumerTest$RetryCommitCallback$1(BaseConsumerTest $outer, Consumer consumer$1, Option offsetsOpt$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_BaseConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_BaseConsumerTest$RetryCommitCallback$1(this, consumer, offsetsOpt);
        this.kafka$api$BaseConsumerTest$$sendAsyncCommit$1(commitCallback, consumer, offsetsOpt);
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)new Serializable(this, commitCallback){
            public static final long serialVersionUID = 0L;
            private final Kafka_api_BaseConsumerTest$RetryCommitCallback$1 commitCallback$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.commitCallback$1.isComplete();
            }
            {
                this.commitCallback$1 = commitCallback$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to observe commit callback before timeout";
            }
        }, 10000L);
        Assert.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int numReassignments = rebalanceListener.callsToAssigned();
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)new Serializable(this, rebalanceListener, numReassignments){
            public static final long serialVersionUID = 0L;
            private final TestConsumerReassignmentListener rebalanceListener$1;
            private final int numReassignments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.rebalanceListener$1.callsToAssigned() > this.numReassignments$1;
            }
            {
                this.rebalanceListener$1 = rebalanceListener$1;
                this.numReassignments$1 = numReassignments$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out before expected rebalance completed";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assert.assertEquals((long)initialRevokeCalls, (long)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Set<TopicPartition> assignment2) {
                return assignment2.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(Set<TopicPartition> x$5, Set<TopicPartition> x$6) {
                    return (Set)x$5.$plus$plus(x$6);
                }
            });
            Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public final boolean kafka$api$BaseConsumerTest$$pollAction$1(ConsumerRecords polledRecords, int numRecords$1, int maxPollRecords$1, ArrayBuffer records$2) {
        Assert.assertTrue((((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public final void kafka$api$BaseConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Consumer consumer$1, Option offsetsOpt$1) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = offsetsOpt$1;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)some.x();
                    consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                consumer$1.commitAsync(callback);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public BaseConsumerTest() {
        this.epsilon = 0.1;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(Duration.ofMillis(50L));
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
                this.lastError_$eq((Option<Exception>)new Some((Object)exception));
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

