/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.MetricsTest$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005%i\u0011B\u0001\b\u0003\u0005%\u0019\u0016m\u001d7TKR,\b\u000fC\u0003\u0011\u0001\u0011\u0005\u0011#\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011\u0011\u0002\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0011\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111!\u00138u\u0011\u0019i\u0002\u0001)A\u0005-\u0005a1/\u001a:wKJ\u001cu.\u001e8uA!)q\u0004\u0001C)A\u0005aA.[:uK:,'OT1nKV\t\u0011\u0005\u0005\u0002#Y5\t1E\u0003\u0002%K\u00059a.\u001a;x_J\\'B\u0001\u0014(\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\taA*[:uK:,'OT1nK\"9q\u0006\u0001b\u0001\n\u0013\u0001\u0014\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0011\u0019Q\u0004\u0001)A\u0005c\u0005I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0011\u001da\u0004A1A\u0005\nu\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\ta\bE\u0002@\tFj\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\rC\u0012AC2pY2,7\r^5p]&\u0011Q\t\u0011\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003aY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.Z\u000b\u0002\u0017B\u0011Aj\u0014\b\u0003/5K!A\u0014\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0004K\u0003\u0002O1!1!\u000b\u0001Q\u0001\n-\u000b\u0011d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7fA!)A\u000b\u0001C)+\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005CV$\bN\u0003\u0002\\K\u0005A1/Z2ve&$\u00180\u0003\u0002^1\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\b?\u0002\u0011\r\u0011\"\u0015a\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\t\u0011\rE\u0002\u0018E\u0012L!a\u0019\r\u0003\tM{W.\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OV\nA!\u001e;jY&\u0011\u0011N\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB6\u0001A\u0003%\u0011-A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000f5\u0004!\u0019!C)A\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKNDaa\u001c\u0001!\u0002\u0013\t\u0017!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\u0006c\u0002!\tE]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002gB\u0011q\u0003^\u0005\u0003kb\u0011A!\u00168ji\"\u0012\u0001o\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u*\nQA[;oSRL!\u0001`=\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0011s\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019\u00010a\u0001\n\u0007\u0005\u0015\u0011PA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\tA]\u0001\fi\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0003\u0002\b\u00055\u0001c\u0001=\u0002\u0010%\u0019\u0011\u0011C=\u0003\tQ+7\u000f\u001e\u0005\b\u0003+\u0001A\u0011BA\f\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u0013M\fI\"a\u000e\u0002<\u0005}\u0002\u0002CA\u000e\u0003'\u0001\r!!\b\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002\"a\b\u0002(\u0005-\u00121F\u0007\u0003\u0003CQA!a\u0007\u0002$)\u0019\u0011QE\u0014\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011FA\u0011\u00055Y\u0015MZ6b!J|G-^2feB)q#!\f\u00022%\u0019\u0011q\u0006\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\t\u0019$C\u0002\u00026a\u0011AAQ=uK\"9\u0011\u0011HA\n\u0001\u00041\u0012A\u00038v[J+7m\u001c:eg\"9\u0011QHA\n\u0001\u00041\u0012A\u0003:fG>\u0014HmU5{K\"A\u0011\u0011IA\n\u0001\u0004\t\u0019%\u0001\u0002uaB!\u0011QIA$\u001b\u0005)\u0013bAA%K\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA'\u0001\u0011%\u0011qJ\u0001\u001eO\u0016tWM]1uK\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sKR\u00191/!\u0015\t\u0011\u0005\u0005\u00131\na\u0001\u0003\u0007Bq!!\u0016\u0001\t\u0013\t9&A\u0015wKJLg-_&bM.\f'+\u0019;f\u001b\u0016$(/[2t\u0011\u00064XmQ;nk2\fG/\u001b<f\u0007>,h\u000e\u001e\u000b\u0006g\u0006e\u00131\f\u0005\t\u00037\t\u0019\u00061\u0001\u0002\u001e!A\u0011QLA*\u0001\u0004\ty&\u0001\u0005d_:\u001cX/\\3s!!\t\t'!\u001a\u0002,\u0005-RBAA2\u0015\u0011\ti&a\t\n\t\u0005\u001d\u00141\r\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u0005Qb/\u001a:jMf\u001cE.[3oiZ+'o]5p]6+GO]5dgR)1/a\u001c\u0002\u0018\"A\u0011\u0011OA5\u0001\u0004\t\u0019(A\u0004nKR\u0014\u0018nY:1\t\u0005U\u0014Q\u0011\t\bK\u0006]\u00141PAA\u0013\r\tIH\u001a\u0002\u0004\u001b\u0006\u0004\b\u0003BA#\u0003{J1!a &\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0005\u0003\u0007\u000b)\t\u0004\u0001\u0005\u0019\u0005\u001d\u0015qNA\u0001\u0002\u0003\u0015\t!!#\u0003\u0007}#\u0013'\u0005\u0003\u0002\f\u0006E\u0005cA\f\u0002\u000e&\u0019\u0011q\u0012\r\u0003\u000f9{G\u000f[5oOB!\u0011QIAJ\u0013\r\t)*\n\u0002\u0007\u001b\u0016$(/[2\t\u000f\u0005e\u0015\u0011\u000ea\u0001\u0017\u00061QM\u001c;jifDq!!(\u0001\t\u0013\ty*A\u0011wKJLg-\u001f\"s_.,'/Q;uQ\u0016tG/[2bi&|g.T3ue&\u001c7\u000fF\u0002t\u0003CC\u0001\"a)\u0002\u001c\u0002\u0007\u0011QU\u0001\u0007g\u0016\u0014h/\u001a:\u0011\t\u0005\u001d\u00161V\u0007\u0003\u0003SS1!a)\u0005\u0013\u0011\ti+!+\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u0003c\u0003A\u0011BAZ\u0003\u00112XM]5gs\n\u0013xn[3s\u001b\u0016\u001c8/Y4f\u0007>tg/\u001a:tS>tW*\u001a;sS\u000e\u001cHcB:\u00026\u0006]\u0016\u0011\u0018\u0005\t\u0003G\u000by\u000b1\u0001\u0002&\"9\u0011QHAX\u0001\u00041\u0002\u0002CA!\u0003_\u0003\r!a\u0011\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u0006)b/\u001a:jMf\u0014%o\\6fej[W*\u001a;sS\u000e\u001cH#B:\u0002B\u0006\r\u0007\u0002CAR\u0003w\u0003\r!!*\t\u000f\u0005\u0015\u00171\u0018a\u0001\u0017\u0006)Ao\u001c9jG\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017\u0001\u0007<fe&4\u0017P\u0011:pW\u0016\u0014XI\u001d:pe6+GO]5dgR\u00191/!4\t\u0011\u0005\r\u0016q\u0019a\u0001\u0003KCq!!5\u0001\t\u0013\t\u0019.A\twKJLg-_&bM.\fW*\u001a;sS\u000e,B!!6\u0002\\RQ\u0011q\u001bB\u0005\u0005\u001b\u0011IBa\u0007\u0015\t\u0005e\u0017q\u001d\t\u0005\u0003\u0007\u000bY\u000e\u0002\u0005\u0002^\u0006='\u0019AAp\u0005\u0005!\u0016\u0003BAF\u0003C\u00042aFAr\u0013\r\t)\u000f\u0007\u0002\u0004\u0003:L\b\u0002CAu\u0003\u001f\u0004\r!a;\u0002\rY,'/\u001b4z!\u001d9\u0012Q^Ay\u00033L1!a<\u0019\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0002t\n\r\u0011\u0011\u0013\b\u0005\u0003k\fyP\u0004\u0003\u0002x\u0006uXBAA}\u0015\r\tYPB\u0001\u0007yI|w\u000e\u001e \n\u0003eI1A!\u0001\u0019\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0002\u0003\b\tA\u0011\n^3sC\ndWMC\u0002\u0003\u0002aAqAa\u0003\u0002P\u0002\u00071*\u0001\u0003oC6,\u0007\u0002CA9\u0003\u001f\u0004\rAa\u00041\t\tE!Q\u0003\t\bK\u0006]\u00141\u0010B\n!\u0011\t\u0019I!\u0006\u0005\u0019\t]!QBA\u0001\u0002\u0003\u0015\t!!#\u0003\u0007}##\u0007C\u0004\u0002\u001a\u0006=\u0007\u0019A&\t\u0015\tu\u0011q\u001aI\u0001\u0002\u0004\u0011y\"A\u0003he>,\b\u000f\u0005\u0003\u0018\u0005CY\u0015b\u0001B\u00121\t1q\n\u001d;j_:DqAa\n\u0001\t\u0013\u0011I#A\nnCb\\\u0015MZ6b\u001b\u0016$(/[2WC2,X\r\u0006\u0006\u0003,\tE\"1\u0007B \u0005\u0003\u00022a\u0006B\u0017\u0013\r\u0011y\u0003\u0007\u0002\u0007\t>,(\r\\3\t\u000f\t-!Q\u0005a\u0001\u0017\"A\u0011\u0011\u000fB\u0013\u0001\u0004\u0011)\u0004\r\u0003\u00038\tm\u0002cB3\u0002x\u0005m$\u0011\b\t\u0005\u0003\u0007\u0013Y\u0004\u0002\u0007\u0003>\tM\u0012\u0011!A\u0001\u0006\u0003\tIIA\u0002`IMBq!!'\u0003&\u0001\u00071\n\u0003\u0005\u0003\u001e\t\u0015\u0002\u0019\u0001B\u0010\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f\n\u0011D^3sS\u001aL8*\u00194lC6+GO]5d%\u0016\u001cwN\u001d3fIRI1O!\u0013\u0003L\t]#\u0011\f\u0005\b\u0005\u0017\u0011\u0019\u00051\u0001L\u0011!\t\tHa\u0011A\u0002\t5\u0003\u0007\u0002B(\u0005'\u0002r!ZA<\u0003w\u0012\t\u0006\u0005\u0003\u0002\u0004\nMC\u0001\u0004B+\u0005\u0017\n\t\u0011!A\u0003\u0002\u0005%%aA0%i!9\u0011\u0011\u0014B\"\u0001\u0004Y\u0005B\u0003B\u000f\u0005\u0007\u0002\n\u00111\u0001\u0003 !9!Q\f\u0001\u0005\n\t}\u0013!E=b[6,'/T3ue&\u001cg+\u00197vKR!\u0011\u0011\u001dB1\u0011\u001d\u0011YAa\u0017A\u0002-CqA!\u001a\u0001\t\u0013\u00119'A\bzC6lWM\u001d%jgR|wM]1n)\u0011\u0011IGa \u0011\t\t-$1P\u0007\u0003\u0005[RAAa\u001c\u0003r\u0005!1m\u001c:f\u0015\u0011\t\tHa\u001d\u000b\t\tU$qO\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\te\u0014aA2p[&!!Q\u0010B7\u0005%A\u0015n\u001d;pOJ\fW\u000eC\u0004\u0003\f\t\r\u0004\u0019A&\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\u0006Qb/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fIR1!1\u0006BD\u0005\u0013CqAa\u0003\u0003\u0002\u0002\u00071\n\u0003\u0006\u0002j\n\u0005\u0005\u0013!a\u0001\u0005\u0017\u0003raFAw\u0005W\u0011i\tE\u0002\u0018\u0005\u001fK1A!%\u0019\u0005\u001d\u0011un\u001c7fC:DqA!&\u0001\t\u0013\u00119*\u0001\fwKJLg-\u001f(p%\u0016\fX/Z:u\u001b\u0016$(/[2t)\r\u0019(\u0011\u0014\u0005\b\u00057\u0013\u0019\n1\u0001L\u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0011%\u0011y\nAI\u0001\n\u0013\u0011\t+A\u0012wKJLg-_&bM.\fW*\u001a;sS\u000e\u0014VmY8sI\u0016$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r&\u0006\u0002B\u0010\u0005K[#Aa*\u0011\t\t%&1W\u0007\u0003\u0005WSAA!,\u00030\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005cC\u0012AC1o]>$\u0018\r^5p]&!!Q\u0017BV\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005s\u0003\u0011\u0013!C\u0005\u0005w\u000b1D^3sS\u001aL8*\u00194lC6+GO]5dI\u0011,g-Y;mi\u0012\"T\u0003\u0002BQ\u0005{#\u0001\"!8\u00038\n\u0007\u0011q\u001c\u0005\n\u0005\u0003\u0004\u0011\u0013!C\u0005\u0005\u0007\fAE^3sS\u001aL\u0018,Y7nKJlU\r\u001e:jGJ+7m\u001c:eK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bTCAa#\u0003&\u0002")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup$class.jaasClientLoginModule$default$2(this);
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp, bytes){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;
            private final byte[] bytes$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)this.bytes$1));
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
                this.bytes$1 = bytes$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", "SCRAM-SHA-256");
        String x$9 = this.brokerList();
        int x$10 = 0;
        int x$11 = 1000;
        long x$12 = 1000L;
        SecurityProtocol x$13 = this.securityProtocol();
        Option<File> x$14 = this.trustStoreFile();
        Some x$15 = new Some((Object)saslProps);
        long x$16 = TestUtils$.MODULE$.createProducer$default$4();
        int x$17 = TestUtils$.MODULE$.createProducer$default$5();
        int x$18 = TestUtils$.MODULE$.createProducer$default$6();
        int x$19 = TestUtils$.MODULE$.createProducer$default$7();
        int x$20 = TestUtils$.MODULE$.createProducer$default$8();
        String x$21 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$22 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$23 = TestUtils$.MODULE$.createProducer$default$15();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$9, x$10, x$12, x$16, x$17, x$18, x$19, x$20, x$21, x$11, x$13, x$14, (Option<Properties>)x$15, x$22, x$23);
        try {
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
        finally {
            producer.close();
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$1) {
                return x$1.name().endsWith("-rate");
            }
        })).foreach((Function1)new Serializable(this, consumerMetricNames){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Set consumerMetricNames$1;

            public final void apply(MetricName x$2) {
                this.$outer.kafka$api$MetricsTest$$verify$1(x$2, this.consumerMetricNames$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerMetricNames$1 = consumerMetricNames$1;
            }
        });
        Set producerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$3) {
                return x$3.name().endsWith("-rate");
            }
        })).filterNot((Function1)new Serializable(this, producerExclusions){
            public static final long serialVersionUID = 0L;
            private final Set producerExclusions$1;

            public final boolean apply(MetricName metricName) {
                return this.producerExclusions$1.contains((Object)metricName.name());
            }
            {
                this.producerExclusions$1 = producerExclusions$1;
            }
        })).foreach((Function1)new Serializable(this, producerMetricNames){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Set producerMetricNames$1;

            public final void apply(MetricName x$4) {
                this.$outer.kafka$api$MetricsTest$$verify$1(x$4, this.producerMetricNames$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerMetricNames$1 = producerMetricNames$1;
            }
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"commit-id", "version"}))).foreach((Function1)new Serializable(this, metrics, entity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Map metrics$1;
            public final String entity$1;

            public final void apply(String name) {
                this.$outer.kafka$api$MetricsTest$$verifyKafkaMetric(name, this.metrics$1, this.entity$1, this.$outer.kafka$api$MetricsTest$$verifyKafkaMetric$default$4(), new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$verifyClientVersionMetrics$1 $outer;
                    private final String name$4;

                    public final void apply(Iterable<org.apache.kafka.common.Metric> matchingMetrics) {
                        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
                        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
                        Object value = metric.metricValue();
                        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.entity$1, this.name$4})), (Object)value);
                        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric ", " should be a non-empty String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.entity$1, this.name$4})), (Object)BoxesRunTime.boxToBoolean((value instanceof String && !((String)value).isEmpty() ? 1 : 0) != 0));
                        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$4 = name$4;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metrics$1 = metrics$1;
                this.entity$1 = entity$1;
            }
        });
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, metrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final Map metrics$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$MetricsTest$$maxKafkaMetricValue("failed-authentication-total", this.metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metrics$2 = metrics$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed-authentication-total not updated";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected temporary memory size requestBytes ", " tempBytes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)requestBytes), BoxesRunTime.boxToDouble((double)tempBytes)})), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec"})).s((Seq)Nil$.MODULE$), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=MessageConversionsTimeMs,request=Produce"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double value) {
                return this.apply$mcZD$sp(value);
            }

            public boolean apply$mcZD$sp(double value) {
                return value > 0.0;
            }
        });
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=TemporaryMemoryBytes,request=Fetch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double value) {
                return this.apply$mcZD$sp(value);
            }

            public boolean apply$mcZD$sp(double value) {
                return value == 0.0;
            }
        });
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",name=RequestBytes,request=Metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requestMetricsPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        long newCount = histogram.count();
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (newCount > initialCount ? 1 : 0) != 0);
        double min = histogram.min();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Min latency should not be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)min)})), (min >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ZK state"})).s((Seq)Nil$.MODULE$), (Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        Object object;
        int startErrorMetricCount = this.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=NONE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        try {
            KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
            object = consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {
            object = BoxedUnit.UNIT;
        }
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=INVALID_TOPIC_EXCEPTION"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = this.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many error metrics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentErrorMetricCount)})), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",request=Metadata,error=LEADER_NOT_AVAILABLE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMetricPrefix})), this.verifyYammerMetricRecorded$default$2());
    }

    public <T> T kafka$api$MetricsTest$$verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify2) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1)new Serializable(this, name, group){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Option group$1;

            public final boolean apply(Tuple2<MetricName, org.apache.kafka.common.Metric> x0$1) {
                Tuple2<MetricName, org.apache.kafka.common.Metric> tuple2 = x0$1;
                if (tuple2 != null) {
                    MetricName metricName = (MetricName)tuple2._1();
                    String string = metricName.name();
                    String string2 = this.name$1;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.group$1.forall((Function1)new Serializable(this, metricName){
                        public static final long serialVersionUID = 0L;
                        private final MetricName metricName$1;

                        public final boolean apply(String x$6) {
                            String string = x$6;
                            String string2 = this.metricName$1.group();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.metricName$1 = metricName$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.name$1 = name$1;
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric not found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (boolean)matchingMetrics.nonEmpty());
        return (T)verify2.apply((Object)matchingMetrics.values());
    }

    public <T> Option<String> kafka$api$MetricsTest$$verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    public double kafka$api$MetricsTest$$maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        return BoxesRunTime.unboxToDouble(this.kafka$api$MetricsTest$$verifyKafkaMetric(name, metrics, entity, group, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Iterable<org.apache.kafka.common.Metric> matchingMetrics) {
                return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double max, org.apache.kafka.common.Metric metric) {
                        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
                    }
                }));
            }
        }));
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.kafka$api$MetricsTest$$maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, name, BoxesRunTime.boxToDouble((double)value)})), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    private Object yammerMetricValue(String name) {
        Tuple2 tuple2;
        block2: {
            Metric metric;
            block6: {
                Object object;
                block4: {
                    block5: {
                        block3: {
                            scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
                            tuple2 = (Tuple2)allMetrics.find((Function1)new Serializable(this, name){
                                public static final long serialVersionUID = 0L;
                                private final String name$3;

                                public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$2) {
                                    Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$2;
                                    if (tuple2 != null) {
                                        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                                        boolean bl = n.getMBeanName().endsWith(this.name$3);
                                        return bl;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.name$3 = name$3;
                                }
                            }).getOrElse((Function0)new Serializable(this, name, allMetrics){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MetricsTest $outer;
                                private final String name$3;
                                private final scala.collection.mutable.Map allMetrics$1;

                                public final Nothing$ apply() {
                                    return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find broker metric ", ": allMetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$3, this.allMetrics$1.keySet().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(com.yammer.metrics.core.MetricName x$7) {
                                            return x$7.getMBeanName();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.name$3 = name$3;
                                    this.allMetrics$1 = allMetrics$1;
                                }
                            });
                            if (tuple2 == null) break block2;
                            Metric metric2 = (Metric)tuple2._2();
                            Metric metric3 = metric2;
                            Metric metric4 = metric3;
                            metric = metric4;
                            if (!(metric instanceof Meter)) break block3;
                            Meter meter = (Meter)metric;
                            object = BoxesRunTime.boxToDouble((double)meter.count());
                            break block4;
                        }
                        if (!(metric instanceof Histogram)) break block5;
                        Histogram histogram = (Histogram)metric;
                        object = BoxesRunTime.boxToDouble((double)histogram.max());
                        break block4;
                    }
                    if (!(metric instanceof Gauge)) break block6;
                    Gauge gauge = (Gauge)metric;
                    object = gauge.value();
                }
                return object;
            }
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker metric of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.getClass()})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        }
        throw new MatchError((Object)tuple2);
    }

    private Histogram yammerHistogram(String name) {
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$3) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$3;
                if (tuple2 != null) {
                    com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                    boolean bl = n.getMBeanName().endsWith(this.name$2);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.name$2 = name$2;
            }
        }).getOrElse((Function0)new Serializable(this, name, allMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String name$2;
            private final scala.collection.mutable.Map allMetrics$2;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find broker metric ", ": allMetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.allMetrics$2.keySet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(com.yammer.metrics.core.MetricName x$8) {
                        return x$8.getMBeanName();
                    }
                }, Set$.MODULE$.canBuildFrom())})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
                this.allMetrics$2 = allMetrics$2;
            }
        });
        if (tuple2 != null) {
            Metric metric = (Metric)tuple2._2();
            Metric metric2 = metric;
            Metric metric3 = metric2;
            Metric metric4 = metric3;
            if (metric4 instanceof Histogram) {
                Histogram histogram;
                Histogram histogram2 = histogram = (Histogram)metric4;
                return histogram2;
            }
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker metric of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric4.getClass()})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify2) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker metric not recorded correctly for ", " value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToDouble((double)metricValue)})), (boolean)verify2.apply$mcZD$sp(metricValue));
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double d) {
                return this.apply$mcZD$sp(d);
            }

            public boolean apply$mcZD$sp(double d) {
                return d > 0.0;
            }
        };
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Metric> x0$4) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x0$4;
                if (tuple2 != null) {
                    com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
                    boolean bl = n.getMBeanName().startsWith("kafka.network:type=RequestMetrics");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, metrics.keys()})), (boolean)metrics.isEmpty());
    }

    private final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    public final void kafka$api$MetricsTest$$verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = this.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = this.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No cumulative count/time metric for rate metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rateMetricName})), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    private final int errorMetricCount$1() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName x$5) {
                String string = x$5.getName();
                String string2 = "ErrorsPerSec";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).size();
    }

    public MetricsTest() {
        SaslSetup$class.$init$(this);
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.kafkaServerJaasEntryName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listenerName().value().toLowerCase(Locale.ROOT), JaasTestUtils$.MODULE$.KafkaServerContextName()}));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

