/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidatorTest$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012\u0001\u0002;j[\u0016,\u0012A\u0006\t\u0003/\u0005j\u0011\u0001\u0007\u0006\u00033i\tQ!\u001e;jYNT!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\t)QD\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u0019\u0005\u0011!\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019\u0015\u0003!\u0002\"!C\u0015\n\u0005)R!\u0001B+oSRD#!\n\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=z\u0012!\u00026v]&$\u0018BA\u0019/\u0005\u0011!Vm\u001d;\t\u000bM\u0002A\u0011\u0002\u001b\u0002?\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0002)k!)aG\ra\u0001o\u0005)Q.Y4jGB\u0011\u0011\u0002O\u0005\u0003s)\u0011AAQ=uK\")1\b\u0001C\u0001O\u0005\u0001C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3\u0011\u0015i\u0004\u0001\"\u0001(\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u000b\u0004F\u0001\u001f-\u0011\u0015\u0001\u0005\u0001\"\u0003B\u0003\r\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:$\"\u0001\u000b\"\t\u000b\r{\u0004\u0019A\u001c\u0002\u0017Q\f'oZ3u\u001b\u0006<\u0017n\u0019\u0005\u0006\u000b\u0002!\taJ\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u0012A\t\f\u0005\u0006\u0011\u0002!\taJ\u0001(i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i_V$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007\u000b\u0002HY!)1\n\u0001C\u0005\u0019\u000613\r[3dW2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\u0005!j\u0005\"\u0002\u001cK\u0001\u00049\u0004\"B(\u0001\t\u00039\u0013\u0001\n;fgRLeN^1mS\u0012|eMZ:fiJ\u000bgnZ3B]\u0012\u0014VmY8sI\u000e{WO\u001c;)\u00059c\u0003\"\u0002*\u0001\t\u0013\u0019\u0016\u0001I1tg\u0016\u0014H/\u00138wC2LGMQ1uG\"\u001cu.\u001e8u\u001fZ,'O]5eKN$2\u0001\u000b+Z\u0011\u0015)\u0016\u000b1\u0001W\u0003=a\u0017m\u001d;PM\u001a\u001cX\r\u001e#fYR\f\u0007CA\u0005X\u0013\tA&BA\u0002J]RDQAW)A\u0002Y\u000bQaY8v]RDQ\u0001\u0018\u0001\u0005\nu\u000bQE^1mS\u0012\fG/\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5D_VtGo\u0014<feJLG-Z:\u0015\u0007!rv\fC\u0003V7\u0002\u0007a\u000bC\u0003[7\u0002\u0007a\u000bC\u0003b\u0001\u0011\u0005q%A\u0014uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]Z\u0013\u0004F\u00011-\u0011\u0015!\u0007\u0001\"\u0001(\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\t\u0019G\u0006C\u0003h\u0001\u0011%\u0001.\u0001\ndQ\u0016\u001c7NT8o\u0007>l\u0007O]3tg\u0016$GC\u0001\u0015j\u0011\u00151d\r1\u00018\u0011\u0015Y\u0007\u0001\"\u0001(\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\tQG\u0006C\u0003o\u0001\u0011\u0005q%A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007\u000b\u0002nY!)\u0011\u000f\u0001C\u0005e\u0006\u00112\r[3dWJ+7m\\7qe\u0016\u001c8/[8o)\tA3\u000fC\u00037a\u0002\u0007q\u0007C\u0003v\u0001\u0011\u0005q%A\nuKN$(+Z2p[B\u0014Xm]:j_:4&\u0007\u000b\u0002uY!)\u0001\u0010\u0001C\u0001O\u0005\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,2Q\t9H\u0006C\u0003|\u0001\u0011%A0A\u0011dQ\u0016\u001c7n\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c$s_64\u0006\u0007\u0006\u0002){\")aP\u001fa\u0001o\u00059Ao\\'bO&\u001c\u0007BBA\u0001\u0001\u0011\u0005q%\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013\u0004FA@-\u0011\u0019\t9\u0001\u0001C\u0001O\u0005\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3Q\r\t)\u0001\f\u0005\u0007\u0003\u001b\u0001A\u0011A\u0014\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u000b\u0004fAA\u0006Y!9\u00111\u0003\u0001\u0005\n\u0005U\u0011aD2iK\u000e\\7i\\7qe\u0016\u001c8/\u001a3\u0015\u0007!\n9\u0002\u0003\u00047\u0003#\u0001\ra\u000e\u0005\u0007\u00037\u0001A\u0011A\u0014\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u0013\u0004fAA\rY!1\u0011\u0011\u0005\u0001\u0005\u0002\u001d\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\b\u0003?a\u0013QEA\u0014\u0003!)\u0007\u0010]3di\u0016$7EAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00185\u00051QM\u001d:peNLA!a\r\u0002.\tI\u0012J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0019\t9\u0004\u0001C\u0001O\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0004\u000261\n)#a\n\t\r\u0005u\u0002\u0001\"\u0001(\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\u001d\tY\u0004LA\u0013\u0003OAa!a\u0011\u0001\t\u00039\u0013!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u0013\u0004fBA!Y\u0005\u0015\u0012q\u0005\u0005\u0007\u0003\u0013\u0002A\u0011A\u0014\u0002SQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi:{gnQ8naJ,7o]3eQ\r\t9\u0005\f\u0005\u0007\u0003\u001f\u0002A\u0011A\u0014\u0002MQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,G\rK\u0002\u0002N1Ba!!\u0016\u0001\t\u00039\u0013a\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\u0005MC\u0006\u0003\u0004\u0002\\\u0001!\taJ\u0001,i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a\u0011\u0011\f\u0017\t\r\u0005\u0005\u0004\u0001\"\u0001(\u0003!\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\r\ty\u0006\f\u0005\u0007\u0003O\u0002A\u0011A\u0014\u0002QQ,7\u000f\u001e*fY\u0006$\u0018N^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007\u0005\u0015D\u0006\u0003\u0004\u0002n\u0001!\taJ\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\r\tY\u0007\f\u0005\u0007\u0003g\u0002A\u0011A\u0014\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001a\u0011\u0011\u000f\u0017\t\r\u0005e\u0004\u0001\"\u0001(\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u000b4i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005]D\u0006\u0003\u0004\u0002\u0000\u0001!\taJ\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We\r{W\u000e\u001d:fgN,G\rK\u0002\u0002~1Ba!!\"\u0001\t\u00039\u0013a\n;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^!mY><X\r\u001a$s_6\u001cE.[3oiNDs!a!-\u0003K\tIi\t\u0002\u0002\fB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012j\taA]3d_J$\u0017\u0002BAK\u0003\u001f\u0013a#\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c\u0005\u0007\u00033\u0003A\u0011A\u0014\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u000e{W\u000e\u001d:fgN,G\rK\u0002\u0002\u00182Ba!a(\u0001\t\u00039\u0013A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa9{gnQ8naJ,7o]3eQ\r\ti\n\f\u0005\u0007\u0003K\u0003A\u0011A\u0014\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006gQ8naJ,7o]3eQ\r\t\u0019\u000b\f\u0005\u0007\u0003W\u0003A\u0011A\u0014\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg+\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001a\u0011\u0011\u0016\u0017\t\r\u0005E\u0006\u0001\"\u0001(\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007\u0005=F\u0006\u0003\u0004\u00028\u0002!\taJ\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3!!.-\u0011\u0019\ti\f\u0001C\u0001O\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vNV\u0019D_6\u0004(/Z:tK\u0012D3!a/-\u0011\u0019\t\u0019\r\u0001C\u0001O\u0005!D/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001a$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:eg:{G\u000fU3s[&$H/\u001a3)\u000f\u0005\u0005G&!\n\u0002H\u000e\u0012\u0011\u0011\u001a\t\u0005\u0003W\tY-\u0003\u0003\u0002N\u00065\"\u0001J+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\r\u0005E\u0007\u0001\"\u0001(\u0003E\"Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8PM&#W-\u001c9pi\u0016tGOU3d_J$7OT8u!\u0016\u0014X.\u001b;uK\u0012Ds!a4-\u0003K\t9\r\u0003\u0004\u0002X\u0002!\taJ\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D3!!6-\u0011\u0019\ti\u000e\u0001C\u0001O\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3!a7-\u0011\u0019\t\u0019\u000f\u0001C\u0001O\u0005aB/Z:u\u0013:4\u0018\r\\5e\u0013:tWM]'bO&\u001cg+\u001a:tS>t\u0007fBAqY\u0005\u0015\u0012\u0011\u0012\u0005\u0007\u0003S\u0004A\u0011A\u0014\u0002WQ,7\u000f^\"p[B\u0014Xm]:fI\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012Ds!a:-\u0003K\tI\t\u0003\u0004\u0002p\u0002!\taJ\u0001,i\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GmV5uQVs\u0017M^1jY\u0006\u0014G.Z%C!Z+'o]5p]\":\u0011Q\u001e\u0017\u0002&\u0005M8EAA{!\u0011\tY#a>\n\t\u0005e\u0018Q\u0006\u0002$+:\u001cX\u000f\u001d9peR,GmQ8naJ,7o]5p]RK\b/Z#yG\u0016\u0004H/[8o\u0011\u0019\ti\u0010\u0001C\u0001O\u0005iC/Z:u+:\u001cw.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u000f\u0005mH&!\n\u0002\n\"1!1\u0001\u0001\u0005\u0002\u001d\nQ\u0006^3tiJ+7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\u001d\u0011\t\u0001LA\u0013\u0003\u0013CqA!\u0003\u0001\t\u0013\u0011Y!A\u0011uKN$()\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rF\u0003)\u0005\u001b\u0011i\u0002\u0003\u0005\u0003\u0010\t\u001d\u0001\u0019\u0001B\t\u0003-\u0019x.\u001e:dK\u000e{G-Z2\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006\u0005\u0003\u001diWm]:bO\u0016LAAa\u0007\u0003\u0016\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0005?\u00119\u00011\u0001\u0003\u0012\u0005YA/\u0019:hKR\u001cu\u000eZ3d\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K\tQb\u0019:fCR,'+Z2pe\u0012\u001cH\u0003\u0003B\u0014\u0005[\u0011\tDa\u000f\u0011\t\u00055%\u0011F\u0005\u0005\u0005W\tyIA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005_\u0011\t\u00031\u00018\u0003)i\u0017mZ5d-\u0006dW/\u001a\u0005\u000b\u0005g\u0011\t\u0003%AA\u0002\tU\u0012!\u0003;j[\u0016\u001cH/Y7q!\rI!qG\u0005\u0004\u0005sQ!\u0001\u0002'p]\u001eD\u0001B!\u0010\u0003\"\u0001\u0007!qH\u0001\u0006G>$Wm\u0019\t\u0005\u0003\u001b\u0013\t%\u0003\u0003\u0003D\u0005=%aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J\u0005a1\r[3dW>3gm]3ugR)\u0001Fa\u0013\u0003P!A!Q\nB#\u0001\u0004\u00119#A\u0004sK\u000e|'\u000fZ:\t\u0011\tE#Q\ta\u0001\u0005k\t!BY1tK>3gm]3u\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/\nAD]3d_J$7oV5uQ&sg/\u00197jI&sg.\u001a:NC\u001eL7\r\u0006\u0003\u0003(\te\u0003\u0002\u0003B.\u0005'\u0002\rA!\u000e\u0002\u001b%t\u0017\u000e^5bY>3gm]3u\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005C\nq#\\1zE\u0016\u001c\u0005.Z2l\u0005\u0006\u001cX\rV5nKN$\u0018-\u001c9\u0015\u000b!\u0012\u0019G!\u001a\t\u0011\u0005\u0015\"Q\fa\u0001\u0005kA\u0001Ba\u001a\u0003^\u0001\u0007!\u0011N\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003\u001b\u0013Y'\u0003\u0003\u0003n\u0005=%a\u0003*fG>\u0014HMQ1uG\"DqA!\u001d\u0001\t\u0003\u0011\u0019(A\u000bwC2LG-\u0019;f\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\u0015\u000f!\u0012)H!\u001f\u0003~!A!q\u000fB8\u0001\u0004\u0011)$A\u000bfqB,7\r^3e\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3\t\u0011\tm$q\u000ea\u0001\u0005k\tQ#\u001a=qK\u000e$X\r\u001a\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0003h\t=\u0004\u0019\u0001B5\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007\u000b1D^3sS\u001aL(+Z2pe\u0012\u001cuN\u001c<feNLwN\\*uCR\u001cH#\u0003\u0015\u0003\u0006\n=%1\u0013BK\u0011!\u00119Ia A\u0002\t%\u0015!B:uCR\u001c\b\u0003BAG\u0005\u0017KAA!$\u0002\u0010\n)\"+Z2pe\u0012\u001cuN\u001c<feNLwN\\*uCR\u001c\bb\u0002BI\u0005\u007f\u0002\rAV\u0001\u0014]Vl7i\u001c8wKJ$X\r\u001a*fG>\u0014Hm\u001d\u0005\t\u0005\u001b\u0012y\b1\u0001\u0003(!A!q\u0013B@\u0001\u0004\u0011I*\u0001\u0006d_6\u0004(/Z:tK\u0012\u00042!\u0003BN\u0013\r\u0011iJ\u0003\u0002\b\u0005>|G.Z1o\u0011%\u0011\t\u000bAI\u0001\n\u0013\u0011\u0019+A\fde\u0016\fG/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0015\u0016\u0005\u0005k\u00119k\u000b\u0002\u0003*B!!1\u0016B[\u001b\t\u0011iK\u0003\u0003\u00030\nE\u0016!C;oG\",7m[3e\u0015\r\u0011\u0019LC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\\\u0005[\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;

    public Time time() {
        return this.time;
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$1, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$9 = 0;
        CompressionType x$10 = CompressionType.GZIP;
        long x$11 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$9, x$11, x$10);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$2, -1L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records2, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$3, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, lastOffsetDelta, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final int lastOffsetDelta$1;
            private final int count$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(this.lastOffsetDelta$1, this.count$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffsetDelta$1 = lastOffsetDelta$1;
                this.count$1 = count$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    public void kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records2.buffer().putInt(57, count);
        records2.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true, ApiVersion$.MODULE$.latestVersion());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$1;
                private final long producerId$1;
                private final short producerEpoch$1;
                private final int baseSequence$1;
                private final boolean isTransactional$1;
                private final int partitionLeaderEpoch$1;
                public final IntRef i$1;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$2) {
                            return x$2.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$1, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$1, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$1, (long)batch.baseSequence());
                    Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
                    Assert.assertEquals((long)this.partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkNonCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$1.apply(this.$outer.i$1.elem)), (long)record.timestamp());
                            ++this.$outer.i$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$1 = timestampSeq$1;
                    this.producerId$1 = producerId$1;
                    this.producerEpoch$1 = producerEpoch$1;
                    this.baseSequence$1 = baseSequence$1;
                    this.isTransactional$1 = isTransactional$1;
                    this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                    this.i$1 = i$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records2, false);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true, ApiVersion$.MODULE$.latestVersion());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$2;
                private final long producerId$2;
                private final short producerEpoch$2;
                private final int baseSequence$2;
                private final int partitionLeaderEpoch$2;
                public final IntRef i$2;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$4) {
                            return x$4.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$2, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$2, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$2, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkRecompression$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$2.apply(this.$outer.i$2.elem)), (long)record.timestamp());
                            ++this.$outer.i$2.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$2 = timestampSeq$2;
                    this.producerId$2 = producerId$2;
                    this.producerEpoch$2 = producerEpoch$2;
                    this.baseSequence$2 = baseSequence$2;
                    this.partitionLeaderEpoch$2 = partitionLeaderEpoch$2;
                    this.i$2 = i$2;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records2;
        byte x$12 = 0;
        CompressionType x$13 = CompressionType.GZIP;
        long x$14 = this.createRecords$default$2();
        MemoryRecords x$15 = records2 = this.createRecords(x$12, x$14, x$13);
        kafka.common.LongRef x$16 = new kafka.common.LongRef(0L);
        Time x$17 = this.time();
        long x$18 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$19 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$20 = DefaultCompressionCodec$.MODULE$;
        byte x$21 = toMagic;
        boolean x$22 = false;
        TimestampType x$23 = TimestampType.CREATE_TIME;
        long x$24 = 1000L;
        int x$25 = -1;
        boolean x$26 = true;
        ApiVersion x$27 = ApiVersion$.MODULE$.latestVersion();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$15, x$16, x$17, x$18, (CompressionCodec)x$19, (CompressionCodec)x$20, x$22, x$21, x$23, x$24, x$25, x$26, x$27);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
                Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records2;
        long timestamp = System.currentTimeMillis();
        byte x$28 = 1;
        CompressionType x$29 = CompressionType.GZIP;
        long x$30 = timestamp;
        MemoryRecords x$31 = records2 = this.createRecords(x$28, x$30, x$29);
        kafka.common.LongRef x$32 = new kafka.common.LongRef(0L);
        Time x$33 = this.time();
        long x$34 = timestamp;
        DefaultCompressionCodec$ x$35 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$36 = DefaultCompressionCodec$.MODULE$;
        byte x$37 = 2;
        boolean x$38 = false;
        TimestampType x$39 = TimestampType.CREATE_TIME;
        long x$40 = 1000L;
        int x$41 = -1;
        boolean x$42 = true;
        ApiVersion x$43 = ApiVersion$.MODULE$.latestVersion();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$31, x$32, x$33, x$34, (CompressionCodec)x$35, (CompressionCodec)x$36, x$38, x$37, x$39, x$40, x$41, x$42, x$43);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long timestamp$1;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(this.timestamp$1, (RecordBatch)batch);
                Assert.assertEquals((long)this.timestamp$1, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
            }
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            MemoryRecords records2;
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords x$44 = records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            kafka.common.LongRef x$45 = new kafka.common.LongRef(0L);
            Time x$46 = this.time();
            long x$47 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$48 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$49 = DefaultCompressionCodec$.MODULE$;
            byte x$50 = magic;
            boolean x$51 = false;
            TimestampType x$52 = TimestampType.CREATE_TIME;
            long x$53 = 1000L;
            int x$54 = partitionLeaderEpoch2;
            boolean x$55 = true;
            ApiVersion x$56 = ApiVersion$.MODULE$.latestVersion();
            LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$44, x$45, x$46, x$47, (CompressionCodec)x$48, (CompressionCodec)x$49, x$51, x$50, x$52, x$53, x$54, x$55, x$56);
            MemoryRecords validatedRecords = validatedResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$3;
                private final long producerId$3;
                private final short producerEpoch$3;
                private final int baseSequence$3;
                private final int partitionLeaderEpoch$3;
                public final IntRef i$3;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$3.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$6) {
                            return x$6.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$3, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$3, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$3, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$3.apply(this.$outer.i$3.elem)), (long)record.timestamp());
                            ++this.$outer.i$3.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$3 = timestampSeq$3;
                    this.producerId$3 = producerId$3;
                    this.producerEpoch$3 = producerEpoch$3;
                    this.baseSequence$3 = baseSequence$3;
                    this.partitionLeaderEpoch$3 = partitionLeaderEpoch$3;
                    this.i$3 = i$3;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$57 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$58 = new kafka.common.LongRef(0L);
        Time x$59 = this.time();
        long x$60 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$61 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$62 = DefaultCompressionCodec$.MODULE$;
        byte x$63 = 1;
        boolean x$64 = false;
        TimestampType x$65 = TimestampType.CREATE_TIME;
        long x$66 = 1000L;
        int x$67 = -1;
        boolean x$68 = true;
        ApiVersion x$69 = ApiVersion$.MODULE$.latestVersion();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$57, x$58, x$59, x$60, (CompressionCodec)x$61, (CompressionCodec)x$62, x$64, x$63, x$65, x$66, x$67, x$68, x$69);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$70 = records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$71 = new kafka.common.LongRef(0L);
        Time x$72 = this.time();
        long x$73 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$74 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$75 = DefaultCompressionCodec$.MODULE$;
        byte x$76 = 1;
        boolean x$77 = false;
        TimestampType x$78 = TimestampType.CREATE_TIME;
        long x$79 = 1000L;
        int x$80 = -1;
        boolean x$81 = true;
        ApiVersion x$82 = ApiVersion$.MODULE$.latestVersion();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$70, x$71, x$72, x$73, (CompressionCodec)x$74, (CompressionCodec)x$75, x$77, x$76, x$78, x$79, x$80, x$81, x$82);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$83 = 0;
        CompressionType x$84 = CompressionType.NONE;
        long x$85 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$83, x$85, x$84);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$86 = records2;
        kafka.common.LongRef x$87 = new kafka.common.LongRef((long)offset);
        Time x$88 = this.time();
        long x$89 = System.currentTimeMillis();
        NoCompressionCodec$ x$90 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$91 = NoCompressionCodec$.MODULE$;
        byte x$92 = 0;
        boolean x$93 = false;
        TimestampType x$94 = TimestampType.CREATE_TIME;
        long x$95 = 1000L;
        int x$96 = -1;
        boolean x$97 = true;
        ApiVersion x$98 = ApiVersion$.MODULE$.latestVersion();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$86, x$87, x$88, x$89, (CompressionCodec)x$90, (CompressionCodec)x$91, x$93, x$92, x$94, x$95, x$96, x$97, x$98).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$99 = 0;
        CompressionType x$100 = CompressionType.GZIP;
        long x$101 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$99, x$101, x$100);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$102 = 0;
        CompressionType x$103 = CompressionType.NONE;
        long x$104 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$102, x$104, x$103);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$105 = 0;
        CompressionType x$106 = CompressionType.NONE;
        long x$107 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$105, x$107, x$106);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$108 = 0;
        CompressionType x$109 = CompressionType.GZIP;
        long x$110 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$108, x$110, x$109);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$111 = 0;
        CompressionType x$112 = CompressionType.GZIP;
        long x$113 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$111, x$113, x$112);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, false, ApiVersion$.MODULE$.latestVersion());
        List batches = TestUtils.toList((Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$114 = 1;
        CompressionType x$115 = CompressionType.NONE;
        long x$116 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$114, x$116, x$115);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$117 = 1;
        CompressionType x$118 = CompressionType.GZIP;
        long x$119 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$117, x$119, x$118);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidInnerMagicVersion() {
        int offset = 1234567;
        MemoryRecords records2 = this.recordsWithInvalidInnerMagic(offset);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)SnappyCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, (ApiVersion)KAFKA_2_0_IV1$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40));
        if (tuple5 != null) {
            Tuple5 tuple52;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple53._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple53._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
            ByteBuffer buffer = ByteBuffer.allocate(61);
            DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (long)0L, (long)5L, (int)partitionLeaderEpoch2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)isTransactional2, (boolean)false);
            buffer.flip();
            MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    public void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(Record entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(long initialOffset) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$8) {
                return x$8.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$2;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$2.elem, record);
                ++this.offset$2.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$2 = offset$2;
            }
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected base timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected max timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, expectedLogAppendTime){
            public static final long serialVersionUID = 0L;
            private final long expectedLogAppendTime$1;

            public final void apply(Record record) {
                Assert.assertTrue((boolean)record.isValid());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected timestamp of record ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})), (long)this.expectedLogAppendTime$1, (long)record.timestamp());
            }
            {
                this.expectedLogAppendTime$1 = expectedLogAppendTime$1;
            }
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records2, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not valid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records2.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temp bytes too small, orig=", " actual=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)originalSize), BoxesRunTime.boxToLong((long)tempBytes)})), (tempBytes > (long)originalSize ? 1 : 0) != 0);
        } else if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)tempBytes);
        }
    }
}

