/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConsumerPathZNode$;
import kafka.zk.ExtendedAclZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkData$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001%\u00111CW6BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000b\u0019\t\u0001b]3dkJLG/\u001f\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\u0011QBB\u0001\u0003u.L!a\u0004\u0007\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t\tB#D\u0001\u0013\u0015\t\u0019b!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\t\u0001B[1bg\u001aKG.Z\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0003S>T\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t!a)\u001b7f\u0011\u00199\u0003\u0001)A\u0005=\u0005I!.Y1t\r&dW\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u00031\tW\u000f\u001e5Qe>4\u0018\u000eZ3s+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018#\u0003\u0011a\u0017M\\4\n\u0005Aj#AB*ue&tw\r\u0003\u00043\u0001\u0001\u0006IaK\u0001\u000eCV$\b\u000e\u0015:pm&$WM\u001d\u0011\t\u000bQ\u0002A\u0011I\u001b\u0002\u000bM,G/\u00169\u0015\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012A!\u00168ji\"\u00121'\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bQA[;oSRT\u0011AQ\u0001\u0004_J<\u0017B\u0001#@\u0005\u0019\u0011UMZ8sK\")a\t\u0001C!k\u0005AA/Z1s\t><h\u000e\u000b\u0002F\u0011B\u0011a(S\u0005\u0003\u0015~\u0012Q!\u00114uKJDQ\u0001\u0014\u0001\u0005\u0002U\nq\u0003^3ti&\u001b(l[*fGV\u0014\u0018\u000e^=F]\u0006\u0014G.\u001a3)\u0005-s\u0005C\u0001 P\u0013\t\u0001vH\u0001\u0003UKN$\b\"\u0002*\u0001\t\u0003)\u0014!\u0005;fgR\\\u0015MZ6b5.\u001cE.[3oi\"\u0012\u0011K\u0014\u0005\u0006+\u0002!IAV\u0001\u0011GJ,\u0017\r^3Ce>\\WM]%oM>$ba\u0016.`O&4\bCA\u0006Y\u0013\tIFB\u0001\u0006Ce>\\WM]%oM>DQa\u0017+A\u0002q\u000b!!\u001b3\u0011\u0005]j\u0016B\u000109\u0005\rIe\u000e\u001e\u0005\u0006AR\u0003\r!Y\u0001\u0005Q>\u001cH\u000f\u0005\u0002cK:\u0011qgY\u0005\u0003Ib\na\u0001\u0015:fI\u00164\u0017B\u0001\u0019g\u0015\t!\u0007\bC\u0003i)\u0002\u0007A,\u0001\u0003q_J$\b\"\u00026U\u0001\u0004Y\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\taG/D\u0001n\u0015\t\u0019aN\u0003\u0002\u0006_*\u0011\u0001/]\u0001\u0007G>lWn\u001c8\u000b\u0005\u001d\u0011(BA:B\u0003\u0019\t\u0007/Y2iK&\u0011Q/\u001c\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Dqa\u001e+\u0011\u0002\u0003\u0007\u00010\u0001\u0003sC\u000e\\\u0007cA\u001czC&\u0011!\u0010\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bq\u0004A\u0011A\u001b\u0002\u001fQ,7\u000f\u001e.l\u001b&<'/\u0019;j_:D#a\u001f(\t\u000b}\u0004A\u0011A\u001b\u0002'Q,7\u000f\u001e.l\u0003:$\u0018.T5he\u0006$\u0018n\u001c8)\u0005yt\u0005BBA\u0003\u0001\u0011\u0005Q'\u0001\u0006uKN$H)\u001a7fi\u0016D3!a\u0001O\u0011\u0019\tY\u0001\u0001C\u0001k\u0005\u0019B/Z:u\t\u0016dW\r^3SK\u000e,(o]5wK\"\u001a\u0011\u0011\u0002(\t\r\u0005E\u0001\u0001\"\u00016\u0003)!Xm\u001d;DQJ|w\u000e\u001e\u0015\u0004\u0003\u001fq\u0005bBA\f\u0001\u0011%\u0011\u0011D\u0001\u000ei\u0016\u001cH/T5he\u0006$\u0018n\u001c8\u0015\u000fY\nY\"a\b\u0002*!9\u0011QDA\u000b\u0001\u0004\t\u0017!\u0002>l+Jd\u0007\u0002CA\u0011\u0003+\u0001\r!a\t\u0002\u000f\u0019L'o\u001d;[WB\u00191\"!\n\n\u0007\u0005\u001dBBA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\t\u0003W\t)\u00021\u0001\u0002$\u0005A1/Z2p]\u0012T6\u000eC\u0004\u00020\u0001!I!!\r\u0002\rY,'/\u001b4z)\r1\u00141\u0007\u0005\b\u0003k\ti\u00031\u0001b\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005a\u0011n]!dY\u000e{'O]3diRA\u0011QHA\"\u0003G\n9\u0007E\u00028\u0003\u007fI1!!\u00119\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0012\u00028\u0001\u0007\u0011qI\u0001\u0005Y&\u001cH\u000f\u0005\u0004\u0002J\u0005=\u00131K\u0007\u0003\u0003\u0017R1!!\u00149\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\nYEA\u0002TKF\u0004B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0003eCR\f'bAA/e\u0006I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003C\n9FA\u0002B\u00072C\u0001\"!\u001a\u00028\u0001\u0007\u0011QH\u0001\u0007g\u0016\u001cWO]3\t\u0011\u0005%\u0014q\u0007a\u0001\u0003{\t\u0011b]3og&$\u0018N^3\t\r\u00055\u0004\u0001\"\u00036\u0003E!W\r\\3uK\u0006cG.\u00168tK\u000e,(/\u001a\u0005\b\u0003c\u0002A\u0011BA:\u0003=!W\r\\3uKJ+7-\u001e:tSZ,GCBA;\u0003\u0003\u000b)\t\u0005\u0004\u0002x\u0005u\u0014QH\u0007\u0003\u0003sR1!a\u001f9\u0003\u0011)H/\u001b7\n\t\u0005}\u0014\u0011\u0010\u0002\u0004)JL\b\u0002CAB\u0003_\u0002\r!a\t\u0002\u0011i\\7\t\\5f]RDq!!\u000e\u0002p\u0001\u0007\u0011\r\u0003\u0004\u0002\n\u0002!\t!N\u0001\u001bi\u0016\u001cHoQ8ogVlWM](gMN,G\u000fU1uQ\u0006\u001bGn\u001d\u0015\u0004\u0003\u000fs\u0005\"CAH\u0001E\u0005I\u0011BAI\u0003i\u0019'/Z1uK\n\u0013xn[3s\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019JK\u0002y\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003CC\u0014AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ZkAuthorizationTest
extends ZooKeeperTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @Before
    public void setUp() {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assert.assertTrue((boolean)JaasUtils.isZkSecurityEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assert.assertFalse((boolean)JaasUtils.isZkSecurityEnabled());
        try {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
            JaasUtils.isZkSecurityEnabled();
            throw this.fail("Should have thrown an exception", new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testKafkaZkClient() {
        Assert.assertTrue((boolean)this.zkClient().secure());
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                this.$outer.zkClient().makeSurePersistentPathExists(path);
                if (ZkData$.MODULE$.sensitivePath(path)) {
                    Seq aclList = this.$outer.zkClient().getAcl(path);
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected acl list size for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (long)1L, (long)aclList.size());
                    aclList.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ACL acl) {
                            Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, true));
                        }
                    });
                } else if (!path.equals(ConsumerPathZNode$.MODULE$.path())) {
                    Seq aclList = this.$outer.zkClient().getAcl(path);
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected acl list size for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (long)2L, (long)aclList.size());
                    aclList.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ACL acl) {
                            Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        this.zkClient().registerBroker(brokerInfo);
        this.verify(brokerInfo.path());
        String topic1 = "topic1";
        Map assignment2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(topic1, assignment2);
        this.verify(TopicZNode$.MODULE$.path(topic1));
        String seqPath = this.zkClient().createSequentialPersistentPath("/c", "".getBytes(StandardCharsets.UTF_8));
        this.verify(seqPath);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        Map updatedAssignment = (Map)assignment2.$minus((Object)new TopicPartition(topic1, 2));
        KafkaZkClient qual$1 = this.zkClient();
        String x$3 = topic1;
        Map x$4 = updatedAssignment;
        int x$5 = qual$1.setTopicAssignment$default$3();
        qual$1.setTopicAssignment(x$3, x$4, x$5);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(topic1).get()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkMigration() {
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        try {
            this.testMigration(this.zkConnect(), unsecureZkClient, this.zkClient());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkClient.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkAntiMigration() {
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        try {
            this.testMigration(this.zkConnect(), this.zkClient(), unsecureZkClient);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkClient.close();
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{"--zookeeper.acl=secure", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()}))}));
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkData$.MODULE$.SecureRootPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                this.$outer.info((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final String path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
                this.$outer.zkClient().makeSurePersistentPathExists(path);
                KafkaZkClient qual$2 = this.$outer.zkClient();
                String x$6 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
                byte[] x$7 = "".getBytes(StandardCharsets.UTF_8);
                boolean x$8 = qual$2.createRecursive$default$3();
                qual$2.createRecursive(x$6, x$7, x$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkClient().setAcl("/", this.zkClient().defaultAcls("/"));
        this.deleteAllUnsecure();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder().append((Object)this.zkConnect()).append((Object)"/kafka").toString();
        KafkaZkClient qual$3 = this.zkClient();
        String x$9 = "/kafka";
        byte[] x$10 = qual$3.createRecursive$default$2();
        boolean x$11 = qual$3.createRecursive$default$3();
        qual$3.createRecursive(x$9, x$10, x$11);
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(zkUrl, false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        KafkaZkClient secureZkClient = KafkaZkClient$.MODULE$.apply(zkUrl, true, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        try {
            this.testMigration(zkUrl, unsecureZkClient, secureZkClient);
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            var6_6.close();
            var7_7.close();
            throw throwable;
        }
        unsecureZkClient.close();
        secureZkClient.close();
    }

    private void testMigration(String zkUrl, KafkaZkClient firstZk, KafkaZkClient secondZk) {
        String string;
        this.info((Function0<String>)new Serializable(this, zkUrl){
            public static final long serialVersionUID = 0L;
            private final String zkUrl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkUrl$1}));
            }
            {
                this.zkUrl$1 = zkUrl$1;
            }
        });
        ((IterableLike)ZkData$.MODULE$.SecureRootPaths().$plus$plus((GenTraversableOnce)ZkData$.MODULE$.SensitiveRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, firstZk){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final KafkaZkClient firstZk$1;

            public final void apply(String path) {
                this.$outer.info((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final String path$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$3}));
                    }
                    {
                        this.path$3 = path$3;
                    }
                });
                this.firstZk$1.makeSurePersistentPathExists(path);
                this.firstZk$1.createRecursive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), "".getBytes(StandardCharsets.UTF_8), this.firstZk$1.createRecursive$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstZk$1 = firstZk$1;
            }
        });
        if (secondZk.secure()) {
            firstZk.createRecursive(ConsumerPathZNode$.MODULE$.path(), firstZk.createRecursive$default$2(), firstZk.createRecursive$default$3());
            string = "secure";
        } else {
            secondZk.createRecursive(ConsumerPathZNode$.MODULE$.path(), secondZk.createRecursive$default$2(), secondZk.createRecursive$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.acl=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secureOpt})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkUrl}))}));
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done with migration";
            }
        });
        ((IterableLike)ZkData$.MODULE$.SecureRootPaths().$plus$plus((GenTraversableOnce)ZkData$.MODULE$.SensitiveRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, secondZk){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final KafkaZkClient secondZk$1;

            public final void apply(String path) {
                boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
                Seq listParent = this.secondZk$1.getAcl(path);
                Assert.assertTrue((String)path, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect((Seq<ACL>)listParent, this.secondZk$1.secure(), sensitive));
                String childPath = new StringBuilder().append((Object)path).append((Object)"/fpjwashere").toString();
                Seq listChild = this.secondZk$1.getAcl(childPath);
                Assert.assertTrue((String)childPath, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect((Seq<ACL>)listChild, this.secondZk$1.secure(), sensitive));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondZk$1 = secondZk$1;
            }
        });
        Seq consumersAcl = firstZk.getAcl(ConsumerPathZNode$.MODULE$.path());
        Assert.assertTrue((String)ConsumerPathZNode$.MODULE$.path(), (boolean)this.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect((Seq<ACL>)consumersAcl, false, false));
        Assert.assertTrue((String)"/kafka-acl-extended", (boolean)this.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect((Seq<ACL>)firstZk.getAcl("/kafka-acl-extended"), secondZk.secure(), ZkData$.MODULE$.sensitivePath(ExtendedAclZNode$.MODULE$.path())));
    }

    private void verify(String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Seq list = this.zkClient().getAcl(path);
        Assert.assertTrue((boolean)list.forall((Function1)new Serializable(this, sensitive){
            public static final long serialVersionUID = 0L;
            private final boolean sensitive$2;

            public final boolean apply(ACL x$1) {
                return TestUtils$.MODULE$.isAclSecure(x$1, this.sensitive$2);
            }
            {
                this.sensitive$2 = sensitive$2;
            }
        }));
    }

    public boolean kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(Seq<ACL> list, boolean secure, boolean sensitive) {
        boolean isListSizeCorrect;
        boolean bl = secure && !sensitive ? list.size() == 2 : (isListSizeCorrect = list.size() == 1);
        return isListSizeCorrect && list.forall((Function1)(secure ? new Serializable(this, sensitive){
            public static final long serialVersionUID = 0L;
            private final boolean sensitive$1;

            public final boolean apply(ACL x$2) {
                return TestUtils$.MODULE$.isAclSecure(x$2, this.sensitive$1);
            }
            {
                this.sensitive$1 = sensitive$1;
            }
        } : new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ACL acl) {
                return TestUtils$.MODULE$.isAclUnsecure(acl);
            }
        }));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        Try<Object> result = this.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(unsecureZkClient, "/");
        unsecureZkClient.close();
        System.clearProperty("zookeeper.sasl.client");
        Try<Object> try_ = result;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw this.fail(e.getMessage(), new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }
        throw new MatchError(try_);
    }

    public Try<Object> kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(KafkaZkClient zkClient, String path) {
        Try try_;
        this.info((Function0<String>)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkClient.getChildren(path).foreach((Function1)new Serializable(this, zkClient, path, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final KafkaZkClient zkClient$1;
            private final String path$1;
            private final ObjectRef result$1;

            public final void apply(String child) {
                Try<Object> try_;
                block4: {
                    Try try_2;
                    block3: {
                        block2: {
                            String string = this.path$1;
                            Try<Object> try_3 = "/".equals(string) ? this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkClient$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{child}))) : this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkClient$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, child})));
                            try_ = try_3;
                            if (!(try_ instanceof Success)) break block2;
                            try_2 = (Try)this.result$1.elem;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        try_2 = new Failure(e);
                    }
                    this.result$1.elem = try_2;
                    return;
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zkClient$1 = zkClient$1;
                this.path$1 = path$1;
                this.result$1 = result$1;
            }
        });
        String string = path;
        if ("/".equals(string)) {
            try_ = (Try)result.elem;
        } else {
            Try try_2;
            try {
                String x$12 = string;
                boolean x$13 = false;
                int x$14 = zkClient.deletePath$default$2();
                zkClient.deletePath(x$12, x$14, x$13);
                try_2 = new Failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Have been able to delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))));
            }
            catch (Exception exception) {
                try_2 = (Try)result.elem;
            }
            try_ = try_2;
        }
        return try_;
    }

    @Test
    public void testConsumerOffsetPathAcls() {
        this.zkClient().makeSurePersistentPathExists(ConsumerPathZNode$.MODULE$.path());
        List consumerPathAcls = this.zkClient().currentZooKeeper().getACL(ConsumerPathZNode$.MODULE$.path(), new Stat());
        Assert.assertTrue((String)"old consumer znode path acls are not open", (boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumerPathAcls).asScala()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ACL acl) {
                return TestUtils$.MODULE$.isAclUnsecure(acl);
            }
        }));
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

