/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\u0001B)\u001a7bs\u0016$g)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\t\u0001\"Z1ts6|7m\u001b\u0006\u0002\u001b\u0005\u0019qN]4\n\u0005=Q!aD#bgflunY6TkB\u0004xN\u001d;\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001b\u0002\f\u0001\u0005\u0004%IaF\u0001\t[\u0006D()\u001f;fgV\t\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0002J]RDaa\b\u0001!\u0002\u0013A\u0012!C7bq\nKH/Z:!\u0011\u001d\t\u0003A1A\u0005\n\t\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001$!\t!B%\u0003\u0002&\u0005\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bBB\u0014\u0001A\u0003%1%A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u001dI\u0003A1A\u0005\n)\nAB]3qY&\u001c\u0017-U;pi\u0006,\u0012a\u000b\t\u0003)1J!!\f\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\r=\u0002\u0001\u0015!\u0003,\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA!)\u0011\u0007\u0001C\u0001e\u0005AB/Z:u\r\u0016$8\r[,ji\"4UM\\2fI\u0016\u0003xn\u00195\u0015\u0003M\u0002\"!\u0007\u001b\n\u0005UR\"\u0001B+oSRD#\u0001M\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005ib\u0011!\u00026v]&$\u0018B\u0001\u001f:\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011B \u0002%\t,\u0018\u000e\u001c3GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0001\u000e+\u0005\u000b\u0005\u0002\u0015\u0003&\u0011!I\u0001\u0002\u000e\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u000b\u0011k\u0004\u0019\u0001\r\u0002\u0013I,\u0007\u000f\\5dC&#\u0007\"\u0002$>\u0001\u00049\u0015A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u0011:k\u0011!\u0013\u0006\u0003\u0015.\u000baaY8n[>t'BA\u0003M\u0015\tiE\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001f&\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003R{\u0001\u0007!+A\u0006gKR\u001c\u0007n\u0015;biV\u001c\bC\u0001\u000bT\u0013\t!&A\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo\u001d\u0005\u0006-\u0002!IaV\u0001\u001fKb\u0004Xm\u0019;SK\u0006$gI]8n%\u0016\u0004H.[2b/&$\b.\u0012:s_J$Ra\r-Z5\u001aDQ\u0001R+A\u0002aAQAR+A\u0002\u001dCQaW+A\u0002q\u000b!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0011Ql\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003A&\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003E~\u000bABR3uG\"\u0014V-];fgRL!\u0001Z3\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t\u0011w\fC\u0003h+\u0002\u0007\u0001.A\u0003feJ|'\u000f\u0005\u0002jY6\t!N\u0003\u0002l\u0013\u0006A\u0001O]8u_\u000e|G.\u0003\u0002nU\n1QI\u001d:peNDQa\u001c\u0001\u0005\nA\f\u0001DY;jY\u0012\u0014V-\u00193SKN,H\u000e^,ji\",%O]8s)\t\tH\u000f\u0005\u0002\u0015e&\u00111O\u0001\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000b\u001dt\u0007\u0019\u00015")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$1(responses, this.fetchResultOpt$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$1 = fetchResultOpt$1;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchStatus)})));
    }

    private void expectReadFromReplicaWithError(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, true, (FetchIsolation)FetchLogEnd$.MODULE$, this.maxBytes(), false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)})), this.replicaQuota())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)this.buildReadResultWithError(error))})));
    }

    private LogReadResult buildReadResultWithError(Errors error) {
        Some x$1 = new Some((Object)error.exception());
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$3 = -1L;
        long x$4 = -1L;
        long x$5 = -1L;
        long x$6 = -1L;
        long x$7 = -1L;
        int x$8 = -1;
        None$ x$9 = None$.MODULE$;
        return new LogReadResult(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$9, (Option)x$1);
    }

    public final void kafka$server$DelayedFetchTest$$callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

