/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012!\u00039ve\u001e\fGo\u001c:z+\u00051\u0002c\u0001\n\u00183%\u0011\u0001D\u0001\u0002\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018\u0010\u0005\u0002\u001b75\t\u0001A\u0002\u0003\u001d\u0001\u0001i\"\u0001F'pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u0005\u0002\u001c=A\u0011!cH\u0005\u0003A\t\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\t\u0013\tZ\"\u0011!Q\u0001\n\r2\u0013a\u00023fY\u0006LXj\u001d\t\u0003\u0013\u0011J!!\n\u0006\u0003\t1{gnZ\u0005\u0003E}A\u0001\u0002K\u000e\u0003\u0002\u0003\u0006I!K\u0001\bY>\u001c7n\u00149u!\rI!\u0006L\u0005\u0003W)\u0011aa\u00149uS>t\u0007CA\u00177\u001b\u0005q#BA\u00181\u0003\u0015awnY6t\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0005!!.\u0019<b\u0013\t9dFA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\tsm\u0011)\u0019!C\u0001u\u0005y!/Z:q_:\u001cX\rT8dW>\u0003H/F\u0001*\u0011!a4D!A!\u0002\u0013I\u0013\u0001\u0005:fgB|gn]3M_\u000e\\w\n\u001d;!\u0011\u0015y1\u0004\"\u0001?)\u0011Ir\bQ!\t\u000b\tj\u0004\u0019A\u0012\t\u000f!j\u0004\u0013!a\u0001S!9\u0011(\u0010I\u0001\u0002\u0004I\u0003bB\"\u001c\u0001\u0004%\t\u0001R\u0001\fG>l\u0007\u000f\\3uC\ndW-F\u0001F!\tIa)\u0003\u0002H\u0015\t9!i\\8mK\u0006t\u0007bB%\u001c\u0001\u0004%\tAS\u0001\u0010G>l\u0007\u000f\\3uC\ndWm\u0018\u0013fcR\u00111J\u0014\t\u0003\u00131K!!\u0014\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f\"\u000b\t\u00111\u0001F\u0003\rAH%\r\u0005\u0007#n\u0001\u000b\u0015B#\u0002\u0019\r|W\u000e\u001d7fi\u0006\u0014G.\u001a\u0011\t\u000bM[B\u0011\u0001+\u0002\u001f\u0005<\u0018-\u001b;FqBL'/\u0019;j_:$\u0012a\u0013\u0005\u0006-n!\teV\u0001\fiJL8i\\7qY\u0016$X\rF\u0001F\u0011\u0015I6\u0004\"\u0011U\u00031yg.\u0012=qSJ\fG/[8o\u0011\u0015Y6\u0004\"\u0011U\u0003)ygnQ8na2,G/\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u00035\u0001XO]4bi>\u0014\u0018p\u0018\u0013fcR\u00111j\u0018\u0005\b\u001fr\u000b\t\u00111\u0001\u0017\u0011\u0019\t\u0007\u0001)Q\u0005-\u0005Q\u0001/\u001e:hCR|'/\u001f\u0011\t\u000f\r\u0004\u0001\u0019!C\u0001I\u0006yQ\r_3dkR|'oU3sm&\u001cW-F\u0001f!\t1w-D\u00011\u0013\tA\u0007GA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f1#\u001a=fGV$xN]*feZL7-Z0%KF$\"a\u00137\t\u000f=K\u0017\u0011!a\u0001K\"1a\u000e\u0001Q!\n\u0015\f\u0001#\u001a=fGV$xN]*feZL7-\u001a\u0011\t\u000bA\u0004A\u0011\u0001+\u0002\u000bM,G/\u00169)\u0005=\u0014\bCA:y\u001b\u0005!(BA;w\u0003\u0015QWO\\5u\u0015\u00059\u0018aA8sO&\u0011\u0011\u0010\u001e\u0002\u0007\u0005\u00164wN]3\t\u000bm\u0004A\u0011\u0001+\u0002\u0011Q,\u0017M\u001d#po:D#A_?\u0011\u0005Mt\u0018BA@u\u0005\u0015\te\r^3s\u0011\u0019\t\u0019\u0001\u0001C\u0001)\u00069B/Z:u%\u0016\fX/Z:u'\u0006$\u0018n\u001d4bGRLwN\u001c\u0015\u0005\u0003\u0003\t9\u0001E\u0002t\u0003\u0013I1!a\u0003u\u0005\u0011!Vm\u001d;\t\r\u0005=\u0001\u0001\"\u0001U\u0003E!Xm\u001d;SKF,Xm\u001d;FqBL'/\u001f\u0015\u0005\u0003\u001b\t9\u0001\u0003\u0004\u0002\u0016\u0001!\t\u0001V\u0001\u0011i\u0016\u001cHOU3rk\u0016\u001cH\u000fU;sO\u0016DC!a\u0005\u0002\b!1\u00111\u0004\u0001\u0005\u0002Q\u000baf\u001d5pk2$7)\u00198dK24uN]&fsJ+G/\u001e:oS:<7)\u00198dK2dW\rZ(qKJ\fG/[8og\"\"\u0011\u0011DA\u0004\u0011\u0019\t\t\u0003\u0001C\u0001)\u0006I4\u000f[8vY\u0012\u0014V\r^;s]:KGn\u00149fe\u0006$\u0018n\u001c8t\u001f:\u001c\u0015M\\2fY\u001a{'oS3z/\",gnS3z\t>,7O\u001c;Fq&\u001cH\u000f\u000b\u0003\u0002 \u0005\u001d\u0001BBA\u0014\u0001\u0011\u0005A+A\u000fuKN$HK]=D_6\u0004H.\u001a;f\u0019>\u001c7nQ8oi\u0016tG/[8oQ\u0011\t)#a\u0002\t\r\u00055\u0002\u0001\"\u0001U\u0003\t\"Xm\u001d;Uef\u001cu.\u001c9mKR,w+\u001b;i\u001bVdG/\u001b9mKRC'/Z1eg\"\"\u00111FA\u0004\u0011\u0019\t\u0019\u0004\u0001C\u0001)\u0006AB/Z:u\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:dunY6)\t\u0005E\u0012q\u0001\u0005\u0007\u0003s\u0001A\u0011\u0001+\u0002AQ,7\u000f\u001e#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7n\u0014<feJLG-\u001a\u0015\u0005\u0003o\t9\u0001C\u0004\u0002@\u0001!\t!!\u0011\u00025Y,'/\u001b4z\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:dunY6\u0015\u000b-\u000b\u0019%!\u0014\t\u0013\u0005\u0015\u0013Q\bCA\u0002\u0005\u001d\u0013\u0001F7pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0003\n\u0003\u0013J\u0012bAA&\u0015\tAAHY=oC6,g\bC\u0004\u0002P\u0005u\u0002\u0019A#\u0002\u001f5L7/\\1uG\",G\rT8dWNDq!a\u0015\u0001\t\u0013\t)&\u0001\nsk:|e.\u00118pi\",'\u000f\u00165sK\u0006$GCBA,\u0003k\nY\b\r\u0003\u0002Z\u0005\r\u0004#\u00024\u0002\\\u0005}\u0013bAA/a\t1a)\u001e;ve\u0016\u0004B!!\u0019\u0002d1\u0001A\u0001DA3\u0003#\n\t\u0011!A\u0003\u0002\u0005\u001d$aA0%eE!\u0011\u0011NA8!\rI\u00111N\u0005\u0004\u0003[R!a\u0002(pi\"Lgn\u001a\t\u0004\u0013\u0005E\u0014bAA:\u0015\t\u0019\u0011I\\=\t\u0013\u0005]\u0014\u0011\u000bCA\u0002\u0005e\u0014a\u00014v]B!\u0011\"!\u0013L\u0011\u001d\ti(!\u0015A\u0002\u0015\u000bab\u001d5pk2$7i\\7qY\u0016$XmB\u0005\u0002\u0002\u0002\t\t\u0011#\u0001\u0002\u0004\u0006!Rj\\2l\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u00042AGAC\r!a\u0002!!A\t\u0002\u0005\u001d5cAAC\u0011!9q\"!\"\u0005\u0002\u0005-ECAAB\u0011)\ty)!\"\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M%fA\u0015\u0002\u0016.\u0012\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003%)hn\u00195fG.,GMC\u0002\u0002\"*\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)+a'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002*\u0006\u0015\u0015\u0013!C\u0001\u0003#\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class DelayedOperationTest {
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;
    private ExecutorService executorService = null;
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$lzycompute() {
        DelayedOperationTest delayedOperationTest = this;
        synchronized (delayedOperationTest) {
            if (this.MockDelayedOperation$module != null) return this.MockDelayedOperation$module;
            this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            return this.MockDelayedOperation$module;
        }
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start2 = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start2;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time for expiration ", " should at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().delayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)2L, (long)this.purgatory().delayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().delayed())).toString(), (long)1L, (long)this.purgatory().delayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 4 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().delayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteLockContention() {
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        AtomicInteger completionAttemptsRemaining = new AtomicInteger(Integer.MAX_VALUE);
        Semaphore tryCompleteSemaphore = new Semaphore(1);
        String key = "key";
        MockDelayedOperation op = new MockDelayedOperation(this, completionAttemptsRemaining, tryCompleteSemaphore){
            private final AtomicInteger completionAttemptsRemaining$1;
            private final Semaphore tryCompleteSemaphore$1;

            public boolean tryComplete() {
                boolean shouldComplete = this.completionAttemptsRemaining$1.decrementAndGet() <= 0;
                this.tryCompleteSemaphore$1.acquire();
                try {
                    boolean bl = shouldComplete ? this.forceComplete() : false;
                    return bl;
                }
                finally {
                    this.tryCompleteSemaphore$1.release();
                }
            }
            {
                this.completionAttemptsRemaining$1 = completionAttemptsRemaining$1;
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
                super($outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
            }
        };
        this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key})));
        completionAttemptsRemaining.set(2);
        tryCompleteSemaphore.acquire();
        Future<?> future = this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.purgatory().checkAndComplete((Object)this.key$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, false);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tryCompleteSemaphore){
            public static final long serialVersionUID = 0L;
            private final Semaphore tryCompleteSemaphore$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.tryCompleteSemaphore$1.hasQueuedThreads();
            }
            {
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Not attempting to complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.purgatory().checkAndComplete((Object)key);
        Assert.assertFalse((String)"Operation should not have completed", (boolean)op.isCompleted());
        tryCompleteSemaphore.release();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1)new Serializable(this, random, maxDelayMs, completionAttempts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Random random$1;
            private final int maxDelayMs$1;
            private final int completionAttempts$1;

            /*
             * WARNING - void declaration
             */
            public final TestDelayOperation.1 apply(int index) {
                void var2_2;
                public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
                extends MockDelayedOperation {
                    private final String key;
                    private final AtomicInteger completionAttemptsRemaining;
                    public final /* synthetic */ DelayedOperationTest $outer;
                    private final Random random$1;
                    private final int maxDelayMs$1;

                    public String key() {
                        return this.key;
                    }

                    public AtomicInteger completionAttemptsRemaining() {
                        return this.completionAttemptsRemaining;
                    }

                    public boolean tryComplete() {
                        boolean shouldComplete = this.completable();
                        Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                        return shouldComplete ? this.forceComplete() : false;
                    }

                    public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$TestDelayOperation$$$outer() {
                        return this.$outer;
                    }

                    public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, Random random$1, int maxDelayMs$1, int completionAttempts$1) {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                        this.maxDelayMs$1 = maxDelayMs$1;
                        super($outer, 10000L, $outer.MockDelayedOperation().$lessinit$greater$default$2(), $outer.MockDelayedOperation().$lessinit$greater$default$3());
                        this.key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                    }
                }
                Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1(this.$outer, index, this.random$1, this.maxDelayMs$1, this.completionAttempts$1);
                this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.random$1 = random$1;
                this.maxDelayMs$1 = maxDelayMs$1;
                this.completionAttempts$1 = completionAttempts$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1)new Serializable(this, executor, random, maxDelayMs, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            public final ScheduledExecutorService executor$1;
            public final Random random$1;
            public final int maxDelayMs$1;
            private final IndexedSeq ops$1;

            public final IndexedSeq<Future<?>> apply(int x$1) {
                return (IndexedSeq)this.ops$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTryCompleteWithMultipleThreads$1 $outer;

                    public final Future<?> apply(TestDelayOperation.1 op) {
                        return this.$outer.kafka$server$DelayedOperationTest$$anonfun$$$outer().kafka$server$DelayedOperationTest$$scheduleTryComplete$1(op, this.$outer.random$1.nextInt(this.$outer.maxDelayMs$1), this.$outer.executor$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executor$1 = executor$1;
                this.random$1 = random$1;
                this.maxDelayMs$1 = maxDelayMs$1;
                this.ops$1 = ops$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> future) {
                return future.get();
            }
        });
        ops.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TestDelayOperation.1 op) {
                Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
            }
        });
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return new MockDelayedOperation(this.$outer, 100000L, this.$outer.MockDelayedOperation().$lessinit$greater$default$2(), this.$outer.MockDelayedOperation().$lessinit$greater$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return this.$outer.kafka$server$DelayedOperationTest$$newMockOperation$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return new MockDelayedOperation(this.$outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        ObjectRef ops = ObjectRef.create((Object)this.createDelayedOperations$1(2, mockDelayedOperation, key));
        this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        CoreUtils$.MODULE$.inLock(((DelayedOperation)((Seq)ops.elem).apply(1)).lock(), (Function0)new Serializable(this, key, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$2;
            private final ObjectRef ops$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)this.ops$2.elem, (Seq)this.ops$2.elem, this.key$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
                this.ops$2 = ops$2;
            }
        });
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, ops){
            public static final long serialVersionUID = 0L;
            private final ObjectRef ops$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((DelayedOperation)((Seq)this.ops$2.elem).apply(0)).lock().lock();
            }
            {
                this.ops$2 = ops$2;
            }
        }, true);
        try {
            this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)ops.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))})), key);
            this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, ops){
                public static final long serialVersionUID = 0L;
                private final ObjectRef ops$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ((DelayedOperation)((Seq)this.ops$2.elem).apply(0)).lock().unlock();
                }
                {
                    this.ops$2 = ops$2;
                }
            }, true);
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, true);
            this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)var4_4.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)var4_4.elem).apply(0))})), (String)var3_3);
            throw throwable;
        }
        this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1)new Serializable(this, mismatchedLocks, key, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final boolean mismatchedLocks$1;
            private final String key$2;
            private final ObjectRef ops$2;

            public final void apply(ReentrantLock lock) {
                this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, lock){
                    public static final long serialVersionUID = 0L;
                    private final ReentrantLock lock$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lock$1.lock();
                    }
                    {
                        this.lock$1 = lock$1;
                    }
                }, true);
                try {
                    try {
                        this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)this.ops$2.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(1))})), this.key$2);
                        Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)this.mismatchedLocks$1);
                    }
                    catch (IllegalStateException illegalStateException) {
                        Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)this.mismatchedLocks$1);
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, lock){
                        public static final long serialVersionUID = 0L;
                        private final ReentrantLock lock$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.lock$1.unlock();
                        }
                        {
                            this.lock$1 = lock$1;
                        }
                    }, true);
                    this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), this.key$2);
                    throw throwable;
                }
                this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, true);
                this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), this.key$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mismatchedLocks$1 = mismatchedLocks$1;
                this.key$2 = key$2;
                this.ops$2 = ops$2;
            }
        });
        ops.elem = this.createCompletableOperations$1(2, mockDelayedOperation);
        ((Seq)ops.elem).foreach((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$2;

            public final void apply(MockDelayedOperation op) {
                Assert.assertTrue((String)"Should have completed", (boolean)this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$2}))));
                Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Future<?> kafka$server$DelayedOperationTest$$runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Object object;
        Future<?> future = this.executorService().submit(new Runnable(this, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (shouldComplete) {
            object = future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        return this.MockDelayedOperation$module == null ? this.MockDelayedOperation$lzycompute() : this.MockDelayedOperation$module;
    }

    public final Future kafka$server$DelayedOperationTest$$scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$1;

            public void run() {
                if (this.op$1.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$1.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$1.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = op$1;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public final MockDelayedOperation kafka$server$DelayedOperationTest$$newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$2) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)new Serializable(this, mockDelayedOperation$1, key$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Function0 mockDelayedOperation$1;
            private final String key$2;

            /*
             * WARNING - void declaration
             */
            public final MockDelayedOperation apply(int x$2) {
                void var2_2;
                MockDelayedOperation op = (MockDelayedOperation)((Object)this.mockDelayedOperation$1.apply());
                this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$2})));
                Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockDelayedOperation$1 = mockDelayedOperation$1;
                this.key$2 = key$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)new Serializable(this, mockDelayedOperation$1){
            public static final long serialVersionUID = 0L;
            private final Function0 mockDelayedOperation$1;

            /*
             * WARNING - void declaration
             */
            public final MockDelayedOperation apply(int x$3) {
                void var2_2;
                MockDelayedOperation op = (MockDelayedOperation)((Object)this.mockDelayedOperation$1.apply());
                op.completable_$eq(true);
                return var2_2;
            }
            {
                this.mockDelayedOperation$1 = mockDelayedOperation$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public final void kafka$server$DelayedOperationTest$$checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$2) {
        completableOps.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                op.completable_$eq(true);
            }
        });
        int completed = this.purgatory().checkAndComplete((Object)key$2);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
            }
        });
        Set expectedNotComplete = (Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete);
        expectedNotComplete.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
            }
        });
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            ((Object)((Object)this)).wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ReentrantLock lock) {
                    if (lock.tryLock()) {
                        return;
                    }
                    throw new IllegalStateException("Response callback lock could not be acquired in callback");
                }
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                ((Object)((Object)this)).notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

