/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\b\"B\u0007\u0001\t\u0003q\u0011A\u0002\u001fj]&$h\bF\u0001\u0010!\tI\u0001\u0001\u0003\u0005\u0012\u0001!\u0015\r\u0011\"\u0003\u0013\u0003\u0011!\u0018.\\3\u0016\u0003M\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005a)\"\u0001C'pG.$\u0016.\\3\t\u0011i\u0001\u0001\u0012!Q!\nM\tQ\u0001^5nK\u0002BQ\u0001\b\u0001\u0005Ru\t!B\\;n\u0005J|7.\u001a:t+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\")Q\u0005\u0001C)M\u0005Q!M]8lKJ$\u0016.\\3\u0015\u0005M9\u0003\"\u0002\u0015%\u0001\u0004q\u0012\u0001\u00032s_.,'/\u00133\t\u000b)\u0002A\u0011K\u0016\u0002#A\u0014x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002-_A\u0011q$L\u0005\u0003]\u0001\u0012A!\u00168ji\")\u0001'\u000ba\u0001c\u0005)\u0001O]8qgB\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0005kRLGNC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u001a$A\u0003)s_B,'\u000f^5fg\")!\b\u0001C\u0001w\u0005iB/Z:u\u000f\u0016$xJ\u001a4tKR\u001chi\u001c:V].twn\u001e8U_BL7\rF\u0001-Q\tIT\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006)!.\u001e8ji*\t!)A\u0002pe\u001eL!\u0001R \u0003\tQ+7\u000f\u001e\u0015\u0005s\u0019K5\n\u0005\u0002 \u000f&\u0011\u0001\n\t\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%\u0001&\u0002+1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u0011Wa\u0005\nA*\u0001\u0001\t\u000b9\u0003A\u0011A\u001e\u0002AQ,7\u000f^$fi>3gm]3ug\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0003\u001bvBC!\u0014$J\u0017\")!\u000b\u0001C\u0001w\u0005qB/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016d\u0015\r^3tiRKW.\u001a\u0015\u0003#vBQ!\u0016\u0001\u0005\u0002m\nq\u0003^3ti\u0016k\u0007\u000f^=M_\u001e\u001cx)\u001a;PM\u001a\u001cX\r^:)\u0005Qk\u0004\"\u0002-\u0001\t\u0003Y\u0014a\u0006;fgR<U\r^(gMN,Go\u001d\"fM>\u0014XMT8xQ\t9V\b\u000b\u0003X\rn[\u0015%\u0001/\u000211,w-Y2z\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X\rC\u0003_\u0001\u0011\u00051(\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,\u0007FA/>Q\u0011ifiW&\t\u000b\t\u0004A\u0011A\u001e\u0002[Q,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8u'&TX\r\u000b\u0002b{!)Q\r\u0001C\u0001w\u0005QC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001c\bF\u00013>\u0011\u0015\u0019\u0001\u0001\"\u0003i+\u0005I\u0007CA\u0005k\u0013\tY'AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B7\u0001\t\u0013q\u0017AF:f]\u0012d\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;\u0015\u0007=Tx\u0010\u0005\u0002qq6\t\u0011O\u0003\u0002sg\u0006A!/Z9vKN$8O\u0003\u0002uk\u000611m\\7n_:T!!\u0002<\u000b\u0005]\f\u0015AB1qC\u000eDW-\u0003\u0002zc\n\u0011B*[:u\u001f\u001a47/\u001a;SKN\u0004xN\\:f\u0011\u0015YH\u000e1\u0001}\u0003\u001d\u0011X-];fgR\u0004\"\u0001]?\n\u0005y\f(!\u0005'jgR|eMZ:fiJ+\u0017/^3ti\"I\u0011\u0011\u00017\u0011\u0002\u0003\u0007\u00111A\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000eE\u0003 \u0003\u000b\tI!C\u0002\u0002\b\u0001\u0012aa\u00149uS>t\u0007\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=A!A\u0004oKR<xN]6\n\t\u0005M\u0011Q\u0002\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\b\u0003/\u0001A\u0011BA\r\u0003A\u0019XM\u001c3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u001c\u00055\u0012Q\u0007\t\u0006a\u0006u\u0011\u0011E\u0005\u0004\u0003?\t(!\u0004$fi\u000eD'+Z:q_:\u001cX\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9c]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005-\u0012Q\u0005\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000fm\f)\u00021\u0001\u00020A\u0019\u0001/!\r\n\u0007\u0005M\u0012O\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0006\u0002\u0002\u0005U\u0001\u0013!a\u0001\u0003\u0007A\u0011\"!\u000f\u0001#\u0003%I!a\u000f\u0002AM,g\u000e\u001a'jgR|eMZ:fiN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003{QC!a\u0001\u0002@-\u0012\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003%)hn\u00195fG.,GMC\u0002\u0002L\u0001\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty%!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002T\u0001\t\n\u0011\"\u0003\u0002<\u0005Q2/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        LogOffsetTest logOffsetTest = this;
        synchronized (logOffsetTest) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
            return this.time;
        }
    }

    private MockTime time() {
        return this.bitmap$0 ? this.time : this.time$lzycompute();
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void propertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 10))}))).asJava()).build((short)0);
        ListOffsetResponse response = this.kafka$server$LogOffsetTest$$sendListOffsetsRequest(request, this.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((ListOffsetResponse.PartitionData)response.responseData().get((Object)topicPartition)).error);
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.kafka$server$LogOffsetTest$$server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, logManager){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;
            private final LogManager logManager$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.logManager$1.getLog(this.topicPartition$1, this.logManager$1.getLog$default$2()).isDefined();
            }
            {
                this.topicPartition$1 = topicPartition$1;
                this.logManager$1 = logManager$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Log for partition [topic,0] should be created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Log log2 = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$1;

            public final LogAppendInfo apply(int _) {
                return this.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
            }
            {
                this.log$1 = log$1;
            }
        });
        log2.flush();
        log2.onHighWatermarkIncremented(log2.logEndOffset());
        log2.maybeIncrementLogStartOffset(3L);
        log2.deleteOldSegments();
        Seq offsets = log2.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$1;
            private final TopicPartition topicPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$1, this.topicPartition$1.partition(), this.$outer.kafka$server$LogOffsetTest$$server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.topicPartition$1 = topicPartition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader should be elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.kafka$server$LogOffsetTest$$sendListOffsetsRequest((ListOffsetRequest)request, this.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.kafka$server$LogOffsetTest$$server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, logManager){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;
            private final LogManager logManager$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.logManager$2.getLog(this.topicPartition$2, this.logManager$2.getLog$default$2()).isDefined();
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.logManager$2 = logManager$2;
            }
        }, (Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log for partition ", " should be created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}));
            }
            {
                this.topicPartition$2 = topicPartition$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Log log2 = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final LogAppendInfo apply(int _) {
                return this.log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$2.appendAsLeader$default$3(), this.log$2.appendAsLeader$default$4());
            }
            {
                this.log$2 = log$2;
            }
        });
        log2.flush();
        Seq offsets = log2.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$2;
            private final TopicPartition topicPartition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$2, this.topicPartition$2.partition(), this.$outer.kafka$server$LogOffsetTest$$server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.topicPartition$2 = topicPartition$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader should be elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.kafka$server$LogOffsetTest$$sendListOffsetsRequest((ListOffsetRequest)request, this.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(fetchRequest, this.sendFetchRequest$default$2());
        Assert.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)fetchResponse.responseData().get((Object)topicPartition)).records).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TestUtils$.MODULE$.tempDir().getAbsolutePath(), topic, BoxesRunTime.boxToInteger((int)topicPartition.partition())}));
        File topicLogDir = new File(topicPartitionPath);
        topicLogDir.mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)new Serializable(this, topic, offsetChanged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$3;
            private final BooleanRef offsetChanged$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                TopicPartition topicPartition = new TopicPartition(this.topic$3, 0);
                ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-2L, 1))}))).asJava()).build();
                Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.$outer.kafka$server$LogOffsetTest$$sendListOffsetsRequest((ListOffsetRequest)request, this.$outer.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
                if (BoxesRunTime.equals((Object)consumerOffsets.head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                    this.offsetChanged$1.elem = true;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.offsetChanged$1 = offsetChanged$1;
            }
        });
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.kafka$server$LogOffsetTest$$server().getLogManager();
        Log log2 = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;

            public final LogAppendInfo apply(int _) {
                return this.log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$3.appendAsLeader$default$3(), this.log$3.appendAsLeader$default$4());
            }
            {
                this.log$3 = log$3;
            }
        });
        log2.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log2.legacyFetchOffsetsBefore(now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$4;
            private final TopicPartition topicPartition$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$4, this.topicPartition$3.partition(), this.$outer.kafka$server$LogOffsetTest$$server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.topicPartition$3 = topicPartition$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader should be elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(now, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.kafka$server$LogOffsetTest$$sendListOffsetsRequest((ListOffsetRequest)request, this.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.kafka$server$LogOffsetTest$$server().getLogManager();
        Log log2 = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;

            public final LogAppendInfo apply(int _) {
                return this.log$4.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$4.appendAsLeader$default$3(), this.log$4.appendAsLeader$default$4());
            }
            {
                this.log$4 = log$4;
            }
        });
        log2.flush();
        Seq offsets = log2.legacyFetchOffsetsBefore(-2L, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$5;
            private final TopicPartition topicPartition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$5, this.topicPartition$4.partition(), this.$outer.kafka$server$LogOffsetTest$$server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$5 = topic$5;
                this.topicPartition$4 = topicPartition$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader should be elected";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-2L, 10))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.kafka$server$LogOffsetTest$$sendListOffsetsRequest((ListOffsetRequest)request, this.kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log2 = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(this){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        Seq logSegments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log2.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log2});
        log2.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log2 = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log2.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(this, logSegment){
            public final LogSegment logSegment$1;

            public Object answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$3 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.class.companion((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.class.seq((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.class.thisCollection((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.class.toCollection((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.class.foreach((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.class.forall((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.class.exists((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.class.find((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.class.isEmpty((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.class.foldRight((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.class.reduceRight((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.class.toIterable((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.class.toIterator((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.class.head((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.class.slice((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.class.take((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.class.drop((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.class.takeWhile((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size2) {
                        return IterableLike.class.grouped((IterableLike)this, (int)size2);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size2) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size2);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size2, int step) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size2, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.class.takeRight((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.class.dropRight((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start2, int len) {
                        IterableLike.class.copyToArray((IterableLike)this, (Object)xs, (int)start2, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zip((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zipAll((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.class.zipWithIndex((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.class.sameElements((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.class.toStream((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.class.canEqual((IterableLike)this, (Object)that);
                    }

                    public Object view() {
                        return IterableLike.class.view((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.class.view((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.class.newBuilder((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.class.genericBuilder((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.class.unzip((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.class.unzip3((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.class.flatten((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.class.transpose((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.class.repr((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.class.isTraversableAgain((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.class.parCombiner((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.class.hasDefiniteSize((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.map((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.flatMap((TraversableLike)this, f, bf);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.class.filter((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.class.filterNot((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.collect((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.partition((TraversableLike)this, p);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.class.groupBy((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.class.scan((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.scanLeft((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.class.scanRight((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.class.headOption((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.class.tail((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.class.last((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.class.lastOption((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.class.init((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.class.sliceWithKnownDelta((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.class.sliceWithKnownBound((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.class.dropWhile((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.span((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.class.splitAt((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.class.tails((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.class.inits((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.class.toTraversable((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.class.to((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.class.toString((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.class.stringPrefix((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.class.withFilter((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.class.par((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start2) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start2, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1}))).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Parallelizable.class.$init$((Parallelizable)this);
                        TraversableLike.class.$init$((TraversableLike)this);
                        GenericTraversableTemplate.class.$init$((GenericTraversableTemplate)this);
                        GenTraversable.class.$init$((GenTraversable)this);
                        Traversable.class.$init$((Traversable)this);
                        GenIterable.class.$init$((GenIterable)this);
                        IterableLike.class.$init$((IterableLike)this);
                        Iterable.class.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log2});
        log2.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    public KafkaServer kafka$server$LogOffsetTest$$server() {
        return (KafkaServer)this.servers().head();
    }

    public ListOffsetResponse kafka$server$LogOffsetTest$$sendListOffsetsRequest(ListOffsetRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.LIST_OFFSETS, (SocketServer)destination.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;

            public final SocketServer apply() {
                return this.$outer.anySocketServer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ListOffsetResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public Option<SocketServer> kafka$server$LogOffsetTest$$sendListOffsetsRequest$default$2() {
        return None$.MODULE$;
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, (SocketServer)destination.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;

            public final SocketServer apply() {
                return this.$outer.anySocketServer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendFetchRequest$default$2() {
        return None$.MODULE$;
    }
}

