/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.cluster.Broker;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.MetadataCacheTest$$anonfun$getTopicMetadata$1$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#T3uC\u0012\fG/Y\"bG\",G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001\u0002'p]\u001eDaA\u0007\u0001!\u0002\u00131\u0012\u0001\u00042s_.,'/\u00129pG\"\u0004\u0003\"\u0002\u000f\u0001\t\u0003i\u0012!I4fiR{\u0007/[2NKR\fG-\u0019;b\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cH#\u0001\u0010\u0011\u0005%y\u0012B\u0001\u0011\u000b\u0005\u0011)f.\u001b;)\u0005m\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0005)\u0016\u001cH\u000fC\u0003,\u0001\u0011\u0005Q$\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"\u0012!F\t\u0005\u0006]\u0001!\t!H\u0001,O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK\"\u0012QF\t\u0005\u0006c\u0001!\t!H\u00016O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM\u001d(pi\u00063\u0018-\u001b7bE2,wJ\u001c'fC\u0012,'\u000f\u000b\u00021E!)A\u0007\u0001C\u0001;\u00059u-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019&\u001cH/\u001a8fe:{G/\u0011<bS2\f'\r\\3P]2+\u0017\rZ3s\u001f2$W*\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u000b\u00024E!)q\u0007\u0001C\u0005q\u0005Ad/\u001a:jMf$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*Z1eKJ|%/\u00128ea>Lg\u000e\u001e(pi\u00063\u0018-\u001b7bE2,GC\u0002\u0010:;\u0016T'\u000fC\u0003;m\u0001\u00071(A\u0004ce>\\WM]:\u0011\u0007qz$I\u0004\u0002\n{%\u0011aHC\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%aA*fi*\u0011aH\u0003\t\u0003\u0007js!\u0001R,\u000f\u0005\u0015#fB\u0001$R\u001d\t9uJ\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111JB\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ!A\u0014\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)\u0001K\u0003\u0002OM%\u0011!kU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001\u0016BA+W\u0003!\u0011X-];fgR\u001c(B\u0001*T\u0013\tA\u0016,A\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u000b\u0005U3\u0016BA.]\u0005\u0019\u0011%o\\6fe*\u0011\u0001,\u0017\u0005\u0006=Z\u0002\raX\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003EZ\u000bqA\\3uo>\u00148.\u0003\u0002eC\naA*[:uK:,'OT1nK\")aM\u000ea\u0001O\u00061A.Z1eKJ\u0004\"!\u00035\n\u0005%T!aA%oi\")1N\u000ea\u0001Y\u0006iQ\r\u001f9fGR,G-\u0012:s_J\u0004\"!\u001c9\u000e\u00039T!a\u001c,\u0002\u0011A\u0014x\u000e^8d_2L!!\u001d8\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015\u0019h\u00071\u0001u\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0011\u0005%)\u0018B\u0001<\u000b\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001f\u0001\u0005\u0002u\t1eZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKBd\u0017nY1O_R\fe/Y5mC\ndW\r\u000b\u0002xE!)1\u0010\u0001C\u0001;\u0005yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3)\u0005i\u0014\u0003\"\u0002@\u0001\t\u0003i\u0012\u0001M4fiR{\u0007/[2NKR\fG-\u0019;b/&$\bNT8o'V\u0004\bo\u001c:uK\u0012\u001cVmY;sSRL\bK]8u_\u000e|G\u000e\u000b\u0002~E!1\u00111\u0001\u0001\u0005\u0002u\tafZ3u\u00032Lg/\u001a\"s_.,'o]*i_VdGMT8u\u0005\u0016lU\u000f^1uK\u0012\u0014\u00150\u00169eCR,7)Y2iK\"\u001a\u0011\u0011\u0001\u0012")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Test
    public void getTopicMetadataNonExistingTopics() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertTrue((boolean)topicMetadata.isEmpty());
    }

    @Test
    public void getTopicMetadata() {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        scala.collection.immutable.Set brokers = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                return new UpdateMetadataRequest.Broker(brokerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.$outer.kafka$server$MetadataCacheTest$$endPoints$1(brokerId)).asJava(), "rack1");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic0, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 0, 0, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), Arrays.asList((Object[])new Integer[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic0, 1)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 1, 1, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, 2, 2, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}), Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}))).foreach((Function1)new Serializable(this, topic0, topic1, cache, partitionStates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataCacheTest $outer;
            private final String topic0$1;
            private final String topic1$1;
            private final MetadataCache cache$1;
            private final scala.collection.immutable.Map partitionStates$1;

            public final void apply(SecurityProtocol securityProtocol) {
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                this.checkTopicMetadata$1(this.topic0$1, listenerName);
                this.checkTopicMetadata$1(this.topic1$1, listenerName);
            }

            public /* synthetic */ MetadataCacheTest kafka$server$MetadataCacheTest$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkTopicMetadata$1(String topic, ListenerName listenerName$1) {
                Seq topicMetadatas = this.cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, this.cache$1.getTopicMetadata$default$3(), this.cache$1.getTopicMetadata$default$4());
                Assert.assertEquals((long)1L, (long)topicMetadatas.size());
                MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
                Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
                Assert.assertEquals((Object)topic, (Object)topicMetadata.topic());
                scala.collection.immutable.Map topicPartitionStates = (scala.collection.immutable.Map)this.partitionStates$1.filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState> x0$1) {
                        Tuple2<TopicPartition, UpdateMetadataRequest.PartitionState> tuple2 = x0$1;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            String string = tp.topic();
                            String string2 = this.topic$1;
                            boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                });
                Buffer partitionMetadatas = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MetadataResponse.PartitionMetadata x$1) {
                        return x$1.partition();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected partition count for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (long)topicPartitionStates.size(), (long)partitionMetadatas.size());
                ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, listenerName$1, topic, topicPartitionStates){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTopicMetadata$1 $outer;
                    public final ListenerName listenerName$1;
                    private final String topic$1;
                    private final scala.collection.immutable.Map topicPartitionStates$1;

                    public final void apply(Tuple2<MetadataResponse.PartitionMetadata, Object> x0$2) {
                        Tuple2<MetadataResponse.PartitionMetadata, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)tuple2._1();
                            int partitionId = tuple2._2$mcI$sp();
                            Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
                            Assert.assertEquals((long)partitionId, (long)partitionMetadata.partition());
                            Node leader2 = partitionMetadata.leader();
                            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)this.topicPartitionStates$1.apply((Object)new TopicPartition(this.topic$1, partitionId));
                            Assert.assertEquals((long)partitionState.basePartitionState.leader, (long)leader2.id());
                            Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)partitionState.basePartitionState.leaderEpoch)), (Object)partitionMetadata.leaderEpoch());
                            Assert.assertEquals((Object)partitionState.basePartitionState.isr, (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$2) {
                                    return x$2.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            Assert.assertEquals((Object)partitionState.basePartitionState.replicas, (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Node x$3) {
                                    return x$3.id();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).asJava());
                            UpdateMetadataRequest.EndPoint endPoint = (UpdateMetadataRequest.EndPoint)this.$outer.kafka$server$MetadataCacheTest$$anonfun$$$outer().kafka$server$MetadataCacheTest$$endPoints$1(partitionMetadata.leader().id()).find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getTopicMetadata$1$$anonfun$checkTopicMetadata$1$1 $outer;

                                public final boolean apply(UpdateMetadataRequest.EndPoint x$4) {
                                    ListenerName listenerName = x$4.listenerName;
                                    ListenerName listenerName2 = this.$outer.listenerName$1;
                                    return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).get();
                            Assert.assertEquals((Object)endPoint.host, (Object)leader2.host());
                            Assert.assertEquals((long)endPoint.port, (long)leader2.port());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.listenerName$1 = listenerName$1;
                        this.topic$1 = topic$1;
                        this.topicPartitionStates$1 = topicPartitionStates$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic0$1 = topic0$1;
                this.topic1$1 = topic1$1;
                this.cache$1 = cache$1;
                this.partitionStates$1 = partitionStates$1;
            }
        });
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host0", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName), new UpdateMetadataRequest.EndPoint("host0", 9093, SecurityProtocol.SSL, sslListenerName)}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host1", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName)}));
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava(), null), new UpdateMetadataRequest.Broker(1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeaderOldMetadataVersion() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host0", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName), new UpdateMetadataRequest.EndPoint("host0", 9093, SecurityProtocol.SSL, sslListenerName)}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("host1", 9092, SecurityProtocol.PLAINTEXT, plaintextListenerName)}));
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava(), null), new UpdateMetadataRequest.Broker(1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava(), null)}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((scala.collection.immutable.Set<UpdateMetadataRequest.Broker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(scala.collection.immutable.Set<UpdateMetadataRequest.Broker> brokers, ListenerName listenerName, int leader2, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), zkVersion, Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}), Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        scala.collection.immutable.Set x$14 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        ListenerName x$15 = listenerName;
        boolean x$16 = errorUnavailableListeners;
        boolean x$17 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$14, x$15, x$17, x$16);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)expectedError, (Object)partitionMetadata.error());
        Assert.assertTrue((boolean)partitionMetadata.isr().isEmpty());
        Assert.assertEquals((long)1L, (long)partitionMetadata.replicas().size());
        Assert.assertEquals((long)0L, (long)((Node)partitionMetadata.replicas().get(0)).id());
    }

    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), null)}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, zkVersion, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$5) {
                return x$5.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$6) {
                return x$6.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$7) {
                return x$7.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataIsrNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, listenerName)}))).asJava(), "rack1")}));
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, zkVersion, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$9) {
                return x$9.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$10) {
                return x$10.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$11) {
                return x$11.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$12) {
                return x$12.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), "")}));
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 3, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadata.size());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().size());
        Assert.assertEquals((long)-1L, (long)((MetadataResponse.PartitionMetadata)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().get(0)).leaderId());
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        scala.collection.immutable.Set initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).toSet();
        this.updateCache$1(initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), topic, cache);
        Assert.assertEquals((Object)initialBrokerIds, (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$13) {
                return x$13.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public final Seq kafka$server$MetadataCacheTest$$endPoints$1(int brokerId) {
        String host = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)}));
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint(host, 9092, SecurityProtocol.PLAINTEXT, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)), new UpdateMetadataRequest.EndPoint(host, 9093, SecurityProtocol.SSL, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL))}));
    }

    private final void updateCache$1(scala.collection.immutable.Set brokerIds, String topic$2, MetadataCache cache$2) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UpdateMetadataRequest.Broker apply(int brokerId) {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                return new UpdateMetadataRequest.Broker(brokerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("foo", 9092, securityProtocol, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol))}))).asJava(), "");
            }
        }, Set$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader2 = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic$2, 0)), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 3, replicas, Arrays.asList((Object[])new Integer[0])))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        cache$2.updateMetadata(15, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }
}

