/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u000f\tY\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\tA\u0001^5nKV\ta\u0003\u0005\u0002\u0018C5\t\u0001D\u0003\u0002\u001a5\u0005)Q\u000f^5mg*\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i\"B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!A\t\r\u0003\u00115{7m\u001b+j[\u0016Da\u0001\n\u0001!\u0002\u00131\u0012!\u0002;j[\u0016\u0004\u0003\"\u0002\u0014\u0001\t\u00039\u0013!I:i_VdG\r\u00165s_R$H.Z(oYf$UMZ5oK\u0012\u0014V\r\u001d7jG\u0006\u001cH#\u0001\u0015\u0011\u0005%I\u0013B\u0001\u0016\u000b\u0005\u0011)f.\u001b;)\u0005\u0015b\u0003CA\u00171\u001b\u0005q#BA\u0018 \u0003\u0015QWO\\5u\u0013\t\tdF\u0001\u0003UKN$\b\"B\u001a\u0001\t\u00039\u0013!N:i_VdG-\u0012=dK\u0016$\u0017+^8uCRCWM\u001c*fiV\u0014hNQ1dW\n+Gn\\<C_VtG-Q:US6,\u0007+Y:tKND#A\r\u0017\t\u000bY\u0002A\u0011A\u001c\u0002\tI\fG/\u001a\u000b\u0003qm\u0002\"!C\u001d\n\u0005iR!A\u0002#pk\ndW\rC\u0003=k\u0001\u0007Q(A\u0004nKR\u0014\u0018nY:\u0011\u0005y\u0002U\"A \u000b\u0005qR\u0012BA!@\u0005\u001diU\r\u001e:jGNDQa\u0011\u0001\u0005\u0002\u001d\nae\u001d5pk2$7+\u001e9q_J$x+\u001b7eG\u0006\u0014H\r\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\t\u0011E\u0006C\u0003G\u0001\u0011%q)A\u0002uaF\"\"\u0001\u0013'\u0011\u0005%SU\"\u0001\u000e\n\u0005-S\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u001b\u0016\u0003\rAT\u0001\u0003S\u0012\u0004\"!C(\n\u0005AS!aA%oi\")!\u000b\u0001C\u0005'\u0006Qa.Z<NKR\u0014\u0018nY:\u0015\u0003u\u0002")
public class ReplicationQuotaManagerTest {
    private final MockTime time = new MockTime();

    private MockTime time() {
        return this.time;
    }

    @Test
    public void shouldThrottleOnlyDefinedReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time());
        quota.markThrottled("topic1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(1)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(2)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(3)));
        Assert.assertFalse((boolean)quota.isThrottled(this.tp1(4)));
    }

    @Test
    public void shouldExceedQuotaThenReturnBackBelowBoundAsTimePasses() {
        Metrics metrics = this.newMetrics();
        int x$1 = 10;
        int x$2 = 1;
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(x$3, x$1, x$2), metrics, (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.updateQuota(new Quota(100.0, true));
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        this.time().sleep(1000L);
        this.time().sleep(500L);
        quota.record(1L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(149L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertEquals((double)100.66666666666667, (double)this.rate(metrics), (double)0.0);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        this.time().sleep(500L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)75.5, (double)this.rate(metrics), (double)0.1);
        this.time().sleep(500L);
        quota.record(99L);
        Assert.assertEquals((double)100.0, (double)this.rate(metrics), (double)0.0);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)100.4, (double)this.rate(metrics), (double)0.0);
        this.time().sleep(2000L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)55.77777777777778, (double)this.rate(metrics), (double)0.0);
    }

    /*
     * WARNING - void declaration
     */
    public double rate(Metrics metrics) {
        void var3_3;
        MetricName metricName = metrics.metricName("byte-rate", QuotaType.LeaderReplication$.MODULE$.toString(), new StringBuilder().append((Object)"Tracking byte-rate for ").append((Object)QuotaType.LeaderReplication$.MODULE$).toString());
        double leaderThrottledRate = BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).apply((Object)metricName)).metricValue());
        return (double)var3_3;
    }

    @Test
    public void shouldSupportWildcardThrottledReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.markThrottled("MyTopic");
        Assert.assertTrue((boolean)quota.isThrottled(new TopicPartition("MyTopic", 0)));
        Assert.assertFalse((boolean)quota.isThrottled(new TopicPartition("MyOtherTopic", 0)));
    }

    private TopicPartition tp1(int id) {
        return new TopicPartition("topic1", id);
    }

    private Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }
}

