/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.EpochDrivenReplicationProtocolAcceptanceTest$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u0001%\u0011A&\u00129pG\"$%/\u001b<f]J+\u0007\u000f\\5dCRLwN\u001c)s_R|7m\u001c7BG\u000e,\u0007\u000f^1oG\u0016$Vm\u001d;\u000b\u0005\r!\u0011!B3q_\u000eD'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u000bCBLg+\u001a:tS>tW#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u00052\u0011aA1qS&\u00111\u0005\t\u0002\u000b\u0003BLg+\u001a:tS>t\u0007BB\u0013\u0001A\u0003%a$A\u0006ba&4VM]:j_:\u0004\u0003bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001\u0006i>\u0004\u0018nY\u000b\u0002SA\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0005Y\u0006twMC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#AB*ue&tw\r\u0003\u00043\u0001\u0001\u0006I!K\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005\u0019Qn]4\u0016\u0003Y\u00022a\u000e\u001e=\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$!B!se\u0006L\bCA\u001c>\u0013\tq\u0004H\u0001\u0003CsR,\u0007B\u0002!\u0001A\u0003%a'\u0001\u0003ng\u001e\u0004\u0003b\u0002\"\u0001\u0005\u0004%\t!N\u0001\n[N<')[4hKJDa\u0001\u0012\u0001!\u0002\u00131\u0014AC7tO\nKwmZ3sA!9a\t\u0001a\u0001\n\u00039\u0015a\u00022s_.,'o]\u000b\u0002\u0011B\u0019\u0011\n\u0014(\u000e\u0003)S!a\u0013\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002N\u0015\n\u00191+Z9\u0011\u0005=\u0003V\"\u0001\u0003\n\u0005E#!aC&bM.\f7+\u001a:wKJDqa\u0015\u0001A\u0002\u0013\u0005A+A\u0006ce>\\WM]:`I\u0015\fHCA+Y!\t9d+\u0003\u0002Xq\t!QK\\5u\u0011\u001dI&+!AA\u0002!\u000b1\u0001\u001f\u00132\u0011\u0019Y\u0006\u0001)Q\u0005\u0011\u0006A!M]8lKJ\u001c\b\u0005C\u0004^\u0001\u0001\u0007I\u0011\u00010\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012a\u0018\t\u0005A&4d'D\u0001b\u0015\ti&M\u0003\u0002dI\u000691\r\\5f]R\u001c(BA\u0004f\u0015\t1w-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0006\u0019qN]4\n\u0005)\f'!D&bM.\f\u0007K]8ek\u000e,'\u000fC\u0004m\u0001\u0001\u0007I\u0011A7\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005Us\u0007bB-l\u0003\u0003\u0005\ra\u0018\u0005\u0007a\u0002\u0001\u000b\u0015B0\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0003b\u0002:\u0001\u0001\u0004%\ta]\u0001\tG>t7/^7feV\tA\u000f\u0005\u0003voZ2T\"\u0001<\u000b\u0005I\u0014\u0017B\u0001=w\u00055Y\u0015MZ6b\u0007>t7/^7fe\"9!\u0010\u0001a\u0001\n\u0003Y\u0018\u0001D2p]N,X.\u001a:`I\u0015\fHCA+}\u0011\u001dI\u00160!AA\u0002QDaA \u0001!B\u0013!\u0018!C2p]N,X.\u001a:!\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007\tQa]3u+B$\u0012!\u0016\u0015\u0004\u007f\u0006\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055q-A\u0003kk:LG/\u0003\u0003\u0002\u0012\u0005-!A\u0002\"fM>\u0014X\rC\u0004\u0002\u0016\u0001!\t%a\u0001\u0002\u0011Q,\u0017M\u001d#po:DC!a\u0005\u0002\u001aA!\u0011\u0011BA\u000e\u0013\u0011\ti\"a\u0003\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002\u0004\u0005!3\u000f[8vY\u00124u\u000e\u001c7po2+\u0017\rZ3s\u000bB|7\r\u001b\"bg&\u001cwk\u001c:lM2|w\u000f\u000b\u0003\u0002 \u0005\u0015\u0002\u0003BA\u0005\u0003OIA!!\u000b\u0002\f\t!A+Z:u\u0011\u001d\ti\u0003\u0001C\u0001\u0003\u0007\t1d\u001d5pk2$gj\u001c;BY2|w\u000fR5wKJ<WM\u001c;M_\u001e\u001c\b\u0006BA\u0016\u0003KAq!a\r\u0001\t\u0003\t\u0019!A\u000epM\u001a\u001cX\r^:TQ>,H\u000e\u001a(pi\u001e{')Y2lo\u0006\u0014Hm\u001d\u0015\u0005\u0003c\t)\u0003C\u0004\u0002:\u0001!\t!a\u0001\u0002;MDw.\u001e7e'V\u0014h/\u001b<f\r\u0006\u001cH\u000fT3bI\u0016\u00148\t[1oO\u0016DC!a\u000e\u0002&!9\u0011q\b\u0001\u0005\u0002\u0005\r\u0011\u0001\f7pON\u001c\u0006n\\;mI:{G\u000fR5wKJ<Wm\u00148V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8tQ\u0011\ti$!\n\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H\u0005\u0019An\\4\u0015\u000bU\u000bI%!\u0014\t\u000f\u0005-\u00131\ta\u0001\u001d\u00061A.Z1eKJDq!a\u0014\u0002D\u0001\u0007a*\u0001\u0005g_2dwn^3s\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+\n!c^1ji\u001a{'\u000fT8hgR{W*\u0019;dQR9Q+a\u0016\u0002\\\u0005}\u0003bBA-\u0003#\u0002\rAT\u0001\u0003EFBq!!\u0018\u0002R\u0001\u0007a*\u0001\u0002ce!Q\u0011\u0011MA)!\u0003\u0005\r!a\u0019\u0002\u0013A\f'\u000f^5uS>t\u0007cA\u001c\u0002f%\u0019\u0011q\r\u001d\u0003\u0007%sG\u000fC\u0004\u0002l\u0001!I!a\u0001\u0002\u001bA\u0014\u0018N\u001c;TK\u001elWM\u001c;t\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\nQb\u001d;beR\u001cuN\\:v[\u0016\u0014H#\u0001;\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\u0005IB-\u001a7fi\u0016lUm]:bO\u0016\u001chI]8n\u0019><g)\u001b7f)\u001d)\u0016\u0011PAB\u0003\u000fC\u0001\"a\u001f\u0002t\u0001\u0007\u0011QP\u0001\u0006Ef$Xm\u001d\t\u0004o\u0005}\u0014bAAAq\t!Aj\u001c8h\u0011\u001d\t))a\u001dA\u00029\u000baA\u0019:pW\u0016\u0014\b\u0002CAE\u0003g\u0002\r!a\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0003\u001b\u0003A\u0011\u00020\u0002/\r\u0014X-\u0019;f\u0005V4g-\u001a:j]\u001e\u0004&o\u001c3vG\u0016\u0014\bbBAI\u0001\u0011%\u00111S\u0001\u000bO\u0016$Hj\\4GS2,GCBAK\u0003C\u000b\u0019\u000b\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tY*L\u0001\u0003S>LA!a(\u0002\u001a\n!a)\u001b7f\u0011\u001d\t))a$A\u00029C\u0001\"!\u0019\u0002\u0010\u0002\u0007\u00111\r\u0005\b\u0003O\u0003A\u0011BAU\u0003\u00199W\r\u001e'pOR1\u00111VA[\u0003o\u0003B!!,\u000226\u0011\u0011q\u0016\u0006\u0004\u0003\u000b2\u0011\u0002BAZ\u0003_\u00131\u0001T8h\u0011\u001d\t))!*A\u00029C\u0001\"!\u0019\u0002&\u0002\u0007\u00111\r\u0005\b\u0003w\u0003A\u0011BA_\u0003\u0019\u0011w.\u001e8dKR\u0019Q+a0\t\u000f\u0005=\u0013\u0011\u0018a\u0001\u001d\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0017AC3q_\u000eD7)Y2iKR!\u0011qYAg!\rQ\u0012\u0011Z\u0005\u0004\u0003\u0017\u0014!\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\rC\u0004\u0002\u0006\u0006\u0005\u0007\u0019\u0001(\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\u0006aA.\u0019;fgR\u0014VmY8sIRA\u0011Q[As\u0003O\fY\u000f\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\rI,7m\u001c:e\u0015\r\ty\u000eZ\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0018\u0011\u001c\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0004\u0002L\u0005=\u0007\u0019\u0001(\t\u0015\u0005%\u0018q\u001aI\u0001\u0002\u0004\t\u0019'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u000b\u0003C\ny\r%AA\u0002\u0005\r\u0004bBAx\u0001\u0011%\u0011\u0011_\u0001\tC^\f\u0017\u000e^%T%R\u0019Q+a=\t\u0011\u0005U\u0018Q\u001ea\u0001\u0003o\f!\u0001\u001e9\u0011\t\u0005e\u00181`\u0007\u0003\u0003;LA!!@\u0002^\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u0002B\u0001\u0001\u0011%a,\u0001\bde\u0016\fG/\u001a)s_\u0012,8-\u001a:\t\u000f\u0005-\u0003\u0001\"\u0003\u0003\u0006Q\ta\nC\u0004\u0002P\u0001!IA!\u0002\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005a1M]3bi\u0016\u0014%o\\6feR)aJa\u0004\u0003\u0014!A!\u0011\u0003B\u0005\u0001\u0004\t\u0019'\u0001\u0002jI\"Q!Q\u0003B\u0005!\u0003\u0005\rAa\u0006\u00027\u0015t\u0017M\u00197f+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o!\r9$\u0011D\u0005\u0004\u00057A$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005?\u0001\u0011\u0013!C\u0005\u0005C\tac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005GQCAa\u0006\u0003&-\u0012!q\u0005\t\u0005\u0005S\u0011\u0019$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003%)hn\u00195fG.,GMC\u0002\u00032a\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Da\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003:\u0001\t\n\u0011\"\u0003\u0003<\u00051B.\u0019;fgR\u0014VmY8sI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003>)\"\u00111\rB\u0013\u0011%\u0011\t\u0005AI\u0001\n\u0013\u0011Y$\u0001\fmCR,7\u000f\u001e*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011)\u0005AI\u0001\n\u0013\u0011Y$\u0001\u000fxC&$hi\u001c:M_\u001e\u001cHk\\'bi\u000eDG\u0005Z3gCVdG\u000fJ\u001a")
public class EpochDrivenReplicationProtocolAcceptanceTest
extends ZooKeeperTestHarness {
    private final ApiVersion apiVersion = ApiVersion$.MODULE$.latestVersion();
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private KafkaConsumer<byte[], byte[]> consumer = null;

    public ApiVersion apiVersion() {
        return this.apiVersion;
    }

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldFollowLeaderEpochBasicWorkflow() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final KafkaServer apply(int x$1) {
                return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker(x$1, this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((long)0L, (long)this.latestRecord(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)0L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower()).epochEntries());
        this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$bounce(this.follower());
        this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$awaitISR(tp);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower()).epochEntries());
        Assert.assertEquals((long)1L, (long)this.latestRecord(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)1L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$bounce(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader());
        this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$awaitISR(tp);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((long)2L, (long)this.latestRecord(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((long)2L, (long)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower()).epochEntries());
    }

    @Test
    public void shouldNotAllowDivergentLogs() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final KafkaServer apply(int id) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.brokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer b) {
                b.shutdown();
            }
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(5 * this.msg().length, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msgBigger()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        Assert.assertEquals((String)"Log files should match Broker0 vs Broker 1", (long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length());
    }

    @Test
    public void offsetsShouldNotGoBackwards() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final KafkaServer apply(int x$3) {
                return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker(x$3, this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.brokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer b) {
                b.shutdown();
            }
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), Log$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length() / 2L, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final Future<RecordMetadata> apply(int x$4) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.producer().flush();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final Future<RecordMetadata> apply(int x$5) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.producer().flush();
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        this.startConsumer();
        Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.consumer(), 100, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        LongRef prevOffset = LongRef.create((long)-1L);
        records2.foreach((Function1)new Serializable(this, prevOffset){
            public static final long serialVersionUID = 0L;
            private final LongRef prevOffset$1;

            public final void apply(ConsumerRecord<byte[], byte[]> r) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset ", " came before ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.prevOffset$1.elem), BoxesRunTime.boxToLong((long)r.offset())})), (r.offset() > this.prevOffset$1.elem ? 1 : 0) != 0);
                this.prevOffset$1.elem = r.offset();
            }
            {
                this.prevOffset$1 = prevOffset$1;
            }
        });
        Assert.assertEquals((String)"Log files should match Broker0 vs Broker 1", (long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length());
    }

    @Test
    public void shouldSurviveFastLeaderChange() {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final KafkaServer apply(int x$6) {
                return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker(x$6, this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        IntRef messagesWritten = IntRef.create((int)1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, tp, messagesWritten){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;
            private final TopicPartition tp$2;
            public final IntRef messagesWritten$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int leaderId = BoxesRunTime.unboxToInt((Object)this.$outer.zkClient().getLeaderForPartition(new TopicPartition(this.$outer.topic(), 0)).get());
                KafkaServer leader2 = (KafkaServer)((SeqLike)this.$outer.brokers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$1;

                    public final boolean apply(KafkaServer x$7) {
                        return x$7.config().brokerId() == this.leaderId$1;
                    }
                    {
                        this.leaderId$1 = leaderId$1;
                    }
                })).apply(0);
                KafkaServer follower2 = (KafkaServer)((SeqLike)this.$outer.brokers().filter((Function1)new Serializable(this, leaderId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderId$1;

                    public final boolean apply(KafkaServer x$8) {
                        return x$8.config().brokerId() != this.leaderId$1;
                    }
                    {
                        this.leaderId$1 = leaderId$1;
                    }
                })).apply(0);
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg())).get();
                ++this.messagesWritten$1.elem;
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$bounce(follower2);
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$log(leader2, follower2);
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$awaitISR(this.tp$2);
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$bounce(leader2);
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$log(leader2, follower2);
                this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$awaitISR(this.tp$2);
                Assert.assertTrue((boolean)this.$outer.brokers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$shouldSurviveFastLeaderChange$1 $outer;

                    public final boolean apply(KafkaServer broker) {
                        return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$anonfun$$$outer().kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(broker, 0).logEndOffset() == (long)this.$outer.messagesWritten$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.messagesWritten$1 = messagesWritten$1;
            }
        });
    }

    @Test
    public void logsShouldNotDivergeOnUncleanLeaderElections() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final KafkaServer apply(int x$9) {
                return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker(x$9, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers(), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.MinInSyncReplicasProp(), (Object)"1")})));
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msgBigger()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msgBigger()));
                this.$outer.producer().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        Seq seq = this.crcSeq$1((KafkaServer)this.brokers().apply(0), this.crcSeq$default$2$1());
        Seq seq2 = this.crcSeq$1((KafkaServer)this.brokers().apply(1), this.crcSeq$default$2$1());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logs on Broker 100 and Broker 101 should match"})).s((Seq)Nil$.MODULE$), (!(seq != null ? !seq.equals(seq2) : seq2 != null) ? 1 : 0) != 0);
    }

    public void kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$log(KafkaServer leader2, KafkaServer follower2) {
        this.info((Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer follower$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bounce complete for follower ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$1.config().brokerId())}));
            }
            {
                this.follower$1 = follower$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;
            private final KafkaServer leader$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader: leo", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1.config().brokerId())}))).append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(this.leader$1, 0).logEndOffset())).append((Object)" cache: ").append((Object)this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.leader$1).epochEntries()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leader$1 = leader$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;
            private final KafkaServer follower$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower: leo", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.follower$1.config().brokerId())}))).append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(this.follower$1, 0).logEndOffset())).append((Object)" cache: ").append((Object)this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(this.follower$1).epochEntries()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.follower$1 = follower$1;
            }
        });
    }

    private void waitForLogsToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, b1, b2, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;
            private final KafkaServer b1$1;
            private final KafkaServer b2$1;
            private final int partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(this.b1$1, this.partition$1).logEndOffset() == this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(this.b2$1, this.partition$1).logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Logs didn't match.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private int waitForLogsToMatch$default$3() {
        return 0;
    }

    private void printSegments() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Broker0:";
            }
        });
        DumpLogSegments$.MODULE$.main((String[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--files", this.getLogFile((KafkaServer)this.brokers().apply(0), 0).getCanonicalPath()}))).toArray(ClassTag$.MODULE$.apply(String.class)));
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Broker1:";
            }
        });
        DumpLogSegments$.MODULE$.main((String[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--files", this.getLogFile((KafkaServer)this.brokers().apply(1), 0).getCanonicalPath()}))).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private KafkaConsumer<byte[], byte[]> startConsumer() {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        consumerConfig.put("fetch.max.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        consumerConfig.put("max.partition.fetch.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        this.consumer_$eq((KafkaConsumer<byte[], byte[]>)new KafkaConsumer(consumerConfig, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0)}))).asJava());
        this.consumer().seek(new TopicPartition(this.topic(), 0), 0L);
        return this.consumer();
    }

    private void deleteMessagesFromLogFile(long bytes, KafkaServer broker, int partitionId) {
        File logFile = this.getLogFile(broker, partitionId);
        RandomAccessFile writable = new RandomAccessFile(logFile, "rwd");
        writable.setLength(logFile.length() - bytes);
        writable.close();
    }

    private KafkaProducer<byte[], byte[]> createBufferingProducer() {
        String x$20 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$21 = -1;
        int x$22 = 10000;
        int x$23 = this.msg().length * 1000;
        String x$24 = "snappy";
        long x$25 = TestUtils$.MODULE$.createProducer$default$3();
        long x$26 = TestUtils$.MODULE$.createProducer$default$4();
        int x$27 = TestUtils$.MODULE$.createProducer$default$5();
        int x$28 = TestUtils$.MODULE$.createProducer$default$6();
        int x$29 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$30 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$31 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$32 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$33 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$34 = TestUtils$.MODULE$.createProducer$default$15();
        return TestUtils$.MODULE$.createProducer(x$20, x$21, x$25, x$26, x$27, x$28, x$22, x$23, x$24, x$29, x$30, x$31, x$32, x$33, x$34);
    }

    private File getLogFile(KafkaServer broker, int partition) {
        Log log2 = this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(broker, partition);
        log2.flush();
        return ((File[])Predef$.MODULE$.refArrayOps((Object[])log2.dir().listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$11) {
                return x$11.getName().endsWith(".log");
            }
        }))[0];
    }

    public Log kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(KafkaServer broker, int partition) {
        LogManager qual$2 = broker.logManager();
        TopicPartition x$35 = new TopicPartition(this.topic(), partition);
        boolean x$36 = qual$2.getLog$default$2();
        return (Log)qual$2.getLog(x$35, x$36).orNull(Predef$.MODULE$.$conforms());
    }

    public void kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$bounce(KafkaServer follower2) {
        follower2.shutdown();
        follower2.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    public LeaderEpochFileCache kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(broker, 0).leaderEpochCache().get();
    }

    private RecordBatch latestRecord(KafkaServer leader2, int offset, int partition) {
        LogSegment qual$3 = this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(leader2, partition).activeSegment();
        long x$37 = 0L;
        None$ x$38 = None$.MODULE$;
        int x$39 = Integer.MAX_VALUE;
        long x$40 = qual$3.read$default$4();
        boolean x$41 = qual$3.read$default$5();
        return (RecordBatch)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(qual$3.read(x$37, (Option)x$38, x$39, x$40, x$41).records().batches()).asScala()).toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    public void kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$awaitISR(TopicPartition tp) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EpochDrivenReplicationProtocolAcceptanceTest $outer;
            private final TopicPartition tp$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((TraversableOnce)((Partition)this.$outer.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader().replicaManager().getPartition(this.tp$1).get()).inSyncReplicas().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Replica x$12) {
                        return x$12.brokerId();
                    }
                }, Set$.MODULE$.canBuildFrom())).size() == 2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for replicas to join ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15());
    }

    public KafkaServer kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$leader() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer x$13) {
                return x$13.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).apply(0);
    }

    private KafkaServer follower() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leader2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$2;

            public final boolean apply(KafkaServer x$14) {
                return x$14.config().brokerId() != this.leader$2;
            }
            {
                this.leader$2 = leader$2;
            }
        })).apply(0);
    }

    public KafkaServer kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), this.apiVersion().version());
        config.setProperty(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), this.apiVersion().version());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableUncleanLeaderElection)).toString());
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    public boolean kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$createBroker$default$2() {
        return false;
    }

    private final Seq crcSeq$1(KafkaServer broker, int partition) {
        LogSegment qual$1 = this.kafka$server$epoch$EpochDrivenReplicationProtocolAcceptanceTest$$getLog(broker, partition).activeSegment();
        long x$15 = 0L;
        None$ x$16 = None$.MODULE$;
        int x$17 = Integer.MAX_VALUE;
        long x$18 = qual$1.read$default$4();
        boolean x$19 = qual$1.read$default$5();
        Seq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(qual$1.read(x$15, (Option)x$16, x$17, x$18, x$19).records().batches()).asScala()).toSeq();
        return (Seq)batches.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RecordBatch x$10) {
                return x$10.checksum();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final int crcSeq$default$2$1() {
        return 0;
    }

    public EpochDrivenReplicationProtocolAcceptanceTest() {
        this.topic = "topic1";
    }
}

