/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.epoch.LeaderEpochIntegrationTest$$anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$;
import kafka.server.epoch.LeaderEpochIntegrationTest$$anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1$;
import kafka.server.epoch.LeaderEpochIntegrationTest$$anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1$$anonfun$apply$1$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001%\u0011!\u0004T3bI\u0016\u0014X\t]8dQ&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000b\u0015\u0004xn\u00195\u000b\u0005\u00151\u0011AB:feZ,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\tia!\u0001\u0002{W&\u0011q\u0002\u0004\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001eDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000fq\u0001\u0001\u0019!C\u0001;\u00059!M]8lKJ\u001cX#\u0001\u0010\u0011\u0007}1\u0003&D\u0001!\u0015\t\t#%A\u0004nkR\f'\r\\3\u000b\u0005\r\"\u0013AC2pY2,7\r^5p]*\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(A\tQA*[:u\u0005V4g-\u001a:\u0011\u0005%RS\"\u0001\u0003\n\u0005-\"!aC&bM.\f7+\u001a:wKJDq!\f\u0001A\u0002\u0013\u0005a&A\u0006ce>\\WM]:`I\u0015\fHCA\u00184!\t\u0001\u0014'D\u0001%\u0013\t\u0011DE\u0001\u0003V]&$\bb\u0002\u001b-\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004B\u0002\u001c\u0001A\u0003&a$\u0001\u0005ce>\\WM]:!\u0011\u001dA\u0004A1A\u0005\u0002e\na\u0001^8qS\u000e\fT#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t11\u000b\u001e:j]\u001eDaa\u0011\u0001!\u0002\u0013Q\u0014a\u0002;pa&\u001c\u0017\u0007\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001:\u0003\u0019!x\u000e]5de!1q\t\u0001Q\u0001\ni\nq\u0001^8qS\u000e\u0014\u0004\u0005C\u0004J\u0001\t\u0007I\u0011\u0001&\u0002\tQ\f\u0004\u000fM\u000b\u0002\u0017B\u0011A\nV\u0007\u0002\u001b*\u0011ajT\u0001\u0007G>lWn\u001c8\u000b\u0005\u001d\u0001&BA)S\u0003\u0019\t\u0007/Y2iK*\t1+A\u0002pe\u001eL!!V'\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1q\u000b\u0001Q\u0001\n-\u000bQ\u0001^\u0019qa\u0001Bq!\u0017\u0001C\u0002\u0013\u0005!*\u0001\u0003ucA\f\u0004BB.\u0001A\u0003%1*A\u0003ucA\f\u0004\u0005C\u0004^\u0001\t\u0007I\u0011\u0001&\u0002\tQ\f\u0004O\r\u0005\u0007?\u0002\u0001\u000b\u0011B&\u0002\u000bQ\f\u0004O\r\u0011\t\u000f\u0005\u0004!\u0019!C\u0001\u0015\u0006!AO\r91\u0011\u0019\u0019\u0007\u0001)A\u0005\u0017\u0006)AO\r91A!9Q\r\u0001b\u0001\n\u0003Q\u0015\u0001\u0002;3aJBaa\u001a\u0001!\u0002\u0013Y\u0015!\u0002;3aJ\u0002\u0003bB5\u0001\u0005\u0004%\tAS\u0001\u0003iBDaa\u001b\u0001!\u0002\u0013Y\u0015a\u0001;qA!9Q\u000e\u0001a\u0001\n\u0003q\u0017\u0001\u00039s_\u0012,8-\u001a:\u0016\u0003=\u0004B\u0001\u001d;wm6\t\u0011O\u0003\u0002ne*\u00111oT\u0001\bG2LWM\u001c;t\u0013\t)\u0018OA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004a]L\u0018B\u0001=%\u0005\u0015\t%O]1z!\t\u0001$0\u0003\u0002|I\t!!)\u001f;f\u0011\u001di\b\u00011A\u0005\u0002y\fA\u0002\u001d:pIV\u001cWM]0%KF$\"aL@\t\u000fQb\u0018\u0011!a\u0001_\"9\u00111\u0001\u0001!B\u0013y\u0017!\u00039s_\u0012,8-\u001a:!\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002_!\"\u0011QAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n%\u0006)!.\u001e8ji&!\u0011qCA\t\u0005\u0015\te\r^3s\u0011\u001d\tY\u0002\u0001C\u0001\u0003\u0013\tQh\u001d5pk2$\u0017\t\u001a3DkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eDGk\\'fgN\fw-Z:BgRCW-_!sK^\u0013\u0018\u000e\u001e;f]R{G*Z1eKJDC!!\u0007\u0002 A!\u0011qBA\u0011\u0013\u0011\t\u0019#!\u0005\u0003\tQ+7\u000f\u001e\u0005\b\u0003O\u0001A\u0011AA\u0005\u0003-\u001a\bn\\;mIN+g\u000e\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgR\fe\u000eZ$fi\u0006\u0013Vm\u001d9p]N,\u0007\u0006BA\u0013\u0003?Aq!!\f\u0001\t\u0003\tI!\u0001\u0018tQ>,H\u000eZ%oGJ,\u0017m]3MK\u0006$WM]#q_\u000eD')\u001a;xK\u0016tG*Z1eKJ\u0014Vm\u001d;beR\u001c\b\u0006BA\u0016\u0003?Aq!a\r\u0001\t\u0003\t)$\u0001\u0017tQ>,H\u000eZ*vaB|'\u000f\u001e*fcV,7\u000f^:G_J,\u0005o\\2ig:{Go\u00148UQ\u0016dU-\u00193feR\u0019q&a\u000e\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\tqAZ3uG\",'\u000f\u0005\u0003\u0002>\u0005}R\"\u0001\u0001\u0007\u000f\u0005\u0005\u0003\u0001\u0001\u0002\u0002D\t\tB+Z:u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0014\u000b\u0005}\u0012Q\t\t\u0011\u0007A\n9%C\u0002\u0002J\u0011\u0012a!\u00118z%\u00164\u0007bCA'\u0003\u007f\u0011\t\u0011)A\u0005\u0003\u001f\naa]3oI\u0016\u0014\bcA\u0015\u0002R%\u0019\u00111\u000b\u0003\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\t\u000f]\ty\u0004\"\u0001\u0002XQ!\u00111HA-\u0011!\ti%!\u0016A\u0002\u0005=\u0003\u0002CA/\u0003\u007f!\t!a\u0018\u0002!1,\u0017\rZ3s\u001f\u001a47/\u001a;t\r>\u0014H\u0003BA1\u0003k\u0002r!a\u0019\u0002f-\u000bI'D\u0001#\u0013\r\t9G\t\u0002\u0004\u001b\u0006\u0004\b\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=T*\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019(!\u001c\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"A\u0011qOA.\u0001\u0004\tI(\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004r!a\u0019\u0002f-\u000bY\bE\u00021\u0003{J1!a %\u0005\rIe\u000e\u001e\u0005\b\u0003\u001b\u0002A\u0011BAB)\u0019\ty%!\"\u0002\n\"9\u0011qQAA\u0001\u0004A\u0013\u0001\u00024s_6Dq!a#\u0002\u0002\u0002\u0007\u0001&\u0001\u0002u_\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0015\u0001F<bSR4uN]#q_\u000eD7\t[1oO\u0016$v\u000eF\u00040\u0003'\u000b\u0019+a*\t\u0011\u0005U\u0015Q\u0012a\u0001\u0003/\u000bQ\u0001^8qS\u000e\u0004B!!'\u0002 :\u0019\u0001'a'\n\u0007\u0005uE%\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0003\u0006\u0005&bAAOI!A\u0011QUAG\u0001\u0004\tY(A\u0005qCJ$\u0018\u000e^5p]\"91!!$A\u0002\u0005m\u0004bBAV\u0001\u0011%\u0011QV\u0001\u0018[\u0016\u001c8/Y4fg\"\u000bg/\u001a'fC\u0012,'/\u00129pG\"$\u0002\"a,\u00026\u0006e\u0016Q\u0018\t\u0004a\u0005E\u0016bAAZI\t9!i\\8mK\u0006t\u0007bBA\\\u0003S\u0003\r\u0001K\u0001\u0007EJ|7.\u001a:\t\u0011\u0005m\u0016\u0011\u0016a\u0001\u0003w\n1#\u001a=qK\u000e$X\r\u001a'fC\u0012,'/\u00129pG\"D\u0001\"a0\u0002*\u0002\u0007\u00111P\u0001\n[&twJ\u001a4tKRDq!a1\u0001\t\u0013\tI!A\u000etK:$gi\\;s\u001b\u0016\u001c8/Y4fgR{W)Y2i)>\u0004\u0018n\u0019")
public class LeaderEpochIntegrationTest
extends ZooKeeperTestHarness {
    private ListBuffer<KafkaServer> brokers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic1;
    private final String topic2;
    private final TopicPartition t1p0 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition t1p1 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition t1p2 = new TopicPartition(this.topic1(), 2);
    private final TopicPartition t2p0 = new TopicPartition(this.topic2(), 0);
    private final TopicPartition t2p2 = new TopicPartition(this.topic2(), 2);
    private final TopicPartition tp = this.t1p0();
    private KafkaProducer<byte[], byte[]> producer = null;

    public ListBuffer<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(ListBuffer<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public TopicPartition t1p0() {
        return this.t1p0;
    }

    public TopicPartition t1p1() {
        return this.t1p1;
    }

    public TopicPartition t1p2() {
        return this.t1p2;
    }

    public TopicPartition t2p0() {
        return this.t2p0;
    }

    public TopicPartition t2p2() {
        return this.t2p2;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @After
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader() {
        this.brokers().$plus$plus$eq((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final KafkaServer apply(int id) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final scala.collection.immutable.Map<Object, Object> apply(String topic) {
                return TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.$outer.brokers());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendFourMessagesToEachTopic();
        IntRef expectedLeaderEpoch = IntRef.create((int)0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expectedLeaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;
            private final IntRef expectedLeaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch((KafkaServer)this.$outer.brokers().apply(0), this.expectedLeaderEpoch$1.elem, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedLeaderEpoch$1 = expectedLeaderEpoch$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader epoch should be 0";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        expectedLeaderEpoch.elem = 1;
        this.waitForEpochChangeTo(this.topic1(), 0, expectedLeaderEpoch.elem);
        this.waitForEpochChangeTo(this.topic2(), 0, expectedLeaderEpoch.elem);
        this.sendFourMessagesToEachTopic();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expectedLeaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;
            private final IntRef expectedLeaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch((KafkaServer)this.$outer.brokers().apply(0), this.expectedLeaderEpoch$1.elem, 4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedLeaderEpoch$1 = expectedLeaderEpoch$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leader epoch should be 1";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void shouldSendLeaderEpochRequestAndGetAResponse() {
        this.brokers().$plus$plus$eq((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 102).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final KafkaServer apply(int id) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        Map assignment1 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), (Map<Object, Seq<Object>>)assignment1, (Seq<KafkaServer>)this.brokers());
        Map assignment2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic2(), (Map<Object, Seq<Object>>)assignment2, (Seq<KafkaServer>)this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final Future<RecordMetadata> apply(int x$1) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"IHeartLogs".getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final Future<RecordMetadata> apply(int x$2) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic1(), Predef$.MODULE$.int2Integer(1), null, (Object)"OhAreThey".getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final Future<RecordMetadata> apply(int x$3) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic2(), Predef$.MODULE$.int2Integer(0), null, (Object)"IReallyDo".getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.producer().flush();
        TestFetcherThread fetcher0 = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(2), (KafkaServer)this.brokers().apply(0)));
        Map epochsRequested = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p0()), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p2()), (Object)BoxesRunTime.boxToInteger((int)0))}));
        Map<TopicPartition, EpochEndOffset> offsetsForEpochs = fetcher0.leaderOffsetsFor((Map<TopicPartition, Object>)epochsRequested);
        Assert.assertEquals((long)10L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p0())).endOffset());
        Assert.assertEquals((long)30L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t2p0())).endOffset());
        Assert.assertTrue((boolean)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).hasError());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).error());
        Assert.assertEquals((long)-1L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).endOffset());
        TestFetcherThread fetcher1 = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(2), (KafkaServer)this.brokers().apply(1)));
        Map<TopicPartition, EpochEndOffset> offsetsForEpochs1 = fetcher1.leaderOffsetsFor((Map<TopicPartition, Object>)epochsRequested);
        Assert.assertEquals((long)20L, (long)((EpochEndOffset)offsetsForEpochs1.apply((Object)this.t1p1())).endOffset());
    }

    @Test
    public void shouldIncreaseLeaderEpochBetweenLeaderRestarts() {
        this.brokers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2()));
        Assert.assertEquals((long)100L, (long)TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2()));
        this.brokers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), TestUtils$.MODULE$.createServer$default$2()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.tp().topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.tp().partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})))}))), (Seq<KafkaServer>)this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        TestFetcherThread fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        EpochEndOffset epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)0))})))).apply((Object)this.tp());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)1L, (long)this.leo$1());
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)0))})))).apply((Object)this.tp());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)1))})))).apply((Object)this.tp());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)2))})))).apply((Object)this.tp());
        Assert.assertEquals((long)2L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)2L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)2L, (long)this.leo$1());
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        Assert.assertEquals((long)1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)0))})))).apply((Object)this.tp())).endOffset());
        Assert.assertEquals((long)2L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)2))})))).apply((Object)this.tp())).endOffset());
        Assert.assertEquals((long)3L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)4))})))).apply((Object)this.tp())).endOffset());
        Assert.assertEquals((long)this.leo$1(), (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToInteger((int)4))})))).apply((Object)this.tp())).endOffset());
        this.shouldSupportRequestsForEpochsNotOnTheLeader(fetcher);
    }

    public void shouldSupportRequestsForEpochsNotOnTheLeader(TestFetcherThread fetcher) {
        Map epoch1 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Assert.assertEquals((long)1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch1).apply((Object)this.t1p0())).endOffset());
        Map epoch3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)3))}));
        Assert.assertEquals((long)2L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch3).apply((Object)this.t1p0())).endOffset());
        Map epoch5 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)5))}));
        Assert.assertEquals((long)-1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch5).apply((Object)this.t1p0())).endOffset());
    }

    private BlockingSend sender(KafkaServer from, KafkaServer to) {
        BrokerEndPoint endPoint = ((Broker)from.metadataCache().getAliveBrokers().find((Function1)new Serializable(this, to){
            public static final long serialVersionUID = 0L;
            private final KafkaServer to$1;

            public final boolean apply(Broker x$4) {
                return x$4.id() == this.to$1.config().brokerId();
            }
            {
                this.to$1 = to$1;
            }
        }).get()).brokerEndPoint(from.config().interBrokerListenerName());
        return new ReplicaFetcherBlockingSend(endPoint, from.config(), new Metrics(), (Time)new SystemTime(), 42, "TestFetcher", new LogContext());
    }

    private void waitForEpochChangeTo(String topic, int partition, int epoch) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;
            private final String topic$1;
            private final int partition$1;
            private final int epoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            option = ((KafkaServer)this.$outer.brokers().apply(0)).metadataCache().getPartitionInfo(this.topic$1, this.partition$1);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            UpdateMetadataRequest.PartitionState m = (UpdateMetadataRequest.PartitionState)some.x();
                            bl = m.basePartitionState.leaderEpoch == this.epoch$1;
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
                this.epoch$1 = epoch$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Epoch didn't change";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public boolean kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch(KafkaServer broker, int expectedLeaderEpoch, int minOffset) {
        BooleanRef result = BooleanRef.create((boolean)true);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})).foreach((Function1)new Serializable(this, broker, expectedLeaderEpoch, minOffset, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;
            private final KafkaServer broker$1;
            public final int expectedLeaderEpoch$2;
            public final int minOffset$1;
            private final BooleanRef result$1;

            public final void apply(String topic) {
                TopicPartition tp = new TopicPartition(topic, 0);
                LogManager qual$1 = this.broker$1.getLogManager();
                TopicPartition x$23 = tp;
                boolean x$24 = qual$1.getLog$default$2();
                long leo = ((Log)qual$1.getLog(x$23, x$24).get()).logEndOffset();
                this.result$1.elem = this.result$1.elem && leo > 0L && this.$outer.brokers().forall((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1 $outer;
                    private final TopicPartition tp$1;

                    public final boolean apply(KafkaServer broker) {
                        LogManager qual$2 = broker.getLogManager();
                        TopicPartition x$25 = this.tp$1;
                        boolean x$26 = qual$2.getLog$default$2();
                        return ((Log)qual$2.getLog(x$25, x$26).get()).logSegments().iterator().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1$$anonfun$apply$1 $outer;

                            public final boolean apply(LogSegment segment) {
                                return segment.read((long)this.$outer.kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$$outer().minOffset$1, (Option)None$.MODULE$, Integer.MAX_VALUE, segment.read$default$4(), segment.read$default$5()) == null ? false : ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(segment.read((long)this.$outer.kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$$outer().minOffset$1, (Option)None$.MODULE$, Integer.MAX_VALUE, segment.read$default$4(), segment.read$default$5()).records().batches().iterator()).asScala()).forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1$$anonfun$apply$1$$anonfun$apply$2 $outer;

                                    public final boolean apply(RecordBatch x$5) {
                                        return this.$outer.kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$anonfun$$$outer().kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$$outer().expectedLeaderEpoch$2 == x$5.partitionLeaderEpoch();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1$$anonfun$apply$1 kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$kafka$server$epoch$LeaderEpochIntegrationTest$$messagesHaveLeaderEpoch$1 kafka$server$epoch$LeaderEpochIntegrationTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tp$1 = tp$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker$1 = broker$1;
                this.expectedLeaderEpoch$2 = expectedLeaderEpoch$2;
                this.minOffset$1 = minOffset$1;
                this.result$1 = result$1;
            }
        });
        return result.elem;
    }

    private void sendFourMessagesToEachTopic() {
        List testMessageList1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"}));
        List testMessageList2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test5", "test6", "test7", "test8"}));
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$9 = new StringSerializer();
        StringSerializer x$10 = new StringSerializer();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        long x$12 = TestUtils$.MODULE$.createProducer$default$3();
        long x$13 = TestUtils$.MODULE$.createProducer$default$4();
        int x$14 = TestUtils$.MODULE$.createProducer$default$5();
        int x$15 = TestUtils$.MODULE$.createProducer$default$6();
        int x$16 = TestUtils$.MODULE$.createProducer$default$7();
        int x$17 = TestUtils$.MODULE$.createProducer$default$8();
        String x$18 = TestUtils$.MODULE$.createProducer$default$9();
        int x$19 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$20 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$21 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$22 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$9, x$10);
        List records2 = (List)((List)testMessageList1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic1(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)testMessageList2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochIntegrationTest $outer;

            public final ProducerRecord<String, String> apply(String m) {
                return new ProducerRecord(this.$outer.topic2(), (Object)m, (Object)m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        ((List)records2.map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;

            public final Future<RecordMetadata> apply(ProducerRecord<String, String> x$1) {
                return this.producer$1.send(x$1);
            }
            {
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$6) {
                return x$6.get();
            }
        });
        producer.close();
    }

    private final long leo$1() {
        return ((Replica)((KafkaServer)this.brokers().apply(1)).replicaManager().localReplica(this.tp()).get()).logEndOffset();
    }

    public LeaderEpochIntegrationTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
    }

    public class TestFetcherThread
    implements Logging {
        private final BlockingSend sender;
        public final /* synthetic */ LeaderEpochIntegrationTest $outer;
        private final Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            TestFetcherThread testFetcherThread = this;
            synchronized (testFetcherThread) {
                if (!this.bitmap$0) {
                    this.logger = Logging.class.logger((Logging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public String logIdent() {
            return this.logIdent;
        }

        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public String loggerName() {
            return Logging.class.loggerName((Logging)this);
        }

        public String msgWithLogIdent(String msg) {
            return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
        }

        public void trace(Function0<String> msg) {
            Logging.class.trace((Logging)this, msg);
        }

        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.trace((Logging)this, msg, e);
        }

        public boolean isDebugEnabled() {
            return Logging.class.isDebugEnabled((Logging)this);
        }

        public boolean isTraceEnabled() {
            return Logging.class.isTraceEnabled((Logging)this);
        }

        public void debug(Function0<String> msg) {
            Logging.class.debug((Logging)this, msg);
        }

        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.debug((Logging)this, msg, e);
        }

        public void info(Function0<String> msg) {
            Logging.class.info((Logging)this, msg);
        }

        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.info((Logging)this, msg, e);
        }

        public void warn(Function0<String> msg) {
            Logging.class.warn((Logging)this, msg);
        }

        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.warn((Logging)this, msg, e);
        }

        public void error(Function0<String> msg) {
            Logging.class.error((Logging)this, msg);
        }

        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.error((Logging)this, msg, e);
        }

        public void fatal(Function0<String> msg) {
            Logging.class.fatal((Logging)this, msg);
        }

        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.class.fatal((Logging)this, msg, e);
        }

        public Map<TopicPartition, EpochEndOffset> leaderOffsetsFor(Map<TopicPartition, Object> partitions) {
            Map partitionData = partitions.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final OffsetsForLeaderEpochRequest.PartitionData apply(int x$7) {
                    return new OffsetsForLeaderEpochRequest.PartitionData(Optional.<T>empty(), x$7);
                }
            });
            OffsetsForLeaderEpochRequest.Builder request = new OffsetsForLeaderEpochRequest.Builder(ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionData).asJava());
            ClientResponse response = this.sender.sendRequest((AbstractRequest.Builder)request);
            return (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
        }

        public /* synthetic */ LeaderEpochIntegrationTest kafka$server$epoch$LeaderEpochIntegrationTest$TestFetcherThread$$$outer() {
            return this.$outer;
        }

        public TestFetcherThread(LeaderEpochIntegrationTest $outer, BlockingSend sender) {
            this.sender = sender;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.class.$init$((Logging)this);
        }
    }
}

