/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.admin.AclCommand$$anonfun$getAcls$1$;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.Write$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.io.StdIn$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Properties$;

public final class AclCommand$
implements Logging {
    public static final AclCommand$ MODULE$;
    private final ResourcePatternFilter ClusterResourceFilter;
    private final String kafka$admin$AclCommand$$Newline;
    private final Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AclCommand$();
    }

    private Logger logger$lzycompute() {
        AclCommand$ aclCommand$ = this;
        synchronized (aclCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return this.ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return this.kafka$admin$AclCommand$$Newline;
    }

    public Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations() {
        return this.ResourceTypeToValidOperations;
    }

    public void main(String[] args) {
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manage acls on kafka.");
        opts.checkArgs();
        AclCommand.AclCommandService aclCommandService = opts.options().has(opts.bootstrapServerOpt()) ? new AclCommand.AdminClientService(opts) : new AclCommand.AuthorizerService(opts);
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).addAcls();
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).removeAcls();
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).listAcls();
            }
            return;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing ACL command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getMessage()})));
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)throwable));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<Resource, Set<Acl>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        void var2_2;
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        if (patternType.isSpecific()) {
            void var3_3;
            Map resourceToAcl = (Map)this.kafka$admin$AclCommand$$getResourceFilterToAcls(opts).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Resource, Set<Acl>> apply(Tuple2<ResourcePatternFilter, Set<Acl>> x0$3) {
                    Tuple2<ResourcePatternFilter, Set<Acl>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        ResourcePatternFilter filter = (ResourcePatternFilter)tuple2._1();
                        Set acls = (Set)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource(ResourceType$.MODULE$.fromJava(filter.resourceType()), filter.name(), filter.patternType())), (Object)acls);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            if (resourceToAcl.values().exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Set<Acl> x$19) {
                    return x$19.isEmpty();
                }
            })) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
            }
            return var3_3;
        }
        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A '--resource-pattern-type' value of '", "' is not valid when adding acls."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    public Map<ResourcePatternFilter, Set<Acl>> kafka$admin$AclCommand$$getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus((GenTraversableOnce)this.getConsumerResourceFilterToAcls(opts).map((Function1)new Serializable(resourceToAcls){
                public static final long serialVersionUID = 0L;
                private final ObjectRef resourceToAcls$3;

                public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(Tuple2<ResourcePatternFilter, Set<Acl>> x0$4) {
                    Tuple2<ResourcePatternFilter, Set<Acl>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        ResourcePatternFilter k = (ResourcePatternFilter)tuple2._1();
                        Set v = (Set)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)((Map)this.resourceToAcls$3.elem).getOrElse((Object)k, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<Acl> apply() {
                                return Predef$.MODULE$.Set().empty();
                            }
                        })));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resourceToAcls$3 = resourceToAcls$3;
                }
            }, Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (Map<ResourcePatternFilter, Set<Acl>>)((Map)resourceToAcls.elem));
        return (Map)resourceToAcls.elem;
    }

    private Map<ResourcePatternFilter, Set<Acl>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ResourcePatternFilter x$20) {
                ResourceType resourceType = x$20.resourceType();
                ResourceType resourceType2 = ResourceType.TOPIC;
                return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
            }
        });
        Set transactionalIds = (Set)filters.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ResourcePatternFilter x$21) {
                ResourceType resourceType = x$21.resourceType();
                ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
                return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
            }
        });
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set<Acl> topicAcls = this.kafka$admin$AclCommand$$getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$, Create$.MODULE$}))));
        Set<Acl> transactionalIdAcls = this.kafka$admin$AclCommand$$getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1)new Serializable(topicAcls){
            public static final long serialVersionUID = 0L;
            private final Set topicAcls$1;

            public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(ResourcePatternFilter x$22) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$22), (Object)this.topicAcls$1);
            }
            {
                this.topicAcls$1 = topicAcls$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)transactionalIds.map((Function1)new Serializable(transactionalIdAcls){
            public static final long serialVersionUID = 0L;
            private final Set transactionalIdAcls$1;

            public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(ResourcePatternFilter x$23) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$23), (Object)this.transactionalIdAcls$1);
            }
            {
                this.transactionalIdAcls$1 = transactionalIdAcls$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)(enableIdempotence ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ClusterResourceFilter()), this.kafka$admin$AclCommand$$getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{IdempotentWrite$.MODULE$})))))})) : Predef$.MODULE$.Map().empty()));
    }

    private Map<ResourcePatternFilter, Set<Acl>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ResourcePatternFilter x$24) {
                ResourceType resourceType = x$24.resourceType();
                ResourceType resourceType2 = ResourceType.TOPIC;
                return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
            }
        });
        Set groups = (Set)filters.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ResourcePatternFilter x$25) {
                ResourceType resourceType = x$25.resourceType();
                ResourceType resourceType2 = ResourceType.GROUP;
                return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
            }
        });
        Set<Acl> acls = this.kafka$admin$AclCommand$$getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1)new Serializable(acls){
            public static final long serialVersionUID = 0L;
            private final Set acls$2;

            public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(ResourcePatternFilter x$26) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$26), (Object)this.acls$2);
            }
            {
                this.acls$2 = acls$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)groups.map((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$1;

            public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(ResourcePatternFilter x$27) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$27), AclCommand$.MODULE$.kafka$admin$AclCommand$$getAcl(this.opts$1, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$})))));
            }
            {
                this.opts$1 = opts$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Map<ResourcePatternFilter, Set<Acl>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<Acl> acls = this.getAcl(opts);
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        return ((TraversableOnce)filters.map((Function1)new Serializable(acls){
            public static final long serialVersionUID = 0L;
            private final Set acls$3;

            public final Tuple2<ResourcePatternFilter, Set<Acl>> apply(ResourcePatternFilter x$28) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$28), (Object)this.acls$3);
            }
            {
                this.acls$3 = acls$3;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<Acl> kafka$admin$AclCommand$$getAcl(AclCommand.AclCommandOptions opts, Set<Operation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, Allow$.MODULE$, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, Deny$.MODULE$, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts) {
        Set operations = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Operation apply(String operation) {
                return Operation$.MODULE$.fromString(operation.trim());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.kafka$admin$AclCommand$$getAcl(opts, (Set<Operation>)operations);
    }

    public Set<Acl> getAcls(Set<KafkaPrincipal> principals, PermissionType permissionType, Set<Operation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1)new Serializable(permissionType, operations, hosts){
            public static final long serialVersionUID = 0L;
            public final PermissionType permissionType$1;
            private final Set operations$1;
            public final Set hosts$1;

            public final Set<Acl> apply(KafkaPrincipal principal) {
                return (Set)this.operations$1.flatMap((Function1)new Serializable(this, principal){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getAcls.1 $outer;
                    public final KafkaPrincipal principal$2;

                    public final Set<Acl> apply(Operation operation) {
                        return (Set)this.$outer.hosts$1.map((Function1)new Serializable(this, operation){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$getAcls$1$$anonfun$apply$29 $outer;
                            private final Operation operation$1;

                            public final Acl apply(String host) {
                                return new Acl(this.$outer.principal$2, this.$outer.kafka$admin$AclCommand$$anonfun$$anonfun$$$outer().permissionType$1, host, this.operation$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.operation$1 = operation$1;
                            }
                        }, Set$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ anonfun.getAcls.1 kafka$admin$AclCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.principal$2 = principal$2;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
            {
                this.permissionType$1 = permissionType$1;
                this.operations$1 = operations$1;
                this.hosts$1 = hosts$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$29) {
                return x$29.trim();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    public Set<KafkaPrincipal> kafka$admin$AclCommand$$getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final KafkaPrincipal apply(String s) {
                return SecurityUtils.parseKafkaPrincipal((String)s.trim());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty();
    }

    public Set<ResourcePatternFilter> kafka$admin$AclCommand$$getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        ObjectRef resourceFilters = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1)new Serializable(patternType, resourceFilters){
                public static final long serialVersionUID = 0L;
                private final PatternType patternType$1;
                private final ObjectRef resourceFilters$1;

                public final void apply(String topic) {
                    this.resourceFilters$1.elem = (Set)((Set)this.resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), this.patternType$1));
                }
                {
                    this.patternType$1 = patternType$1;
                    this.resourceFilters$1 = resourceFilters$1;
                }
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)this.ClusterResourceFilter());
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1)new Serializable(patternType, resourceFilters){
                public static final long serialVersionUID = 0L;
                private final PatternType patternType$1;
                private final ObjectRef resourceFilters$1;

                public final void apply(String group) {
                    this.resourceFilters$1.elem = (Set)((Set)this.resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.GROUP, group.trim(), this.patternType$1));
                }
                {
                    this.patternType$1 = patternType$1;
                    this.resourceFilters$1 = resourceFilters$1;
                }
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1)new Serializable(patternType, resourceFilters){
                public static final long serialVersionUID = 0L;
                private final PatternType patternType$1;
                private final ObjectRef resourceFilters$1;

                public final void apply(String transactionalId) {
                    this.resourceFilters$1.elem = (Set)((Set)this.resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, this.patternType$1));
                }
                {
                    this.patternType$1 = patternType$1;
                    this.resourceFilters$1 = resourceFilters$1;
                }
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.delegationTokenOpt())).asScala()).foreach((Function1)new Serializable(patternType, resourceFilters){
                public static final long serialVersionUID = 0L;
                private final PatternType patternType$1;
                private final ObjectRef resourceFilters$1;

                public final void apply(String token) {
                    this.resourceFilters$1.elem = (Set)((Set)this.resourceFilters$1.elem).$plus((Object)new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), this.patternType$1));
                }
                {
                    this.patternType$1 = patternType$1;
                    this.resourceFilters$1 = resourceFilters$1;
                }
            });
        }
        if (((Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return StdIn$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<ResourcePatternFilter, Set<Acl>> resourceToAcls) {
        resourceToAcls.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ResourcePatternFilter, Set<Acl>> check$ifrefutable$9) {
                Tuple2<ResourcePatternFilter, Set<Acl>> tuple2 = check$ifrefutable$9;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$2;

            public final void apply(Tuple2<ResourcePatternFilter, Set<Acl>> x$31) {
                Tuple2<ResourcePatternFilter, Set<Acl>> tuple2 = x$31;
                if (tuple2 != null) {
                    ResourcePatternFilter resource = (ResourcePatternFilter)tuple2._1();
                    Set acls = (Set)tuple2._2();
                    Set validOps = (Set)AclCommand$.MODULE$.ResourceTypeToValidOperations().apply((Object)resource.resourceType());
                    if (((TraversableOnce)((Subtractable)acls.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Operation apply(Acl x$30) {
                            return x$30.operation();
                        }
                    }, Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)validOps)).nonEmpty()) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(this.opts$2.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ResourceType ", " only supports operations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource.resourceType(), validOps.mkString(",")})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.opts$2 = opts$2;
            }
        });
    }

    private AclCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.kafka$admin$AclCommand$$Newline = Properties$.MODULE$.lineSeparator();
        this.ResourceTypeToValidOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TOPIC), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.GROUP), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.CLUSTER), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TRANSACTIONAL_ID), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.DELEGATION_TOKEN), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, All$.MODULE$})))}));
    }
}

