/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t=d!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005\"\u0002.\u0001\t#Z\u0016A\u00037pO\u001e,'OT1nKV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u0011\u001d)\u0007\u00011A\u0005\n\u0019\f!B]3bI\n+hMZ3s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016a\u0003\rq\u0017n\\\u0005\u0003Y&\u0014!BQ=uK\n+hMZ3s\u0011\u001dq\u0007\u00011A\u0005\n=\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ka\"9\u0011/\\A\u0001\u0002\u00049\u0017a\u0001=%c!11\u000f\u0001Q!\n\u001d\f1B]3bI\n+hMZ3sA!9Q\u000f\u0001a\u0001\n\u00131\u0017aC<sSR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010A\bxe&$XMQ;gM\u0016\u0014x\fJ3r)\tQ\u0015\u0010C\u0004rm\u0006\u0005\t\u0019A4\t\rm\u0004\u0001\u0015)\u0003h\u000319(/\u001b;f\u0005V4g-\u001a:!\u0011\u001di\bA1A\u0005\ny\f1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00029\u0003\u0019\u0011XmY8sI&!\u0011\u0011BA\u0002\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJDq!!\u0004\u0001A\u0003%q0\u0001\u000feK\u000e|W\u000e\u001d:fgNLwN\u001c\"vM\u001a,'oU;qa2LWM\u001d\u0011\t\u0011\u0005E\u0001\u0001\"\u0001\u0003\u0003'\tQa\u00197fC:$B!!\u0006\u0002(A9\u0001\"a\u0006\u0002\u001c\u0005\u0005\u0012bAA\r\u0013\t1A+\u001e9mKJ\u00022\u0001CA\u000f\u0013\r\ty\"\u0003\u0002\u0005\u0019>tw\rE\u0002!\u0003GI1!!\n\u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011!\tI#a\u0004A\u0002\u0005-\u0012!C2mK\u0006t\u0017M\u00197f!\r\u0001\u0013QF\u0005\u0004\u0003_\u0011!A\u0003'pOR{7\t\\3b]\"A\u00111\u0007\u0001\u0005\u0002\t\t)$A\u0004e_\u000ecW-\u00198\u0015\r\u0005U\u0011qGA\u001d\u0011!\tI#!\rA\u0002\u0005-\u0002\u0002CA\u001e\u0003c\u0001\r!a\u0007\u0002\u001f\u0011,G.\u001a;f\u0011>\u0014\u0018N_8o\u001bND\u0001\"a\u0010\u0001\t\u0003\u0011\u0011\u0011I\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u0017)\u000b\u0019%a\u0013\u0002n\u0005E\u00141\u000f\u0005\b\u0007\u0005u\u0002\u0019AA#!\r\u0001\u0013qI\u0005\u0004\u0003\u0013\u0012!a\u0001'pO\"A\u0011QJA\u001f\u0001\u0004\ty%\u0001\u0005tK\u001elWM\u001c;t!\u0019\t\t&!\u0019\u0002h9!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-+\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003?J\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)GA\u0002TKFT1!a\u0018\n!\r\u0001\u0013\u0011N\u0005\u0004\u0003W\u0012!A\u0003'pON+w-\\3oi\"9\u0011qNA\u001f\u0001\u0004y\u0012aA7ba\"A\u00111HA\u001f\u0001\u0004\tY\u0002\u0003\u0005\u0002v\u0005u\u0002\u0019AA\u0011\u0003\u0015\u0019H/\u0019;t\u0011!\tI\b\u0001C\u0001\u0005\u0005m\u0014!C2mK\u0006t\u0017J\u001c;p)MQ\u0015QPAA\u0003\u0017\u000by)!%\u0002\u001c\u0006}\u0015\u0011VA^\u0011\u001d\ty(a\u001eA\u0002\u0019\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\u0004\u0006]\u0004\u0019AAC\u00035\u0019x.\u001e:dKJ+7m\u001c:egB!\u0011\u0011AAD\u0013\u0011\tI)a\u0001\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm\u001d\u0005\t\u0003\u001b\u000b9\b1\u0001\u0002h\u0005!A-Z:u\u0011\u001d\ty'a\u001eA\u0002}A\u0001\"a%\u0002x\u0001\u0007\u0011QS\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007!\t9*C\u0002\u0002\u001a&\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001e\u0006]\u0004\u0019A\f\u0002#5\f\u0007\u0010T8h\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0005\u0002\"\u0006]\u0004\u0019AAR\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r\u0001\u0013QU\u0005\u0004\u0003O\u0013!AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007\u0002CAV\u0003o\u0002\r!!,\u0002\u001f\u0005\u001cG/\u001b<f!J|G-^2feN\u0004r!a,\u00026\u0006mqCD\u0002\t\u0003cK1!a-\n\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\ri\u0015\r\u001d\u0006\u0004\u0003gK\u0001\u0002CA;\u0003o\u0002\r!!\t\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\u0006\trM]8x\u0005V4g-\u001a:t\u001fJ4\u0015-\u001b7\u0015\u0013)\u000b\u0019-!2\u0002J\u0006-\u0007\u0002CAB\u0003{\u0003\r!!\"\t\u000f\u0005\u001d\u0017Q\u0018a\u0001/\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0002\u001e\u0006u\u0006\u0019A\f\t\u0011\u00055\u0017Q\u0018a\u0001\u0003\u001f\fQ\"\\3n_JL(+Z2pe\u0012\u001c\b\u0003BA\u0001\u0003#LA!a5\u0002\u0004\tiQ*Z7pef\u0014VmY8sINDq!a6\u0001\t\u0013\tI.\u0001\ntQ>,H\u000e\u001a#jg\u000e\f'\u000f\u001a\"bi\u000eDG\u0003CAK\u00037\f)/a:\t\u0011\u0005u\u0017Q\u001ba\u0001\u0003?\fQAY1uG\"\u0004B!!\u0001\u0002b&!\u00111]A\u0002\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u0011\u0005\u0005\u0016Q\u001ba\u0001\u0003GC\u0001\"!;\u0002V\u0002\u0007\u0011QS\u0001\u0011e\u0016$\u0018-\u001b8Uq:l\u0015M]6feNDq!!<\u0001\t\u0013\ty/\u0001\ntQ>,H\u000e\u001a*fi\u0006LgNU3d_J$G\u0003DAK\u0003c\f\u00190!>\u0002x\u0006}\bbBA8\u0003W\u0004\ra\b\u0005\t\u0003'\u000bY\u000f1\u0001\u0002\u0016\"A\u0011Q\\Av\u0001\u0004\ty\u000e\u0003\u0005\u0002\u0006\u0005-\b\u0019AA}!\u0011\t\t!a?\n\t\u0005u\u00181\u0001\u0002\u0007%\u0016\u001cwN\u001d3\t\u0011\u0005U\u00141\u001ea\u0001\u0003CAqAa\u0001\u0001\t\u0003\u0011)!A\u0006he><()\u001e4gKJ\u001cHc\u0001&\u0003\b!9\u0011Q\u0014B\u0001\u0001\u00049\u0002b\u0002B\u0006\u0001\u0011\u0005!QB\u0001\u000fe\u0016\u001cHo\u001c:f\u0005V4g-\u001a:t)\u0005Q\u0005\u0002\u0003B\t\u0001\u0011\u0005!Aa\u0005\u0002'\u001d\u0014x.\u001e9TK\u001elWM\u001c;t\u0005f\u001c\u0016N_3\u0015\u0015\tU!1\u0004B\u0015\u0005[\u0011\t\u0004\u0005\u0004\u0002R\t]\u0011qJ\u0005\u0005\u00053\t)G\u0001\u0003MSN$\b\u0002CA'\u0005\u001f\u0001\rA!\b\u0011\r\t}!QEA4\u001b\t\u0011\tCC\u0002\u0003$%\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119C!\t\u0003\u0011%#XM]1cY\u0016DqAa\u000b\u0003\u0010\u0001\u0007q#A\u0004nCb\u001c\u0016N_3\t\u000f\t=\"q\u0002a\u0001/\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"A!1\u0007B\b\u0001\u0004\tY\"\u0001\fgSJ\u001cH/\u00168dY\u0016\fg.\u00192mK>3gm]3u\u0011\u001d\u00119\u0004\u0001C\u0005\u0005s\t\u0011\u0004\\1ti>3gm]3u\r>\u0014h)\u001b:tiN+w-\\3oiR1\u00111\u0004B\u001e\u0005\u0003B\u0001B!\u0010\u00036\u0001\u0007!qH\u0001\u0005g\u0016<7\u000f\u0005\u0004\u0002R\t]\u0011q\r\u0005\t\u0005g\u0011)\u00041\u0001\u0002\u001c!A!Q\t\u0001\u0005\u0002\t\u00119%\u0001\bck&dGm\u00144gg\u0016$X*\u00199\u0015\u0017)\u0013IEa\u0013\u0003P\tM#Q\u000b\u0005\b\u0007\t\r\u0003\u0019AA#\u0011!\u0011iEa\u0011A\u0002\u0005m\u0011!B:uCJ$\b\u0002\u0003B)\u0005\u0007\u0002\r!a\u0007\u0002\u0007\u0015tG\rC\u0004\u0002p\t\r\u0003\u0019A\u0010\t\u0011\u0005U$1\ta\u0001\u0003CAqA!\u0017\u0001\t\u0013\u0011Y&\u0001\rck&dGm\u00144gg\u0016$X*\u00199G_J\u001cVmZ7f]R$\u0002#!&\u0003^\t}#1\rB3\u0005S\u0012YG!\u001c\t\u000f\u0005}$q\u000ba\u0001\r\"A!\u0011\rB,\u0001\u0004\t9'A\u0004tK\u001elWM\u001c;\t\u000f\u0005=$q\u000ba\u0001?!A!q\rB,\u0001\u0004\tY\"A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBAO\u0005/\u0002\ra\u0006\u0005\t\u0003C\u00139\u00061\u0001\u0002$\"A\u0011Q\u000fB,\u0001\u0004\t\t\u0003")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            return this.doClean(cleanable, deleteHorizonMs);
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$13) {
                return x$13.lastModified();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.info((Function0<String>)new Serializable(this, deleteHorizonMs, log, cleanableHorizonMs){
            public static final long serialVersionUID = 0L;
            private final long deleteHorizonMs$1;
            private final Log log$2;
            private final long cleanableHorizonMs$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
            }
            {
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$2 = log$2;
                this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
            }
        });
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1)new Serializable(this, deleteHorizonMs, log, stats){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final long deleteHorizonMs$1;
            private final Log log$2;
            private final CleanerStats stats$2;

            public final void apply(Seq<LogSegment> group) {
                this.$outer.cleanSegments(this.log$2, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$2 = log$2;
                this.stats$2 = stats$2;
            }
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log, ((LogSegment)segments.head()).baseOffset());
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$14) {
                        return x$14.baseOffset();
                    }
                }).getOrElse((Function0)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMap map$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.map$2.latestOffset() + 1L;
                    }
                    {
                        this.map$2 = map$2;
                    }
                }));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, (Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)new Serializable(this, log, cleaned, currentSegment, startOffset, retainDeletes){
                    public static final long serialVersionUID = 0L;
                    private final Log log$4;
                    private final LogSegment cleaned$1;
                    private final LogSegment currentSegment$1;
                    private final long startOffset$1;
                    private final boolean retainDeletes$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning segment ", " in log ", " (largest timestamp ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startOffset$1), this.log$4.name(), new Date(this.currentSegment$1.largestTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"into ", ", ", " deletes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}))).toString();
                    }
                    {
                        this.log$4 = log$4;
                        this.cleaned$1 = cleaned$1;
                        this.currentSegment$1 = currentSegment$1;
                        this.startOffset$1 = startOffset$1;
                        this.retainDeletes$1 = retainDeletes$1;
                    }
                });
                this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$4;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Swapping in cleaned segment ", " for segment(s) ", " in log ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleaned$1, this.segments$1, this.log$4}));
                }
                {
                    this.log$4 = log$4;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            });
            log.replaceSegments((Seq<LogSegment>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{cleaned})), segments, log.replaceSegments$default$3());
            return;
            catch (LogSegmentOffsetOverflowException logSegmentOffsetOverflowException) {
                void var13_9;
                this.info((Function0<String>)new Serializable(this, logSegmentOffsetOverflowException){
                    public static final long serialVersionUID = 0L;
                    private final LogSegmentOffsetOverflowException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Caught segment overflow error during cleaning: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                log.splitOverflowedSegment((LogSegment)var13_9);
                throw new LogCleaningAbortedException();
            }
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception exception) {
                    logCleaningAbortedException.addSuppressed(exception);
                }
            }
            finally {
                throw logCleaningAbortedException;
            }
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).contains((Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record2) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletes$2, batch, record2, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log segment ", " at position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceRecords.file(), BoxesRunTime.boxToInteger((int)position)}));
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not determine next batch size for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logDesc})));
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid batch size ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, logDesc})));
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.kafka$log$Cleaner$$readBuffer().capacity()) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch size ", " < buffer size ", ", but not processed for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, BoxesRunTime.boxToInteger((int)this.kafka$log$Cleaner$$readBuffer().capacity()), logDesc})));
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log segment may be corrupt, batch size ", " > ", " bytes left in segment for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, BoxesRunTime.boxToLong((long)bytesLeft), logDesc})));
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record2.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record2.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record2.key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && record2.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record2.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Growing cleaner I/O buffers from ", " bytes to ", " bytes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity()), BoxesRunTime.boxToInteger((int)this.newSize$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)new Serializable(this, log, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$3 = log$3;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        });
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1)new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach((Function1)new Serializable(this, log, start, map, stats, dirty, transactionMetadata, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$3;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$3.topicPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$3.topicPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$3.config().maxMessageSize()), this.transactionMetadata$2, this.stats$3);
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.dirty$1.indexOf((Object)this.segment$1)), BoxesRunTime.boxToLong((long)this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$3 = log$3;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name()}));
            }
            {
                this.log$3 = log$3;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (true) {
                if (position >= segment.log().sizeInBytes()) {
                    this.restoreBuffers();
                    return false;
                }
                this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
                this.kafka$log$Cleaner$$readBuffer().clear();
                try {
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                }
                catch (Exception exception) {
                    throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read from segment ", " of partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{segment, topicPartition}))).append((Object)"while loading offset map").toString(), (Throwable)exception);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(this, map, startOffset, transactionMetadata, stats, maxDesiredMapSize, object){
                    public static final long serialVersionUID = 0L;
                    public final OffsetMap map$4;
                    public final long startOffset$2;
                    private final CleanedTransactionMetadata transactionMetadata$3;
                    public final CleanerStats stats$5;
                    public final int maxDesiredMapSize$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(MutableRecordBatch batch) {
                        if (batch.isControlBatch()) {
                            this.transactionMetadata$3.onControlBatchRead((RecordBatch)batch);
                            this.stats$5.indexMessagesRead(1);
                        } else {
                            boolean isAborted = this.transactionMetadata$3.onBatchRead((RecordBatch)batch);
                            if (isAborted) {
                                this.stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                            } else {
                                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1 $outer;

                                    public final void apply(Record record2) {
                                        if (record2.hasKey() && record2.offset() >= this.$outer.startOffset$2) {
                                            if (this.$outer.map$4.size() < this.$outer.maxDesiredMapSize$1) {
                                                this.$outer.map$4.put(record2.key(), record2.offset());
                                            } else {
                                                throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                                            }
                                        }
                                        this.$outer.stats$5.indexMessagesRead(1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                        }
                        if (batch.lastOffset() >= this.startOffset$2) {
                            this.map$4.updateLatestOffset(batch.lastOffset());
                        }
                    }
                    {
                        this.map$4 = map$4;
                        this.startOffset$2 = startOffset$2;
                        this.transactionMetadata$3 = transactionMetadata$3;
                        this.stats$5 = stats$5;
                        this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            bl = nonLocalReturnControl22.value$mcZ$sp();
        }
        return bl;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaner ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        });
    }
}

