/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.AdminManager$;
import kafka.server.AdminManager$$anonfun$10$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005A!p[\"mS\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\tE!\u0001\u0002{W&\u00111\t\u0011\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0011\u0015\u0003!\u0011!Q\u0001\ny\n\u0011B_6DY&,g\u000e\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\tq\u0002\u0001C\u0003\u001c\r\u0002\u0007Q\u0004C\u0003\u0018\r\u0002\u0007Q\u0005C\u00035\r\u0002\u0007a\u0007C\u0003=\r\u0002\u0007a\bC\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u001dQ|\u0007/[2QkJ<\u0017\r^8ssV\t\u0011\u000bE\u0002\u001f%RK!a\u0015\u0002\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003=UK!A\u0016\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007B\u0002-\u0001A\u0003%\u0011+A\bu_BL7\rU;sO\u0006$xN]=!\u0011\u001dQ\u0006A1A\u0005\nm\u000bQ\"\u00193nS:T6n\u00117jK:$X#\u0001/\u0011\u0005}j\u0016B\u00010A\u00055\tE-\\5o5.\u001cE.[3oi\"1\u0001\r\u0001Q\u0001\nq\u000ba\"\u00193nS:T6n\u00117jK:$\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170F\u0001e!\rIQmZ\u0005\u0003M*\u0011aa\u00149uS>t\u0007C\u00015m\u001b\u0005I'B\u00016l\u0003\u0019\u0001x\u000e\\5ds*\u00111AK\u0005\u0003[&\u0014\u0011c\u0011:fCR,Gk\u001c9jGB{G.[2z\u0011\u0019y\u0007\u0001)A\u0005I\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0011\u001d\t\bA1A\u0005\nI\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\u0005\u0019\bcA\u0005fiB\u0011\u0001.^\u0005\u0003m&\u0014\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0011\u0019A\b\u0001)A\u0005g\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0011\u0015Q\b\u0001\"\u0001|\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0003q\u0004\"!C?\n\u0005yT!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\u0011\t)!a\u0003\u0011\u0007%\t9!C\u0002\u0002\n)\u0011A!\u00168ji\"9\u0011QB@A\u0002\u0005=\u0011!\u0002;pa&\u001c\u0007\u0003BA\t\u0003/q1!CA\n\u0013\r\t)BC\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U!\u0002C\u0004\u0002 \u0001!\t!!\t\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0015\u0005\u0015\u00111EA\u0017\u0003c\ti\u0007\u0003\u0005\u0002&\u0005u\u0001\u0019AA\u0014\u0003\u001d!\u0018.\\3pkR\u00042!CA\u0015\u0013\r\tYC\u0003\u0002\u0004\u0013:$\bbBA\u0018\u0003;\u0001\r\u0001`\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\t\u0003g\ti\u00021\u0001\u00026\u0005Q1M]3bi\u0016LeNZ8\u0011\u0011\u0005]\u0012QHA\b\u0003\u0003j!!!\u000f\u000b\u0007\u0005m\"\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u0002:\t\u0019Q*\u00199\u0011\t\u0005\r\u0013q\r\b\u0005\u0003\u000b\n\tG\u0004\u0003\u0002H\u0005uc\u0002BA%\u00037rA!a\u0013\u0002Z9!\u0011QJA,\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*\r\u00051AH]8pizJ\u0011AL\u0005\u0003Y5J!!B\u0016\n\u0005%R\u0013bAA0Q\u0005A!/Z9vKN$8/\u0003\u0003\u0002d\u0005\u0015\u0014aE\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$(bAA0Q%!\u0011\u0011NA6\u00051!v\u000e]5d\t\u0016$\u0018-\u001b7t\u0015\u0011\t\u0019'!\u001a\t\u0011\u0005=\u0014Q\u0004a\u0001\u0003c\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u000f%\t\u0019(a\u001e\u0002\u0006%\u0019\u0011Q\u000f\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003CA\u001c\u0003{\ty!!\u001f\u0011\t\u0005m\u0014QP\u0007\u0003\u0003KJA!a \u0002f\tA\u0011\t]5FeJ|'\u000fC\u0004\u0002\u0004\u0002!\t!!\"\u0002\u0019\u0011,G.\u001a;f)>\u0004\u0018nY:\u0015\u0011\u0005\u0015\u0011qQAE\u0003'C\u0001\"!\n\u0002\u0002\u0002\u0007\u0011q\u0005\u0005\t\u0003\u0017\u000b\t\t1\u0001\u0002\u000e\u00061Ao\u001c9jGN\u0004b!a\u000e\u0002\u0010\u0006=\u0011\u0002BAI\u0003s\u00111aU3u\u0011!\ty'!!A\u0002\u0005U\u0005cB\u0005\u0002t\u0005]\u0015Q\u0001\t\t\u0003o\ti$a\u0004\u0002\u001aB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \"\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003G\u000biJ\u0001\u0004FeJ|'o\u001d\u0005\b\u0003O\u0003A\u0011AAU\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000f\u0006\u0007\u0002\u0006\u0005-\u0016QVAa\u0003\u0007\f\u0019\u000e\u0003\u0005\u0002&\u0005\u0015\u0006\u0019AA\u0014\u0011!\ty+!*A\u0002\u0005E\u0016!\u00048foB\u000b'\u000f^5uS>t7\u000f\u0005\u0005\u00028\u0005u\u0012qBAZ!\u0011\t),a/\u000f\t\u0005\u0015\u0013qW\u0005\u0005\u0003s\u000b)'A\fDe\u0016\fG/\u001a)beRLG/[8ogJ+\u0017/^3ti&!\u0011QXA`\u0005A\u0001\u0016M\u001d;ji&|g\u000eR3uC&d7O\u0003\u0003\u0002:\u0006\u0015\u0004bBA\u0018\u0003K\u0003\r\u0001 \u0005\t\u0003\u000b\f)\u000b1\u0001\u0002H\u0006aA.[:uK:,'OT1nKB!\u0011\u0011ZAh\u001b\t\tYMC\u0002\u0002N\"\nqA\\3uo>\u00148.\u0003\u0003\u0002R\u0006-'\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0002CAk\u0003K\u0003\r!!\u001d\u0002\u0011\r\fG\u000e\u001c2bG.Dq!!7\u0001\t\u0003\tY.A\beKN\u001c'/\u001b2f\u0007>tg-[4t)\u0019\ti.a>\u0002\u0000BA\u0011qGA\u001f\u0003?\fI\u000f\u0005\u0003\u0002b\u0006\u0015XBAAr\u0015\tY\u0002&\u0003\u0003\u0002h\u0006\r(AD\"p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0003W\f\tP\u0004\u0003\u0002|\u00055\u0018\u0002BAx\u0003K\nq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\u0005M\u0018Q\u001f\u0002\u0007\u0007>tg-[4\u000b\t\u0005=\u0018Q\r\u0005\t\u0003s\f9\u000e1\u0001\u0002|\u0006)\"/Z:pkJ\u001cW\rV8D_:4\u0017n\u001a(b[\u0016\u001c\b\u0003CA\u001c\u0003{\ty.!@\u0011\t%)\u0017Q\u0012\u0005\b\u0005\u0003\t9\u000e1\u0001}\u0003=Ign\u00197vI\u0016\u001c\u0016P\\8os6\u001c\bb\u0002B\u0003\u0001\u0011\u0005!qA\u0001\rC2$XM]\"p]\u001aLwm\u001d\u000b\u0007\u0005\u0013\u0011YA!\b\u0011\u0011\u0005]\u0012QHAp\u0003sB\u0001B!\u0004\u0003\u0004\u0001\u0007!qB\u0001\bG>tg-[4t!!\t9$!\u0010\u0002`\nE\u0001\u0003\u0002B\n\u00053qA!a\u001f\u0003\u0016%!!qCA3\u0003M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0013\u0011\t\u0019Pa\u0007\u000b\t\t]\u0011Q\r\u0005\b\u0003_\u0011\u0019\u00011\u0001}\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u000bAqAa\n\u0001\t\u0013\u0011I#\u0001\fsKN|WO]2f\u001d\u0006lW\rV8Ce>\\WM]%e)\u0011\t9Ca\u000b\t\u0011\t5\"Q\u0005a\u0001\u0003\u001f\tAB]3t_V\u00148-\u001a(b[\u0016DqA!\r\u0001\t\u0013\u0011\u0019$\u0001\bce>\\WM]*z]>t\u00170\\:\u0015\t\tU\"q\t\t\u0007\u0005o\u0011\t%a\u0004\u000f\t\te\"Q\b\b\u0005\u0003\u001f\u0012Y$C\u0001\f\u0013\r\u0011yDC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019E!\u0012\u0003\t1K7\u000f\u001e\u0006\u0004\u0005\u007fQ\u0001\u0002\u0003B%\u0005_\u0001\r!a\u0004\u0002\t9\fW.\u001a\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0003)\u0019wN\u001c4jORK\b/\u001a\u000b\u0007\u0005#\u0012yF!\u0019\u0011\t\tM#\u0011\f\b\u0005\u0003C\u0014)&\u0003\u0003\u0003X\u0005\r\u0018!C\"p]\u001aLw\rR3g\u0013\u0011\u0011YF!\u0018\u0003\tQK\b/\u001a\u0006\u0005\u0005/\n\u0019\u000f\u0003\u0005\u0003J\t-\u0003\u0019AA\b\u0011!\u0011\u0019Ga\u0013A\u0002\tU\u0012\u0001C:z]>t\u00170\\:\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\u0005q1m\u001c8gS\u001e\u001c\u0016P\\8os6\u001cH\u0003\u0003B6\u0005g\u0012)Ha\u001e\u0011\r\t]\"\u0011\tB7!\u0011\tYOa\u001c\n\t\tE\u0014Q\u001f\u0002\u000e\u0007>tg-[4Ts:|g._7\t\u0011\t%#Q\ra\u0001\u0003\u001fA\u0001Ba\u0019\u0003f\u0001\u0007!Q\u0007\u0005\b\u0005s\u0012)\u00071\u0001}\u0003-I7oU3og&$\u0018N^3\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000\u000512M]3bi\u0016$v\u000e]5d\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0005\u0003\u0002\nU%Q\u0015B])\u0019\u0011\u0019I!#\u0003\fB!\u00111\u001eBC\u0013\u0011\u00119)!>\u0003\u0017\r{gNZ5h\u000b:$(/\u001f\u0005\t\u0005\u0013\u0012Y\b1\u0001\u0002\u0010!A!Q\u0012B>\u0001\u0004\u0011y)A\u0003wC2,X\rE\u0002\n\u0005#K1Aa%\u000b\u0005\r\te.\u001f\u0005\t\u0005/\u0013Y\b1\u0001\u0003\u001a\u0006IAn\\4D_:4\u0017n\u001a\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*\u0019!q\u0014\u0003\u0002\u00071|w-\u0003\u0003\u0003$\nu%!\u0003'pO\u000e{gNZ5h\u0011!\u00119Ka\u001fA\u0002\t%\u0016A\u0003;pa&\u001c\u0007K]8qgB!!1\u0016B[\u001b\t\u0011iK\u0003\u0003\u00030\nE\u0016\u0001B;uS2T!Aa-\u0002\t)\fg/Y\u0005\u0005\u0005o\u0013iK\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!\u0001\u0003|\u0001\u0007A\u0010C\u0004\u0003>\u0002!IAa0\u0002/\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ#oiJLHC\u0002Ba\u0005\u000f\u0014Y\r\u0006\u0004\u0003\u0004\n\r'Q\u0019\u0005\t\u0005\u0013\u0012Y\f1\u0001\u0002\u0010!A!Q\u0012B^\u0001\u0004\u0011y\tC\u0004\u0003J\nm\u0006\u0019\u0001?\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDqA!\u0001\u0003<\u0002\u0007A\u0010")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient kafka$server$AdminManager$$adminZkClient;
    private final Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy;
    private final Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public AdminZkClient kafka$server$AdminManager$$adminZkClient() {
        return this.kafka$server$AdminManager$$adminZkClient;
    }

    public Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy() {
        return this.kafka$server$AdminManager$$createTopicPolicy;
    }

    public Option<AlterConfigPolicy> kafka$server$AdminManager$$alterConfigPolicy() {
        return this.kafka$server$AdminManager$$alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)new Serializable(this, key, completed){
            public static final long serialVersionUID = 0L;
            private final TopicKey key$1;
            private final int completed$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.keyLabel(), BoxesRunTime.boxToInteger((int)this.completed$1)}));
            }
            {
                this.key$1 = key$1;
                this.completed$1 = completed$1;
            }
        });
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker b) {
                return new BrokerMetadata(b.id(), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1)new Serializable(this, validateOnly, brokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$1;
            private final Seq brokers$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreatePartitionsMetadata apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                CreatePartitionsMetadata createPartitionsMetadata;
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                String value2 = (String)tuple2._2();
                                Object object = this.configs$1.setProperty(key, value2);
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map assignments = arguments.replicasAssignments.isEmpty() ? AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokers$1, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Integer, java.util.List<Integer>> x0$3) {
                            Tuple2<Integer, java.util.List<Integer>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                java.util.List replicas = (java.util.List)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Integer x$1) {
                                        return x$1;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    this.$outer.trace((Function0<String>)new Serializable(this, topic, assignments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Map assignments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.assignments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.assignments$1 = assignments$1;
                        }
                    });
                    Option<CreateTopicPolicy> option = this.$outer.kafka$server$AdminManager$$createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.x();
                        this.$outer.kafka$server$AdminManager$$adminZkClient().validateTopicCreate(topic, (Map<Object, Seq<Object>>)assignments, configs);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (this.validateOnly$1) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().createTopicWithAssignment(topic, configs, (Map<Object, Seq<Object>>)assignments);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit;
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        if (this.validateOnly$1) {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().validateTopicCreate(topic, (Map<Object, Seq<Object>>)assignments, configs);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.kafka$server$AdminManager$$adminZkClient().createTopicWithAssignment(topic, configs, (Map<Object, Seq<Object>>)assignments);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)assignments, ApiError.NONE);
                    return createPartitionsMetadata;
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$3;

                        public final Throwable apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = e$3;
                        }
                    });
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable));
                    return createPartitionsMetadata;
                }
                catch (ConfigException configException) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, configException){
                        public static final long serialVersionUID = 0L;
                        private final ConfigException e$2;

                        public final ConfigException apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(configException.getMessage(), configException.getCause())));
                    return createPartitionsMetadata;
                }
                catch (ApiException apiException) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic, arguments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final CreateTopicsRequest.TopicDetails arguments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.arguments$1 = arguments$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, apiException){
                        public static final long serialVersionUID = 0L;
                        private final ApiException e$1;

                        public final ApiException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)apiException));
                }
                return createPartitionsMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$1 = validateOnly$1;
                this.brokers$1 = brokers$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreatePartitionsMetadata x$2) {
                return x$2.error().is(Errors.NONE);
            }
        })) {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$3) {
                    return new TopicKey(x$3);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$1;

                public final Tuple2<String, ApiError> apply(CreatePartitionsMetadata createTopicMetadata) {
                    return createTopicMetadata.error().isSuccess() && !this.validateOnly$1 ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
                }
                {
                    this.validateOnly$1 = validateOnly$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final DeleteTopicMetadata apply(String topic) {
                DeleteTopicMetadata deleteTopicMetadata;
                try {
                    this.$outer.kafka$server$AdminManager$$adminZkClient().deleteTopic(topic);
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$4;

                        public final Throwable apply() {
                            return this.e$4;
                        }
                        {
                            this.e$4 = e$4;
                        }
                    });
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.forException((Throwable)throwable));
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                return deleteTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DeleteTopicMetadata x$4) {
                Errors errors = x$4.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$5) {
                    return new TopicKey(x$5);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(DeleteTopicMetadata deleteTopicMetadata) {
                    Errors errors = deleteTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void createPartitions(int timeout, Map<String, CreatePartitionsRequest.PartitionDetails> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas(this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas$default$1(), this.kafka$server$AdminManager$$adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$6) {
                return x$6.id();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1)new Serializable(this, validateOnly, reassignPartitionsInProgress, allBrokers, allBrokerIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$2;
            private final boolean reassignPartitionsInProgress$1;
            private final Seq allBrokers$1;
            public final Seq allBrokerIds$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreatePartitionsMetadata apply(Tuple2<String, CreatePartitionsRequest.PartitionDetails> x0$4) {
                CreatePartitionsMetadata createPartitionsMetadata;
                Tuple2<String, CreatePartitionsRequest.PartitionDetails> tuple2 = x0$4;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreatePartitionsRequest.PartitionDetails newPartition = (CreatePartitionsRequest.PartitionDetails)tuple2._2();
                try {
                    if (this.reassignPartitionsInProgress$1) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.$outer.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                            Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                            if (tuple2 != null) {
                                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                                Seq replicas = (Seq)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic currently has ", " partitions, which is higher than the requested ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions), BoxesRunTime.boxToInteger((int)newNumPartitions)})));
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic already has ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions)})));
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.newAssignments()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Buffer<Buffer<Object>> apply(java.util.List<java.util.List<Integer>> x$7) {
                            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Buffer<Object> apply(java.util.List<Integer> x$8) {
                                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Integer x$9) {
                                            return Predef$.MODULE$.Integer2int(x$9);
                                        }
                                    }, Buffer$.MODULE$.canBuildFrom());
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                        }
                    }).map((Function1)new Serializable(this, existingAssignment, numPartitionsIncrement){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$10 $outer;
                        public final scala.collection.immutable.Map existingAssignment$1;
                        private final int numPartitionsIncrement$1;

                        public final scala.collection.immutable.Map<Object, Buffer<Object>> apply(Buffer<Buffer<Object>> assignments) {
                            scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)this.$outer.allBrokerIds$1);
                            if (unknownBrokers.nonEmpty()) {
                                throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown broker(s) in replica assignment: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unknownBrokers.mkString(", ")})));
                            }
                            if (assignments.size() != this.numPartitionsIncrement$1) {
                                throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Increasing the number of partitions by ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitionsIncrement$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " assignments provided."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)assignments.size())}))).toString());
                            }
                            return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$13 $outer;

                                public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Buffer<Object>, Object> x0$6) {
                                    Tuple2<Buffer<Object>, Object> tuple2 = x0$6;
                                    if (tuple2 != null) {
                                        Buffer replicas = (Buffer)tuple2._1();
                                        int index = tuple2._2$mcI$sp();
                                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(this.$outer.existingAssignment$1.size() + index))), (Object)replicas);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.existingAssignment$1 = existingAssignment$1;
                            this.numPartitionsIncrement$1 = numPartitionsIncrement$1;
                        }
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.$outer.kafka$server$AdminManager$$adminZkClient().addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, (Seq<BrokerMetadata>)this.allBrokers$1, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, this.validateOnly$2);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                    return createPartitionsMetadata;
                }
                catch (ApiException apiException) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)apiException));
                    return createPartitionsMetadata;
                }
                catch (AdminOperationException adminOperationException) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)adminOperationException));
                }
                return createPartitionsMetadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$2 = validateOnly$2;
                this.reassignPartitionsInProgress$1 = reassignPartitionsInProgress$1;
                this.allBrokers$1 = allBrokers$1;
                this.allBrokerIds$1 = allBrokerIds$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreatePartitionsMetadata x$10) {
                return x$10.error().is(Errors.NONE);
            }
        })) {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$11) {
                    return new TopicKey(x$11);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$2;

                public final Tuple2<String, ApiError> apply(CreatePartitionsMetadata createPartitionMetadata) {
                    return createPartitionMetadata.error().isSuccess() && !this.validateOnly$2 ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
                }
                {
                    this.validateOnly$2 = validateOnly$2;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        }
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1)new Serializable(this, includeSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            public final boolean includeSynonyms$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<ConfigResource, DescribeConfigsResponse.Config> apply(Tuple2<ConfigResource, Option<Set<String>>> x0$7) {
                Tuple2 tuple2;
                Tuple2<ConfigResource, Option<Set<String>>> tuple22 = x0$7;
                if (tuple22 == null) throw new MatchError(tuple22);
                ConfigResource resource = (ConfigResource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.$outer.metadataCache().contains(topic)) {
                            Properties topicProps = this.$outer.kafka$server$AdminManager$$adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.$outer.config()), topicProps);
                            config2 = this.createResponseConfig$1((Map)this.allConfigs$1(logConfig), (Function2)new Serializable(this, topicProps, logConfig){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;
                                private final Properties topicProps$1;
                                private final LogConfig logConfig$1;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createTopicConfigEntry(this.logConfig$1, this.topicProps$1, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.topicProps$1 = topicProps$1;
                                    this.logConfig$1 = logConfig$1;
                                }
                            }, configNames);
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.<T>emptyList());
                        }
                        config = config2;
                    } else {
                        DescribeConfigsResponse.Config config3;
                        if (!ConfigResource.Type.BROKER.equals(type)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported resource type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config3 = this.createResponseConfig$1(this.$outer.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createBrokerConfigEntry(false, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, configNames);
                        } else {
                            if (this.$outer.kafka$server$AdminManager$$resourceNameToBrokerId(resource.name()) != this.$outer.config().brokerId()) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", " or empty string, but received ", ".name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()), resource})));
                            config3 = this.createResponseConfig$1((Map)this.allConfigs$1(this.$outer.config()), (Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$describeConfigs$1 $outer;

                                public final DescribeConfigsResponse.ConfigEntry apply(String name, Object value2) {
                                    return this.$outer.kafka$server$AdminManager$$anonfun$$$outer().kafka$server$AdminManager$$createBrokerConfigEntry(true, this.$outer.includeSynonyms$1, name, value2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, configNames);
                        }
                        config = config3;
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                    return tuple2;
                }
                catch (Throwable throwable) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing describe configs request for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource}));
                    if (throwable instanceof ApiException) {
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$5;

                            public final Throwable apply() {
                                return this.e$5;
                            }
                            {
                                this.e$5 = e$5;
                            }
                        });
                    } else {
                        this.$outer.error((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$5;

                            public final Throwable apply() {
                                return this.e$5;
                            }
                            {
                                this.e$5 = e$5;
                            }
                        });
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)throwable), Collections.<T>emptyList()));
                }
                return tuple2;
            }

            public /* synthetic */ AdminManager kafka$server$AdminManager$$anonfun$$$outer() {
                return this.$outer;
            }

            private final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
                return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Object> x$12) {
                        return x$12._2() != null;
                    }
                })).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
            }

            private final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
                IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1)new Serializable(this, configNames$1){
                    public static final long serialVersionUID = 0L;
                    private final Option configNames$1;

                    public final boolean apply(Tuple2<String, Object> x0$8) {
                        Tuple2<String, Object> tuple2 = x0$8;
                        if (tuple2 != null) {
                            String configName = (String)tuple2._1();
                            boolean bl = this.configNames$1.forall((Function1)new Serializable(this, configName){
                                public static final long serialVersionUID = 0L;
                                private final String configName$1;

                                public final boolean apply(Set<String> x$13) {
                                    return x$13.contains((Object)this.configName$1);
                                }
                                {
                                    this.configName$1 = configName$1;
                                }
                            });
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.configNames$1 = configNames$1;
                    }
                })).toIndexedSeq();
                IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1)new Serializable(this, createConfigEntry){
                    public static final long serialVersionUID = 0L;
                    private final Function2 createConfigEntry$1;

                    public final DescribeConfigsResponse.ConfigEntry apply(Tuple2<String, Object> x0$9) {
                        Tuple2<String, Object> tuple2 = x0$9;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Object value2 = tuple2._2();
                            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)this.createConfigEntry$1.apply((Object)name, value2);
                            return configEntry;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.createConfigEntry$1 = createConfigEntry$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.includeSynonyms$1 = includeSynonyms$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1)new Serializable(this, validateOnly){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$3;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<ConfigResource, ApiError> apply(Tuple2<ConfigResource, AlterConfigsRequest.Config> x0$10) {
                Tuple2 tuple2;
                Tuple2<ConfigResource, AlterConfigsRequest.Config> tuple22 = x0$10;
                if (tuple22 == null) throw new MatchError(tuple22);
                ConfigResource resource = (ConfigResource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        String topic = resource.name();
                        Properties properties = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this, properties){
                            public static final long serialVersionUID = 0L;
                            private final Properties properties$1;

                            public final Object apply(AlterConfigsRequest.ConfigEntry configEntry) {
                                return this.properties$1.setProperty(configEntry.name(), configEntry.value());
                            }
                            {
                                this.properties$1 = properties$1;
                            }
                        });
                        this.$outer.kafka$server$AdminManager$$adminZkClient().validateTopicConfig(topic, properties);
                        this.validateConfigPolicy$1(ConfigResource.Type.TOPIC, resource, config);
                        if (!this.validateOnly$3) {
                            this.$outer.info((Function0<String>)new Serializable(this, config, topic){
                                public static final long serialVersionUID = 0L;
                                private final AlterConfigsRequest.Config config$1;
                                private final String topic$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating topic ", " with new configuration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.config$1}));
                                }
                                {
                                    this.config$1 = config$1;
                                    this.topic$2 = topic$2;
                                }
                            });
                            this.$outer.kafka$server$AdminManager$$adminZkClient().changeTopicConfig(topic, properties);
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else {
                        None$ none$;
                        if (!ConfigResource.Type.BROKER.equals(type)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AlterConfigs is only supported for topics and brokers, but resource type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type})));
                        if (resource.name() == null || resource.name().isEmpty()) {
                            none$ = None$.MODULE$;
                        } else {
                            int id = this.$outer.kafka$server$AdminManager$$resourceNameToBrokerId(resource.name());
                            if (id != this.$outer.config().brokerId()) {
                                throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", ", but received ", ".name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()), resource})));
                            }
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)id));
                        }
                        None$ brokerId = none$;
                        Properties configProps = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this, configProps){
                            public static final long serialVersionUID = 0L;
                            private final Properties configProps$1;

                            public final Object apply(AlterConfigsRequest.ConfigEntry configEntry) {
                                return this.configProps$1.setProperty(configEntry.name(), configEntry.value());
                            }
                            {
                                this.configProps$1 = configProps$1;
                            }
                        });
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        this.$outer.config().dynamicConfig().validate(configProps, perBrokerConfig);
                        this.validateConfigPolicy$1(ConfigResource.Type.BROKER, resource, config);
                        if (!this.validateOnly$3) {
                            if (perBrokerConfig) {
                                this.$outer.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
                            }
                            this.$outer.kafka$server$AdminManager$$adminZkClient().changeBrokerConfig((Option<Object>)brokerId, this.$outer.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    }
                    tuple2 = tuple23;
                    return tuple2;
                }
                catch (Throwable throwable22) {
                    Tuple2 tuple24;
                    Throwable throwable3 = throwable22;
                    boolean bl = throwable3 instanceof ConfigException ? true : throwable3 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for resource ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, throwable3.getMessage()}));
                        this.$outer.info((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$2;

                            public final String apply() {
                                return this.message$2;
                            }
                            {
                                this.message$2 = message$2;
                            }
                        });
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable3)));
                    } else {
                        if (throwable3 == null) throw throwable22;
                        Throwable throwable4 = throwable3;
                        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing alter configs request for resource ", ", config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, config}));
                        if (throwable4 instanceof ApiException) {
                            this.$outer.info((Function0<String>)new Serializable(this, message){
                                public static final long serialVersionUID = 0L;
                                private final String message$3;

                                public final String apply() {
                                    return this.message$3;
                                }
                                {
                                    this.message$3 = message$3;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable4){
                                public static final long serialVersionUID = 0L;
                                private final Throwable x10$1;

                                public final Throwable apply() {
                                    return this.x10$1;
                                }
                                {
                                    this.x10$1 = x10$1;
                                }
                            });
                        } else {
                            this.$outer.error((Function0<String>)new Serializable(this, message){
                                public static final long serialVersionUID = 0L;
                                private final String message$3;

                                public final String apply() {
                                    return this.message$3;
                                }
                                {
                                    this.message$3 = message$3;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable4){
                                public static final long serialVersionUID = 0L;
                                private final Throwable x10$1;

                                public final Throwable apply() {
                                    return this.x10$1;
                                }
                                {
                                    this.x10$1 = x10$1;
                                }
                            });
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable4));
                    }
                    tuple2 = tuple24;
                }
                return tuple2;
            }

            private final void validateConfigPolicy$1(ConfigResource.Type resourceType, ConfigResource resource$1, AlterConfigsRequest.Config config$1) {
                Option<AlterConfigPolicy> option;
                block4: {
                    block3: {
                        block2: {
                            option = this.$outer.kafka$server$AdminManager$$alterConfigPolicy();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            AlterConfigPolicy policy = (AlterConfigPolicy)some.x();
                            scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config$1.entries()).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, String> apply(AlterConfigsRequest.ConfigEntry entry2) {
                                    return new Tuple2((Object)entry2.name(), (Object)entry2.value());
                                }
                            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resourceType, resource$1.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.validateOnly$3 = validateOnly$3;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$createTopicPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(CreateTopicPolicy x$14) {
                        x$14.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$alterConfigPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AlterConfigPolicy x$15) {
                        x$15.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public int kafka$server$AdminManager$$resourceNameToBrokerId(String resourceName) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id must be an integer, but it is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceName})));
        }
    }

    public List<String> kafka$server$AdminManager$$brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType2 = this.config().typeOf(name);
        return configType2 == null ? (ConfigDef.Type)synonyms.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final ConfigDef.Type apply(String x$1) {
                return this.$outer.config().typeOf(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigDef.Type x$16) {
                return x$16 != null;
            }
        }).orNull(Predef$.MODULE$.$conforms()) : configType2;
    }

    public List<DescribeConfigsResponse.ConfigSynonym> kafka$server$AdminManager$$configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1)new Serializable(this, isSensitive, allSynonyms, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final Map eta$0$1$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1(this.eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1)new Serializable(this, isSensitive, allSynonyms, map2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final Map eta$0$2$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1(this.eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        synonyms.foreach((Function1)new Serializable(this, isSensitive, dynamicConfig, allSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final DynamicBrokerConfig dynamicConfig$1;
            private final Buffer allSynonyms$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1((Map)this.dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.dynamicConfig$1 = dynamicConfig$1;
                this.allSynonyms$1 = allSynonyms$1;
            }
        });
        synonyms.foreach((Function1)new Serializable(this, isSensitive, dynamicConfig, allSynonyms){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$1;
            private final DynamicBrokerConfig dynamicConfig$1;
            private final Buffer allSynonyms$1;

            public final void apply(String name) {
                this.$outer.kafka$server$AdminManager$$maybeAddSynonym$1((Map)this.dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, this.isSensitive$1, this.allSynonyms$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$1 = isSensitive$1;
                this.dynamicConfig$1 = dynamicConfig$1;
                this.allSynonyms$1 = allSynonyms$1;
            }
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(DescribeConfigsResponse.ConfigSynonym s) {
                String string = s.name();
                String string2 = this.name$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.name$1 = name$1;
            }
        })).toList();
    }

    public DescribeConfigsResponse.ConfigEntry kafka$server$AdminManager$$createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value2) {
        List list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value2, (ConfigDef.Type)configEntryType);
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1)new Serializable(this, isSensitive){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean isSensitive$2;

            public final List<DescribeConfigsResponse.ConfigSynonym> apply(String s) {
                return this.$outer.kafka$server$AdminManager$$configSynonyms(s, this.$outer.kafka$server$AdminManager$$brokerSynonyms(s), this.isSensitive$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isSensitive$2 = isSensitive$2;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return List$.MODULE$.empty();
            }
        });
        if (topicProps.containsKey(name)) {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = (List)list2.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        } else {
            list = list2;
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = includeSynonyms ? allSynonyms : List$.MODULE$.empty();
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public DescribeConfigsResponse.ConfigEntry kafka$server$AdminManager$$createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value2) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.kafka$server$AdminManager$$brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value2;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString((Object)value2, (ConfigDef.Type)configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.kafka$server$AdminManager$$configSynonyms(name, allNames, isSensitive).filter((Function1)new Serializable(this, perBrokerConfig){
            public static final long serialVersionUID = 0L;
            private final boolean perBrokerConfig$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(DescribeConfigsResponse.ConfigSynonym x$18) {
                if (this.perBrokerConfig$1) return true;
                DescribeConfigsResponse.ConfigSource configSource = x$18.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null) {
                    if (!configSource.equals(configSource2)) return false;
                    return true;
                }
                if (configSource2 == null) return true;
                return false;
            }
            {
                this.perBrokerConfig$1 = perBrokerConfig$1;
            }
        });
        List synonyms = includeSynonyms ? allSynonyms : List$.MODULE$.empty();
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
            }
        });
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public final void kafka$server$AdminManager$$maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1)new Serializable(this, isSensitive$1, allSynonyms$1, source, name){
            public static final long serialVersionUID = 0L;
            private final boolean isSensitive$1;
            private final Buffer allSynonyms$1;
            private final DescribeConfigsResponse.ConfigSource source$1;
            private final String name$2;

            public final Buffer<DescribeConfigsResponse.ConfigSynonym> apply(String value2) {
                String configValue = this.isSensitive$1 ? null : value2;
                return this.allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(this.name$2, configValue, this.source$1));
            }
            {
                this.isSensitive$1 = isSensitive$1;
                this.allSynonyms$1 = allSynonyms$1;
                this.source$1 = source$1;
                this.name$2 = name$2;
            }
        });
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Admin Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.kafka$server$AdminManager$$adminZkClient = new AdminZkClient(zkClient);
        this.kafka$server$AdminManager$$createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.kafka$server$AdminManager$$alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

