/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.log.Log$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005s!B\u0001\u0003\u0011\u00039\u0011a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u0011YI!\u0019!C\u0001\u0005]\tQBU#D\u001fJ#u,\u0013(E\u000b:#V#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012A\u0004*F\u0007>\u0013FiX%O\t\u0016sE\u000b\t\u0005\u0006G%!\t\u0001J\u0001\u0005[\u0006Lg\u000e\u0006\u0002&QA\u0011QBJ\u0005\u0003O9\u0011A!\u00168ji\")\u0011F\ta\u0001U\u0005!\u0011M]4t!\ri1&L\u0005\u0003Y9\u0011Q!\u0011:sCf\u0004\"AL\u0019\u000f\u00055y\u0013B\u0001\u0019\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011qD\r\u0006\u0003a9AQ\u0001N\u0005\u0005\nU\nA\u0002Z;naRCh.\u00138eKb$\"!\n\u001c\t\u000b]\u001a\u0004\u0019\u0001\u001d\u0002\t\u0019LG.\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003wq\t!![8\n\u0005uR$\u0001\u0002$jY\u0016DQaP\u0005\u0005\n\u0001\u000ba\u0003Z;naB\u0013x\u000eZ;dKJLEm\u00158baNDw\u000e\u001e\u000b\u0003K\u0005CQa\u000e A\u0002aBQaQ\u0005\u0005\n\u0011\u000b\u0011\u0002Z;na&sG-\u001a=\u0015\r\u0015*eiS'j\u0011\u00159$\t1\u00019\u0011\u00159%\t1\u0001I\u0003=Ig\u000eZ3y'\u0006t\u0017\u000e^=P]2L\bCA\u0007J\u0013\tQeBA\u0004C_>dW-\u00198\t\u000b1\u0013\u0005\u0019\u0001%\u0002\u0015Y,'/\u001b4z\u001f:d\u0017\u0010C\u0003O\u0005\u0002\u0007q*\u0001\u000enSNl\u0015\r^2iKN4uN]%oI\u0016Dh)\u001b7fg6\u000b\u0007\u000f\u0005\u0003Q+6:V\"A)\u000b\u0005I\u001b\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003):\t!bY8mY\u0016\u001cG/[8o\u0013\t1\u0016KA\u0004ICNDW*\u00199\u0011\u0007a\u00037M\u0004\u0002Z=:\u0011!,X\u0007\u00027*\u0011ALB\u0001\u0007yI|w\u000e\u001e \n\u0003=I!a\u0018\b\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\u0005\u0019&\u001cHO\u0003\u0002`\u001dA!Q\u0002\u001a4g\u0013\t)gB\u0001\u0004UkBdWM\r\t\u0003\u001b\u001dL!\u0001\u001b\b\u0003\t1{gn\u001a\u0005\u0006U\n\u0003\ra[\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f!\tiA.\u0003\u0002n\u001d\t\u0019\u0011J\u001c;\t\u000b=LA\u0011\u00029\u0002\u001b\u0011,X\u000e\u001d+j[\u0016Le\u000eZ3y)\u001d)\u0013O]:u\u0003#BQa\u000e8A\u0002aBQa\u00128A\u0002!CQ\u0001\u00148A\u0002!CQ!\u001e8A\u0002Y\f1\u0003^5nK&sG-\u001a=Ek6\u0004XI\u001d:peN\u0004\"a\u001e=\u000e\u0003%1A!_\u0005\u0001u\n\u0019B+[7f\u0013:$W\r\u001f#v[B,%O]8sgN\u0011\u0001\u0010\u0004\u0005\u0006'a$\t\u0001 \u000b\u0002m\"9a\u0010\u001fb\u0001\n\u0003y\u0018AH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1q+\t\t\t\u0001E\u0003Q+6\n\u0019\u0001\u0005\u0003Q\u0003\u000b\u0019\u0017bAA\u0004#\nY\u0011I\u001d:bs\n+hMZ3s\u0011!\tY\u0001\u001fQ\u0001\n\u0005\u0005\u0011aH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1qA!A\u0011q\u0002=C\u0002\u0013\u0005q0A\npkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002\u0014a\u0004\u000b\u0011BA\u0001\u0003QyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7qA!A\u0011q\u0003=C\u0002\u0013\u0005q0A\u000btQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3\t\u0011\u0005m\u0001\u0010)A\u0005\u0003\u0003\tac\u001d5bY2|wo\u00144gg\u0016$hj\u001c;G_VtG\r\t\u0005\b\u0003?AH\u0011AA\u0011\u0003]\u0011XmY8sI6K7/\\1uG\"$\u0016.\\3J]\u0012,\u0007\u0010F\u0004&\u0003G\t)#!\u000b\t\r]\ni\u00021\u00019\u0011\u001d\t9#!\bA\u0002\u0019\fa\"\u001b8eKb$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002,\u0005u\u0001\u0019\u00014\u0002\u00191|w\rV5nKN$\u0018-\u001c9\t\u000f\u0005=\u0002\u0010\"\u0001\u00022\u0005q\"/Z2pe\u0012|U\u000f^(g\u001fJ$WM]%oI\u0016DH+[7fgR\fW\u000e\u001d\u000b\bK\u0005M\u0012QGA\u001c\u0011\u00199\u0014Q\u0006a\u0001q!9\u0011qEA\u0017\u0001\u00041\u0007bBA\u001d\u0003[\u0001\rAZ\u0001\u0013aJ,g/\u00138eKb$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002>a$\t!a\u0010\u00027I,7m\u001c:e'\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e)\u001d)\u0013\u0011IA\"\u0003\u000fBaaNA\u001e\u0001\u0004A\u0004bBA#\u0003w\u0001\rAZ\u0001\fS:$W\r_(gMN,G\u000fC\u0004\u0002J\u0005m\u0002\u0019\u00014\u0002\u00131|wm\u00144gg\u0016$\bbBA'q\u0012\u0005\u0011qJ\u0001\faJLg\u000e^#se>\u00148\u000fF\u0001&\u0011\u0015Qg\u000e1\u0001l\r%\t)&\u0003I\u0001$\u0013\t9FA\u0007NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u00033\ni'a!\u0014\u0007\u0005MC\u0002\u0003\u0005\u0002^\u0005Mc\u0011AA0\u0003\u0015\u0001\u0018M]:f)\u0011\t\t'a\"\u0011\r5!\u00171MA@!\u0015i\u0011QMA5\u0013\r\t9G\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0014Q\u000e\u0007\u0001\t!\ty'a\u0015C\u0002\u0005E$!A&\u0012\t\u0005M\u0014\u0011\u0010\t\u0004\u001b\u0005U\u0014bAA<\u001d\t9aj\u001c;iS:<\u0007cA\u0007\u0002|%\u0019\u0011Q\u0010\b\u0003\u0007\u0005s\u0017\u0010E\u0003\u000e\u0003K\n\t\t\u0005\u0003\u0002l\u0005\rE\u0001CAC\u0003'\u0012\r!!\u001d\u0003\u0003YC\u0001\"!#\u0002\\\u0001\u0007\u00111R\u0001\u0007e\u0016\u001cwN\u001d3\u0011\t\u00055\u0015qT\u0007\u0003\u0003\u001fSA!!#\u0002\u0012*!\u00111SAK\u0003\u0019\u0019w.\\7p]*\u0019Q!a&\u000b\t\u0005e\u00151T\u0001\u0007CB\f7\r[3\u000b\u0005\u0005u\u0015aA8sO&!\u0011\u0011UAH\u0005\u0019\u0011VmY8sI\u001a1\u0011QU\u0005\u0005\u0003O\u0013A\u0003R3d_\u0012,'/T3tg\u0006<W\rU1sg\u0016\u0014XCBAU\u0003_\u000b\u0019lE\u0003\u0002$2\tY\u000bE\u0004x\u0003'\ni+!-\u0011\t\u0005-\u0014q\u0016\u0003\t\u0003_\n\u0019K1\u0001\u0002rA!\u00111NAZ\t!\t))a)C\u0002\u0005E\u0004bCA\\\u0003G\u0013\t\u0011)A\u0005\u0003s\u000b!b[3z\t\u0016\u001cw\u000eZ3s!\u0019\tY,!1\u0002.6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f#\u0011AC:fe&\fG.\u001b>fe&!\u00111YA_\u0005\u001d!UmY8eKJD1\"a2\u0002$\n\u0005\t\u0015!\u0003\u0002J\u0006aa/\u00197vK\u0012+7m\u001c3feB1\u00111XAa\u0003cCqaEAR\t\u0003\ti\r\u0006\u0004\u0002P\u0006E\u00171\u001b\t\bo\u0006\r\u0016QVAY\u0011!\t9,a3A\u0002\u0005e\u0006\u0002CAd\u0003\u0017\u0004\r!!3\t\u0011\u0005u\u00131\u0015C!\u0003/$B!!7\u0002`B1Q\u0002ZAn\u0003;\u0004R!DA3\u0003[\u0003R!DA3\u0003cC\u0001\"!#\u0002V\u0002\u0007\u00111\u0012\u0004\u0007\u0003GLA!!:\u00037Q\u0013\u0018M\\:bGRLwN\u001c'pO6+7o]1hKB\u000b'o]3s'\u0015\t\t\u000fDAt!\u00159\u00181K\u0017.\u0011\u001d\u0019\u0012\u0011\u001dC\u0001\u0003W$\"!!<\u0011\u0007]\f\t\u000f\u0003\u0005\u0002^\u0005\u0005H\u0011IAy)\u0011\t\u00190a>\u0011\r5!\u0017Q_A{!\u0011i\u0011QM\u0017\t\u0011\u0005%\u0015q\u001ea\u0001\u0003\u00173a!a?\n\t\u0005u(\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'oE\u0003\u0002z2\t9\u000fC\u0004\u0014\u0003s$\tA!\u0001\u0015\u0005\t\r\u0001cA<\u0002z\"A!qAA}\t\u0013\u0011I!A\u0002iKb$2!\fB\u0006\u0011!\u0011iA!\u0002A\u0002\t=\u0011!\u00022zi\u0016\u001c\b\u0003B\u0007,\u0005#\u00012!\u0004B\n\u0013\r\u0011)B\u0004\u0002\u0005\u0005f$X\r\u0003\u0005\u0003\u001a\u0005eH\u0011\u0002B\u000e\u00031\u0001\u0018M]:f\u001f\u001a47/\u001a;t)\u0019\u0011iBa\n\u0003<A1Q\u0002\u001aB\u0010\u0005K\u0001B!\u0004B\u0011[%\u0019!1\u0005\b\u0003\tM{W.\u001a\t\u0005\u001b\t\u0005\u0002\u0004\u0003\u0005\u0003*\t]\u0001\u0019\u0001B\u0016\u0003%ygMZ:fi.+\u0017\u0010\u0005\u0003\u0003.\t]RB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\tUB!A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002\u0002B\u001d\u0005_\u0011\u0011b\u00144gg\u0016$8*Z=\t\u0011\tu\"q\u0003a\u0001\u0005\u007f\tq\u0001]1zY>\fG\r\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\r\u0011)\u0005H\u0001\u0004]&|\u0017\u0002\u0002B%\u0005\u0007\u0012!BQ=uK\n+hMZ3s\u0011!\u0011i%!?\u0005\n\t=\u0013A\u00059beN,wI]8va6+G/\u00193bi\u0006$bA!\u0015\u0003T\tu\u0003CB\u0007e\u0005?\u0011y\u0002\u0003\u0005\u0003V\t-\u0003\u0019\u0001B,\u0003A9'o\\;q\u001b\u0016$\u0018\rZ1uC.+\u0017\u0010\u0005\u0003\u0003.\te\u0013\u0002\u0002B.\u0005_\u0011\u0001c\u0012:pkBlU\r^1eCR\f7*Z=\t\u0011\tu\"1\na\u0001\u0005\u007fA\u0001\"!\u0018\u0002z\u0012\u0005#\u0011\r\u000b\u0005\u0003g\u0014\u0019\u0007\u0003\u0005\u0002\n\n}\u0003\u0019AAF\u0011\u001d\u00119'\u0003C\u0005\u0005S\nq\u0001Z;na2{w\rF\u0007&\u0005W\u0012iG!\u001d\u0003v\te$1\u0010\u0005\u0007o\t\u0015\u0004\u0019\u0001\u001d\t\u000f\t=$Q\ra\u0001\u0011\u0006i\u0001O]5oi\u000e{g\u000e^3oiNDqAa\u001d\u0003f\u0001\u0007q*A\u0011o_:\u001cuN\\:fGV$\u0018N^3QC&\u00148OR8s\u0019><g)\u001b7fg6\u000b\u0007\u000fC\u0004\u0003x\t\u0015\u0004\u0019\u0001%\u0002\u001f%\u001cH)Z3q\u0013R,'/\u0019;j_:DaA\u001bB3\u0001\u0004Y\u0007\u0002\u0003B?\u0005K\u0002\rAa \u0002\rA\f'o]3sa\u0019\u0011\tI!\"\u0003\fB9q/a\u0015\u0003\u0004\n%\u0005\u0003BA6\u0005\u000b#ABa\"\u0003|\u0005\u0005\t\u0011!B\u0001\u0003c\u00121a\u0018\u00132!\u0011\tYGa#\u0005\u0019\t5%1PA\u0001\u0002\u0003\u0015\t!!\u001d\u0003\u0007}##\u0007C\u0004\u0003\u0012&!IAa%\u0002\u001fA\u0014\u0018N\u001c;CCR\u001c\u0007\u000eT3wK2$R!\nBK\u0005OC\u0001Ba&\u0003\u0010\u0002\u0007!\u0011T\u0001\u0006E\u0006$8\r\u001b\t\u0005\u00057\u0013\tK\u0004\u0003\u0002\u000e\nu\u0015\u0002\u0002BP\u0003\u001f\u000b!CR5mK2{w-\u00138qkR\u001cFO]3b[&!!1\u0015BS\u0005Y1\u0015\u000e\\3DQ\u0006tg.\u001a7SK\u000e|'\u000f\u001a\"bi\u000eD'\u0002\u0002BP\u0003\u001fCqA!+\u0003\u0010\u0002\u0007a-A\tbG\u000e,X.\u001e7bi&4XMQ=uKN4aA!,\n\u0001\t=&A\u0006#v[BdunZ*fO6,g\u000e^:PaRLwN\\:\u0014\t\t-&\u0011\u0017\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*\u0019!q\u0017\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\tm&Q\u0017\u0002\u0016\u0007>lW.\u00198e\t\u00164\u0017-\u001e7u\u001fB$\u0018n\u001c8t\u0011-I#1\u0016B\u0001B\u0003%!Fa0\n\u0007%\u0012I\fC\u0004\u0014\u0005W#\tAa1\u0015\t\t\u0015'q\u0019\t\u0004o\n-\u0006BB\u0015\u0003B\u0002\u0007!\u0006\u0003\u0006\u0003L\n-&\u0019!C\u0001\u0005\u001b\f\u0001\u0002\u001d:j]R|\u0005\u000f^\u000b\u0003\u0005\u001f\u0004BA!5\u0003X6\u0011!1\u001b\u0006\u0003\u0005+\f!B[8qiNLW\u000e\u001d7f\u0013\u0011\u0011INa5\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000fC\u0005\u0003^\n-\u0006\u0015!\u0003\u0003P\u0006I\u0001O]5oi>\u0003H\u000f\t\u0005\u000b\u0005C\u0014YK1A\u0005\u0002\t5\u0017!\u0003<fe&4\u0017p\u00149u\u0011%\u0011)Oa+!\u0002\u0013\u0011y-\u0001\u0006wKJLg-_(qi\u0002B!B!;\u0003,\n\u0007I\u0011\u0001Bg\u00039Ig\u000eZ3y'\u0006t\u0017\u000e^=PaRD\u0011B!<\u0003,\u0002\u0006IAa4\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002B!B!=\u0003,\n\u0007I\u0011\u0001Bz\u0003!1\u0017\u000e\\3t\u001fB$XC\u0001B{!\u0015\u0011\tNa>.\u0013\u0011\u0011IPa5\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011%\u0011iPa+!\u0002\u0013\u0011)0A\u0005gS2,7o\u00149uA!Q1\u0011\u0001BV\u0005\u0004%\taa\u0001\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004\u0006A1!\u0011\u001bB|\u0007\u000f\u00012!GB\u0005\u0013\r\u0019YA\u0007\u0002\b\u0013:$XmZ3s\u0011%\u0019yAa+!\u0002\u0013\u0019)!\u0001\nnCblUm]:bO\u0016\u001c\u0016N_3PaR\u0004\u0003BCB\n\u0005W\u0013\r\u0011\"\u0001\u0003N\u0006\u0001B-Z3q\u0013R,'/\u0019;j_:|\u0005\u000f\u001e\u0005\n\u0007/\u0011Y\u000b)A\u0005\u0005\u001f\f\u0011\u0003Z3fa&#XM]1uS>tw\n\u001d;!\u0011)\u0019YBa+C\u0002\u0013\u00051QD\u0001\u0010m\u0006dW/\u001a#fG>$WM](qiV\u00111q\u0004\t\u0006\u0005#\u00149\u0010\u0007\u0005\n\u0007G\u0011Y\u000b)A\u0005\u0007?\t\u0001C^1mk\u0016$UmY8eKJ|\u0005\u000f\u001e\u0011\t\u0015\r\u001d\"1\u0016b\u0001\n\u0003\u0019i\"A\u0007lKf$UmY8eKJ|\u0005\u000f\u001e\u0005\n\u0007W\u0011Y\u000b)A\u0005\u0007?\tab[3z\t\u0016\u001cw\u000eZ3s\u001fB$\b\u0005\u0003\u0006\u00040\t-&\u0019!C\u0001\u0005\u001b\f!b\u001c4gg\u0016$8o\u00149u\u0011%\u0019\u0019Da+!\u0002\u0013\u0011y-A\u0006pM\u001a\u001cX\r^:PaR\u0004\u0003BCB\u001c\u0005W\u0013\r\u0011\"\u0001\u0003N\u0006\tBO]1og\u0006\u001cG/[8o\u0019><w\n\u001d;\t\u0013\rm\"1\u0016Q\u0001\n\t=\u0017A\u0005;sC:\u001c\u0018m\u0019;j_:dunZ(qi\u0002B\u0001ba\u0010\u0003,\u0012\u0005\u0011qJ\u0001\nG\",7m[!sON\u0004")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class TimeIndexDumpErrors {
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = new HashMap();
        private final HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = new HashMap();

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public HashMap<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$3) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found timestamp mismatch in :").append((Object)fileName).toString());
                        listOfMismatches.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.outOfOrderTimestamp().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$4) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found out of order timestamp in :").append((Object)fileName).toString());
                        outOfOrderTimestamps.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.shallowOffsetNotFound().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ArrayBuffer<Tuple2<Object, Object>> listOfShallowOffsetNotFound) {
                    System.err.println("The following indexed offsets are not found in the log.");
                    listOfShallowOffsetNotFound.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$5) {
                            Tuple2<Object, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                long indexedOffset = tuple2._1$mcJ$sp();
                                long logOffset = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexed offset: ", ", found log offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexedOffset), BoxesRunTime.boxToLong((long)logOffset)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
            });
        }
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record2) {
            Tuple2 tuple2;
            if (record2.hasValue()) {
                None$ key = record2.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.key()))) : None$.MODULE$;
                Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.value())));
                tuple2 = new Tuple2((Object)key, (Object)payload);
            } else {
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        public String kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(byte[] bytes) {
            return Predef$.MODULE$.byteArrayOps(bytes).isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString("%X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
        }

        private Tuple2<Some<String>, Some<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
            String group = offsetKey.key().group();
            TopicPartition topicPartition = offsetKey.key().topicPartition();
            OffsetAndMetadata offset2 = GroupMetadataManager$.MODULE$.readOffsetMessageValue(payload);
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset::", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition())}));
            String valueString = offset2.metadata().isEmpty() ? String.valueOf(offset2.offset()) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2.offset()), offset2.metadata()}));
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        private Tuple2<Some<String>, Some<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
            String groupId = groupMetadataKey.key();
            GroupMetadata group = GroupMetadataManager$.MODULE$.readGroupMessageValue(groupId, payload, Time.SYSTEM);
            String protocolType = (String)group.protocolType().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1)new Serializable(this, protocolType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetsMessageParser $outer;
                private final String protocolType$1;

                public final String apply(MemberMetadata member) {
                    PartitionAssignor.Assignment partitionAssignment;
                    String userData;
                    String string = this.protocolType$1;
                    String string2 = "consumer";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(Utils.toArray((ByteBuffer)(partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()))).userData()))).isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions(), userData}))) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(member.assignment())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.protocolType$1 = protocolType$1;
                }
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            String keyString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)groupId)}))).asJava());
            String valueString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)group.protocolOrNull()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)}))).asJava());
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            Tuple2<Some<String>, Some<String>> tuple2;
            if (record2.hasValue()) {
                Tuple2<Some<String>, Some<String>> tuple22;
                if (!record2.hasKey()) throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
                BaseKey baseKey = GroupMetadataManager$.MODULE$.readMessageKey(record2.key());
                if (baseKey instanceof OffsetKey) {
                    OffsetKey offsetKey = (OffsetKey)baseKey;
                    tuple22 = this.parseOffsets(offsetKey, record2.value());
                } else {
                    if (!(baseKey instanceof GroupMetadataKey)) throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
                    GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
                    tuple22 = this.parseGroupMetadata(groupMetadataKey, record2.value());
                }
                tuple2 = tuple22;
                return tuple2;
            } else {
                tuple2 = new Tuple2<Some<String>, Some<String>>((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
    }

    public static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public void checkArgs() {
            MessageParser<String, String> messageParser;
            boolean isDeepIteration;
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
            boolean printDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
            boolean verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
            boolean indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
            String[] files = ((String)this.options().valueOf(this.filesOpt())).split(",");
            int maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
            boolean bl = isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || printDataLog;
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                messageParser = new OffsetsMessageParser();
            } else if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                messageParser = new TransactionLogMessageParser();
            } else {
                Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                messageParser = new DecoderMessageParser(keyDecoder, valueDecoder);
            }
            OffsetsMessageParser messageParser2 = messageParser;
            HashMap misMatchesForIndexFilesMap = new HashMap();
            TimeIndexDumpErrors timeIndexDumpErrors = new TimeIndexDumpErrors();
            HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
            Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(this, printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap){
                public static final long serialVersionUID = 0L;
                private final boolean printDataLog$1;
                private final boolean verifyOnly$1;
                private final boolean indexSanityOnly$1;
                private final int maxMessageSize$1;
                private final boolean isDeepIteration$1;
                private final MessageParser messageParser$1;
                private final HashMap misMatchesForIndexFilesMap$1;
                private final TimeIndexDumpErrors timeIndexDumpErrors$1;
                private final HashMap nonConsecutivePairsForLogFilesMap$1;

                public final void apply(String arg) {
                    String suffix;
                    File file = new File(arg);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dumping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    String filename = file.getName();
                    String string = suffix = filename.substring(filename.lastIndexOf("."));
                    String string2 = Log$.MODULE$.LogFileSuffix();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.printDataLog$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1, this.maxMessageSize$1, this.messageParser$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string4 = Log$.MODULE$.IndexFileSuffix();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string6 = Log$.MODULE$.TimeIndexFileSuffix();
                            String string7 = string;
                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTimeIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, this.timeIndexDumpErrors$1, this.maxMessageSize$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string8 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                                String string9 = string;
                                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpProducerIdSnapshot(file);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string10 = Log$.MODULE$.TxnIndexFileSuffix();
                                    String string11 = string;
                                    if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                        DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTxnIndex(file);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring unknown file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                            }
                        }
                    }
                }
                {
                    this.printDataLog$1 = printDataLog$1;
                    this.verifyOnly$1 = verifyOnly$1;
                    this.indexSanityOnly$1 = indexSanityOnly$1;
                    this.maxMessageSize$1 = maxMessageSize$1;
                    this.isDeepIteration$1 = isDeepIteration$1;
                    this.messageParser$1 = messageParser$1;
                    this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                    this.timeIndexDumpErrors$1 = timeIndexDumpErrors$1;
                    this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
                }
            });
            misMatchesForIndexFilesMap.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                    Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        List listOfMismatches = (List)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)fileName).toString());
                        listOfMismatches.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            timeIndexDumpErrors.printErrors();
            nonConsecutivePairsForLogFilesMap.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$2) {
                    Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        List listOfNonConsecutivePairs = (List)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Non-consecutive offsets in :").append((Object)fileName).toString());
                        listOfNonConsecutivePairs.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record2.key());
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(txnKey.transactionalId(), record2.value());
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnKey.transactionalId()}));
            String valueString = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.state()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.topicPartitions()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs())}))).toString();
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
    }
}

