/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.zk.ControllerEpochZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CheckOp;
import kafka.zookeeper.CreateOp;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteOp;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.MultiRequest;
import kafka.zookeeper.MultiResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataOp;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZkOp;
import kafka.zookeeper.ZkOpResult;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaZkClient$ {
    public static final KafkaZkClient$ MODULE$;

    static {
        new KafkaZkClient$();
    }

    public KafkaZkClient apply(String connectString, boolean isSecure, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String metricGroup, String metricType) {
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(connectString, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, metricGroup, metricType);
        return new KafkaZkClient(zooKeeperClient, isSecure, time);
    }

    public String apply$default$7() {
        return "kafka.server";
    }

    public String apply$default$8() {
        return "SessionExpireListener";
    }

    public MultiRequest kafka$zk$KafkaZkClient$$wrapRequestWithControllerEpochCheck(AsyncRequest request, int expectedControllerZkVersion) {
        block5: {
            MultiRequest multiRequest;
            block3: {
                AsyncRequest asyncRequest;
                CheckOp checkOp;
                block4: {
                    block2: {
                        checkOp = new CheckOp(ControllerEpochZNode$.MODULE$.path(), expectedControllerZkVersion);
                        asyncRequest = request;
                        if (!(asyncRequest instanceof CreateRequest)) break block2;
                        CreateRequest createRequest = (CreateRequest)asyncRequest;
                        String path = createRequest.path();
                        byte[] data = createRequest.data();
                        Seq<ACL> acl = createRequest.acl();
                        CreateMode createMode = createRequest.createMode();
                        Option<Object> ctx = createRequest.ctx();
                        multiRequest = new MultiRequest((Seq<ZkOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{checkOp, new CreateOp(path, data, acl, createMode)}))), ctx);
                        break block3;
                    }
                    if (!(asyncRequest instanceof DeleteRequest)) break block4;
                    DeleteRequest deleteRequest = (DeleteRequest)asyncRequest;
                    String path = deleteRequest.path();
                    int version = deleteRequest.version();
                    Option<Object> ctx = deleteRequest.ctx();
                    multiRequest = new MultiRequest((Seq<ZkOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{checkOp, new DeleteOp(path, version)}))), ctx);
                    break block3;
                }
                if (!(asyncRequest instanceof SetDataRequest)) break block5;
                SetDataRequest setDataRequest = (SetDataRequest)asyncRequest;
                String path = setDataRequest.path();
                byte[] data = setDataRequest.data();
                int version = setDataRequest.version();
                Option<Object> ctx = setDataRequest.ctx();
                multiRequest = new MultiRequest((Seq<ZkOp>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{checkOp, new SetDataOp(path, data, version)}))), ctx);
            }
            return multiRequest;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not need controller epoch check"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request})));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsyncResponse kafka$zk$KafkaZkClient$$unwrapResponseWithControllerEpochCheck(AsyncResponse response) {
        AsyncResponse asyncResponse = response;
        if (!(asyncResponse instanceof MultiResponse)) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot unwrap ", " because it is not a MultiResponse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response})));
        MultiResponse multiResponse = (MultiResponse)asyncResponse;
        KeeperException.Code resultCode = multiResponse.resultCode();
        Option<Object> ctx = multiResponse.ctx();
        Seq<ZkOpResult> zkOpResults = multiResponse.zkOpResults();
        ResponseMetadata responseMetadata = multiResponse.metadata();
        Seq<ZkOpResult> seq = zkOpResults;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            ZkOpResult zkOpResult = (ZkOpResult)((SeqLike)some.get()).apply(0);
            ZkOpResult zkOpResult2 = (ZkOpResult)((SeqLike)some.get()).apply(1);
            if (zkOpResult != null) {
                ZkOp checkOp = zkOpResult.zkOp();
                OpResult checkOpResult = zkOpResult.rawOpResult();
                if (checkOp instanceof CheckOp) {
                    void var16_39;
                    void var26_32;
                    CheckOp checkOp2 = (CheckOp)checkOp;
                    OpResult opResult = checkOpResult;
                    if (opResult instanceof OpResult.ErrorResult) {
                        BoxedUnit boxedUnit;
                        OpResult.ErrorResult errorResult = (OpResult.ErrorResult)opResult;
                        if (checkOp2.path().equals(ControllerEpochZNode$.MODULE$.path())) {
                            KeeperException.Code errorCode;
                            KeeperException.Code code = errorCode = KeeperException.Code.get((int)errorResult.getErr());
                            KeeperException.Code code2 = KeeperException.Code.BADVERSION;
                            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                                throw new ControllerMovedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller epoch zkVersion check fails. Expected zkVersion = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)checkOp2.version())})));
                            }
                            KeeperException.Code code3 = errorCode;
                            KeeperException.Code code4 = KeeperException.Code.OK;
                            if (code3 == null) {
                                if (code4 != null) {
                                    throw KeeperException.create((KeeperException.Code)errorCode, (String)checkOp2.path());
                                }
                            } else if (!code3.equals(code4)) throw KeeperException.create((KeeperException.Code)errorCode, (String)checkOp2.path());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    OpResult rawOpResult = zkOpResult2.rawOpResult();
                    ZkOp zkOp = zkOpResult2.zkOp();
                    if (zkOp instanceof CreateOp) {
                        String string;
                        CreateOp createOp = (CreateOp)zkOp;
                        OpResult opResult2 = rawOpResult;
                        if (opResult2 instanceof OpResult.CreateResult) {
                            OpResult.CreateResult createResult = (OpResult.CreateResult)opResult2;
                            string = createResult.getPath();
                        } else {
                            string = null;
                        }
                        String name = string;
                        CreateResponse createResponse2 = new CreateResponse(resultCode, createOp.path(), ctx, name, responseMetadata);
                        var16_39 = var26_32;
                        return var16_39;
                    } else if (zkOp instanceof DeleteOp) {
                        DeleteOp deleteOp = (DeleteOp)zkOp;
                        DeleteResponse deleteResponse = new DeleteResponse(resultCode, deleteOp.path(), ctx, responseMetadata);
                        var16_39 = var26_32;
                        return var16_39;
                    } else {
                        Stat stat;
                        if (!(zkOp instanceof SetDataOp)) throw new MatchError((Object)zkOp);
                        SetDataOp setDataOp = (SetDataOp)zkOp;
                        OpResult opResult3 = rawOpResult;
                        if (opResult3 instanceof OpResult.SetDataResult) {
                            OpResult.SetDataResult setDataResult = (OpResult.SetDataResult)opResult3;
                            stat = setDataResult.getStat();
                        } else {
                            stat = null;
                        }
                        Stat stat2 = stat;
                        SetDataResponse setDataResponse = new SetDataResponse(resultCode, setDataOp.path(), ctx, stat2, responseMetadata);
                    }
                    var16_39 = var26_32;
                    return var16_39;
                }
            }
        }
        if (seq != null) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot unwrap ", " because the first zookeeper op is not check op in original MultiRequest"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response})));
        throw KeeperException.create((KeeperException.Code)resultCode);
    }

    private KafkaZkClient$() {
        MODULE$ = this;
    }
}

