/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$AdminClientTopicService$;
import kafka.admin.TopicCommand$ZookeeperTopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Whitelist;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.io.StdIn$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TopicCommand$
implements Logging {
    public static final TopicCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    private Logger logger$lzycompute() {
        TopicCommand$ topicCommand$ = this;
        synchronized (topicCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                }
                if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                }
                if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                }
                if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                }
                if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing topic command : ").append((Object)throwable.getMessage()).toString());
                this.error((Function0<String>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final String apply() {
                        return Utils.stackTrace((Throwable)this.e$1);
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                exitCode = 1;
            }
        }
        finally {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> topics, boolean topicOptWithExists) {
        if (topics.isEmpty() && !topicOptWithExists) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topics in [", "] does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.mkString(",")})));
        }
    }

    public boolean kafka$admin$TopicCommand$$ensureTopicExists$default$2() {
        return false;
    }

    public void kafka$admin$TopicCommand$$printPartition(TopicCommand.PartitionDescription tp) {
        String markedForDeletionString = tp.markedForDeletion() && !tp.describeConfigs() ? "\tMarkedForDeletion: true" : "";
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tTopic: ").append((Object)tp.topic()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tPartition: ").append((Object)BoxesRunTime.boxToInteger((int)tp.partition())).toString());
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tLeader: ").append(tp.leader().isDefined() ? tp.leader().get() : "none").toString());
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tReplicas: ").append((Object)tp.assignedReplicas().mkString(",")).toString());
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tIsr: ").append((Object)tp.isr().mkString(",")).toString());
        Predef$.MODULE$.print((Object)markedForDeletionString);
        Predef$.MODULE$.println();
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicWhitelist, boolean excludeInternalTopics) {
        Seq seq;
        if (topicWhitelist.isDefined()) {
            Whitelist topicsFilter = new Whitelist((String)topicWhitelist.get());
            seq = (Seq)allTopics.filter((Function1)new Serializable(excludeInternalTopics, topicsFilter){
                public static final long serialVersionUID = 0L;
                private final boolean excludeInternalTopics$1;
                private final Whitelist topicsFilter$1;

                public final boolean apply(String x$13) {
                    return this.topicsFilter$1.isTopicAllowed(x$13, this.excludeInternalTopics$1);
                }
                {
                    this.excludeInternalTopics$1 = excludeInternalTopics$1;
                    this.topicsFilter$1 = topicsFilter$1;
                }
            });
        } else {
            seq = (Seq)allTopics.filterNot((Function1)new Serializable(excludeInternalTopics){
                public static final long serialVersionUID = 0L;
                private final boolean excludeInternalTopics$1;

                public final boolean apply(String x$14) {
                    return Topic.isInternal((String)x$14) && this.excludeInternalTopics$1;
                }
                {
                    this.excludeInternalTopics$1 = excludeInternalTopics$1;
                }
            });
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.topicConfig().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.List<String> apply() {
                return Collections.emptyList();
            }
        })).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$15) {
                return x$15.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        });
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] pair) {
                return this.props$1.setProperty(pair[0].trim(), pair[1].trim());
            }
            {
                this.props$1 = props$1;
            }
        });
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)).toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_2;
        Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.configsToDelete().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.List<String> apply() {
                return Collections.emptyList();
            }
        })).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$16) {
                return x$16.trim();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Properties propsToBeDeleted$1;

            public final Object apply(String x$17) {
                return this.propsToBeDeleted$1.setProperty(x$17, "");
            }
            {
                this.propsToBeDeleted$1 = propsToBeDeleted$1;
            }
        });
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])partitionList).size()).foreach$mVc$sp((Function1)new Serializable(partitionList, ret){
            public static final long serialVersionUID = 0L;
            private final String[] partitionList$1;
            private final LinkedHashMap ret$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[i].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s) {
                        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                Iterable<T> duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
                if (duplicateBrokers.nonEmpty()) {
                    throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition replica lists may not contain duplicate entries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateBrokers.mkString(",")})));
                }
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
            }
            {
                this.partitionList$1 = partitionList$1;
                this.ret$1 = ret$1;
            }
        });
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)original.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, java.util.List<Integer>> apply(Tuple2<Object, List<Object>> f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f._1$mcI$sp()), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)f._2()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(int e) {
                        return e;
                    }
                }, List$.MODULE$.canBuildFrom())).asJava());
            }
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public void askToProceed() {
        Predef$.MODULE$.println((Object)"Are you sure you want to continue? [y/n]");
        if (StdIn$.MODULE$.readLine().equalsIgnoreCase("y")) {
            return;
        }
        Predef$.MODULE$.println((Object)"Ending your session");
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

