/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ee!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t7\u0001A\u000b\u0002#A\u0011!CG\u0007\u0002')\u0011A#F\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\"BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001eL!aG\n\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"AQ\u0004\u0001B\u0001B\u0003%\u0011#A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011!y\u0002A!b\u0001\n\u0003\u0001\u0013A\u00039s_\u0012,8-\u001a:JIV\t\u0011\u0005\u0005\u0002\tE%\u00111%\u0003\u0002\u0005\u0019>tw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\"\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nAbY;se\u0016tG/\u00128uef,\u0012!\u000b\t\u0003U-j\u0011AA\u0005\u0003Y\t\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ss\"Aa\u0006\u0001B\u0001B\u0003%\u0011&A\u0007dkJ\u0014XM\u001c;F]R\u0014\u0018\u0010\t\u0005\ta\u0001\u0011)\u0019!C\u0001c\u0005qa/\u00197jI\u0006$\u0018n\u001c8UsB,W#\u0001\u001a\u0011\u0005)\u001a\u0014B\u0001\u001b\u0003\u000591\u0016\r\\5eCRLwN\u001c+za\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0010m\u0006d\u0017\u000eZ1uS>tG+\u001f9fA!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"RAO\u001e={y\u0002\"A\u000b\u0001\t\u000b99\u0004\u0019A\t\t\u000b}9\u0004\u0019A\u0011\t\u000b\u001d:\u0004\u0019A\u0015\t\u000bA:\u0004\u0019\u0001\u001a\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\u0006aAO]1og\u0006\u001cG/[8ogV\t!\tE\u0002D\u0011*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bq!\\;uC\ndWM\u0003\u0002H\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%#%A\u0003'jgR\u0014UO\u001a4feB\u0011!fS\u0005\u0003\u0019\n\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\"1a\n\u0001Q\u0001\n\t\u000bQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0003b\u0002)\u0001\u0005\u0004%I\u0001K\u0001\rkB$\u0017\r^3e\u000b:$(/\u001f\u0005\u0007%\u0002\u0001\u000b\u0011B\u0015\u0002\u001bU\u0004H-\u0019;fI\u0016sGO]=!\u0011\u0015!\u0006\u0001\"\u0003V\u0003Mi\u0017-\u001f2f-\u0006d\u0017\u000eZ1uK\u0006\u0003\b/\u001a8e)\u00111\u0016LX2\u0011\u0005!9\u0016B\u0001-\n\u0005\u0011)f.\u001b;\t\u000bi\u001b\u0006\u0019A.\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\tAA,\u0003\u0002^\u0013\t)1\u000b[8si\")ql\u0015a\u0001A\u0006Aa-\u001b:tiN+\u0017\u000f\u0005\u0002\tC&\u0011!-\u0003\u0002\u0004\u0013:$\b\"\u00023T\u0001\u0004\t\u0013AB8gMN,G\u000fC\u0003g\u0001\u0011%q-\u0001\ndQ\u0016\u001c7\u000e\u0015:pIV\u001cWM]#q_\u000eDGc\u0001,iS\")!,\u001aa\u00017\")A-\u001aa\u0001C!)1\u000e\u0001C\u0005Y\u0006i1\r[3dWN+\u0017/^3oG\u0016$BAV7oa\")!L\u001ba\u00017\")qN\u001ba\u0001A\u0006q\u0011\r\u001d9f]\u00124\u0015N]:u'\u0016\f\b\"\u00023k\u0001\u0004\t\u0003\"\u0002:\u0001\t\u0013\u0019\u0018AC5o'\u0016\fX/\u001a8dKR\u0019Ao^=\u0011\u0005!)\u0018B\u0001<\n\u0005\u001d\u0011un\u001c7fC:DQ\u0001_9A\u0002\u0001\fq\u0001\\1tiN+\u0017\u000fC\u0003{c\u0002\u0007\u0001-A\u0004oKb$8+Z9\t\u000bq\u0004A\u0011A?\u0002\r\u0005\u0004\b/\u001a8e)\rq\u0018\u0011\u0002\t\u0005\u0011}\f\u0019!C\u0002\u0002\u0002%\u0011aa\u00149uS>t\u0007c\u0001\u0016\u0002\u0006%\u0019\u0011q\u0001\u0002\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\u0005-1\u00101\u0001\u0002\u000e\u0005)!-\u0019;dQB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014M\taA]3d_J$\u0017\u0002BA\f\u0003#\u00111BU3d_J$')\u0019;dQ\"1A\u0010\u0001C\u0001\u00037!rBVA\u000f\u0003C\t\u0019#!\n\u0002*\u00055\u0012\u0011\u0007\u0005\b\u0003?\tI\u00021\u0001\\\u0003\u0015)\u0007o\\2i\u0011\u0019y\u0016\u0011\u0004a\u0001A\"1\u00010!\u0007A\u0002\u0001Dq!a\n\u0002\u001a\u0001\u0007\u0011%A\u0007mCN$H+[7fgR\fW\u000e\u001d\u0005\b\u0003W\tI\u00021\u0001\"\u0003-1\u0017N]:u\u001f\u001a47/\u001a;\t\u000f\u0005=\u0012\u0011\u0004a\u0001C\u0005QA.Y:u\u001f\u001a47/\u001a;\t\u000f\u0005M\u0012\u0011\u0004a\u0001i\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eC\u0004\u00028\u0001!\t!!\u000f\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u000b\u0003\u0007\tY$!\u0012\u0002H\u0005%\u0003\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\u0019\u0015tG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0011\t\u0005=\u0011\u0011I\u0005\u0005\u0003\u0007\n\tB\u0001\u000bF]\u0012$&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM\u001d\u0005\u00075\u0006U\u0002\u0019A.\t\r\u0011\f)\u00041\u0001\"\u0011\u001d\tY%!\u000eA\u0002\u0005\n\u0011\u0002^5nKN$\u0018-\u001c9\t\r\u0005=\u0003\u0001\"\u0001)\u0003\u001d!x.\u00128uefDq!a\u0015\u0001\t\u0003\t)&A\nti\u0006\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002XA)\u0011\u0011LA5\u0015:!\u00111LA3\u001d\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1\u001f\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003OJ\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003W\niG\u0001\u0003MSN$(bAA4\u0013!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014\u0001I7bs\n,7)Y2iKRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006$2AVA;\u0011!\t9(a\u001cA\u0002\u0005e\u0014!\u00057pO>3gm]3u\u001b\u0016$\u0018\rZ1uCB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000\u0011\taa]3sm\u0016\u0014\u0018\u0002BAB\u0003{\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u0014:\u0019\u0001\"a$\n\u0007\u0005E\u0015\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\u000b9J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#K\u0001")
public class ProducerAppendInfo {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq, long offset2) {
        ValidationType validationType;
        block5: {
            block3: {
                block4: {
                    block2: {
                        validationType = this.validationType();
                        if (!ValidationType$None$.MODULE$.equals(validationType)) break block2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!ValidationType$EpochOnly$.MODULE$.equals(validationType)) break block4;
                    this.checkProducerEpoch(producerEpoch, offset2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!ValidationType$Full$.MODULE$.equals(validationType)) break block5;
                this.checkProducerEpoch(producerEpoch, offset2);
                this.checkSequence(producerEpoch, firstSeq, offset2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)validationType);
    }

    private void checkProducerEpoch(short producerEpoch, long offset2) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch at offset ", " is no longer valid in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", ": ", " (request epoch), ", " (current epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset2) {
        int currentLastSeq;
        block9: {
            block8: {
                block7: {
                    if (producerEpoch == this.updatedEntry().producerEpoch()) break block7;
                    if (appendFirstSeq != 0) {
                        if (this.updatedEntry().producerEpoch() != -1) {
                            throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch at offset ", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", ": ", " (request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).toString());
                        }
                        throw new UnknownProducerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found no record of producerId=", " on the broker at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in partition ", ". It is possible that the last message with the producerId=", " has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)"been removed due to hitting the retention limit.").toString());
                    }
                    break block8;
                }
                int n = this.updatedEntry().isEmpty() ? (producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1) : (currentLastSeq = this.updatedEntry().lastSeq());
                if (currentLastSeq == -1 && appendFirstSeq != 0) {
                    throw new UnknownProducerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local producer state matches expected epoch ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for producerId=", " at offset ", " in partition ", ", but the next expected "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToLong((long)offset2), this.topicPartition()}))).append((Object)"sequence number is not known.").toString());
                }
                if (!this.inSequence(currentLastSeq, appendFirstSeq)) break block9;
            }
            return;
        }
        throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " (incoming seq. number), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentLastSeq)}))).toString());
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record2 = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record2.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.baseOffset(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long firstOffset, long lastOffset, boolean isTransactional) {
        this.maybeValidateAppend(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstOffset), this.topicPartition()}))).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset2, long timestamp) {
        Option<Object> option;
        block6: {
            long l;
            block5: {
                block4: {
                    long txnFirstOffset;
                    this.checkProducerEpoch(producerEpoch, offset2);
                    if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
                        throw new TransactionCoordinatorFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).toString());
                    }
                    this.updatedEntry().maybeUpdateEpoch(producerEpoch);
                    option = this.updatedEntry().currentTxnFirstOffset();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.x());
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset2));
                l = offset2;
            }
            long firstOffset = l;
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
            this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
            ControlRecordType controlRecordType = endTxnMarker.controlType();
            ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
            return new CompletedTxn(this.producerId(), firstOffset, offset2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
        }
        throw new MatchError(option);
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1)new Serializable(this, logOffsetMetadata){
            public static final long serialVersionUID = 0L;
            private final LogOffsetMetadata logOffsetMetadata$1;

            public final void apply(TxnMetadata txn) {
                if (txn.firstOffset().messageOffset() == this.logOffsetMetadata$1.messageOffset()) {
                    txn.firstOffset_$eq(this.logOffsetMetadata$1);
                }
            }
            {
                this.logOffsetMetadata$1 = logOffsetMetadata$1;
            }
        });
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerAppendInfo(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().firstSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updatedEntry().currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}))).toString();
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

