/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ProducerIdManager$
implements Logging {
    public static final ProducerIdManager$ MODULE$;
    private final long CurrentVersion;
    private final long PidBlockSize;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ProducerIdManager$();
    }

    private Logger logger$lzycompute() {
        ProducerIdManager$ producerIdManager$ = this;
        synchronized (producerIdManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public long CurrentVersion() {
        return this.CurrentVersion;
    }

    public long PidBlockSize() {
        return this.PidBlockSize;
    }

    public byte[] generateProducerIdBlockJson(ProducerIdBlock producerIdBlock) {
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)this.CurrentVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker"), (Object)BoxesRunTime.boxToInteger((int)producerIdBlock.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_start"), (Object)((Object)BoxesRunTime.boxToLong((long)producerIdBlock.blockStartId())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"block_end"), (Object)((Object)BoxesRunTime.boxToLong((long)producerIdBlock.blockEndId())).toString())}))).asJava());
    }

    public ProducerIdBlock parseProducerIdBlockData(byte[] jsonData) {
        try {
            return (ProducerIdBlock)Json$.MODULE$.parseBytes(jsonData).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonObject apply(JsonValue x$1) {
                    return x$1.asJsonObject();
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Some<ProducerIdBlock> apply(JsonObject js) {
                    int brokerId = BoxesRunTime.unboxToInt((Object)js.apply("broker").to(DecodeJson$DecodeInt$.MODULE$));
                    long blockStart = new StringOps(Predef$.MODULE$.augmentString(js.apply("block_start").to(DecodeJson$DecodeString$.MODULE$))).toLong();
                    long blockEnd = new StringOps(Predef$.MODULE$.augmentString(js.apply("block_end").to(DecodeJson$DecodeString$.MODULE$))).toLong();
                    return new Some((Object)new ProducerIdBlock(brokerId, blockStart, blockEnd));
                }
            }).getOrElse((Function0)new Serializable(jsonData){
                public static final long serialVersionUID = 0L;
                private final byte[] jsonData$1;

                public final Nothing$ apply() {
                    throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the producerId block json ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1})));
                }
                {
                    this.jsonData$1 = jsonData$1;
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            this.fatal((Function0<String>)new Serializable(jsonData){
                public static final long serialVersionUID = 0L;
                private final byte[] jsonData$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read jason data ", " contains producerIds that have exceeded long type limit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1}));
                }
                {
                    this.jsonData$1 = jsonData$1;
                }
            });
            throw numberFormatException;
        }
    }

    private ProducerIdManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.CurrentVersion = 1L;
        this.PidBlockSize = 1000L;
    }
}

