/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetIndex$$anonfun$kafka$log$OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b}3\u0017\u000e\\3\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012AA5p\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\t\u0019KG.\u001a\u0005\nA\u0001\u0011\t\u0011)A\u0005\u0019\u0005\n!BY1tK>3gm]3u\u0013\t\u0001#\u0002C\u0005$\u0001\t\u0005\t\u0015!\u0003\u0013I\u0005aQ.\u0019=J]\u0012,\u0007pU5{K&\u00111E\u0003\u0005\nM\u0001\u0011\t\u0011)A\u0005O)\n\u0001b\u001e:ji\u0006\u0014G.\u001a\t\u0003\u001b!J!!\u000b\b\u0003\u000f\t{w\u000e\\3b]&\u0011aE\u0003\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9z\u0003'\r\u001a\u0011\u0005%\u0001\u0001\"\u0002\f,\u0001\u00049\u0002\"\u0002\u0011,\u0001\u0004a\u0001bB\u0012,!\u0003\u0005\rA\u0005\u0005\bM-\u0002\n\u00111\u0001(\u0011\u0015!\u0004\u0001\"\u00116\u0003%)g\u000e\u001e:z'&TX-F\u0001\u0013\u0011\u00199\u0004\u0001)Q\u0005\u0019\u0005Yq\f\\1ti>3gm]3u\u0011\u0015I\u0004\u0001\"\u0003;\u0003%a\u0017m\u001d;F]R\u0014\u00180F\u0001<!\tIA(\u0003\u0002>\u0005\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007\"B \u0001\t\u0003\u0001\u0015A\u00037bgR|eMZ:fiV\tA\u0002C\u0003C\u0001\u0011\u00051)\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003w\u0011CQ!R!A\u00021\tA\u0002^1sO\u0016$xJ\u001a4tKRDQa\u0012\u0001\u0005\u0002!\u000bQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000fF\u0002J\u0019:\u00032!\u0004&<\u0013\tYeB\u0001\u0004PaRLwN\u001c\u0005\u0006\u001b\u001a\u0003\raO\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0003P\r\u0002\u0007!#A\u0005gKR\u001c\u0007nU5{K\")\u0011\u000b\u0001C\u0005%\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$Hc\u0001\nT7\")A\u000b\u0015a\u0001+\u00061!-\u001e4gKJ\u0004\"AV-\u000e\u0003]S!\u0001W\u000e\u0002\u00079Lw.\u0003\u0002[/\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bq\u0003\u0006\u0019\u0001\n\u0002\u00039DQA\u0018\u0001\u0005\n}\u000b\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u000b\u0004%\u0001\f\u0007\"\u0002+^\u0001\u0004)\u0006\"\u0002/^\u0001\u0004\u0011\u0002\"B2\u0001\t#\"\u0017A\u00039beN,WI\u001c;ssR\u00191(\u001a4\t\u000bQ\u0013\u0007\u0019A+\t\u000bq\u0013\u0007\u0019\u0001\n\t\u000b!\u0004A\u0011A5\u0002\u000b\u0015tGO]=\u0015\u0005mR\u0007\"\u0002/h\u0001\u0004\u0011\u0002\"\u00027\u0001\t\u0003i\u0017AB1qa\u0016tG\rF\u0002ocN\u0004\"!D8\n\u0005At!\u0001B+oSRDQA]6A\u00021\taa\u001c4gg\u0016$\b\"\u0002;l\u0001\u0004\u0011\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000bY\u0004A\u0011I<\u0002\u0011Q\u0014XO\\2bi\u0016$\u0012A\u001c\u0005\u0006s\u0002!\tE_\u0001\u000biJ,hnY1uKR{GC\u00018|\u0011\u0015\u0011\b\u00101\u0001\r\u0011\u0015i\b\u0001\"\u0003\u007f\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0003]~Da!!\u0001}\u0001\u0004\u0011\u0012aB3oiJLWm\u001d\u0005\u0007\u0003\u000b\u0001A\u0011I<\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0005\r\u0003\u0013\u0001\u0001\u0013aA\u0001\u0002\u0013%Q\u0007J\u0001\u0013gV\u0004XM\u001d\u0013nCbLe\u000eZ3y'&TX\r\u0003\u0007\u0002\u000e\u0001\u0001\n1!A\u0001\n\u0013\u0001\u0015%\u0001\ttkB,'\u000f\n2bg\u0016|eMZ:fi\u001e9\u0011\u0011\u0003\u0002\t\u0002\u0005M\u0011aC(gMN,G/\u00138eKb\u00042!CA\u000b\r\u0019\t!\u0001#\u0001\u0002\u0018M1\u0011QCA\r\u0003?\u00012!DA\u000e\u0013\r\tiB\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n\u0005\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\t\u0003\u000f1{wmZ5oO\"9A&!\u0006\u0005\u0002\u00055BCAA\n\u0011)\t\t$!\u0006C\u0002\u0013\u0005\u00131G\u0001\u000bY><w-\u001a:OC6,WCAA\u001b!\u0011\t9$!\u0010\u000f\u00075\tI$C\u0002\u0002<9\ta\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e\u001d!I\u0011QIA\u000bA\u0003%\u0011QG\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0006\u0002J\u0005U\u0011\u0013!C\u0001\u0003\u0017\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA'U\r\u0011\u0012qJ\u0016\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0005v]\u000eDWmY6fI*\u0019\u00111\f\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0005U#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111MA\u000b#\u0003%\t!!\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9GK\u0002(\u0003\u001f\u0002")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    public long kafka$log$OffsetIndex$$_lastOffset = this.kafka$log$OffsetIndex$$lastEntry().offset();

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        OffsetIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        OffsetIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        OffsetIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        OffsetIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        OffsetIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return OffsetIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return OffsetIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        OffsetIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return OffsetIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        OffsetIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return OffsetIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return OffsetIndex$.MODULE$.logger();
    }

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return OffsetIndex$.MODULE$.loggerName();
    }

    public /* synthetic */ int kafka$log$OffsetIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$OffsetIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    public OffsetPosition kafka$log$OffsetIndex$$lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        offsetPosition = this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetOffset$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0) : this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), new Serializable(this, fetchOffset, fetchSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final OffsetPosition fetchOffset$1;
            private final int fetchSize$1;

            public final Option<OffsetPosition> apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.smallestUpperBoundSlotFor(idx, this.fetchOffset$1.position() + this.fetchSize$1, IndexSearchType$.MODULE$.VALUE());
                return slot == -1 ? None$.MODULE$ : new Some((Object)this.$outer.parseEntry(idx, slot));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffset$1 = fetchOffset$1;
                this.fetchSize$1 = fetchSize$1;
            }
        });
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.kafka$log$OffsetIndex$$relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to fetch the ", "th entry from index ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which has size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer._entries())}))).toString());
                }
                return this.$outer.parseEntry(this.$outer.mmap(), this.n$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    public void append(long offset2, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer._entries() == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    OffsetIndex$.MODULE$.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding index entry ", " => ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putInt(this.$outer.relativeOffset(this.offset$1));
                    this.$outer.mmap().putInt(this.position$1);
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to append an offset (", ") to position ", " no larger than"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" the last offset appended (", ") to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.file().getAbsolutePath()}))).toString());
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.KEY());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.kafka$log$OffsetIndex$$lastEntry().offset();
                OffsetIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$log$OffsetIndex$$truncateToEntries$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated index ", " to ", " entries;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.entries$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" position is now ", " and last offset is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$_lastOffset)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this.kafka$log$OffsetIndex$$_lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the last offset is ", " which is less than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToLong((long)super.baseOffset())}))).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index file ", " is corrupt, found ", " bytes which is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"neither positive nor a multiple of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.entrySize())}))).toString());
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        OffsetIndex$.MODULE$.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded index file ", " with maxEntries = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIndexSize = ", ", entries = ", ", lastOffset = ", ", file position = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer._entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

