/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C!+\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aA%oi\"9Q\u0004\u0001b\u0001\n\u0003)\u0012a\u00039beRLG/[8o\u0013\u0012Daa\b\u0001!\u0002\u00131\u0012\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB\u0011\u0001\u0005\u0004%\tAI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgn\u001a\u0005\u0007Y\u0001\u0001\u000b\u0011B\u0012\u0002\u000fQ|\u0007/[22A!9a\u0006\u0001b\u0001\n\u0003y\u0013\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005\u0001\u0004\u0003B\u00197-aj\u0011A\r\u0006\u0003gQ\n\u0011\"[7nkR\f'\r\\3\u000b\u0005UB\u0012AC2pY2,7\r^5p]&\u0011qG\r\u0002\u0004\u001b\u0006\u0004\bCA\u001d=\u001b\u0005Q$BA\u001e\u0005\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003{i\u0012\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0019y\u0004\u0001)A\u0005a\u0005\tBo\u001c9jGF\n5o]5h]6,g\u000e\u001e\u0011\t\u000f\u0005\u0003!\u0019!C\u0001E\u00051Ao\u001c9jGJBaa\u0011\u0001!\u0002\u0013\u0019\u0013a\u0002;pa&\u001c'\u0007\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u00010\u0003A!x\u000e]5de\u0005\u001b8/[4o[\u0016tG\u000f\u0003\u0004H\u0001\u0001\u0006I\u0001M\u0001\u0012i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]R\u0004\u0003bB%\u0001\u0005\u0004%\tAI\u0001\u0007i>\u0004\u0018nY\u001a\t\r-\u0003\u0001\u0015!\u0003$\u0003\u001d!x\u000e]5dg\u0001Bq!\u0014\u0001C\u0002\u0013\u0005q&\u0001\tu_BL7mM!tg&<g.\\3oi\"1q\n\u0001Q\u0001\nA\n\u0011\u0003^8qS\u000e\u001c\u0014i]:jO:lWM\u001c;!\u0011\u001d\t\u0006A1A\u0005\u0002\t\na\u0001^8qS\u000e$\u0004BB*\u0001A\u0003%1%A\u0004u_BL7\r\u000e\u0011\t\u000fU\u0003!\u0019!C\u0001_\u0005\u0001Bo\u001c9jGR\n5o]5h]6,g\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011\u0002\u0019\u0002#Q|\u0007/[25\u0003N\u001c\u0018n\u001a8nK:$\b\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001\u0012\u0002\rQ|\u0007/[26\u0011\u0019Y\u0006\u0001)A\u0005G\u00059Ao\u001c9jGV\u0002\u0003bB/\u0001\u0005\u0004%\taL\u0001\u0011i>\u0004\u0018nY\u001bBgNLwM\\7f]RDaa\u0018\u0001!\u0002\u0013\u0001\u0014!\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8uA!)\u0011\r\u0001C!E\u0006)1/\u001a;VaR\t1\r\u0005\u0002\u0018I&\u0011Q\r\u0007\u0002\u0005+:LG\u000f\u000b\u0002aOB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0006\u0019qN]4\n\u00059L'A\u0002\"fM>\u0014X\rC\u0003q\u0001\u0011\u0005!-A\u000buKN$xK]8oOJ+\u0007\u000f\\5dC\u000e{WO\u001c;)\u0005=\u0014\bC\u00015t\u0013\t!\u0018N\u0001\u0003UKN$\b\"\u0002<\u0001\t\u0003\u0011\u0017!\u0006;fgRl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\r\u0015\u0003kJDQ!\u001f\u0001\u0005\u0002\t\fq\u0003^3ti&s7M]3nK:$\b+\u0019:uSRLwN\\:)\u0005a\u0014\b\"\u0002?\u0001\t\u0003\u0011\u0017A\b;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGo\u00144SKBd\u0017nY1tQ\tY(\u000fC\u0003\u0000\u0001\u0011\u0005!-\u0001\u0010uKN$(+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e^!mYN+'O^3sg\"\u0012aP\u001d\u0005\u0007\u0003\u000b\u0001A\u0011\u00012\u0002EQ,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u!\u0006\u0014H/[1m'\u0016\u0014h/\u001a:tQ\r\t\u0019A\u001d\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003e1\u0018\r\\5eCR,G*Z1eKJ\fe\u000e\u001a*fa2L7-Y:\u0015\u0013\r\fy!!\u0013\u0002L\u0005=\u0003\u0002CA\t\u0003\u0013\u0001\r!a\u0005\u0002\u00115,G/\u00193bi\u0006\u0004B!!\u0006\u0002D9!\u0011qCA\u001f\u001d\u0011\tI\"a\u000e\u000f\t\u0005m\u0011\u0011\u0007\b\u0005\u0003;\tiC\u0004\u0003\u0002 \u0005%b\u0002BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015b!\u0001\u0004=e>|GOP\u0005\u0002Y&\u0019\u00111F6\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r)\u0011q\u0006\u0006\u0004\u0003WY\u0017\u0002BA\u001a\u0003k\taaY8n[>t'bA\u0003\u00020%!\u0011\u0011HA\u001e\u0003!\u0011X-];fgR\u001c(\u0002BA\u001a\u0003kIA!a\u0010\u0002B\u0005\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0006\u0005\u0003s\tY$\u0003\u0003\u0002F\u0005\u001d#!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018M\u0003\u0003\u0002@\u0005\u0005\u0003BB\u000f\u0002\n\u0001\u0007a\u0003C\u0004\u0002N\u0005%\u0001\u0019\u0001\f\u0002!\u0015D\b/Z2uK\u0012dU-\u00193fe&#\u0007\u0002CA)\u0003\u0013\u0001\r!a\u0015\u0002!\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006\u001c\b#BA+\u000372bbA\f\u0002X%\u0019\u0011\u0011\f\r\u0002\rA\u0013X\rZ3g\u0013\u0011\ti&a\u0018\u0003\u0007M+GOC\u0002\u0002ZaAq!a\u0019\u0001\t\u0013\t)'A\ntK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0006\u0004\u0002h\u0005=\u0014\u0011\u0010\t\u0005\u0003S\nY'\u0004\u0002\u0002B%!\u0011QNA!\u0005AiU\r^1eCR\f'+Z:q_:\u001cX\r\u0003\u0005\u0002r\u0005\u0005\u0004\u0019AA:\u0003\u001d\u0011X-];fgR\u0004B!!\u001b\u0002v%!\u0011qOA!\u0005=iU\r^1eCR\f'+Z9vKN$\bBCA>\u0003C\u0002\n\u00111\u0001\u0002~\u0005YA-Z:uS:\fG/[8o!\u00159\u0012qPAB\u0013\r\t\t\t\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#\u0005\u0003\u001dqW\r^<pe.LA!!$\u0002\b\na1k\\2lKR\u001cVM\u001d<fe\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013%\u00111S\u0001\u001eg\u0016tG-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0013\u0016\u0005\u0003{\n9j\u000b\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016!C;oG\",7m[3e\u0015\r\t\u0019\u000bG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAT\u0003;\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$1) {
                return x$1.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$2) {
                return x$2.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$3) {
                return x$3.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$4) {
                return x$4.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$11 = this.topic1();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$12 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$9 = qual$2.getBrokerMetadatas$default$1();
            Option x$10 = qual$2.getBrokerMetadatas$default$2();
            Seq x$13 = qual$2.getBrokerMetadatas(x$9, x$10);
            int x$14 = 2;
            Some x$15 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$16 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$11, x$12, x$13, x$14, (Option)x$15, x$16);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {}
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$3 = this.adminZkClient();
            String x$19 = this.topic5();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$20 = this.topic5Assignment();
            AdminZkClient qual$4 = this.adminZkClient();
            RackAwareMode x$17 = qual$4.getBrokerMetadatas$default$1();
            Option x$18 = qual$4.getBrokerMetadatas$default$2();
            Seq x$21 = qual$4.getBrokerMetadatas(x$17, x$18);
            int x$22 = 2;
            Some x$23 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$24 = qual$3.addPartitions$default$6();
            qual$3.addPartitions(x$19, x$20, x$21, x$22, (Option)x$23, x$24);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (AdminOperationException adminOperationException) {
            Assert.assertTrue((boolean)adminOperationException.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$5 = this.adminZkClient();
        String x$27 = this.topic1();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$28 = this.topic1Assignment();
        AdminZkClient qual$6 = this.adminZkClient();
        RackAwareMode x$25 = qual$6.getBrokerMetadatas$default$1();
        Option x$26 = qual$6.getBrokerMetadatas$default$2();
        Seq x$29 = qual$6.getBrokerMetadatas(x$25, x$26);
        int x$30 = 3;
        Option x$31 = qual$5.addPartitions$default$5();
        boolean x$32 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$27, x$28, x$29, x$30, x$31, x$32);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MetadataResponse.PartitionMetadata x$5) {
                return x$5.partition();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$7 = this.adminZkClient();
        String x$35 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$36 = this.topic2Assignment();
        AdminZkClient qual$8 = this.adminZkClient();
        RackAwareMode x$33 = qual$8.getBrokerMetadatas$default$1();
        Option x$34 = qual$8.getBrokerMetadatas$default$2();
        Seq x$37 = qual$8.getBrokerMetadatas(x$33, x$34);
        int x$38 = 3;
        Some x$39 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$40 = qual$7.addPartitions$default$6();
        qual$7.addPartitions(x$35, x$36, x$37, x$38, (Option)x$39, x$40);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MetadataResponse.PartitionMetadata x$6) {
                return x$6.partition();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$9 = this.adminZkClient();
        String x$43 = this.topic3();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$44 = this.topic3Assignment();
        AdminZkClient qual$10 = this.adminZkClient();
        RackAwareMode x$41 = qual$10.getBrokerMetadatas$default$1();
        Option x$42 = qual$10.getBrokerMetadatas$default$2();
        Seq x$45 = qual$10.getBrokerMetadatas(x$41, x$42);
        int x$46 = 7;
        Option x$47 = qual$9.addPartitions$default$5();
        boolean x$48 = qual$9.addPartitions$default$6();
        qual$9.addPartitions(x$43, x$44, x$45, x$46, x$47, x$48);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$11 = this.adminZkClient();
        String x$51 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$52 = this.topic2Assignment();
        AdminZkClient qual$12 = this.adminZkClient();
        RackAwareMode x$49 = qual$12.getBrokerMetadatas$default$1();
        Option x$50 = qual$12.getBrokerMetadatas$default$2();
        Seq x$53 = qual$12.getBrokerMetadatas(x$49, x$50);
        int x$54 = 3;
        Option x$55 = qual$11.addPartitions$default$5();
        boolean x$56 = qual$11.addPartitions$default$6();
        qual$11.addPartitions(x$51, x$52, x$53, x$54, x$55, x$56);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1)new Serializable(this, partitionId){
            public static final long serialVersionUID = 0L;
            private final int partitionId$1;

            public final boolean apply(MetadataResponse.PartitionMetadata x$7) {
                return x$7.partition() == this.partitionId$1;
            }
            {
                this.partitionId$1 = partitionId$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final SocketServer apply() {
                return this.$outer.anySocketServer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

