/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTest$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTest$$anonfun$bounceServer$1$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0006\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\tQ8.\u0003\u0002\u000e\u0015\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001A\u0002\u0013\u00051$A\u0004tKJ4XM]:\u0016\u0003q\u00012!\b\u0012%\u001b\u0005q\"BA\u0010!\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002C\u0005)1oY1mC&\u00111E\b\u0002\u0004'\u0016\f\bCA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011F\n\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004,\u0001\u0001\u0007I\u0011\u0001\u0017\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003[E\u0002\"AL\u0018\u000e\u0003\u0001J!\u0001\r\u0011\u0003\tUs\u0017\u000e\u001e\u0005\be)\n\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\u0007i\u0001\u0001\u000b\u0015\u0002\u000f\u0002\u0011M,'O^3sg\u0002BQA\u000e\u0001\u0005B]\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002[!\u0012Q'\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nQA[;oSRT\u0011AP\u0001\u0004_J<\u0017B\u0001!<\u0005\u0015\te\r^3s\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0003e\u0019'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:\u0015\u00075\"U\rC\u0003F\u0003\u0002\u0007a)\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u001dSUJ\u0016\b\u0003]!K!!\u0013\u0011\u0002\rA\u0013X\rZ3g\u0013\tYEJA\u0002NCBT!!\u0013\u0011\u0011\u00059#V\"A(\u000b\u0005A\u000b\u0016AB2p[6|gN\u0003\u0002\u0006%*\u00111+P\u0001\u0007CB\f7\r[3\n\u0005U{%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004/~\u0013gB\u0001-^\u001d\tIF,D\u0001[\u0015\tYf!\u0001\u0004=e>|GOP\u0005\u0002C%\u0011a\fI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0017M\u0001\u0003MSN$(B\u00010!!\tq3-\u0003\u0002eA\t\u0019\u0011J\u001c;\t\u000f\u0019\f\u0005\u0013!a\u0001O\u0006Q\u0011-\u001e;i_JL'0\u001a:\u0011\u00079B'.\u0003\u0002jA\t1q\n\u001d;j_:\u0004\"aR6\n\u00051d%AB*ue&tw\rC\u0003C\u0001\u0011%a\u000eF\u0002._FDQ\u0001]7A\u0002\u0019\u000b\u0001\u0004]1si&$\u0018n\u001c8t\u0003:$\u0017i]:jO:lWM\u001c;t\u0011\u0015\u0011X\u000e1\u0001t\u00035\u0011'o\\6fe\u000e{gNZ5hgB\u0019QD\t;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001B;uS2T\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|m\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bu\u0004A\u0011\u0002@\u0002\u0019\t|WO\\2f'\u0016\u0014h/\u001a:\u0015\t5z\u00181\u0001\u0005\u0007\u0003\u0003a\b\u0019\u00012\u0002\u0019Q\f'oZ3u'\u0016\u0014h/\u001a:\t\r\u0005\u0015A\u00101\u0001N\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0002\n\u0001!I!a\u0003\u0002\u001b\u001d,GoQ8oiJ|G\u000e\\3s)\t\ti\u0001E\u0002/Q\u0012Bq!!\u0005\u0001\t\u0013\t\u0019\"A\u0006bo\u0006LG\u000fT3bI\u0016\u0014H#\u00022\u0002\u0016\u0005]\u0001BB#\u0002\u0010\u0001\u0007Q\n\u0003\u0006\u0002\u001a\u0005=\u0001\u0013!a\u0001\u00037\t\u0011\u0002^5nK>,H/T:\u0011\u00079\ni\"C\u0002\u0002 \u0001\u0012A\u0001T8oO\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0012a\u00042p_R\u001cHO]1q'\u0016\u0014h/\u001a:\u0015\u0007)\f9\u0003C\u0005\u0002*\u0005\u0005\u0002\u0013!a\u0001E\u00061!M]8lKJD\u0011\"!\f\u0001\u0005\u0004%\t!a\f\u0002\u001bQ,7\u000f\u001e)beRLG/[8o+\u0005i\u0005bBA\u001a\u0001\u0001\u0006I!T\u0001\u000fi\u0016\u001cH\u000fU1si&$\u0018n\u001c8!\u0011%\t9\u0004\u0001b\u0001\n\u0003\tI$A\fuKN$\b+\u0019:uSRLwN\\!tg&<g.\\3oiV\u0011\u00111\b\t\u0006\u0003{\t\u0019EY\u0007\u0003\u0003\u007fQ1!!\u0011\u001f\u0003%IW.\\;uC\ndW-C\u0002a\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u00111H\u0001\u0019i\u0016\u001cH\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0003\"CA&\u0001\t\u0007I\u0011AA'\u0003q!Xm\u001d;QCJ$\u0018\u000e^5p]B\u0013XMZ3se\u0016$G*Z1eKJ,\u0012A\u0019\u0005\b\u0003#\u0002\u0001\u0015!\u0003c\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]B\u0013XMZ3se\u0016$G*Z1eKJ\u0004\u0003\"CA+\u0001\t\u0007I\u0011AA,\u0003i!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006sG-Q:tS\u001etW.\u001a8u+\t\tI\u0006E\u0004\u0002>\u0005mS*a\u000f\n\u0007-\u000by\u0004\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA-\u0003m!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006sG-Q:tS\u001etW.\u001a8uA!1\u00111\r\u0001\u0005\u0002]\n\u0001\u0004^3ti6+H\u000e^5qY\u0016\u0014%o\\6feN<\u0015N^3oQ\u0011\t\t'a\u001a\u0011\u0007i\nI'C\u0002\u0002lm\u0012A\u0001V3ti\"1\u0011q\u000e\u0001\u0005\u0002]\na\u0003^3ti&sg/\u00197jI\n\u0013xn[3s\u000f&4XM\u001c\u0015\u0005\u0003[\n9\u0007\u0003\u0004\u0002v\u0001!\taN\u0001\u0016i\u0016\u001cHOT8QCJ$\u0018\u000e^5p]N<\u0015N^3oQ\u0011\t\u0019(a\u001a\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u0005QAo\u001c&t_:4\u0015\u000e\\3\u0015\t\u0005}\u00141\u0012\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011=\u0002\u0005%|\u0017\u0002BAE\u0003\u0007\u0013AAR5mK\"A\u0011QRA=\u0001\u0004\ty)\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004BaRAI\u001b&\u0019\u00111\u0013'\u0003\u0007M+G\u000f\u0003\u0004\u0002\u0018\u0002!\taN\u0001\u001ci\u0016\u001cHoU5oO2,Go\u001c8QCJ$\u0018\u000e^5p]\u001eKg/\u001a8)\t\u0005U\u0015q\r\u0005\u0007\u0003;\u0003A\u0011A\u001c\u0002+Q,7\u000f\u001e+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\"\u00111TA4\u0011\u0019\t\u0019\u000b\u0001C\u0001o\u0005!C/Z:u\u001bVdG/\u001b9mKB\u000b'\u000f^5uS>t7oU1nK\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0003\u0002\"\u0006\u001d\u0004BBAU\u0001\u0011\u0005q'\u0001\tuKN$hj\\8q\u000b2,7\r^5p]\"\"\u0011qUA4\u0011\u0019\ty\u000b\u0001C\u0001o\u0005yB/Z:u/&$\bn\u00144gY&tW\r\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1)\t\u00055\u0016q\r\u0005\u0007\u0003k\u0003A\u0011A\u001c\u0002\u0017Q,7\u000f\u001e+j[\u0016|W\u000f\u001e\u0015\u0005\u0003g\u000b9\u0007\u0003\u0004\u0002<\u0002!\taN\u0001\u0011i\u0016\u001cH/Q;uQj4\u0015-\u001b7ve\u0016DC!!/\u0002h!1\u0011\u0011\u0019\u0001\u0005\u0002]\nA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f'j]8o\t\u0006$\u0018\r\u000b\u0003\u0002@\u0006\u001d\u0004BBAd\u0001\u0011\u0005q'A\u0011uKN$()Y:jGB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fW\t\\3di&|g\u000e\u000b\u0003\u0002F\u0006\u001d\u0004\"CAg\u0001E\u0005I\u0011BAh\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uII*\"!!5+\u0007\u001d\f\u0019n\u000b\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017!C;oG\",7m[3e\u0015\r\ty\u000eI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAr\u00033\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\u000fAI\u0001\n\u0013\tI/A\u000bbo\u0006LG\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-(\u0006BA\u000e\u0003'D\u0011\"a<\u0001#\u0003%I!!=\u00023\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003gT3AYAj\u0001")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testPartition()), this.testPartitionAssignment())}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Option<String> option;
        block4: {
            Seq<Properties> brokerConfigs;
            block3: {
                block2: {
                    brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
                    brokerConfigs.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Properties p) {
                            return p.setProperty("auto.leader.rebalance.enable", "false");
                        }
                    });
                    option = authorizer;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String className = (String)some.x();
                    brokerConfigs.foreach((Function1)new Serializable(this, className){
                        public static final long serialVersionUID = 0L;
                        private final String className$1;

                        public final Object apply(Properties p) {
                            return p.setProperty("authorizer.class.name", this.className$1);
                        }
                        {
                            this.className$1 = className$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.createTestTopicAndCluster(topicPartition, brokerConfigs);
            return;
        }
        throw new MatchError(option);
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties b) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        partitionsAndAssignments.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;

            public final void apply(Tuple2<TopicPartition, List<Object>> x0$1) {
                Tuple2<TopicPartition, List<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    List assignment2 = (List)tuple2._2();
                    this.$outer.zkClient().createTopicAssignment(tp.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)assignment2)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partitionsAndAssignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;
            public final scala.collection.immutable.Map partitionsAndAssignments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createTestTopicAndCluster$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.partitionsAndAssignments$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$1;

                            public final boolean apply(Tuple2<TopicPartition, List<Object>> partitionAndAssignment) {
                                LogManager qual$1 = this.server$1.getLogManager();
                                TopicPartition x$2 = (TopicPartition)partitionAndAssignment._1();
                                boolean x$3 = qual$1.getLog$default$2();
                                return qual$1.getLog(x$2, x$3).isDefined();
                            }
                            {
                                this.server$1 = server$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsAndAssignments$1 = partitionsAndAssignments$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replicas for topic test not created";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)new Serializable(this, targetServer){
            public static final long serialVersionUID = 0L;
            private final int targetServer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutting down server ", " so a non-preferred replica becomes leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.targetServer$1)}));
            }
            {
                this.targetServer$1 = targetServer$1;
            }
        });
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)new Serializable(this, targetServer){
            public static final long serialVersionUID = 0L;
            private final int targetServer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting server ", " now that a non-preferred replica is leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.targetServer$1)}));
            }
            {
                this.targetServer$1 = targetServer$1;
            }
        });
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, targetServer, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;
            public final int targetServer$1;
            public final TopicPartition partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$bounceServer$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.metadataCache().getPartitionInfo(this.$outer.partition$1.topic(), this.$outer.partition$1.partition()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$bounceServer$1$$anonfun$apply$mcZ$sp$2 $outer;

                            public final boolean apply(UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
                                return partitionState.isr().contains(BoxesRunTime.boxToInteger((int)this.$outer.kafka$admin$PreferredReplicaLeaderElectionCommandTest$$anonfun$$anonfun$$$outer().targetServer$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$bounceServer$1 kafka$admin$PreferredReplicaLeaderElectionCommandTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetServer$1 = targetServer$1;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replicas for partition ", " not created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1}));
            }
            {
                this.partition$1 = partition$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer p) {
                return p.kafkaController().isActive();
            }
        });
    }

    private int awaitLeader(TopicPartition topicPartition, long timeoutMs) {
        return BoxesRunTime.unboxToInt(TestUtils$.MODULE$.awaitValue(new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PreferredReplicaLeaderElectionCommandTest $outer;
            private final TopicPartition topicPartition$1;

            public final Option<Object> apply() {
                return ((KafkaServer)this.$outer.servers().head()).metadataCache().getPartitionInfo(this.topicPartition$1.topic(), this.topicPartition$1.partition()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
                        return x$1.leader();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        }, (Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting to find current leader of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }, timeoutMs));
    }

    private long awaitLeader$default$2() {
        return 15000L;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)new Serializable(this, port){
            public static final long serialVersionUID = 0L;
            private final int port$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Server bound to port ").append((Object)BoxesRunTime.boxToInteger((int)this.port$1)).toString();
            }
            {
                this.port$1 = port$1;
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)}));
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServer(1), this.bootstrapServer(0)}))}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    @Test
    public void testInvalidBrokerGiven() {
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", "example.com:1234"}), 1000);
            Assert.fail();
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
        }
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1())}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(scala.collection.immutable.Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = TestUtils$.MODULE$.stringifyTopicPartitions(partitions);
        this.debug((Function0<String>)new Serializable(this, jsonString){
            public static final long serialVersionUID = 0L;
            private final String jsonString$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Using json: ").append((Object)this.jsonString$1).toString();
            }
            {
                this.jsonString$1 = jsonString$1;
            }
        });
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.delete();
            throw throwable;
        }
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    @Test
    public void testTopicDoesNotExist() {
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        scala.collection.immutable.Map nonExistentPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentPartition), (Object)nonExistentPartitionAssignment)}));
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw throwable;
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Throwable suppressed = adminCommandFailedException.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof UnknownTopicOrPartitionException));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiplePartitionsSameAssignment() {
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        scala.collection.immutable.Map testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionA), (Object)testPartitionAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionB), (Object)testPartitionAssignment)}));
        this.createTestTopicAndCluster((scala.collection.immutable.Map<TopicPartition, List<Object>>)testPartitionAndAssignment, this.createTestTopicAndCluster$default$2());
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, this.awaitLeader$default$2()));
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.delete();
            throw throwable;
        }
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, this.awaitLeader$default$2()));
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, this.awaitLeader$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            jsonFile.delete();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.delete();
            throw throwable;
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                Assert.fail();
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)adminCommandFailedException.getMessage());
                Throwable suppressed = adminCommandFailedException.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assert.assertTrue((String)suppressed.getMessage(), (boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
                Assert.assertEquals((long)leader2, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}), 2000);
                Assert.fail();
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"Timeout waiting for election results", (Object)adminCommandFailedException.getMessage());
                Assert.assertEquals((long)leader2, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader2 = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader2);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                Assert.fail();
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertEquals((Object)"Not authorized to perform leader election", (Object)adminCommandFailedException.getMessage());
                Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof ClusterAuthorizationException));
                Assert.assertEquals((long)leader2, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), (Set)partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        int preferredReplica = 0;
        scala.collection.immutable.Map brokerRack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$4 = 3;
        String x$5 = this.zkConnect();
        boolean x$6 = false;
        scala.collection.immutable.Map x$7 = brokerRack;
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Map<Object, String>)x$7, x$16, x$17, x$18, x$19).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.adminZkClient().createTopicWithAssignment(topic, new Properties(), (Map)expectedReplicaAssignment);
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        KafkaZkClient x$20 = this.zkClient();
        String x$21 = topic;
        int x$22 = partition;
        None$ x$23 = None$.MODULE$;
        long x$24 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$20, x$21, x$22, x$24, (Option<Object>)x$23, x$25);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        KafkaZkClient x$26 = this.zkClient();
        String x$27 = topic;
        int x$28 = partition;
        Some x$29 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$30 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$26, x$27, x$28, x$30, (Option<Object>)x$29, x$31);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }
}

