/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.api.AbstractConsumerTest$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Before;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ee!B\u0001\u0003\u0003\u00039!\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055Q!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\bKB\u001c\u0018\u000e\\8o+\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"A\u0002#pk\ndW\r\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\tKB\u001c\u0018\u000e\\8oA!)q\u0004\u0001C!A\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\t\u0003CA\f#\u0013\t\u0019\u0003DA\u0002J]RDq!\n\u0001C\u0002\u0013\u0005a%A\u0003u_BL7-F\u0001(!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003mC:<'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012aa\u0015;sS:<\u0007B\u0002\u0019\u0001A\u0003%q%\u0001\u0004u_BL7\r\t\u0005\be\u0001\u0011\r\u0011\"\u0001!\u0003\u0011\u0001\u0018M\u001d;\t\rQ\u0002\u0001\u0015!\u0003\"\u0003\u0015\u0001\u0018M\u001d;!\u0011\u001d1\u0004A1A\u0005\u0002]\n!\u0001\u001e9\u0016\u0003a\u0002\"!O!\u000e\u0003iR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t)QH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\";\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da\u0001\u0012\u0001!\u0002\u0013A\u0014a\u0001;qA!9a\t\u0001b\u0001\n\u0003\u0001\u0013!\u00029beR\u0014\u0004B\u0002%\u0001A\u0003%\u0011%\u0001\u0004qCJ$(\u0007\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u00018\u0003\r!\bO\r\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002\u001d\u0002\tQ\u0004(\u0007\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001'\u0003\u00159'o\\;q\u0011\u0019\u0001\u0006\u0001)A\u0005O\u00051qM]8va\u0002BqA\u0015\u0001C\u0002\u0013\u0005a%\u0001\tqe>$WoY3s\u00072LWM\u001c;JI\"1A\u000b\u0001Q\u0001\n\u001d\n\u0011\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133!\u0011\u001d1\u0006A1A\u0005\u0002\u0019\n\u0001cY8ogVlWM]\"mS\u0016tG/\u00133\t\ra\u0003\u0001\u0015!\u0003(\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\r\t\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0003a9'o\\;q\u001b\u0006D8+Z:tS>tG+[7f_V$Xj]\u000b\u00029B\u0011q#X\u0005\u0003=b\u0011A\u0001T8oO\"1\u0001\r\u0001Q\u0001\nq\u000b\u0011d\u001a:pkBl\u0015\r_*fgNLwN\u001c+j[\u0016|W\u000f^'tA!)!\r\u0001C)G\u00069\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003I\u001e\u0004\"aF3\n\u0005\u0019D\"\u0001B+oSRDQ\u0001[1A\u0002%\f!\u0002\u001d:pa\u0016\u0014H/[3t!\tQW.D\u0001l\u0015\ta7&\u0001\u0003vi&d\u0017B\u00018l\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006a\u0002!\t%]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002I\"\u0012qn\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m~\nQA[;oSRL!\u0001_;\u0003\r\t+gm\u001c:f\r\u0011Q\b\u0001C>\u0003AQ+7\u000f^\"p]N,X.\u001a:SK\u0006\u001c8/[4o[\u0016tG\u000fT5ti\u0016tWM]\n\u0004sr|\bC\u0001\u0015~\u0013\tq\u0018F\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003!\u0019wN\\:v[\u0016\u0014(bAA\u0005y\u000591\r\\5f]R\u001c\u0018\u0002BA\u0007\u0003\u0007\u0011\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\"1q\"\u001fC\u0001\u0003#!\"!a\u0005\u0011\u0007\u0005U\u00110D\u0001\u0001\u0011!\tI\"\u001fa\u0001\n\u0003\u0001\u0013aD2bY2\u001cHk\\!tg&<g.\u001a3\t\u0013\u0005u\u0011\u00101A\u0005\u0002\u0005}\u0011aE2bY2\u001cHk\\!tg&<g.\u001a3`I\u0015\fHc\u00013\u0002\"!I\u00111EA\u000e\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004bBA\u0014s\u0002\u0006K!I\u0001\u0011G\u0006dGn\u001d+p\u0003N\u001c\u0018n\u001a8fI\u0002B\u0001\"a\u000bz\u0001\u0004%\t\u0001I\u0001\u000fG\u0006dGn\u001d+p%\u00164xn[3e\u0011%\ty#\u001fa\u0001\n\u0003\t\t$\u0001\ndC2d7\u000fV8SKZ|7.\u001a3`I\u0015\fHc\u00013\u00024!I\u00111EA\u0017\u0003\u0003\u0005\r!\t\u0005\b\u0003oI\b\u0015)\u0003\"\u0003=\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012\u0004\u0003bBA\u001es\u0012\u0005\u0011QH\u0001\u0015_:\u0004\u0016M\u001d;ji&|gn]!tg&<g.\u001a3\u0015\u0007\u0011\fy\u0004\u0003\u0005\u0002B\u0005e\u0002\u0019AA\"\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005U\u0006\u0015\u0003(C\u0002\u0002H-\u0014!bQ8mY\u0016\u001cG/[8o\u0011\u001d\tY%\u001fC\u0001\u0003\u001b\n1c\u001c8QCJ$\u0018\u000e^5p]N\u0014VM^8lK\u0012$2\u0001ZA(\u0011!\t\t%!\u0013A\u0002\u0005\r\u0003bBA*\u0001\u0011E\u0011QK\u0001\u001aGJ,\u0017\r^3D_:\u001cX/\\3s/&$\bn\u0012:pkBLE\r\u0006\u0003\u0002X\u0005%\u0004\u0003CA\u0001\u00033\ni&!\u0018\n\t\u0005m\u00131\u0001\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u000b]\ty&a\u0019\n\u0007\u0005\u0005\u0004DA\u0003BeJ\f\u0017\u0010E\u0002\u0018\u0003KJ1!a\u001a\u0019\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005-\u0014\u0011\u000ba\u0001\u0003[\nqa\u001a:pkBLE\r\u0005\u0003\u0002p\u0005UdbA\f\u0002r%\u0019\u00111\u000f\r\u0002\rA\u0013X\rZ3g\u0013\rq\u0013q\u000f\u0006\u0004\u0003gB\u0002bBA>\u0001\u0011E\u0011QP\u0001\fg\u0016tGMU3d_J$7\u000f\u0006\u0005\u0002\u0000\u0005\r\u00161VAX!\u0019\t\t)!%\u0002\u0018:!\u00111QAG\u001d\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\r\u00051AH]8pizJ\u0011!G\u0005\u0004\u0003\u001fC\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003'\u000b)JA\u0002TKFT1!a$\u0019!!\tI*a(\u0002^\u0005uSBAAN\u0015\u0011\ti*a\u0002\u0002\u0011A\u0014x\u000eZ;dKJLA!!)\u0002\u001c\nq\u0001K]8ek\u000e,'OU3d_J$\u0007\u0002CAO\u0003s\u0002\r!!*\u0011\u0011\u0005e\u0015qUA/\u0003;JA!!+\u0002\u001c\ni1*\u00194lCB\u0013x\u000eZ;dKJDq!!,\u0002z\u0001\u0007\u0011%\u0001\u0006ok6\u0014VmY8sINDaANA=\u0001\u0004A\u0004bBAZ\u0001\u0011E\u0011QW\u0001\u0018G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$\u0012\u0003ZA\\\u0003\u007f\u000b\t-!2\u0002J\u00065\u0017Q\\Ap\u0011!\t)!!-A\u0002\u0005e\u0006\u0003CA\u0001\u0003w\u000bi&!\u0018\n\t\u0005u\u00161\u0001\u0002\t\u0007>t7/^7fe\"9\u0011QVAY\u0001\u0004\t\u0003bBAb\u0003c\u0003\r!I\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0011%\t9-!-\u0011\u0002\u0003\u0007\u0011%\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD\u0011\"a3\u00022B\u0005\t\u0019\u0001/\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0002P\u0006E\u0006\u0013!a\u0001\u0003#\fQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAj\u00033l!!!6\u000b\u0007\u0005]'(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u00037\f)NA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\tm\u0005E\u0006\u0013!a\u0001q!I\u0011\u0011]AY!\u0003\u0005\r!I\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011\u001d\t)\u000f\u0001C\t\u0003O\fabY8ogVlWMU3d_J$7/\u0006\u0004\u0002j\n\u0015!\u0011\u0004\u000b\t\u0003W\u0014iB!\t\u0003$A1\u0011Q^A|\u0003wl!!a<\u000b\t\u0005E\u00181_\u0001\b[V$\u0018M\u00197f\u0015\r\t)\u0010G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA}\u0003_\u00141\"\u0011:sCf\u0014UO\u001a4feBA\u0011\u0011AA\u007f\u0005\u0003\u00119\"\u0003\u0003\u0002\u0000\u0006\r!AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0005\u0005\u0007\u0011)\u0001\u0004\u0001\u0005\u0011\t\u001d\u00111\u001db\u0001\u0005\u0013\u0011\u0011aS\t\u0005\u0005\u0017\u0011\t\u0002E\u0002\u0018\u0005\u001bI1Aa\u0004\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u0006B\n\u0013\r\u0011)\u0002\u0007\u0002\u0004\u0003:L\b\u0003\u0002B\u0002\u00053!\u0001Ba\u0007\u0002d\n\u0007!\u0011\u0002\u0002\u0002-\"A\u0011QAAr\u0001\u0004\u0011y\u0002\u0005\u0005\u0002\u0002\u0005m&\u0011\u0001B\f\u0011\u001d\ti+a9A\u0002\u0005B\u0011\"!9\u0002dB\u0005\t\u0019A\u0011\t\u000f\t\u001d\u0002\u0001\"\u0005\u0003*\u000592/\u001a8e\u0003:$\u0017i^1ji\u0006\u001b\u0018P\\2D_6l\u0017\u000e^\u000b\u0007\u0005W\u0011\u0019Da\u000e\u0015\u000b\u0011\u0014iC!\u000f\t\u0011\u0005\u0015!Q\u0005a\u0001\u0005_\u0001\u0002\"!\u0001\u0002<\nE\"Q\u0007\t\u0005\u0005\u0007\u0011\u0019\u0004\u0002\u0005\u0003\b\t\u0015\"\u0019\u0001B\u0005!\u0011\u0011\u0019Aa\u000e\u0005\u0011\tm!Q\u0005b\u0001\u0005\u0013A!Ba\u000f\u0003&A\u0005\t\u0019\u0001B\u001f\u0003)ygMZ:fiN|\u0005\u000f\u001e\t\u0006/\t}\"1I\u0005\u0004\u0005\u0003B\"AB(qi&|g\u000eE\u0004\u0002p\t\u0015\u0003H!\u0013\n\t\t\u001d\u0013q\u000f\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0001\u0005\u0017JAA!\u0014\u0002\u0004\t\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\tE\u0003\u0001\"\u0001\u0003T\u0005a\u0013\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u000b\u000f\u0005+\u001aid!\u0011\u0004F\r%31JB(!\u001d9\"q\u000bB.\u0005CJ1A!\u0017\u0019\u0005\u0019!V\u000f\u001d7feA1\u0011Q\u001eB/\u0003/JAAa\u0018\u0002p\n1!)\u001e4gKJ\u0004b!!<\u0003^\t\r\u0004\u0003BA\u000b\u0005K2aAa\u001a\u0001\u0011\t%$\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7feN!!Q\rB6!\u0011\u0011iGa\u001d\u000e\u0005\t=$b\u0001B9\t\u0005)Q\u000f^5mg&!!Q\u000fB8\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0017\u0005\u0015!Q\rB\u0001B\u0003%\u0011\u0011\u0018\u0005\f\u0005w\u0012)G!A!\u0002\u0013\u0011i(A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004b!!!\u0003\u0000\u00055\u0014\u0002\u0002BA\u0003+\u0013A\u0001T5ti\"Y!Q\u0011B3\u0005\u0003\u0005\u000b\u0011\u0002BD\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p\u0003N\u001c\u0018n\u001a8\u0011\u000b\u0005=$\u0011\u0012\u001d\n\t\t-\u0015q\u000f\u0002\u0004'\u0016$\bbB\b\u0003f\u0011\u0005!q\u0012\u000b\t\u0005G\u0012\tJa%\u0003\u0016\"A\u0011Q\u0001BG\u0001\u0004\tI\f\u0003\u0005\u0003|\t5\u0005\u0019\u0001B?\u0011!\u0011)I!$A\u0002\t\u001d\u0005bB\b\u0003f\u0011\u0005!\u0011\u0014\u000b\u0007\u0005G\u0012YJ!(\t\u0011\u0005\u0015!q\u0013a\u0001\u0003sC\u0001Ba\u001f\u0003\u0018\u0002\u0007!Q\u0010\u0005\b\u001f\t\u0015D\u0011\u0001BQ)\u0019\u0011\u0019Ga)\u0003&\"A\u0011Q\u0001BP\u0001\u0004\tI\f\u0003\u0005\u0003\u0006\n}\u0005\u0019\u0001BD\u0011)\u0011IK!\u001aA\u0002\u0013\u0005!1V\u0001\u0010i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]V\u0011!Q\u0016\t\u0006/\t}\"q\u0016\t\u0005\u0003\u0003\u0013\t,\u0003\u0003\u00034\u0006U%!\u0003+ie><\u0018M\u00197f\u0011)\u00119L!\u001aA\u0002\u0013\u0005!\u0011X\u0001\u0014i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u0004I\nm\u0006BCA\u0012\u0005k\u000b\t\u00111\u0001\u0003.\"I!q\u0018B3A\u0003&!QV\u0001\u0011i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]\u0002BCA!0\u0003DB\u0019qC!2\n\u0007\t\u001d\u0007D\u0001\u0005w_2\fG/\u001b7f\u0011%\u0011YM!\u001aA\u0002\u0013\u0005\u0001%\u0001\tsK\u000e,\u0017N^3e\u001b\u0016\u001c8/Y4fg\"Q!q\u001aB3\u0001\u0004%\tA!5\u0002)I,7-Z5wK\u0012lUm]:bO\u0016\u001cx\fJ3r)\r!'1\u001b\u0005\n\u0003G\u0011i-!AA\u0002\u0005B\u0001Ba6\u0003f\u0001\u0006K!I\u0001\u0012e\u0016\u001cW-\u001b<fI6+7o]1hKN\u0004\u0003\u0006\u0002Bk\u0005\u0007D!B!8\u0003f\t\u0007I\u0011\u0002Bp\u0003M\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8u+\t\u0011\t\u000fE\u0003\u0002n\n\r\b(\u0003\u0003\u0003\f\u0006=\b\"\u0003Bt\u0005K\u0002\u000b\u0011\u0002Bq\u0003Q\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8uA!Q!1\u001eB3\u0001\u0004%IA!<\u0002'M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3\u0016\u0005\t=\bcA\f\u0003r&\u0019!1\u001f\r\u0003\u000f\t{w\u000e\\3b]\"Q!q\u001fB3\u0001\u0004%IA!?\u0002/M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3`I\u0015\fHc\u00013\u0003|\"Q\u00111\u0005B{\u0003\u0003\u0005\rAa<\t\u0013\t}(Q\rQ!\n\t=\u0018\u0001F:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$\u0007\u0005\u000b\u0003\u0003~\n\r\u0007BCB\u0003\u0005K\u0002\r\u0011\"\u0003\u0004\b\u0005\u0011Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o+\t\u0011i\b\u0003\u0006\u0004\f\t\u0015\u0004\u0019!C\u0005\u0007\u001b\ta\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0004I\u000e=\u0001BCA\u0012\u0007\u0013\t\t\u00111\u0001\u0003~!I11\u0003B3A\u0003&!QP\u0001\u0014i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g\u000e\t\u0005\u000b\u0007/\u0011)G1A\u0005\u0002\re\u0011!\u0005:fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feV\tq\u0010\u0003\u0005\u0004\u001e\t\u0015\u0004\u0015!\u0003\u0000\u0003I\u0011XMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u0011\t\u0011\r\u0005\"Q\rC\u0001\u0007G\t!cY8ogVlWM]!tg&<g.\\3oiR\u0011!q\u0011\u0005\t\u0007O\u0011)\u0007\"\u0001\u0004*\u0005I1/\u001e2tGJL'-\u001a\u000b\u0004I\u000e-\u0002\u0002CB\u0017\u0007K\u0001\rA! \u0002)9,w\u000fV8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f\u0011!\u0019\tD!\u001a\u0005\u0002\t5\u0018aG5t'V\u00147o\u0019:jE\u0016\u0014V-];fgR\u0004&o\\2fgN,G\r\u0003\u0005\u00046\t\u0015D\u0011IB\u001c\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0003p\"911\bB3\t\u0003\n\u0018A\u00023p/>\u00148\u000eC\u0004\u0004@\t=\u0003\u0019A\u0011\u0002'9,Xn\u00144D_:\u001cX/\\3sgR{\u0017\t\u001a3\t\u0011\r\r#q\na\u0001\u00057\nQbY8ogVlWM]$s_V\u0004\b\u0002CB$\u0005\u001f\u0002\rA!\u0019\u0002\u001f\r|gn];nKJ\u0004v\u000e\u001c7feND\u0001Ba\u001f\u0003P\u0001\u0007!Q\u0010\u0005\t\u0007\u001b\u0012y\u00051\u0001\u0003\b\u0006i1/\u001e2tGJL\u0007\u000f^5p]ND\u0011B\u0014B(!\u0003\u0005\r!!\u001c\t\u000f\rM\u0003\u0001\"\u0001\u0004V\u0005\u0019\u0012\r\u001a3D_:\u001cX/\\3sgR{wI]8vaRq!QKB,\u00073\u001aYf!\u0018\u0004`\r\u0005\u0004bBB \u0007#\u0002\r!\t\u0005\t\u0007\u0007\u001a\t\u00061\u0001\u0003\\!A1qIB)\u0001\u0004\u0011\t\u0007\u0003\u0005\u0003|\rE\u0003\u0019\u0001B?\u0011!\u0019ie!\u0015A\u0002\t\u001d\u0005\"\u0003(\u0004RA\u0005\t\u0019AA7\u0011\u001d\u0019)\u0007\u0001C\u0001\u0007O\nqC^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;\u0015\u0013\u0011\u001cIga\u001b\u0004n\rM\u0004\u0002CB$\u0007G\u0002\rA!\u0019\t\u0011\r531\ra\u0001\u0005\u000fC!ba\u001c\u0004dA\u0005\t\u0019AB9\u0003\ri7o\u001a\t\u0006/\t}\u0012Q\u000e\u0005\n\u0007k\u001a\u0019\u0007%AA\u0002q\u000b\u0001b^1jiRKW.\u001a\u0005\b\u0007s\u0002A\u0011AB>\u0003\u0001\u001aXOY:de&\u0014WmQ8ogVlWM]!oIN#\u0018M\u001d;Q_2d\u0017N\\4\u0015\u0011\t\r4QPB@\u0007\u0003C\u0001\"!\u0002\u0004x\u0001\u0007\u0011\u0011\u0018\u0005\t\u0005w\u001a9\b1\u0001\u0003~!Q!QQB<!\u0003\u0005\rAa\"\t\u000f\r\u0015\u0005\u0001\"\u0005\u0004\b\u0006q\u0011m^1jiJ+'-\u00197b]\u000e,G#\u00023\u0004\n\u000em\u0005\u0002CA\u0003\u0007\u0007\u0003\raa#1\r\r55\u0011SBL!!\t\t!a/\u0004\u0010\u000eU\u0005\u0003\u0002B\u0002\u0007##Aba%\u0004\n\u0006\u0005\t\u0011!B\u0001\u0005\u0013\u00111a\u0018\u00132!\u0011\u0011\u0019aa&\u0005\u0019\re5\u0011RA\u0001\u0002\u0003\u0015\tA!\u0003\u0003\u0007}##\u0007\u0003\u0005\u0004\u0018\r\r\u0005\u0019AA\n\u0011\u001d\u0019y\n\u0001C\t\u0007C\u000b\u0011#\u001a8tkJ,gj\u001c*fE\u0006d\u0017M\\2f)\u0015!71UB[\u0011!\t)a!(A\u0002\r\u0015\u0006GBBT\u0007W\u001b\t\f\u0005\u0005\u0002\u0002\u0005m6\u0011VBX!\u0011\u0011\u0019aa+\u0005\u0019\r561UA\u0001\u0002\u0003\u0015\tA!\u0003\u0003\u0007}#3\u0007\u0005\u0003\u0003\u0004\rEF\u0001DBZ\u0007G\u000b\t\u0011!A\u0003\u0002\t%!aA0%i!A1qCBO\u0001\u0004\t\u0019B\u0002\u0004\u0004:\u0002A11\u0018\u0002\u001c\u0007>,h\u000e^\"p]N,X.\u001a:D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0014\u000b\r]Fp!0\u0011\t\u0005\u00051qX\u0005\u0005\u0007\u0003\f\u0019A\u0001\u000bPM\u001a\u001cX\r^\"p[6LGoQ1mY\n\f7m\u001b\u0005\b\u001f\r]F\u0011ABc)\t\u00199\r\u0005\u0003\u0002\u0016\r]\u0006\"CBf\u0007o\u0003\r\u0011\"\u0001!\u00031\u0019XoY2fgN\u001cu.\u001e8u\u0011)\u0019yma.A\u0002\u0013\u00051\u0011[\u0001\u0011gV\u001c7-Z:t\u0007>,h\u000e^0%KF$2\u0001ZBj\u0011%\t\u0019c!4\u0002\u0002\u0003\u0007\u0011\u0005\u0003\u0005\u0004X\u000e]\u0006\u0015)\u0003\"\u00035\u0019XoY2fgN\u001cu.\u001e8uA!I11\\B\\\u0001\u0004%\t\u0001I\u0001\nM\u0006LGnQ8v]RD!ba8\u00048\u0002\u0007I\u0011ABq\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR\u0019Ama9\t\u0013\u0005\r2Q\\A\u0001\u0002\u0004\t\u0003\u0002CBt\u0007o\u0003\u000b\u0015B\u0011\u0002\u0015\u0019\f\u0017\u000e\\\"pk:$\b\u0005\u0003\u0006\u0004l\u000e]\u0006\u0019!C\u0001\u0007[\f\u0011\u0002\\1ti\u0016\u0013(o\u001c:\u0016\u0005\r=\b#B\f\u0003@\rE\b\u0003BAA\u0007gLAa!>\u0002\u0016\nIQ\t_2faRLwN\u001c\u0005\u000b\u0007s\u001c9\f1A\u0005\u0002\rm\u0018!\u00047bgR,%O]8s?\u0012*\u0017\u000fF\u0002e\u0007{D!\"a\t\u0004x\u0006\u0005\t\u0019ABx\u0011%!\taa.!B\u0013\u0019y/\u0001\u0006mCN$XI\u001d:pe\u0002B\u0001\u0002\"\u0002\u00048\u0012\u0005CqA\u0001\u000b_:\u001cu.\u001c9mKR,G#\u00023\u0005\n\u0011E\u0001\u0002\u0003C\u0006\t\u0007\u0001\r\u0001\"\u0004\u0002\u000f=4gm]3ugB1!\u000eb\u00049\u0005\u0013J1Aa\u0012l\u0011!!\u0019\u0002b\u0001A\u0002\rE\u0018!C3yG\u0016\u0004H/[8o\u0011\u001d!9\u0002\u0001C\u0001\t3\t!$[:QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tGOV1mS\u0012$bAa<\u0005\u001c\u0011\u0005\u0002\u0002\u0003C\u000f\t+\u0001\r\u0001b\b\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\t\u0007\u0003[\u0014iFa\"\t\u0011\u0005\u0005CQ\u0003a\u0001\u0005\u000fC\u0011\u0002\"\n\u0001#\u0003%\t\u0002b\n\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0011%\"fA\u0011\u0005,-\u0012AQ\u0006\t\u0005\t_!I$\u0004\u0002\u00052)!A1\u0007C\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00058a\t!\"\u00198o_R\fG/[8o\u0013\u0011!Y\u0004\"\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0005@\u0001\t\n\u0011\"\u0005\u0005B\u0005\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011A1\t\u0016\u00049\u0012-\u0002\"\u0003C$\u0001E\u0005I\u0011\u0003C%\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!YE\u000b\u0003\u0002R\u0012-\u0002\"\u0003C(\u0001E\u0005I\u0011\u0003C)\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t!\u0019FK\u00029\tWA\u0011\u0002b\u0016\u0001#\u0003%\t\u0002b\n\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001d\t\u0013\u0011m\u0003!%A\u0005\u0012\u0011u\u0013\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU1Aq\u0005C0\tC\"\u0001Ba\u0002\u0005Z\t\u0007!\u0011\u0002\u0003\t\u00057!IF1\u0001\u0003\n!IAQ\r\u0001\u0012\u0002\u0013EAqM\u0001\"g\u0016tG-\u00118e\u0003^\f\u0017\u000e^!ts:\u001c7i\\7nSR$C-\u001a4bk2$HEM\u000b\u0007\tS\"i\u0007b\u001c\u0016\u0005\u0011-$\u0006\u0002B\u001f\tW!\u0001Ba\u0002\u0005d\t\u0007!\u0011\u0002\u0003\t\u00057!\u0019G1\u0001\u0003\n!IA1\u000f\u0001\u0012\u0002\u0013\u0005AQO\u00017C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$HEN\u000b\u0003\toRC!!\u001c\u0005,!IA1\u0010\u0001\u0012\u0002\u0013\u0005AQO\u0001\u001eC\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%m!IAq\u0010\u0001\u0012\u0002\u0013\u0005A\u0011Q\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$HeM\u000b\u0003\t\u0007SCa!\u001d\u0005,!IAq\u0011\u0001\u0012\u0002\u0013\u0005A\u0011I\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$H\u0005\u000e\u0005\n\t\u0017\u0003\u0011\u0013!C\u0001\t\u001b\u000b!f];cg\u000e\u0014\u0018NY3D_:\u001cX/\\3s\u0003:$7\u000b^1siB{G\u000e\\5oO\u0012\"WMZ1vYR$3'\u0006\u0002\u0005\u0010*\"!q\u0011C\u0016\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.groupMaxSessionTimeoutMs())).toString());
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        Properties x$6 = groupOverrideConfig;
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        List<String> x$9 = this.createConsumer$default$4();
        return this.createConsumer(x$7, x$8, x$6, x$9);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records2;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records2 = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records2, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records2 = new ArrayBuffer();
        Consumer<K, V> x$10 = consumer;
        Serializable x$11 = new Serializable(this, numRecords, maxPollRecords, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final int numRecords$1;
            private final int maxPollRecords$1;
            private final ArrayBuffer records$2;

            public final boolean apply(ConsumerRecords<K, V> polledRecords) {
                return this.$outer.kafka$api$AbstractConsumerTest$$pollAction$1(polledRecords, this.numRecords$1, this.maxPollRecords$1, this.records$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
                this.maxPollRecords$1 = maxPollRecords$1;
                this.records$2 = records$2;
            }
        };
        long x$12 = 60000L;
        Serializable x$13 = new Serializable(this, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final int numRecords$1;
            private final ArrayBuffer records$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out before consuming expected ", " records. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numRecords$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number consumed was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$2.size())}))).toString();
            }
            {
                this.numRecords$1 = numRecords$1;
                this.records$2 = records$2;
            }
        };
        TestUtils$.MODULE$.pollRecordsUntilTrue(x$10, x$11, (Function0<String>)x$13, x$12);
        return records2;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            public final /* synthetic */ AbstractConsumerTest $outer;
            private final Consumer consumer$1;
            private final Option offsetsOpt$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Exception exception2 = exception;
                if (exception2 instanceof RetriableCommitFailedException) {
                    this.kafka$api$AbstractConsumerTest$RetryCommitCallback$$$outer().kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.consumer$1, this.offsetsOpt$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.isComplete_$eq(true);
                    this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$RetryCommitCallback$$$outer() {
                return this.$outer;
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Consumer consumer$1, Option offsetsOpt$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, consumer, offsetsOpt);
        this.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, consumer, offsetsOpt);
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)new Serializable(this, commitCallback){
            public static final long serialVersionUID = 0L;
            private final Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.commitCallback$1.isComplete();
            }
            {
                this.commitCallback$1 = commitCallback$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to observe commit callback before timeout";
            }
        }, 10000L);
        Assert.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$1;
            private final List topicsToSubscribe$1;
            private final String group$1;

            public final Buffer<ConsumerAssignmentPoller> apply(int _) {
                KafkaConsumer<byte[], byte[]> consumer = this.$outer.createConsumerWithGroupId(this.group$1);
                this.consumerGroup$1.$plus$eq(consumer);
                return this.consumerPollers$1.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$1, this.$outer.subscribeConsumerAndStartPolling$default$3())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$1 = consumerPollers$1;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
                this.group$1 = group$1;
            }
        });
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions, assignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Buffer consumerPollers$2;
            private final scala.collection.immutable.Set subscriptions$1;
            public final Buffer assignments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.assignments$1.clear();
                this.consumerPollers$2.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateGroupAssignment$1 $outer;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(ConsumerAssignmentPoller x$1) {
                        return this.$outer.assignments$1.$plus$eq(x$1.consumerAssignment());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)this.assignments$1, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerPollers$2 = consumerPollers$2;
                this.subscriptions$1 = subscriptions$1;
                this.assignments$1 = assignments$1;
            }
        }, (Function0<String>)new Serializable(this, subscriptions, msg, assignments){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Set subscriptions$1;
            private final Option msg$1;
            public final Buffer assignments$1;

            public final String apply() {
                return (String)this.msg$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateGroupAssignment$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", ". Instead, got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.subscriptions$1, this.$outer.assignments$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.subscriptions$1 = subscriptions$1;
                this.msg$1 = msg$1;
                this.assignments$1 = assignments$1;
            }
        }, waitTime, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int numReassignments = rebalanceListener.callsToAssigned();
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)new Serializable(this, rebalanceListener, numReassignments){
            public static final long serialVersionUID = 0L;
            private final TestConsumerReassignmentListener rebalanceListener$1;
            private final int numReassignments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.rebalanceListener$1.callsToAssigned() > this.numReassignments$1;
            }
            {
                this.rebalanceListener$1 = rebalanceListener$1;
                this.numReassignments$1 = numReassignments$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out before expected rebalance completed";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assert.assertEquals((long)initialRevokeCalls, (long)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(scala.collection.immutable.Set<TopicPartition> assignment2) {
                return assignment2.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            scala.collection.immutable.Set uniqueAssignedPartitions;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, scala.collection.immutable.Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = uniqueAssignedPartitions = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Set<TopicPartition> apply(scala.collection.immutable.Set<TopicPartition> x$4, scala.collection.immutable.Set<TopicPartition> x$5) {
                    return (scala.collection.immutable.Set)x$4.$plus$plus(x$5);
                }
            });
            scala.collection.immutable.Set<TopicPartition> set2 = partitions;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }
        return false;
    }

    public final boolean kafka$api$AbstractConsumerTest$$pollAction$1(ConsumerRecords polledRecords, int numRecords$1, int maxPollRecords$1, ArrayBuffer records$2) {
        Assert.assertTrue((((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback2, Consumer consumer$1, Option offsetsOpt$1) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = offsetsOpt$1;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)some.x();
                    consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                consumer$1.commitAsync(callback2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 30000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
            }
            catch (Throwable throwable) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)throwable));
                throw throwable;
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0])));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0])));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
            } else {
                consumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(partitionsToAssign).asJava());
            }
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
                this.lastError_$eq((Option<Exception>)new Some((Object)exception));
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

