/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.cluster.ReplicaTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\tY!+\u001a9mS\u000e\fG+Z:u\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051A/\u001c9ESJ,\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t!![8\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0005\r&dW\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\bi6\u0004H)\u001b:!\u0011\u001d\t\u0003A1A\u0005\u0002U\ta\u0001\\8h\t&\u0014\bBB\u0012\u0001A\u0003%a#A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005!A/[7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0015)H/\u001b7t\u0013\ta\u0013F\u0001\u0005N_\u000e\\G+[7f\u0011\u0019q\u0003\u0001)A\u0005O\u0005)A/[7fA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\u0007\u000e\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biNDa!\u000f\u0001!\u0002\u0013\u0011\u0014!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA!I1\b\u0001a\u0001\u0002\u0004%\t\u0001P\u0001\u0004Y><W#A\u001f\u0011\u0005y\u0002U\"A \u000b\u0005m\"\u0011BA!@\u0005\raun\u001a\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\u0002\u0011\u000bq\u0001\\8h?\u0012*\u0017\u000f\u0006\u0002F\u0011B\u0011\u0011BR\u0005\u0003\u000f*\u0011A!\u00168ji\"9\u0011JQA\u0001\u0002\u0004i\u0014a\u0001=%c!11\n\u0001Q!\nu\nA\u0001\\8hA!)Q\n\u0001C\u0001\u001d\u0006)1/\u001a;vaR\tQ\t\u000b\u0002M!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002+\u0006\u0019qN]4\n\u0005]\u0013&A\u0002\"fM>\u0014X\rC\u0003Z\u0001\u0011\u0005a*\u0001\u0005uK\u0006\u0014Hi\\<oQ\tA6\f\u0005\u0002R9&\u0011QL\u0015\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006?\u0002!\tAT\u00013i\u0016\u001cHoU3h[\u0016tG\u000fR3mKRLwN\\,ji\"D\u0015n\u001a5XCR,'/\\1sW&s\u0017\u000e^5bY&T\u0018\r^5p]\"\u0012a,\u0019\t\u0003#\nL!a\u0019*\u0003\tQ+7\u000f\u001e\u0005\u0006K\u0002!\tAT\u0001/i\u0016\u001cHoQ1o]>$H)\u001a7fi\u0016\u001cVmZ7f]R\u001c\u0018\t^(s\u0003\n|g/\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0002eC\")\u0001\u000e\u0001C\u0001\u001d\u0006\u0011D/Z:u\u0007\u0006tgn\u001c;J]\u000e\u0014X-\\3oi2{wm\u0015;beR|eMZ:fiB\u000b7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0003hC*\\\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u00031\u0004\"!\\;\u000e\u00039T!a\u001c9\u0002\r\u0015\u0014(o\u001c:t\u0015\t\t(/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bMT!\u0001\u001e+\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t1hNA\rPM\u001a\u001cX\r^(vi>3'+\u00198hK\u0016C8-\u001a9uS>t\u0007")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.log_$eq(Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.time().scheduler(), this.brokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10)));
    }

    @After
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$1;

            public final LogAppendInfo apply(int i) {
                byte[] x$1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$2 = this.expiredTimestamp$1;
                byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
                Log qual$1 = this.$outer.log();
                MemoryRecords x$6 = records2;
                int x$7 = 0;
                boolean x$8 = qual$1.appendAsLeader$default$3();
                ApiVersion x$9 = qual$1.appendAsLeader$default$4();
                return qual$1.appendAsLeader(x$6, x$7, x$8, x$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$1 = expiredTimestamp$1;
            }
        });
        long initialHighWatermark = this.log().updateHighWatermark(25L);
        Assert.assertEquals((long)25L, (long)initialHighWatermark);
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assert.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assert.assertTrue((this.log().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$2;

            public final LogAppendInfo apply(int i) {
                byte[] x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$11 = this.expiredTimestamp$2;
                byte[] x$12 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$13 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$14 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$10, x$12, x$13, x$11, x$14);
                Log qual$2 = this.$outer.log();
                MemoryRecords x$15 = records2;
                int x$16 = 0;
                boolean x$17 = qual$2.appendAsLeader$default$3();
                ApiVersion x$18 = qual$2.appendAsLeader$default$4();
                return qual$2.appendAsLeader(x$15, x$16, x$17, x$18);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$2 = expiredTimestamp$2;
            }
        });
        Assert.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.log().highWatermark());
        Assert.assertEquals((long)0L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)100L, (long)this.log().logEndOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final void apply(int hw) {
                this.apply$mcVI$sp(hw);
            }

            public void apply$mcVI$sp(int hw) {
                this.$outer.log().updateHighWatermark((long)hw);
                Assert.assertEquals((long)hw, (long)this.$outer.log().highWatermark());
                this.$outer.log().deleteOldSegments();
                Assert.assertTrue((this.$outer.log().logStartOffset() <= (long)hw ? 1 : 0) != 0);
                this.$outer.log().logSegments().headOption().foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() <= (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().log().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
                ((IterableLike)this.$outer.log().logSegments().tail()).foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() > (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().log().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
            }

            public /* synthetic */ ReplicaTest kafka$cluster$ReplicaTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)1L, (long)this.log().numberOfSegments());
        Assert.assertEquals((long)0L, (long)this.log().activeSegment().size());
    }

    @Test(expected=OffsetOutOfRangeException.class)
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final LogAppendInfo apply(int i) {
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                Log qual$3 = this.$outer.log();
                MemoryRecords x$19 = records2;
                int x$20 = 0;
                boolean x$21 = qual$3.appendAsLeader$default$3();
                ApiVersion x$22 = qual$3.appendAsLeader$default$4();
                return qual$3.appendAsLeader(x$19, x$20, x$21, x$22);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.log().updateHighWatermark(25L);
        this.log().maybeIncrementLogStartOffset(26L);
    }
}

