/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\u001diW\r\u001e:jGNL!!\u0005\b\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000fC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011\u0011\u0002\u0001\u0005\b/\u0001\u0011\r\u0011\"\u0001\u0019\u0003\u0015\u0019w\u000eZ3d+\u0005I\u0002C\u0001\u000e%\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0019\u0011XmY8sI*\u0011adH\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001#BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001eL!!J\u000e\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016Daa\n\u0001!\u0002\u0013I\u0012AB2pI\u0016\u001c\u0007\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\u0002\tQLW.Z\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011a\u0006B\u0001\u0006kRLGn]\u0005\u0003a5\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007e\u0001\u0001\u000b\u0011B\u0016\u0002\u000bQLW.\u001a\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u00017!\r9$\bP\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t)\u0011I\u001d:bsB\u0011QHP\u0007\u0002;%\u0011q(\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0005\u0001)A\u0005m\u0005\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\t\u0005\u0006\u0007\u0002!\t\u0001R\u0001\bG2,\u0017M\\;q)\u0005)\u0005CA\u001cG\u0013\t9\u0005H\u0001\u0003V]&$\bF\u0001\"J!\tQU*D\u0001L\u0015\ta%%A\u0003kk:LG/\u0003\u0002O\u0017\n)\u0011I\u001a;fe\")\u0001\u000b\u0001C\u0001\t\u0006QD/Z:u\u001b\u0006\u00148n\u001d)beRLG/[8og\u0006\u001bxJ\u001a4mS:,\u0017I\u001c3Q_B,H.\u0019;fgVs7\r\\3b]\u0006\u0014G.Z'fiJL7m\u001d\u0015\u0005\u001fJ+f\u000b\u0005\u0002K'&\u0011Ak\u0013\u0002\u0005)\u0016\u001cH/A\u0004uS6,w.\u001e;\u001f\u0005iB\n\"\u0002-\u0001\t\u0013I\u0016\u0001C4fi\u001e\u000bWoZ3\u0016\u0005iCGCA.r!\raFMZ\u0007\u0002;*\u0011alX\u0001\u0005G>\u0014XM\u0003\u0002\u0010A*\u0011\u0011MY\u0001\u0007s\u0006lW.\u001a:\u000b\u0003\r\f1aY8n\u0013\t)WLA\u0003HCV<W\r\u0005\u0002hQ2\u0001A!B5X\u0005\u0004Q'!\u0001+\u0012\u0005-t\u0007CA\u001cm\u0013\ti\u0007HA\u0004O_RD\u0017N\\4\u0011\u0005]z\u0017B\u000199\u0005\r\te.\u001f\u0005\u0006e^\u0003\ra]\u0001\u0007M&dG/\u001a:\u0011\t]\"h/_\u0005\u0003kb\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005q;\u0018B\u0001=^\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0003oiL!a\u001f\u001d\u0003\u000f\t{w\u000e\\3b]\")\u0001\f\u0001C\u0005{V\u0019a0a\u0001\u0015\u0007}\f)\u0001\u0005\u0003]I\u0006\u0005\u0001cA4\u0002\u0004\u0011)\u0011\u000e b\u0001U\"9\u0011q\u0001?A\u0002\u0005%\u0011AC7fiJL7MT1nKB!\u00111BA\t\u001d\r9\u0014QB\u0005\u0004\u0003\u001fA\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010aBa\u0001\u0017\u0001\u0005\n\u0005eQ\u0003BA\u000e\u0003C!b!!\b\u0002$\u0005\u0015\u0002\u0003\u0002/e\u0003?\u00012aZA\u0011\t\u0019I\u0017q\u0003b\u0001U\"A\u0011qAA\f\u0001\u0004\tI\u0001\u0003\u0005\u0002(\u0005]\u0001\u0019AA\u0005\u0003-iW\r\u001e:jGN\u001bw\u000e]3\t\r\u0005-\u0002\u0001\"\u0001E\u0003]!Xm\u001d;NCbdunZ\"p[B\f7\r^5p]2\u000bw\rK\u0002\u0002*ICq!!\r\u0001\t\u0013\t\u0019$A\u0006sK\u0006$gI]8n\u0019><G\u0003BA\u001b\u0003\u001b\u0002b!a\u000e\u0002>\u0005\u0005SBAA\u001d\u0015\r\tY\u0004O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA \u0003s\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\bo\u0005\r\u0013qIA$\u0013\r\t)\u0005\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007]\nI%C\u0002\u0002La\u00121!\u00138u\u0011\u001d\u0019\u0011q\u0006a\u0001\u0003\u001f\u00022!CA)\u0013\r\t\u0019F\u0001\u0002\u0004\u0019><\u0007bBA,\u0001\u0011%\u0011\u0011L\u0001\roJLG/Z&fs\u0012+\bo\u001d\u000b\u0011\u00037\n\t'!\u001a\u0002j\u0005-\u0014QNA<\u0003w\u0002b!a\u000e\u0002^\u0005\u0005\u0013\u0002BA0\u0003s\u00111aU3r\u0011!\t\u0019'!\u0016A\u0002\u0005\u001d\u0013a\u00028v[.+\u0017p\u001d\u0005\t\u0003O\n)\u00061\u0001\u0002H\u00059a.^7EkB\u001c\bbB\u0002\u0002V\u0001\u0007\u0011q\n\u0005\u0007/\u0005U\u0003\u0019A\r\t\u0011\u0005=\u0014Q\u000ba\u0001\u0003c\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007]\n\u0019(C\u0002\u0002va\u0012A\u0001T8oO\"A\u0011\u0011PA+\u0001\u0004\t9%\u0001\u0006ti\u0006\u0014HOV1mk\u0016D\u0001\"! \u0002V\u0001\u0007\u0011qI\u0001\u0005gR,\u0007\u000f\u0003\u0004\u0002\u0002\u0002!\t\u0001R\u0001\u0013i\u0016\u001cH/S:UQJ,\u0017\r\u001a$bS2,G\rK\u0002\u0002\u0000I\u0003")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.class.metricName((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.class.explicitMetricName((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newGauge((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newMeter((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newHistogram((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newTimer((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.class.removeMetric((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.class.removeMetric$default$2((KafkaMetricsGroup)this);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.class.newGauge$default$3((KafkaMetricsGroup)this);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.class.newTimer$default$4((KafkaMetricsGroup)this);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.class.newHistogram$default$2((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.class.newHistogram$default$3((KafkaMetricsGroup)this);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.class.newMeter$default$4((KafkaMetricsGroup)this);
    }

    private Logger logger$lzycompute() {
        LogCleanerIntegrationTest logCleanerIntegrationTest = this;
        synchronized (logCleanerIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @After
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test(timeout=15000L)
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            MemoryRecords largeMessageSet;
            MemoryRecords memoryRecords;
            MemoryRecords largeMessageSet2 = memoryRecords = (largeMessageSet = (MemoryRecords)tuple2._2());
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$4 = maxMessageSize;
            long x$5 = 100L;
            float x$6 = this.makeCleaner$default$2();
            int x$7 = this.makeCleaner$default$3();
            long x$8 = this.makeCleaner$default$6();
            int x$9 = this.makeCleaner$default$7();
            int x$10 = this.makeCleaner$default$8();
            long x$11 = this.makeCleaner$default$9();
            Option<Object> x$12 = this.makeCleaner$default$10();
            Properties x$13 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$3, x$6, x$7, x$5, x$4, x$8, x$9, x$10, x$11, x$12, x$13));
            this.breakPartitionLog$1(this.topicPartitions()[0]);
            this.breakPartitionLog$1(this.topicPartitions()[1]);
            this.cleaner().startup();
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Log log22 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
            String uncleanableDirectory = log2.dir().getParent();
            Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
            Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, uncleanablePartitionsCountGauge){
                public static final long serialVersionUID = 0L;
                private final Gauge uncleanablePartitionsCountGauge$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToInt((Object)this.uncleanablePartitionsCountGauge$1.value()) == 2;
                }
                {
                    this.uncleanablePartitionsCountGauge$1 = uncleanablePartitionsCountGauge$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There should be 2 uncleanable partitions";
                }
            }, 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log22, 0L, ((LogSegment)log22.logSegments().last()).baseOffset())._2$mcJ$sp();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, uncleanableBytesGauge, expectedTotalUncleanableBytes){
                public static final long serialVersionUID = 0L;
                private final Gauge uncleanableBytesGauge$1;
                private final long expectedTotalUncleanableBytes$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToLong((Object)this.uncleanableBytesGauge$1.value()) == this.expectedTotalUncleanableBytes$1;
                }
                {
                    this.uncleanableBytesGauge$1 = uncleanableBytesGauge$1;
                    this.expectedTotalUncleanableBytes$1 = expectedTotalUncleanableBytes$1;
                }
            }, (Function0<String>)new Serializable(this, expectedTotalUncleanableBytes){
                public static final long serialVersionUID = 0L;
                private final long expectedTotalUncleanableBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " uncleanable bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalUncleanableBytes$1)}));
                }
                {
                    this.expectedTotalUncleanableBytes$1 = expectedTotalUncleanableBytes$1;
                }
            }, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
            Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
            Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
            Assert.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
            return;
        }
        throw new MatchError(tuple2);
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, filter){
            public static final long serialVersionUID = 0L;
            private final Function1 filter$1;

            public final boolean apply(MetricName x$1) {
                return BoxesRunTime.unboxToBoolean((Object)this.filter$1.apply((Object)x$1));
            }
            {
                this.filter$1 = filter$1;
            }
        }).headOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric"})).s((Seq)Nil$.MODULE$));
            }
        }))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        return this.getGauge((Function1<MetricName, Object>)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$2;

            public final boolean apply(MetricName mName) {
                return mName.getName().endsWith(this.metricName$2) && mName.getScope() == null;
            }
            {
                this.metricName$2 = metricName$2;
            }
        });
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        return this.getGauge((Function1<MetricName, Object>)new Serializable(this, metricName, metricScope){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;
            private final String metricScope$1;

            public final boolean apply(MetricName k) {
                return k.getName().endsWith(this.metricName$1) && k.getScope().endsWith(this.metricScope$1);
            }
            {
                this.metricName$1 = metricName$1;
                this.metricScope$1 = metricScope$1;
            }
        });
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$14 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$15 = cleanerBackOffMs;
        long x$16 = minCompactionLagMs;
        int x$17 = segmentSize;
        long x$18 = maxCompactionLagMs;
        float x$19 = minCleanableDirtyRatio;
        int x$20 = this.makeCleaner$default$3();
        int x$21 = this.makeCleaner$default$5();
        int x$22 = this.makeCleaner$default$7();
        Option<Object> x$23 = this.makeCleaner$default$10();
        Properties x$24 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$14, x$19, x$20, x$15, x$21, x$16, x$22, x$17, x$18, x$23, x$24));
        Log log2 = (Log)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log2, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log2.size();
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assert.assertEquals((String)"There should be no cleaning until the max compaction lag has passed", (long)startSizeBlock0, (long)log2.size());
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log2, CompressionType.NONE, T1, 0, 0);
        log2.roll(log2.roll$default$1());
        LogSegment activeSegAtT1 = log2.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$25 = new TopicPartition("log", 0);
        long x$26 = firstBlockCleanableSegmentOffset;
        long x$27 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$25, x$26, x$27);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log2);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed at least to offset ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlockCleanableSegmentOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastCleaned)}))).toString(), (lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0);
        Assert.assertNotEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should still contain non-zero keys"})).s((Seq)Nil$.MODULE$), appends1, read1);
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$28 = new TopicPartition("log", 0);
        long x$29 = activeSegAtT1.baseOffset();
        long x$30 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$28, x$29, x$30);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log2);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should only contains zero keys now"})).s((Seq)Nil$.MODULE$), appends1, read2);
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assert.assertTrue((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed at least to offset ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)secondBlockCleanableSegmentOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastCleaned2)}))).toString(), (lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Record record) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, Log log2, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, timestamp, step, valCounter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            public final long timestamp$1;
            public final int step$1;
            public final IntRef valCounter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeKeyDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int curValue = this.$outer.valCounter$1.elem;
                        byte[] x$31 = ((Object)BoxesRunTime.boxToInteger((int)curValue)).toString().getBytes();
                        CompressionType x$32 = this.$outer.codec$1;
                        byte[] x$33 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        long x$34 = this.$outer.timestamp$1;
                        byte x$35 = TestUtils$.MODULE$.singletonRecords$default$5();
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$31, x$33, x$32, x$34, x$35), 0, this.$outer.log$1.appendAsLeader$default$3(), this.$outer.log$1.appendAsLeader$default$4());
                        this.$outer.valCounter$1.elem += this.$outer.step$1;
                        return new Tuple2.mcII.sp(key, curValue);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.timestamp$1 = timestamp$1;
                this.step$1 = step$1;
                this.valCounter$1 = valCounter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$36 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$37 = 100000;
        long x$38 = 100L;
        float x$39 = this.makeCleaner$default$2();
        int x$40 = this.makeCleaner$default$3();
        long x$41 = this.makeCleaner$default$6();
        int x$42 = this.makeCleaner$default$7();
        int x$43 = this.makeCleaner$default$8();
        long x$44 = this.makeCleaner$default$9();
        Option<Object> x$45 = this.makeCleaner$default$10();
        Properties x$46 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$36, x$39, x$40, x$38, x$37, x$41, x$42, x$43, x$44, x$45, x$46));
        this.cleaner().startup();
        Assert.assertEquals((long)0L, (long)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogCleaner.CleanerThread x$2) {
                x$2.interrupt();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean result, LogCleaner.CleanerThread thread) {
                        return thread.isThreadFailed() && result;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Threads didn't terminate unexpectedly";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)this.cleaner().cleaners().size(), (long)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assert.assertEquals((long)this.cleaner().cleaners().size(), (long)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log2 = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log2.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public LogCleanerIntegrationTest() {
        Logging.class.$init$((Logging)this);
        KafkaMetricsGroup.class.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

