/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001A\u0002\u0013\u0005Q#\u0001\u0004m_\u001e$\u0015N]\u000b\u0002-A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0003S>T\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t!a)\u001b7f\u0011\u001dy\u0002\u00011A\u0005\u0002\u0001\n!\u0002\\8h\t&\u0014x\fJ3r)\t\tC\u0005\u0005\u0002\nE%\u00111E\u0003\u0002\u0005+:LG\u000fC\u0004&=\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004(\u0001\u0001\u0006KAF\u0001\bY><G)\u001b:!\u0011\u001dI\u0003\u00011A\u0005\u0002)\nAb\u001d;bi\u0016l\u0015M\\1hKJ,\u0012a\u000b\t\u0003%1J!!\f\u0002\u0003)A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0011\u001dy\u0003\u00011A\u0005\u0002A\n\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0005\u0005\n\u0004bB\u0013/\u0003\u0003\u0005\ra\u000b\u0005\u0007g\u0001\u0001\u000b\u0015B\u0016\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0011\u001d)\u0004A1A\u0005\u0002Y\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\r\r|W.\\8o\u0015\t)AH\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<\u0017BA!:\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Daa\u0011\u0001!\u0002\u00139\u0014A\u00039beRLG/[8oA!9Q\t\u0001b\u0001\n\u00031\u0015A\u00039s_\u0012,8-\u001a:JIV\tq\t\u0005\u0002\n\u0011&\u0011\u0011J\u0003\u0002\u0005\u0019>tw\r\u0003\u0004L\u0001\u0001\u0006IaR\u0001\faJ|G-^2fe&#\u0007\u0005C\u0004N\u0001\t\u0007I\u0011\u0001(\u0002%5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj]\u000b\u0002\u001fB\u0011\u0011\u0002U\u0005\u0003#*\u00111!\u00138u\u0011\u0019\u0019\u0006\u0001)A\u0005\u001f\u0006\u0019R.\u0019=QS\u0012,\u0005\u0010]5sCRLwN\\'tA!9Q\u000b\u0001b\u0001\n\u00031\u0016\u0001\u0002;j[\u0016,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035f\nQ!\u001e;jYNL!\u0001X-\u0003\u00115{7m\u001b+j[\u0016DaA\u0018\u0001!\u0002\u00139\u0016!\u0002;j[\u0016\u0004\u0003\"\u00021\u0001\t\u0003\t\u0017!B:fiV\u0003H#A\u0011)\u0005}\u001b\u0007C\u00013h\u001b\u0005)'B\u00014?\u0003\u0015QWO\\5u\u0013\tAWM\u0001\u0004CK\u001a|'/\u001a\u0005\u0006U\u0002!\t!Y\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0011\u000e\u001c\t\u0003I6L!A\\3\u0003\u000b\u00053G/\u001a:\t\u000bA\u0004A\u0011A1\u0002%Q,7\u000f\u001e\"bg&\u001c\u0017\nZ'baBLgn\u001a\u0015\u0003_J\u0004\"\u0001Z:\n\u0005Q,'\u0001\u0002+fgRDQA\u001e\u0001\u0005\u0002\u0005\fa\u0005^3ti\u0006\u0003\b/\u001a8e)btW*\u0019:lKJ<\u0016\u000e\u001e5O_B\u0013x\u000eZ;dKJ\u001cF/\u0019;fQ\t)(\u000fC\u0003z\u0001\u0011\u0005\u0011-\u0001\u0010uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z,sCB\f%o\\;oI\"\u0012\u0001P\u001d\u0005\u0006y\u0002!\t!Y\u0001.i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3XSRDwK]1q\u0003J|WO\u001c3CCR\u001c\u0007NU3d_J$\u0007FA>s\u0011\u0015y\b\u0001\"\u0001b\u0003\u0015\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK&sg/\u00197jI^\u0013\u0018\r]!s_VtG\r\u000b\u0004\u007fe\u0006\r\u0011QA\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u001d\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\t\t\"a\u0003\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0011\u0019\t)\u0002\u0001C\u0001C\u0006QC/Z:u\u001d>4\u0016\r\\5eCRLwN\\(o\r&\u00148\u000f^#oiJLx\u000b[3o\u0019>\fG-\u001b8h\u0019><\u0007fAA\ne\"1\u00111\u0004\u0001\u0005\u0002\u0005\f1\u0004^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:e\u0005Vl\u0007o]#q_\u000eD\u0007fAA\re\"1\u0011\u0011\u0005\u0001\u0005\u0002\u0005\f\u0001\u0005^3tiRChNR5sgR|eMZ:fi6+G/\u00193bi\u0006\u001c\u0015m\u00195fI\"\u001a\u0011q\u0004:\t\r\u0005\u001d\u0002\u0001\"\u0001b\u0003\u0001\"Xm\u001d;MCN$8\u000b^1cY\u0016|eMZ:fi\u000e{W\u000e\u001d7fi\u0016$G\u000b\u001f8)\u0007\u0005\u0015\"\u000f\u0003\u0004\u0002.\u0001!\t!Y\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3!a\u000bs\u0011\u0019\t\u0019\u0004\u0001C\u0001C\u0006qR\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0015\u0004\u0003c\u0011\bBBA\u001d\u0001\u0011\u0005\u0011-\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001a\u0011q\u0007:\t\r\u0005}\u0002\u0001\"\u0001b\u0003A\"Xm\u001d;O_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0003\b/\u001a8e/&$\bn\u00148h_&tw\r\u0016:b]N\f7\r^5p]\":\u0011Q\b:\u0002\u0004\u0005\r3EAA#!\u0011\tI!a\u0012\n\t\u0005%\u00131\u0002\u0002\u0019\u0013:4\u0018\r\\5e)bt7\u000b^1uK\u0016C8-\u001a9uS>t\u0007BBA'\u0001\u0011\u0005\u0011-A\u0018uKN$HK];oG\u0006$X-\u00118e%\u0016dw.\u00193SK6|g/Z:PkR|eMU1oO\u0016\u001cf.\u00199tQ>$8\u000fK\u0002\u0002LIDa!a\u0015\u0001\t\u0003\t\u0017\u0001\u0005;fgR$\u0016m[3T]\u0006\u00048\u000f[8uQ\r\t\tF\u001d\u0005\u0007\u00033\u0002A\u0011A1\u0002/Q,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$\bfAA,e\"1\u0011q\f\u0001\u0005\u0002\u0005\fQ\u0004^3tiJ+Wn\u001c<f\u000bb\u0004\u0018N]3e!&$7o\u00148SK2|\u0017\r\u001a\u0015\b\u0003;\u0012\u00181AA2G\t\t)\u0007\u0005\u0003\u0002\n\u0005\u001d\u0014\u0002BA5\u0003\u0017\u0011!$\u00168l]><h\u000e\u0015:pIV\u001cWM]%e\u000bb\u001cW\r\u001d;j_:Da!!\u001c\u0001\t\u0003\t\u0017!\f;fgR\f5mY3qi\u0006\u0003\b/\u001a8e/&$\bn\\;u!J|G-^2feN#\u0018\r^3P]J+\u0007\u000f\\5dC\"\u001a\u00111\u000e:\t\r\u0005M\u0004\u0001\"\u0001b\u0003%\"Xm\u001d;BG\u000e,\u0007\u000f^!qa\u0016tGmV5uQN+\u0017/^3oG\u0016<\u0015\r]:P]J+\u0007\u000f\\5dC\"\u001a\u0011\u0011\u000f:\t\r\u0005e\u0004\u0001\"\u0001b\u0003e!Xm\u001d;EK2,G/Z*oCB\u001c\bn\u001c;t\u0005\u00164wN]3)\u0007\u0005]$\u000f\u0003\u0004\u0002\u0000\u0001!\t!Y\u0001\ri\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a\u0015\u0004\u0003{\u0012\bBBAC\u0001\u0011\u0005\u0011-\u0001\u0014uKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3!a!s\u0011\u0019\tY\t\u0001C\u0001C\u0006qC/Z:u\u0019>\fGM\u0012:p[Ns\u0017\r]:i_R\u0014V\r^1j]NtuN\\#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:tQ\r\tII\u001d\u0005\u0007\u0003#\u0003A\u0011A1\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u0007\u0005=%\u000f\u0003\u0004\u0002\u0018\u0002!\t!Y\u0001\u0010i\u0016\u001cHo\u0015;beR|eMZ:fi\"\u001a\u0011Q\u0013:\t\r\u0005u\u0005\u0001\"\u0001b\u0003a!Xm\u001d;QS\u0012,\u0005\u0010]5sCRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\b\u00037\u0013\u00181AA2\u0011\u0019\t\u0019\u000b\u0001C\u0001C\u00069B/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004\u0003C\u0013\bBBAU\u0001\u0011\u0005\u0011-\u0001\u0018uKN$\bK]8ek\u000e,'o],ji\"|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8t\t>tG/\u0012=qSJ,\u0007fAATe\"1\u0011q\u0016\u0001\u0005\u0002\u0005\fQ\u0006^3tiN+\u0017/^3oG\u0016tu\u000e\u001e,bY&$\u0017\r^3e\r>\u0014xI]8va6+G/\u00193bi\u0006$v\u000e]5dQ\r\tiK\u001d\u0005\u0007\u0003k\u0003A\u0011A1\u00029Q,7\u000f^(mI\u0016\u0003xn\u00195G_J\u001cuN\u001c;s_2\u0014VmY8sI\":\u00111\u0017:\u0002\u0004\u0005e6EAA^!\u0011\tI!!0\n\t\u0005}\u00161\u0002\u0002\u0018!J|G-^2fe\u001a+gnY3e\u000bb\u001cW\r\u001d;j_:Da!a1\u0001\t\u0003\t\u0017A\u0006;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001c\u0017N\\4)\u0007\u0005\u0005'\u000f\u0003\u0004\u0002J\u0002!\t!Y\u0001!i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a+gnY3e\u0003\u001a$XM\u001d*fY>\fG\rK\u0004\u0002HJ\f\u0019!!4$\u0005\u0005=\u0007\u0003BA\u0005\u0003#LA!a5\u0002\f\t)CK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'OR3oG\u0016$W\t_2faRLwN\u001c\u0005\u0007\u0003/\u0004A\u0011A1\u0002;Q,7\u000f\u001e'pC\u00124%o\\7F[B$\u0018p\u00158baNDw\u000e\u001e$jY\u0016D3!!6s\u0011\u0019\ti\u000e\u0001C\u0001C\u0006\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001a\u00111\u001c:\t\r\u0005\r\b\u0001\"\u0001b\u0003}!Xm\u001d;M_\u0006$gI]8n\u0007>\u0014(/\u001e9u':\f\u0007o\u001d5pi\u001aKG.\u001a\u0015\u0004\u0003C\u0014\bBBAu\u0001\u0011\u0005\u0011-A\u000euKN$\u0018\t\u001d9f]\u0012,U\u000e\u001d;z\u0007>tGO]8m\u0005\u0006$8\r\u001b\u0015\u0004\u0003O\u0014\bbBAx\u0001\u0011%\u0011\u0011_\u0001\u001ci\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;\u0015\u0007\u0005\n\u0019\u0010\u0003\u0005\u0002v\u00065\b\u0019AA|\u0003=i\u0017m[3GS2,7i\u001c:skB$\bCB\u0005\u0002z\u0006u\u0018%C\u0002\u0002|*\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\u0005}(\u0011B\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005A1\r[1o]\u0016d7OC\u0002\u0003\bi\t1A\\5p\u0013\u0011\u0011YA!\u0001\u0003\u0017\u0019KG.Z\"iC:tW\r\u001c\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\tM!q\u0004B\u0012\u0005K\u0011yCa\u0010\u0003D\t\u001d\u0003CB\u0005\u0003\u0016\teq)C\u0002\u0003\u0018)\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\n\u0003\u001c%\u0019!Q\u0004\u0002\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\t\u0005\"Q\u0002a\u0001W\u00059Q.\u00199qS:<\u0007BB#\u0003\u000e\u0001\u0007q\t\u0003\u0005\u0003(\t5\u0001\u0019\u0001B\u0015\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019\u0011Ba\u000b\n\u0007\t5\"BA\u0003TQ>\u0014H\u000f\u0003\u0005\u00032\t5\u0001\u0019\u0001B\u001a\u0003-\u0019wN\u001c;s_2$\u0016\u0010]3\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000f:\u0003\u0019\u0011XmY8sI&!!Q\bB\u001c\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\b\u0005\u0003\u0012i\u00011\u0001H\u0003\u0019ygMZ:fi\"I!Q\tB\u0007!\u0003\u0005\raT\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0011B!\u0013\u0003\u000eA\u0005\t\u0019A$\u0002\u0013QLW.Z:uC6\u0004\bb\u0002B'\u0001\u0011%!qJ\u0001\u0007CB\u0004XM\u001c3\u0015#\u0005\u0012\tFa\u0015\u0003V\t]#1\fB/\u0005?\u0012I\u0007\u0003\u0004*\u0005\u0017\u0002\ra\u000b\u0005\u0007\u000b\n-\u0003\u0019A$\t\u0011\t\u001d\"1\na\u0001\u0005SAqA!\u0017\u0003L\u0001\u0007q*A\u0002tKFDqA!\u0011\u0003L\u0001\u0007q\tC\u0005\u0003J\t-\u0003\u0013!a\u0001\u000f\"Q!\u0011\rB&!\u0003\u0005\rAa\u0019\u0002\u001f%\u001cHK]1og\u0006\u001cG/[8oC2\u00042!\u0003B3\u0013\r\u00119G\u0003\u0002\b\u0005>|G.Z1o\u0011)\u0011YGa\u0013\u0011\u0002\u0003\u0007!1M\u0001\rSN4%o\\7DY&,g\u000e\u001e\u0005\b\u0005\u001b\u0002A\u0011\u0002B8)5\t#\u0011\u000fB:\u0005k\u00129H!\u001f\u0003\u0004\"1\u0011F!\u001cA\u0002-Ba!\u0012B7\u0001\u00049\u0005\u0002\u0003B\u0014\u0005[\u0002\rA!\u000b\t\u000f\t\u0005#Q\u000ea\u0001\u000f\"A!1\u0010B7\u0001\u0004\u0011i(A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u00036\t}\u0014\u0002\u0002BA\u0005o\u00111BU3d_J$')\u0019;dQ\"A!1\u000eB7\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\b\u0002!IA!#\u0002-\r,(O]3oiNs\u0017\r]:i_R|eMZ:fiN,\"Aa#\u0011\u000b\t5%qS$\u000e\u0005\t=%\u0002\u0002BI\u0005'\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\tU%\"\u0001\u0006d_2dWm\u0019;j_:LAA!'\u0003\u0010\n\u00191+\u001a;\t\u0013\tu\u0005!%A\u0005\n\t}\u0015\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tKK\u0002H\u0005G[#A!*\u0011\t\t\u001d&\u0011W\u0007\u0003\u0005SSAAa+\u0003.\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005_S\u0011AC1o]>$\u0018\r^5p]&!!1\u0017BU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005o\u0003\u0011\u0013!C\u0005\u0005s\u000b\u0001#\u00199qK:$G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\tm&\u0006\u0002B2\u0005GC\u0011Ba0\u0001#\u0003%IA!/\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012B\u0004\"\u0003Bb\u0001E\u0005I\u0011\u0002Bc\u0003q\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIY*\"Aa2+\u0007=\u0013\u0019\u000bC\u0005\u0003L\u0002\t\n\u0011\"\u0003\u0003 \u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u0012:\u0004")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 1, 0L, 1L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 5, 0L, 2L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), (short)0, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, producerEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short producerEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.producerEpoch$1, 17, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerEpoch$1 = producerEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$17 = this.stateManager();
        long x$18 = this.producerId();
        short x$19 = epoch;
        int x$20 = sequence;
        long x$21 = offset;
        boolean x$22 = false;
        long x$23 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$24 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$17, x$18, x$19, x$20, x$21, x$23, x$24, x$22);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$25 = this.stateManager();
        long x$26 = this.producerId();
        short x$27 = epoch;
        int x$28 = sequence;
        long x$29 = offset;
        boolean x$30 = false;
        long x$31 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$32 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$25, x$26, x$27, x$28, x$29, x$31, x$32, x$30);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = epoch;
        int x$36 = sequence;
        long x$37 = offset;
        boolean x$38 = false;
        long x$39 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$40 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$33, x$34, x$35, x$36, x$37, x$39, x$40, x$38);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
            long lastStableOffset = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
            CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
            long lastStableOffset2 = tuple23._2$mcJ$sp();
            Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
            Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
            Assert.assertEquals((long)2L, (long)lastStableOffset2);
            Assert.assertTrue((boolean)completedTxn2.isAborted());
            Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
            Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
            Assert.assertTrue((boolean)maybeLastEntry.isDefined());
            ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
            Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
            Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
            Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
            this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ProducerStateEntry x$2) {
                    return x$2.firstSeq();
                }
            }));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, producerEpoch, segmentBaseOffset);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, producerEpoch, segmentBaseOffset);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, producerEpoch, segmentBaseOffset);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$3) {
                return x$3.messageOffset();
            }
        }));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        }));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$41 = this.stateManager();
        long x$42 = this.producerId();
        short x$43 = epoch;
        int x$44 = 0;
        long x$45 = 0L;
        boolean x$46 = true;
        long x$47 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$48 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$41, x$42, x$43, x$44, x$45, x$47, x$46, x$48);
        ProducerStateManager x$49 = this.stateManager();
        long x$50 = this.producerId();
        short x$51 = epoch;
        int x$52 = 1;
        long x$53 = 1L;
        boolean x$54 = true;
        long x$55 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$56 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$49, x$50, x$51, x$52, x$53, x$55, x$54, x$56);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$57 = this.$outer.stateManager();
                long x$58 = this.$outer.producerId();
                short x$59 = this.bumpedEpoch$1;
                int x$60 = 2;
                long x$61 = 2L;
                boolean x$62 = true;
                long x$63 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$64 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$57, x$58, x$59, x$60, x$61, x$63, x$62, x$64);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$65 = this.$outer.stateManager();
                long x$66 = this.$outer.producerId();
                short x$67 = (short)(this.bumpedEpoch$1 + 1);
                int x$68 = 2;
                long x$69 = 2L;
                boolean x$70 = true;
                long x$71 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$72 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$65, x$66, x$67, x$68, x$69, x$71, x$70, x$72);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        ProducerStateManager x$73 = this.stateManager();
        long x$74 = this.producerId();
        short x$75 = bumpedEpoch;
        int x$76 = 0;
        long x$77 = 0L;
        boolean x$78 = true;
        long x$79 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$80 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$73, x$74, x$75, x$76, x$77, x$79, x$78, x$80);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$81 = this.stateManager();
        long x$82 = this.producerId();
        short x$83 = epoch;
        int x$84 = 0;
        long x$85 = 0L;
        boolean x$86 = true;
        long x$87 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$88 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$81, x$82, x$83, x$84, x$85, x$87, x$86, x$88);
        ProducerStateManager x$89 = this.stateManager();
        long x$90 = this.producerId();
        short x$91 = epoch;
        int x$92 = 1;
        long x$93 = 1L;
        boolean x$94 = false;
        long x$95 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$96 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$89, x$90, x$91, x$92, x$93, x$95, x$94, x$96);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$97 = recoveredMapping;
        long x$98 = this.producerId();
        short x$99 = epoch;
        int x$100 = sequence;
        long x$101 = 2L;
        long x$102 = 70001L;
        boolean x$103 = false;
        boolean x$104 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$97, x$98, x$99, x$100, x$101, x$102, x$104, x$103);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$105 = this.stateManager();
            long x$106 = this.producerId();
            short x$107 = epoch;
            int x$108 = outOfOrderSequence;
            long x$109 = 1L;
            long x$110 = 1L;
            boolean x$111 = true;
            boolean x$112 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$105, x$106, x$107, x$108, x$109, x$110, x$112, x$111);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
            Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            ProducerStateManager x$113 = this.stateManager();
            long x$114 = this.producerId();
            short x$115 = epoch;
            int x$116 = outOfOrderSequence;
            long x$117 = 1L;
            long x$118 = 1L;
            boolean x$119 = false;
            boolean x$120 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$113, x$114, x$115, x$116, x$117, x$118, x$120, x$119);
            Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            return;
        }
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$121 = this.stateManager();
        long x$122 = this.producerId();
        short x$123 = epoch;
        int x$124 = sequence;
        long x$125 = 99L;
        boolean x$126 = true;
        long x$127 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$128 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$121, x$122, x$123, x$124, x$125, x$127, x$126, x$128);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$5) {
                return x$5.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$6) {
                return x$6.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$7) {
                return x$7.messageOffset();
            }
        }));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$8) {
                return x$8.messageOffset();
            }
        }));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid1, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assert.assertTrue((boolean)entry1.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastSeq());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry2.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry2.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, epoch, pid2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$2;
            private final long pid2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager recoveredMapping = new ProducerStateManager(this.$outer.partition(), this.$outer.logDir(), this.$outer.maxPidExpirationMs());
                recoveredMapping.truncateAndReload(0L, 1L, this.$outer.time().milliseconds());
                this.$outer.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.pid2$1, this.epoch$2, 1, 4L, 5L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.pid2$1 = pid2$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$129 = this.stateManager();
        long x$130 = this.producerId();
        short x$131 = epoch;
        int x$132 = sequence;
        long x$133 = 99L;
        boolean x$134 = true;
        long x$135 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$136 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$129, x$130, x$131, x$132, x$133, x$135, x$134, x$136);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$9) {
                return x$9.messageOffset();
            }
        }));
        long anotherPid = 2L;
        ProducerStateManager x$137 = this.stateManager();
        long x$138 = anotherPid;
        short x$139 = epoch;
        int x$140 = sequence;
        long x$141 = 105L;
        boolean x$142 = true;
        long x$143 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$144 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$137, x$138, x$139, x$140, x$141, x$143, x$142, x$144);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$10) {
                return x$10.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$11) {
                return x$11.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$12) {
                return x$12.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$13) {
                return x$13.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$14) {
                return x$14.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$15) {
                return x$15.messageOffset();
            }
        }));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$145 = this.stateManager();
        long x$146 = this.producerId();
        short x$147 = epoch;
        int x$148 = sequence;
        long x$149 = 99L;
        boolean x$150 = true;
        long x$151 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$152 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$145, x$146, x$147, x$148, x$149, x$151, x$150, x$152);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$153 = stateManager;
        long x$154 = this.producerId();
        short x$155 = epoch;
        int x$156 = -1;
        long x$157 = 99L;
        boolean x$158 = true;
        long x$159 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$160 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$153, x$154, x$155, x$156, x$157, x$159, x$158, x$160);
        ProducerStateManager x$161 = stateManager;
        long x$162 = this.producerId();
        short x$163 = epoch;
        int x$164 = -1;
        long x$165 = 100L;
        boolean x$166 = true;
        long x$167 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$168 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$161, x$162, x$163, x$164, x$165, x$167, x$166, x$168);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$169 = this.stateManager();
        long x$170 = this.producerId();
        short x$171 = epoch;
        int x$172 = sequence;
        long x$173 = 99L;
        boolean x$174 = true;
        long x$175 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$176 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$169, x$170, x$171, x$172, x$173, x$175, x$174, x$176);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$177 = this.stateManager();
        long x$178 = this.producerId();
        short x$179 = epoch;
        int x$180 = sequence;
        long x$181 = 99L;
        boolean x$182 = true;
        long x$183 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$184 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$177, x$178, x$179, x$180, x$181, x$183, x$182, x$184);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ProducerStateEntry x$16) {
                return x$16.coordinatorEpoch();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$185 = this.stateManager();
        long x$186 = this.producerId();
        short x$187 = producerEpoch;
        int x$188 = 0;
        long x$189 = 99L;
        boolean x$190 = true;
        long x$191 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$192 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$185, x$186, x$187, x$188, x$189, x$191, x$190, x$192);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                file.truncate(0L);
            }
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.truncate(file.size() / 2L);
            }
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
            }
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    /*
     * WARNING - void declaration
     */
    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);
        try {
            makeFileCorrupt.apply((Object)channel);
        }
        catch (Throwable throwable) {
            void var7_6;
            var7_6.close();
            throw throwable;
        }
        channel.close();
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    public void kafka$log$ProducerStateManagerTest$$append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    public long kafka$log$ProducerStateManagerTest$$append$default$6() {
        return this.time().milliseconds();
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$7() {
        return false;
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$8() {
        return true;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, short producerEpoch$2, long segmentBaseOffset$1) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (ValidationType)ValidationType.Full$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.append(producerEpoch$2, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

