/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogOffsetSnapshot;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003R3mCf,GMR3uG\"$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001C3bgflwnY6\u000b\u00035\t1a\u001c:h\u0013\ty!BA\bFCNLXj\\2l'V\u0004\bo\u001c:u\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0004\u0017\u0001\t\u0007I\u0011B\f\u0002\u00115\f\u0007PQ=uKN,\u0012\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0004\u0013:$\bBB\u0010\u0001A\u0003%\u0001$A\u0005nCb\u0014\u0015\u0010^3tA!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002GA\u0011A\u0003J\u0005\u0003K\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0004(\u0001\u0001\u0006IaI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0013\u0001\u0004:fa2L7-Y)v_R\fW#A\u0016\u0011\u0005Qa\u0013BA\u0017\u0003\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0011\u0019y\u0003\u0001)A\u0005W\u0005i!/\u001a9mS\u000e\f\u0017+^8uC\u0002BQ!\r\u0001\u0005\u0002I\n\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2i)\u0005\u0019\u0004CA\r5\u0013\t)$D\u0001\u0003V]&$\bF\u0001\u00198!\tA4(D\u0001:\u0015\tQD\"A\u0003kk:LG/\u0003\u0002=s\t!A+Z:u\u0011\u0015q\u0004\u0001\"\u00013\u0003]!Xm\u001d;SKBd\u0017nY1O_R\fe/Y5mC\ndW\r\u000b\u0002>o!)\u0011\t\u0001C\u0001\u0005\u0006\u00113\r[3dW\u000e{W\u000e\u001d7fi\u0016<\u0006.\u001a8G_2dwn^3s\u0019\u0006<w-\u001b8h\u0011^#2aM\"L\u0011\u0015!\u0005\t1\u0001F\u0003)1w\u000e\u001c7po\u0016\u0014\bj\u0016\t\u00043\u0019C\u0015BA$\u001b\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011$S\u0005\u0003\u0015j\u0011A\u0001T8oO\")A\n\u0011a\u0001\u001b\u0006Y1\r[3dWJ+7/\u001e7u!\u0011Ib\nU\u001a\n\u0005=S\"!\u0003$v]\u000e$\u0018n\u001c82!\t!\u0012+\u0003\u0002S\u0005\taA)\u001a7bs\u0016$g)\u001a;dQ\")A\u000b\u0001C\u0001e\u0005\tC/Z:u\u0007>l\u0007\u000f\\3uK^CWM\u001c$pY2|w/\u001a:MC\u001e<\u0017N\\4I/\"\u00121k\u000e\u0005\u0006/\u0002!I\u0001W\u0001\u0013EVLG\u000e\u001a$fi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003Z9zK\u0007C\u0001\u000b[\u0013\tY&AA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\u0006;Z\u0003\r\u0001G\u0001\ne\u0016\u0004H.[2b\u0013\u0012DQa\u0018,A\u0002\u0001\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002bO6\t!M\u0003\u0002dI\u000611m\\7n_:T!!B3\u000b\u0005\u0019d\u0011AB1qC\u000eDW-\u0003\u0002iE\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u00026W\u0001\u0004Y\u0017a\u00034fi\u000eD7\u000b^1ukN\u0004\"\u0001\u00067\n\u00055\u0014!\u0001\u0006$fi\u000eD\u0007+\u0019:uSRLwN\\*uCR,8\u000fC\u0003p\u0001\u0011%\u0001/\u0001\u0010fqB,7\r\u001e*fC\u00124%o\\7SKBd\u0017nY1XSRDWI\u001d:peR)1'\u001d:t\u007f\")QL\u001ca\u00011!)qL\u001ca\u0001A\")AO\u001ca\u0001k\u0006\u0011b-\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\t1HP\u0004\u0002xu6\t\u0001P\u0003\u0002zE\u0006A!/Z9vKN$8/\u0003\u0002|q\u0006aa)\u001a;dQJ+\u0017/^3ti&\u0011QP \u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\u0005mD\bbBA\u0001]\u0002\u0007\u00111A\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u00022\u0002\u0011A\u0014x\u000e^8d_2LA!!\u0004\u0002\b\t1QI\u001d:peNDq!!\u0005\u0001\t\u0013\t\u0019\"A\u000bfqB,7\r\u001e*fC\u00124%o\\7SKBd\u0017nY1\u0015\u000fM\n)\"a\u0006\u0002\u001a!1Q,a\u0004A\u0002aAaaXA\b\u0001\u0004\u0001\u0007B\u0002;\u0002\u0010\u0001\u0007Q\u000fC\u0004\u0002\u001e\u0001!I!a\b\u00021\t,\u0018\u000e\u001c3SK\u0006$'+Z:vYR<\u0016\u000e\u001e5FeJ|'\u000f\u0006\u0003\u0002\"\u0005\u001d\u0002c\u0001\u000b\u0002$%\u0019\u0011Q\u0005\u0002\u0003\u001b1{wMU3bIJ+7/\u001e7u\u0011!\t\t!a\u0007A\u0002\u0005\r\u0001")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$1(responses, this.fetchResultOpt$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$1 = fetchResultOpt$1;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testReplicaNotAvailable() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$2(responses, this.fetchResultOpt$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$2 = fetchResultOpt$2;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andThrow((Throwable)new ReplicaNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica for ", " not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}))));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.REPLICA_NOT_AVAILABLE);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    public void checkCompleteWhenFollowerLaggingHW(Option<Object> followerHW, Function1<DelayedFetch, BoxedUnit> checkResult) {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$3;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$3(responses, this.fetchResultOpt$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$3 = fetchResultOpt$3;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), new LogOffsetMetadata(480L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), new LogOffsetMetadata(400L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())));
        this.expectReadFromReplica(replicaId, topicPartition, fetchStatus.fetchInfo());
        Replica follower2 = new Replica(replicaId, topicPartition);
        followerHW.foreach((Function1)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final Replica follower$1;

            public final void apply(long hw) {
                this.apply$mcVJ$sp(hw);
            }

            public void apply$mcVJ$sp(long hw) {
                this.follower$1.updateFetchState(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), 0L, 0L, 0L, hw);
            }
            {
                this.follower$1 = follower$1;
            }
        });
        EasyMock.expect((Object)partition.getReplica(replicaId)).andReturn((Object)new Some((Object)follower2));
        this.replayAll();
        checkResult.apply((Object)delayedFetch);
    }

    @Test
    public void testCompleteWhenFollowerLaggingHW() {
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)None$.MODULE$, (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertTrue((boolean)delayedFetch.tryComplete());
                Assert.assertTrue((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)500L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertFalse((boolean)delayedFetch.tryComplete());
                Assert.assertFalse((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)480L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertFalse((boolean)delayedFetch.tryComplete());
                Assert.assertFalse((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)470L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertTrue((boolean)delayedFetch.tryComplete());
                Assert.assertTrue((boolean)delayedFetch.isCompleted());
            }
        });
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchStatus)})));
    }

    private void expectReadFromReplicaWithError(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        int x$1 = replicaId;
        boolean x$2 = true;
        FetchLogEnd$ x$3 = FetchLogEnd$.MODULE$;
        int x$4 = this.maxBytes();
        boolean x$5 = false;
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)}));
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$1, x$2, (FetchIsolation)x$3, x$4, x$5, x$6, x$8, (Option)x$7)).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)this.buildReadResultWithError(error))})));
    }

    private void expectReadFromReplica(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData) {
        None$ x$9 = None$.MODULE$;
        FetchDataInfo x$10 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$11 = -1L;
        long x$12 = -1L;
        long x$13 = -1L;
        long x$14 = -1L;
        long x$15 = -1L;
        int x$16 = -1;
        None$ x$17 = None$.MODULE$;
        Option x$18 = LogReadResult$.MODULE$.apply$default$9();
        boolean x$19 = LogReadResult$.MODULE$.apply$default$10();
        LogReadResult result = new LogReadResult(x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option)x$17, x$18, x$19, (Option)x$9);
        int x$20 = replicaId;
        boolean x$21 = true;
        FetchLogEnd$ x$22 = FetchLogEnd$.MODULE$;
        int x$23 = this.maxBytes();
        boolean x$24 = false;
        Seq x$25 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)}));
        None$ x$26 = None$.MODULE$;
        ReplicaQuota x$27 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$20, x$21, (FetchIsolation)x$22, x$23, x$24, x$25, x$27, (Option)x$26)).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)result)}))).anyTimes();
    }

    private LogReadResult buildReadResultWithError(Errors error) {
        Some x$28 = new Some((Object)error.exception());
        FetchDataInfo x$29 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$30 = -1L;
        long x$31 = -1L;
        long x$32 = -1L;
        long x$33 = -1L;
        long x$34 = -1L;
        int x$35 = -1;
        None$ x$36 = None$.MODULE$;
        Option x$37 = LogReadResult$.MODULE$.apply$default$9();
        boolean x$38 = LogReadResult$.MODULE$.apply$default$10();
        return new LogReadResult(x$29, x$30, x$31, x$32, x$33, x$34, x$35, (Option)x$36, x$37, x$38, (Option)x$28);
    }

    public final void kafka$server$DelayedFetchTest$$callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    public final void kafka$server$DelayedFetchTest$$callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public final void kafka$server$DelayedFetchTest$$callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

