/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import kafka.utils.Exit$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.junit.Assert;
import org.junit.Test;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,\u0007K]8ek\u000e,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003%1\u0018\r\\5e\u0003J<7/F\u0001\u0017!\rIq#G\u0005\u00031)\u0011Q!\u0011:sCf\u0004\"AG\u000f\u000f\u0005%Y\u0012B\u0001\u000f\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qQ\u0001BB\u0011\u0001A\u0003%a#\u0001\u0006wC2LG-\u0011:hg\u0002Bqa\t\u0001C\u0002\u0013\u0005Q#A\u0006j]Z\fG.\u001b3Be\u001e\u001c\bBB\u0013\u0001A\u0003%a#\u0001\u0007j]Z\fG.\u001b3Be\u001e\u001c\b\u0005C\u0003(\u0001\u0011\u0005\u0001&\u0001\tuKN$h+\u00197jI\u000e{gNZ5hgR\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0005+:LG\u000f\u000b\u0002'[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#\u0001\u0002+fgRDQA\u000e\u0001\u0005\u0002!\n!\u0003^3ti&sg/\u00197jI\u000e{gNZ5hg\"\"Q'\f\u001d:\u0003!)\u0007\u0010]3di\u0016$7%\u0001\u001e\u0011\u0005m\u001aeB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\tyd!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011!IC\u0001\ba\u0006\u001c7.Y4f\u0013\t!UI\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!A\u0011\u0006\t\u000b\u001d\u0003A\u0011\u0001\u0015\u0002!Q,7\u000f\u001e)beN,7*Z=Qe>\u0004\bF\u0001$.\u0001")
public class ConsoleProducerTest {
    private final String[] validArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});

    public String[] validArgs() {
        return this.validArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    @Test
    public void testValidConfigs() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1001", "localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConfigs() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$1, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
        try {
            new ConsoleProducer.ProducerConfig(this.invalidArgs());
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(reader.parseKey());
    }
}

