/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001du!B\u0001\u0003\u0011\u00039\u0011a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u0011YI!\u0019!C\u0001\u0005]\tABU3d_J$\u0017J\u001c3f]R,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011%\u0003Q\u0001\na\tQBU3d_J$\u0017J\u001c3f]R\u0004\u0003\"B\u0012\n\t\u0003!\u0013\u0001B7bS:$\"!\n\u0015\u0011\u000551\u0013BA\u0014\u000f\u0005\u0011)f.\u001b;\t\u000b%\u0012\u0003\u0019\u0001\u0016\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b-j\u0013B\u0001\u0017\u000f\u0005\u0015\t%O]1z!\tq\u0013G\u0004\u0002\u000e_%\u0011\u0001GD\u0001\u0007!J,G-\u001a4\n\u0005}\u0011$B\u0001\u0019\u000f\u0011\u0015!\u0014\u0002\"\u00036\u00031!W/\u001c9Uq:Le\u000eZ3y)\t)c\u0007C\u00038g\u0001\u0007\u0001(\u0001\u0003gS2,\u0007CA\u001d=\u001b\u0005Q$BA\u001e\u001d\u0003\tIw.\u0003\u0002>u\t!a)\u001b7f\u0011\u0015y\u0014\u0002\"\u0003A\u0003Y!W/\u001c9Qe>$WoY3s\u0013\u0012\u001cf.\u00199tQ>$HCA\u0013B\u0011\u00159d\b1\u00019\u0011\u0019\u0019\u0015\u0002\"\u0001\u0003\t\u0006IA-^7q\u0013:$W\r\u001f\u000b\u0007K\u001535*T5\t\u000b]\u0012\u0005\u0019\u0001\u001d\t\u000b\u001d\u0013\u0005\u0019\u0001%\u0002\u001f%tG-\u001a=TC:LG/_(oYf\u0004\"!D%\n\u0005)s!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019\n\u0003\r\u0001S\u0001\u000bm\u0016\u0014\u0018NZ=P]2L\b\"\u0002(C\u0001\u0004y\u0015AG7jg6\u000bGo\u00195fg\u001a{'/\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b\u0003\u0002)V[]k\u0011!\u0015\u0006\u0003%N\u000bq!\\;uC\ndWM\u0003\u0002U\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u000b&aA'baB\u0019\u0001\fY2\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002`\u001d\u00059\u0001/Y2lC\u001e,\u0017BA1c\u0005\u0011a\u0015n\u001d;\u000b\u0005}s\u0001\u0003B\u0007eM\u001aL!!\u001a\b\u0003\rQ+\b\u000f\\33!\tiq-\u0003\u0002i\u001d\t!Aj\u001c8h\u0011\u0015Q'\t1\u0001l\u00039i\u0017\r_'fgN\fw-Z*ju\u0016\u0004\"!\u00047\n\u00055t!aA%oi\"1q.\u0003C\u0001\u0005A\fQ\u0002Z;naRKW.Z%oI\u0016DHcB\u0013reN$\u0018\u0011\u000b\u0005\u0006o9\u0004\r\u0001\u000f\u0005\u0006\u000f:\u0004\r\u0001\u0013\u0005\u0006\u0019:\u0004\r\u0001\u0013\u0005\u0006k:\u0004\rA^\u0001\u0014i&lW-\u00138eKb$U/\u001c9FeJ|'o\u001d\t\u0003obl\u0011!\u0003\u0004\u0005s&\u0001!PA\nUS6,\u0017J\u001c3fq\u0012+X\u000e]#se>\u00148o\u0005\u0002y\u0019!)1\u0003\u001fC\u0001yR\ta\u000fC\u0004\u007fq\n\u0007I\u0011A@\u0002=5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004XCAA\u0001!\u0015\u0001V+LA\u0002!\u0011\u0001\u0016QA2\n\u0007\u0005\u001d\u0011KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0002CA\u0006q\u0002\u0006I!!\u0001\u0002?5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b\u0005\u0003\u0005\u0002\u0010a\u0014\r\u0011\"\u0001\u0000\u0003MyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7q\u0011!\t\u0019\u0002\u001fQ\u0001\n\u0005\u0005\u0011\u0001F8vi>3wJ\u001d3feRKW.Z:uC6\u0004\b\u0005\u0003\u0005\u0002\u0018a\u0014\r\u0011\"\u0001\u0000\u0003U\u0019\b.\u00197m_^|eMZ:fi:{GOR8v]\u0012D\u0001\"a\u0007yA\u0003%\u0011\u0011A\u0001\u0017g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8eA!9\u0011q\u0004=\u0005\u0002\u0005\u0005\u0012a\u0006:fG>\u0014H-T5t[\u0006$8\r\u001b+j[\u0016Le\u000eZ3y)\u001d)\u00131EA\u0013\u0003SAaaNA\u000f\u0001\u0004A\u0004bBA\u0014\u0003;\u0001\rAZ\u0001\u000fS:$W\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\tY#!\bA\u0002\u0019\fA\u0002\\8h)&lWm\u001d;b[BDq!a\fy\t\u0003\t\t$\u0001\u0010sK\u000e|'\u000fZ(vi>3wJ\u001d3fe&sG-\u001a=US6,7\u000f^1naR9Q%a\r\u00026\u0005]\u0002BB\u001c\u0002.\u0001\u0007\u0001\bC\u0004\u0002(\u00055\u0002\u0019\u00014\t\u000f\u0005e\u0012Q\u0006a\u0001M\u0006\u0011\u0002O]3w\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\ti\u0004\u001fC\u0001\u0003\u007f\t1D]3d_J$7\u000b[1mY><xJ\u001a4tKRtu\u000e\u001e$pk:$GcB\u0013\u0002B\u0005\r\u0013q\t\u0005\u0007o\u0005m\u0002\u0019\u0001\u001d\t\u000f\u0005\u0015\u00131\ba\u0001M\u0006Y\u0011N\u001c3fq>3gm]3u\u0011\u001d\tI%a\u000fA\u0002\u0019\f\u0011\u0002\\8h\u001f\u001a47/\u001a;\t\u000f\u00055\u0003\u0010\"\u0001\u0002P\u0005Y\u0001O]5oi\u0016\u0013(o\u001c:t)\u0005)\u0003\"\u00026o\u0001\u0004Yg!CA+\u0013A\u0005\u0019\u0013BA,\u00055iUm]:bO\u0016\u0004\u0016M]:feV1\u0011\u0011LA7\u0003\u0007\u001b2!a\u0015\r\u0011!\ti&a\u0015\u0007\u0002\u0005}\u0013!\u00029beN,G\u0003BA1\u0003\u000f\u0003b!\u00043\u0002d\u0005}\u0004#B\u0007\u0002f\u0005%\u0014bAA4\u001d\t1q\n\u001d;j_:\u0004B!a\u001b\u0002n1\u0001A\u0001CA8\u0003'\u0012\r!!\u001d\u0003\u0003-\u000bB!a\u001d\u0002zA\u0019Q\"!\u001e\n\u0007\u0005]dBA\u0004O_RD\u0017N\\4\u0011\u00075\tY(C\u0002\u0002~9\u00111!\u00118z!\u0015i\u0011QMAA!\u0011\tY'a!\u0005\u0011\u0005\u0015\u00151\u000bb\u0001\u0003c\u0012\u0011A\u0016\u0005\t\u0003\u0013\u000bY\u00061\u0001\u0002\f\u00061!/Z2pe\u0012\u0004B!!$\u0002 6\u0011\u0011q\u0012\u0006\u0005\u0003\u0013\u000b\tJ\u0003\u0003\u0002\u0014\u0006U\u0015AB2p[6|gNC\u0002\u0006\u0003/SA!!'\u0002\u001c\u00061\u0011\r]1dQ\u0016T!!!(\u0002\u0007=\u0014x-\u0003\u0003\u0002\"\u0006=%A\u0002*fG>\u0014HM\u0002\u0004\u0002&&!\u0011q\u0015\u0002\u0015\t\u0016\u001cw\u000eZ3s\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\u0005%\u0016qVAZ'\u0015\t\u0019\u000bDAV!\u001d9\u00181KAW\u0003c\u0003B!a\u001b\u00020\u0012A\u0011qNAR\u0005\u0004\t\t\b\u0005\u0003\u0002l\u0005MF\u0001CAC\u0003G\u0013\r!!\u001d\t\u0017\u0005]\u00161\u0015B\u0001B\u0003%\u0011\u0011X\u0001\u000bW\u0016LH)Z2pI\u0016\u0014\bCBA^\u0003\u0003\fi+\u0004\u0002\u0002>*\u0019\u0011q\u0018\u0003\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002D\u0006u&a\u0002#fG>$WM\u001d\u0005\f\u0003\u000f\f\u0019K!A!\u0002\u0013\tI-\u0001\u0007wC2,X\rR3d_\u0012,'\u000f\u0005\u0004\u0002<\u0006\u0005\u0017\u0011\u0017\u0005\b'\u0005\rF\u0011AAg)\u0019\ty-!5\u0002TB9q/a)\u0002.\u0006E\u0006\u0002CA\\\u0003\u0017\u0004\r!!/\t\u0011\u0005\u001d\u00171\u001aa\u0001\u0003\u0013D\u0001\"!\u0018\u0002$\u0012\u0005\u0013q\u001b\u000b\u0005\u00033\fy\u000e\u0005\u0004\u000eI\u0006m\u0017Q\u001c\t\u0006\u001b\u0005\u0015\u0014Q\u0016\t\u0006\u001b\u0005\u0015\u0014\u0011\u0017\u0005\t\u0003\u0013\u000b)\u000e1\u0001\u0002\f\u001a1\u00111]\u0005\u0005\u0003K\u00141\u0004\u0016:b]N\f7\r^5p]2{w-T3tg\u0006<W\rU1sg\u0016\u00148#BAq\u0019\u0005\u001d\b#B<\u0002T5j\u0003bB\n\u0002b\u0012\u0005\u00111\u001e\u000b\u0003\u0003[\u00042a^Aq\u0011!\ti&!9\u0005B\u0005EH\u0003BAz\u0003o\u0004b!\u00043\u0002v\u0006U\b\u0003B\u0007\u0002f5B\u0001\"!#\u0002p\u0002\u0007\u00111\u0012\u0004\u0007\u0003wLA!!@\u0003)=3gm]3ug6+7o]1hKB\u000b'o]3s'\u0015\tI\u0010DAt\u0011\u001d\u0019\u0012\u0011 C\u0001\u0005\u0003!\"Aa\u0001\u0011\u0007]\fI\u0010\u0003\u0005\u0003\b\u0005eH\u0011\u0002B\u0005\u0003\rAW\r\u001f\u000b\u0004[\t-\u0001\u0002\u0003B\u0007\u0005\u000b\u0001\rAa\u0004\u0002\u000b\tLH/Z:\u0011\t5Y#\u0011\u0003\t\u0004\u001b\tM\u0011b\u0001B\u000b\u001d\t!!)\u001f;f\u0011!\u0011I\"!?\u0005\n\tm\u0011\u0001\u00049beN,wJ\u001a4tKR\u001cHC\u0002B\u000f\u0005O\u0011Y\u0004\u0005\u0004\u000eI\n}!Q\u0005\t\u0005\u001b\t\u0005R&C\u0002\u0003$9\u0011AaU8nKB!QB!\t\u0019\u0011!\u0011ICa\u0006A\u0002\t-\u0012!C8gMN,GoS3z!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\tQa\u001a:pkBT1A!\u000e\u0005\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\te\"q\u0006\u0002\n\u001f\u001a47/\u001a;LKfD\u0001B!\u0010\u0003\u0018\u0001\u0007!qH\u0001\ba\u0006LHn\\1e!\u0011\u0011\tEa\u0012\u000e\u0005\t\r#b\u0001B#9\u0005\u0019a.[8\n\t\t%#1\t\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002\u0003B'\u0003s$IAa\u0014\u0002%A\f'o]3He>,\b/T3uC\u0012\fG/\u0019\u000b\u0007\u0005#\u0012\u0019F!\u0018\u0011\r5!'q\u0004B\u0010\u0011!\u0011)Fa\u0013A\u0002\t]\u0013\u0001E4s_V\u0004X*\u001a;bI\u0006$\u0018mS3z!\u0011\u0011iC!\u0017\n\t\tm#q\u0006\u0002\u0011\u000fJ|W\u000f]'fi\u0006$\u0017\r^1LKfD\u0001B!\u0010\u0003L\u0001\u0007!q\b\u0005\t\u0003;\nI\u0010\"\u0011\u0003bQ!\u00111\u001fB2\u0011!\tIIa\u0018A\u0002\u0005-\u0005b\u0002B4\u0013\u0011%!\u0011N\u0001\bIVl\u0007\u000fT8h)5)#1\u000eB7\u0005c\u0012)H!\u001f\u0003|!1qG!\u001aA\u0002aBqAa\u001c\u0003f\u0001\u0007\u0001*A\u0007qe&tGoQ8oi\u0016tGo\u001d\u0005\b\u0005g\u0012)\u00071\u0001P\u0003\u0005rwN\\\"p]N,7-\u001e;jm\u0016\u0004\u0016-\u001b:t\r>\u0014Hj\\4GS2,7/T1q\u0011\u001d\u00119H!\u001aA\u0002!\u000bq\"[:EK\u0016\u0004\u0018\n^3sCRLwN\u001c\u0005\u0007U\n\u0015\u0004\u0019A6\t\u0011\tu$Q\ra\u0001\u0005\u007f\na\u0001]1sg\u0016\u0014\bG\u0002BA\u0005\u000b\u0013Y\tE\u0004x\u0003'\u0012\u0019I!#\u0011\t\u0005-$Q\u0011\u0003\r\u0005\u000f\u0013Y(!A\u0001\u0002\u000b\u0005\u0011\u0011\u000f\u0002\u0004?\u0012\n\u0004\u0003BA6\u0005\u0017#AB!$\u0003|\u0005\u0005\t\u0011!B\u0001\u0003c\u00121a\u0018\u00133\u0011\u001d\u0011\t*\u0003C\u0005\u0005'\u000bq\u0002\u001d:j]R\u0014\u0015\r^2i\u0019\u00164X\r\u001c\u000b\u0006K\tU%q\u0015\u0005\t\u0005/\u0013y\t1\u0001\u0003\u001a\u0006)!-\u0019;dQB!!1\u0014BQ\u001d\u0011\tiI!(\n\t\t}\u0015qR\u0001\u0013\r&dW\rT8h\u0013:\u0004X\u000f^*ue\u0016\fW.\u0003\u0003\u0003$\n\u0015&A\u0006$jY\u0016\u001c\u0005.\u00198oK2\u0014VmY8sI\n\u000bGo\u00195\u000b\t\t}\u0015q\u0012\u0005\b\u0005S\u0013y\t1\u0001g\u0003E\t7mY;nk2\fG/\u001b<f\u0005f$Xm\u001d\u0004\u0007\u0005[KAAa,\u0003-\u0011+X\u000e\u001d'pON+w-\\3oiN|\u0005\u000f^5p]N\u001cBAa+\u00032B!!1\u0017B]\u001b\t\u0011)LC\u0002\u00038\u0012\tQ!\u001e;jYNLAAa/\u00036\n)2i\\7nC:$G)\u001a4bk2$x\n\u001d;j_:\u001c\bbC\u0015\u0003,\n\u0005\t\u0015!\u0003+\u0005\u007fK1!\u000bB]\u0011\u001d\u0019\"1\u0016C\u0001\u0005\u0007$BA!2\u0003HB\u0019qOa+\t\r%\u0012\t\r1\u0001+\u0011)\u0011YMa+C\u0002\u0013\u0005!QZ\u0001\taJLg\u000e^(qiV\u0011!q\u001a\t\u0005\u0005#\u00149.\u0004\u0002\u0003T*\u0011!Q[\u0001\u000bU>\u0004Ho]5na2,\u0017\u0002\u0002Bm\u0005'\u0014\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011%\u0011iNa+!\u0002\u0013\u0011y-A\u0005qe&tGo\u00149uA!Q!\u0011\u001dBV\u0005\u0004%\tA!4\u0002\u0013Y,'/\u001b4z\u001fB$\b\"\u0003Bs\u0005W\u0003\u000b\u0011\u0002Bh\u0003)1XM]5gs>\u0003H\u000f\t\u0005\u000b\u0005S\u0014YK1A\u0005\u0002\t5\u0017AD5oI\u0016D8+\u00198jif|\u0005\u000f\u001e\u0005\n\u0005[\u0014Y\u000b)A\u0005\u0005\u001f\fq\"\u001b8eKb\u001c\u0016M\\5us>\u0003H\u000f\t\u0005\u000b\u0005c\u0014YK1A\u0005\u0002\tM\u0018\u0001\u00034jY\u0016\u001cx\n\u001d;\u0016\u0005\tU\b#\u0002Bi\u0005ol\u0013\u0002\u0002B}\u0005'\u00141$\u0011:hk6,g\u000e^!dG\u0016\u0004H/\u001b8h\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007\"\u0003B\u007f\u0005W\u0003\u000b\u0011\u0002B{\u0003%1\u0017\u000e\\3t\u001fB$\b\u0005\u0003\u0006\u0004\u0002\t-&\u0019!C\u0001\u0007\u0007\t\u0011#\\1y\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\t\u0019)\u0001\u0005\u0004\u0003R\n]8q\u0001\t\u00043\r%\u0011bAB\u00065\t9\u0011J\u001c;fO\u0016\u0014\b\"CB\b\u0005W\u0003\u000b\u0011BB\u0003\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\t\u0015\rM!1\u0016b\u0001\n\u0003\u0011i-\u0001\teK\u0016\u0004\u0018\n^3sCRLwN\\(qi\"I1q\u0003BVA\u0003%!qZ\u0001\u0012I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\u0004\u0003BCB\u000e\u0005W\u0013\r\u0011\"\u0001\u0004\u001e\u0005ya/\u00197vK\u0012+7m\u001c3fe>\u0003H/\u0006\u0002\u0004 A)!\u0011\u001bB|1!I11\u0005BVA\u0003%1qD\u0001\u0011m\u0006dW/\u001a#fG>$WM](qi\u0002B!ba\n\u0003,\n\u0007I\u0011AB\u000f\u00035YW-\u001f#fG>$WM](qi\"I11\u0006BVA\u0003%1qD\u0001\u000fW\u0016LH)Z2pI\u0016\u0014x\n\u001d;!\u0011)\u0019yCa+C\u0002\u0013\u0005!QZ\u0001\u000b_\u001a47/\u001a;t\u001fB$\b\"CB\u001a\u0005W\u0003\u000b\u0011\u0002Bh\u0003-ygMZ:fiN|\u0005\u000f\u001e\u0011\t\u0015\r]\"1\u0016b\u0001\n\u0003\u0011i-A\tue\u0006t7/Y2uS>tGj\\4PaRD\u0011ba\u000f\u0003,\u0002\u0006IAa4\u0002%Q\u0014\u0018M\\:bGRLwN\u001c'pO>\u0003H\u000f\t\u0005\t\u0007\u007f\u0011Y\u000b\"\u0001\u0004B\u0005iQ.Z:tC\u001e,\u0007+\u0019:tKJ,\"aa\u00111\r\r\u00153\u0011JB(!\u001d9\u00181KB$\u0007\u001b\u0002B!a\u001b\u0004J\u0011a11JB\u001f\u0003\u0003\u0005\tQ!\u0001\u0002r\t\u0019q\fJ\u001a\u0011\t\u0005-4q\n\u0003\r\u0007#\u001ai$!A\u0001\u0002\u000b\u0005\u0011\u0011\u000f\u0002\u0004?\u0012\"\u0004bCB+\u0005WC)\u0019!C\u0001\u0007/\n!c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pOV\t\u0001\n\u0003\u0006\u0004\\\t-\u0006\u0012!Q!\n!\u000b1c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pO\u0002B1Ba\u001e\u0003,\"\u0015\r\u0011\"\u0001\u0004X!Q1\u0011\rBV\u0011\u0003\u0005\u000b\u0015\u0002%\u0002!%\u001cH)Z3q\u0013R,'/\u0019;j_:\u0004\u0003B\u0003'\u0003,\"\u0015\r\u0011\"\u0001\u0004X!Q1q\rBV\u0011\u0003\u0005\u000b\u0015\u0002%\u0002\u0017Y,'/\u001b4z\u001f:d\u0017\u0010\t\u0005\u000b\u000f\n-\u0006R1A\u0005\u0002\r]\u0003BCB7\u0005WC\t\u0011)Q\u0005\u0011\u0006\u0001\u0012N\u001c3fqN\u000bg.\u001b;z\u001f:d\u0017\u0010\t\u0005\f\u0007c\u0012Y\u000b#b\u0001\n\u0003\u0019\u0019(A\u0003gS2,7/\u0006\u0002\u0004vA\u0019Qb\u000b\r\t\u0017\re$1\u0016E\u0001B\u0003&1QO\u0001\u0007M&dWm\u001d\u0011\t\u0015)\u0014Y\u000b#b\u0001\n\u0003\u0019i(F\u0001l\u0011)\u0019\tIa+\t\u0002\u0003\u0006Ka[\u0001\u0010[\u0006DX*Z:tC\u001e,7+\u001b>fA!A1Q\u0011BV\t\u0003\ty%A\u0005dQ\u0016\u001c7.\u0011:hg\u0002")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class TimeIndexDumpErrors {
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public scala.collection.mutable.Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$5) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$5;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found timestamp mismatch in :").append((Object)fileName).toString());
                        listOfMismatches.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.outOfOrderTimestamp().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$6) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found out of order timestamp in :").append((Object)fileName).toString());
                        outOfOrderTimestamps.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.shallowOffsetNotFound().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ArrayBuffer<Tuple2<Object, Object>> listOfShallowOffsetNotFound) {
                    System.err.println("The following indexed offsets are not found in the log.");
                    listOfShallowOffsetNotFound.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$7) {
                            Tuple2<Object, Object> tuple2 = x0$7;
                            if (tuple2 != null) {
                                long indexedOffset = tuple2._1$mcJ$sp();
                                long logOffset = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexed offset: ", ", found log offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexedOffset), BoxesRunTime.boxToLong((long)logOffset)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
            });
        }
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record2) {
            Tuple2 tuple2;
            None$ key;
            Object object = key = record2.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.key()))) : None$.MODULE$;
            if (record2.hasValue()) {
                Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.value())));
                tuple2 = new Tuple2((Object)key, (Object)payload);
            } else {
                tuple2 = new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        public String kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(byte[] bytes) {
            return Predef$.MODULE$.byteArrayOps(bytes).isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString("%X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
        }

        private Tuple2<Some<String>, Some<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
            String group = offsetKey.key().group();
            TopicPartition topicPartition = offsetKey.key().topicPartition();
            OffsetAndMetadata offset2 = GroupMetadataManager$.MODULE$.readOffsetMessageValue(payload);
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset::", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition())}));
            String valueString = offset2.metadata().isEmpty() ? String.valueOf(offset2.offset()) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2.offset()), offset2.metadata()}));
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        private Tuple2<Some<String>, Some<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
            String groupId = groupMetadataKey.key();
            GroupMetadata group = GroupMetadataManager$.MODULE$.readGroupMessageValue(groupId, payload, Time.SYSTEM);
            String protocolType = (String)group.protocolType().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1)new Serializable(this, protocolType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetsMessageParser $outer;
                private final String protocolType$1;

                public final String apply(MemberMetadata member) {
                    ConsumerPartitionAssignor.Assignment partitionAssignment;
                    String userData;
                    String string = this.protocolType$1;
                    String string2 = "consumer";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ((userData = this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(Utils.toArray((ByteBuffer)(partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()))).userData()))).isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), partitionAssignment.partitions(), userData}))) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.memberId(), this.$outer.kafka$tools$DumpLogSegments$OffsetsMessageParser$$hex(member.assignment())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.protocolType$1 = protocolType$1;
                }
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            String keyString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata"), (Object)groupId)}))).asJava());
            String valueString = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)group.protocolOrNull()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)}))).asJava());
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            Tuple2<Some<String>, Some<String>> tuple2;
            if (record2.hasValue()) {
                Tuple2<Some<String>, Some<String>> tuple22;
                if (!record2.hasKey()) throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
                BaseKey baseKey = GroupMetadataManager$.MODULE$.readMessageKey(record2.key());
                if (baseKey instanceof OffsetKey) {
                    OffsetKey offsetKey = (OffsetKey)baseKey;
                    tuple22 = this.parseOffsets(offsetKey, record2.value());
                } else {
                    if (!(baseKey instanceof GroupMetadataKey)) throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
                    GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
                    tuple22 = this.parseGroupMetadata(groupMetadataKey, record2.value());
                }
                tuple2 = tuple22;
                return tuple2;
            } else {
                tuple2 = new Tuple2<Some<String>, Some<String>>((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
    }

    public static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private boolean shouldPrintDataLog;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private volatile byte bitmap$0;

        private boolean shouldPrintDataLog$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.shouldPrintDataLog;
            }
        }

        private boolean isDeepIteration$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.isDeepIteration;
            }
        }

        private boolean verifyOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
                return this.verifyOnly;
            }
        }

        private boolean indexSanityOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
                return this.indexSanityOnly;
            }
        }

        private String[] files$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
                return this.files;
            }
        }

        private int maxMessageSize$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
                return this.maxMessageSize;
            }
        }

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public MessageParser<?, ?> messageParser() {
            MessageParser<String, String> messageParser;
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                messageParser = new OffsetsMessageParser();
            } else if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                messageParser = new TransactionLogMessageParser();
            } else {
                Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                messageParser = new DecoderMessageParser(keyDecoder, valueDecoder);
            }
            return messageParser;
        }

        public boolean shouldPrintDataLog() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldPrintDataLog$lzycompute() : this.shouldPrintDataLog;
        }

        public boolean isDeepIteration() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.isDeepIteration$lzycompute() : this.isDeepIteration;
        }

        public boolean verifyOnly() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.verifyOnly$lzycompute() : this.verifyOnly;
        }

        public boolean indexSanityOnly() {
            return (byte)(this.bitmap$0 & 8) == 0 ? this.indexSanityOnly$lzycompute() : this.indexSanityOnly;
        }

        public String[] files() {
            return (byte)(this.bitmap$0 & 0x10) == 0 ? this.files$lzycompute() : this.files;
        }

        public int maxMessageSize() {
            return (byte)(this.bitmap$0 & 0x20) == 0 ? this.maxMessageSize$lzycompute() : this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record2.key());
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(txnKey.transactionalId(), record2.value());
            String keyString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnKey.transactionalId()}));
            String valueString = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch:", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.state()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.topicPartitions()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs())}))).toString();
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
    }
}

