/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011a%\u00113nS:\u001cE.[3oi^KG\u000f\u001b)pY&\u001c\u0017.Z:J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QB\u0003\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001a\u0001\n\u0003Y\u0012AB2mS\u0016tG/F\u0001\u001d!\tir%D\u0001\u001f\u0015\ty\u0002%A\u0003bI6LgN\u0003\u0002\"E\u000591\r\\5f]R\u001c(BA\u0003$\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\n\u0005!r\"!B!e[&t\u0007b\u0002\u0016\u0001\u0001\u0004%\taK\u0001\u000bG2LWM\u001c;`I\u0015\fHC\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;\t\u000fMJ\u0013\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\rU\u0002\u0001\u0015)\u0003\u001d\u0003\u001d\u0019G.[3oi\u0002Bqa\u000e\u0001C\u0002\u0013\u0005\u0001(A\u0006ce>\\WM]\"pk:$X#A\u001d\u0011\u00055R\u0014BA\u001e/\u0005\rIe\u000e\u001e\u0005\u0007{\u0001\u0001\u000b\u0011B\u001d\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\t\u000b}\u0002A\u0011\u0001!\u0002\u001b\u001ddwNY1m)&lWm\\;u+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0015\u0011X\u000f\\3t\u0015\t1U%A\u0003kk:LG/\u0003\u0002I\u0007\n9A+[7f_V$\bF\u0001 K!\tYE*D\u0001F\u0013\tiUI\u0001\u0003Sk2,\u0007\"B(\u0001\t\u0003\u0002\u0016!B:fiV\u0003H#\u0001\u0017)\u00059\u0013\u0006CA&T\u0013\t!VI\u0001\u0004CK\u001a|'/\u001a\u0005\u0006-\u0002!\t\u0005U\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q\u000b\u0017\t\u0003\u0017fK!AW#\u0003\u000b\u00053G/\u001a:\t\u000bq\u0003A\u0011A/\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0016\u0003y\u0003Ba\u00183g[6\t\u0001M\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\u00075\u000b\u0007\u000f\u0005\u0002hU:\u0011Q\u0006[\u0005\u0003S:\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011N\f\t\u0003]Fl\u0011a\u001c\u0006\u0003a\n\fA\u0001\\1oO&\u0011!o\u001c\u0002\u0007\u001f\nTWm\u0019;\t\u000bQ\u0004A\u0011I;\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u001e\t\u0004ojdX\"\u0001=\u000b\u0005et\u0013AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\u0004'\u0016\f\bcA?\u0002\u00025\taP\u0003\u0002\u0000\t\u000511/\u001a:wKJL1!a\u0001\u007f\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0005\u001d\u0001\u0001\"\u0001Q\u0003U!Xm\u001d;WC2LG-\u00117uKJ\u001cuN\u001c4jONDC!!\u0002\u0002\fA\u00191*!\u0004\n\u0007\u0005=QI\u0001\u0003UKN$\bBBA\n\u0001\u0011\u0005\u0001+A\fuKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hg\"\"\u0011\u0011CA\u0006\u0011\u0019\tI\u0002\u0001C\u0001!\u0006\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGfDC!a\u0006\u0002\f\u001d9\u0011q\u0004\u0002\t\u0002\u0005\u0005\u0012AJ!e[&t7\t\\5f]R<\u0016\u000e\u001e5Q_2L7-[3t\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0019\u0001$a\t\u0007\r\u0005\u0011\u0001\u0012AA\u0013'\u0011\t\u0019#a\n\u0011\u00075\nI#C\u0002\u0002,9\u0012a!\u00118z%\u00164\u0007bB\u000b\u0002$\u0011\u0005\u0011q\u0006\u000b\u0003\u0003C1q!a\r\u0002$\u0001\t)D\u0001\u0004Q_2L7-_\n\u0006\u0003ci\u0017q\u0007\t\u0005\u0003s\t\t%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0019\u0001x\u000e\\5ds*\u0011qPI\u0005\u0005\u0003\u0007\nYDA\tBYR,'oQ8oM&<\u0007k\u001c7jGfDq!FA\u0019\t\u0003\t9\u0005\u0006\u0002\u0002JA!\u00111JA\u0019\u001b\t\t\u0019\u0003\u0003\u0007\u0002P\u0005E\u0002\u0019!a\u0001\n\u0003\t\t&A\u0004d_:4\u0017nZ:\u0016\u0005\u0005M\u0003\u0007BA+\u0003;\u0002baZA,M\u0006e\u0013BA3m!\u0011\tY&!\u0018\r\u0001\u0011a\u0011qLA1\u0003\u0003\u0005\tQ!\u0001\u0002n\t\u0019q\fJ\u0019\t\u0013\u0005\r\u0014\u0011\u0007Q!\n\u0005\u0015\u0014\u0001C2p]\u001aLwm\u001d\u00111\t\u0005\u001d\u00141\u000e\t\u0007O\u0006]c-!\u001b\u0011\t\u0005m\u00131\u000e\u0003\r\u0003?\n\t'!A\u0001\u0002\u000b\u0005\u0011QN\t\u0005\u0003_\n)\bE\u0002.\u0003cJ1!a\u001d/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!LA<\u0013\r\tIH\f\u0002\u0004\u0003:L\b\u0002DA?\u0003c\u0001\r\u00111A\u0005\u0002\u0005}\u0014aC2p]\u001aLwm]0%KF$2\u0001LAA\u0011%\u0019\u00141PA\u0001\u0002\u0004\t\u0019\t\r\u0003\u0002\u0006\u0006%\u0005CB4\u0002X\u0019\f9\t\u0005\u0003\u0002\\\u0005%E\u0001DA0\u0003C\n\t\u0011!A\u0003\u0002\u00055\u0004BCAG\u0003c\u0001\r\u0011\"\u0001\u0002\u0010\u000611\r\\8tK\u0012,\"!!%\u0011\u00075\n\u0019*C\u0002\u0002\u0016:\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\u001a\u0006E\u0002\u0019!C\u0001\u00037\u000b!b\u00197pg\u0016$w\fJ3r)\ra\u0013Q\u0014\u0005\ng\u0005]\u0015\u0011!a\u0001\u0003#C\u0011\"!)\u00022\u0001\u0006K!!%\u0002\u000f\rdwn]3eA!A\u0011QUA\u0019\t\u0003\t9+A\u0005d_:4\u0017nZ;sKR\u0019A&!+\t\u0011\u0005=\u00131\u0015a\u0001\u0003W\u0003D!!,\u00022B)q\f\u001a4\u00020B!\u00111LAY\t1\t\u0019,!+\u0002\u0002\u0003\u0005)\u0011AA7\u0005\ryFE\r\u0005\t\u0003o\u000b\t\u0004\"\u0001\u0002:\u0006Aa/\u00197jI\u0006$X\rF\u0002-\u0003wC\u0001\"!0\u00026\u0002\u0007\u0011qX\u0001\u0010e\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uCB!\u0011\u0011YAd\u001d\u0011\tI$a1\n\t\u0005\u0015\u00171H\u0001\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018\u0002BAe\u0003\u0017\u0014qBU3rk\u0016\u001cH/T3uC\u0012\fG/\u0019\u0006\u0005\u0003\u000b\fY\u0004C\u0004\u0002P\u0006EB\u0011\u0001)\u0002\u000b\rdwn]3")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client = null;
    private final int brokerCount;

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        configs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties props) {
                return props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class);
            }
        });
        return (Seq)configs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString());
        List brokerConfigEntries = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicResource1, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource topicResource1$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.topicResource1$1)).get();
            }
            {
                this.topicResource1$1 = topicResource1$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicResource3, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource topicResource3$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.topicResource3$1)).get();
            }
            {
                this.topicResource3$1 = topicResource3$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerResource, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource brokerResource$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.brokerResource$1)).get();
            }
            {
                this.brokerResource$1 = brokerResource$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause() instanceof InvalidRequestException));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicResource1, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource topicResource1$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.topicResource1$1)).get();
            }
            {
                this.topicResource1$1 = topicResource1$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicResource3, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource topicResource3$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.topicResource3$1)).get();
            }
            {
                this.topicResource3$1 = topicResource3$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerResource, alterResult){
            public static final long serialVersionUID = 0L;
            private final ConfigResource brokerResource$1;
            private final ObjectRef alterResult$1;

            public final Void apply() {
                return (Void)((KafkaFuture)((AlterConfigsResult)this.alterResult$1.elem).values().get(this.brokerResource$1)).get();
            }
            {
                this.brokerResource$1 = brokerResource$1;
                this.alterResult$1 = alterResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166))).getCause() instanceof InvalidRequestException));
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Policy should not be closed";
                }
            });
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "configure should have been called with non empty configs";
                }
            });
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "request configs should not be empty";
                }
            });
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "resource name should not be empty";
                }
            });
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

