/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.AutoPreferredReplicaLeaderElection$;
import kafka.controller.BrokerChange$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.TopicChange$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u000f\tQ2i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0003\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0016\u0003Y\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014X#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005Y\u0019uN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\b\"\u0003\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u001c\u0003i\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014x\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004#\u0001\u0001\u0006KAF\u0001\u0018G>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u00029!\u00121e\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0004\u0001\"\u0001&\u0003e!Xm\u001d;NKR\u0014\u0018nY:DY\u0016\fg.\u001a3P]\u000ecwn]3)\u0005=\u0012\u0004C\u0001\u00154\u0013\t!\u0014F\u0001\u0003UKN$\b\"\u0002\u001c\u0001\t\u0003)\u0013A\u0005;fgR,e/\u001a8u#V,W/\u001a+j[\u0016D#!\u000e\u001a\t\u000be\u0002A\u0011A\u0013\u0002'Q,7\u000f^*vG\u000e,7o\u001d4vY\u00163XM\u001c;)\u0005a\u0012\u0004\"\u0002\u001f\u0001\t\u0003)\u0013\u0001\b;fgR,e/\u001a8u)\"\fG\u000f\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0003wIBQa\u0010\u0001\u0005\n\u0001\u000bQa\u00195fG.$B\u0001H!K\u001f\")!I\u0010a\u0001\u0007\u0006QQ.\u001a;sS\u000et\u0015-\\3\u0011\u0005\u0011;eBA\u0005F\u0013\t1%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$\u000b\u0011\u0015Ye\b1\u0001M\u0003\u0015)g/\u001a8u!\t\u0011R*\u0003\u0002O\u0005\ty1i\u001c8ue>dG.\u001a:Fm\u0016tG\u000fC\u0003Q}\u0001\u0007\u0011+\u0001\u0003gk:\u001c\u0007cA\u0005S9%\u00111K\u0003\u0002\n\rVt7\r^5p]BBQ!\u0016\u0001\u0005\nY\u000bQ\u0001^5nKJ$\"aV2\u0011\u0005a\u000bW\"A-\u000b\u0005i[\u0016\u0001B2pe\u0016T!\u0001X/\u0002\u000f5,GO]5dg*\u0011alX\u0001\u0007s\u0006lW.\u001a:\u000b\u0003\u0001\f1aY8n\u0013\t\u0011\u0017LA\u0003US6,'\u000fC\u0003C)\u0002\u00071\t")
public class ControllerEventManagerTest {
    private ControllerEventManager kafka$controller$ControllerEventManagerTest$$controllerEventManager;

    public ControllerEventManager kafka$controller$ControllerEventManagerTest$$controllerEventManager() {
        return this.kafka$controller$ControllerEventManagerTest$$controllerEventManager;
    }

    private void kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(ControllerEventManager x$1) {
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        if (this.kafka$controller$ControllerEventManagerTest$$controllerEventManager() != null) {
            this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().close();
        }
    }

    @Test
    public void testMetricsCleanedOnClose() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(this){

            public void process(ControllerEvent event) {
            }

            public void preempt(ControllerEvent event) {
            }
        };
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().start();
        Assert.assertTrue((boolean)this.allEventManagerMetrics$1().nonEmpty());
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().close();
        Assert.assertTrue((boolean)this.allEventManagerMetrics$1().isEmpty());
    }

    @Test
    public void testEventQueueTime() {
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(this, time, latch, processedEvents){
            private final MockTime time$1;
            private final CountDownLatch latch$1;
            private final AtomicInteger processedEvents$1;

            public void process(ControllerEvent event) {
                this.latch$1.await();
                this.time$1.sleep(500L);
                this.processedEvents$1.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.time$1 = time$1;
                this.latch$1 = latch$1;
                this.processedEvents$1 = processedEvents$1;
            }
        };
        Assert.assertTrue((boolean)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$2) {
                String string = x$2.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().isEmpty());
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().start();
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, processedEvents){
            public static final long serialVersionUID = 0L;
            private final AtomicInteger processedEvents$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.processedEvents$1.get() == 2;
            }
            {
                this.processedEvents$1 = processedEvents$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for processing of all events";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Histogram queueTimeHistogram = (Histogram)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$3) {
                String string = x$3.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})));
            }
            {
                this.metricName$1 = metricName$1;
            }
        });
        Assert.assertEquals((long)2L, (long)queueTimeHistogram.count());
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.01);
        Assert.assertEquals((double)500.0, (double)queueTimeHistogram.max(), (double)0.01);
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerEvent)AutoPreferredReplicaLeaderElection$.MODULE$, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerEvent)BrokerChange$.MODULE$, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new NullPointerException();
            }
        });
    }

    private void check(String metricName, ControllerEvent event, Function0<BoxedUnit> func) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(this, func, eventProcessedListenerCount, latch){
            private final Function0 func$1;
            private final AtomicInteger eventProcessedListenerCount$1;
            private final CountDownLatch latch$2;

            public void process(ControllerEvent event) {
                this.latch$2.await();
                this.eventProcessedListenerCount$1.incrementAndGet();
                this.func$1.apply$mcV$sp();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.func$1 = func$1;
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
                this.latch$2 = latch$2;
            }
        };
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)new MockTime(), controllerStats.rateAndTimeMetrics()));
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        this.kafka$controller$ControllerEventManagerTest$$controllerEventManager().put(event);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, event){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerEventManagerTest $outer;
            private final ControllerEvent event$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ControllerState controllerState = this.$outer.kafka$controller$ControllerEventManagerTest$$controllerEventManager().state();
                ControllerState controllerState2 = this.event$1.state();
                return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.event$1 = event$1;
            }
        }, (Function0<String>)new Serializable(this, event){
            public static final long serialVersionUID = 0L;
            private final ControllerEvent event$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller state is not ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.event$1.state()}));
            }
            {
                this.event$1 = event$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerEventManagerTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ControllerState controllerState = this.$outer.kafka$controller$ControllerEventManagerTest$$controllerEventManager().state();
                ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller state has not changed back to Idle";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$2;

            public final boolean apply(MetricName x$4) {
                String string = x$4.getMBeanName();
                String string2 = this.metricName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$2 = metricName$2;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$2})));
            }
            {
                this.metricName$2 = metricName$2;
            }
        });
    }

    private final Set allEventManagerMetrics$1() {
        return ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$1) {
                return x$1.getMBeanName().startsWith("kafka.controller:type=ControllerEventManager");
            }
        })).toSet();
    }
}

