/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerFailoverTest$;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.MockEvent;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011acQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005\u0019An\\4\u0016\u0003q\u0001\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u000b1|w\r\u000e6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0005\u0003Ky\u0011a\u0001T8hO\u0016\u0014\bBB\u0014\u0001A\u0003%A$\u0001\u0003m_\u001e\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAK\u0001\t]Vlgj\u001c3fgV\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0002J]RDaA\r\u0001!\u0002\u0013Y\u0013!\u00038v[:{G-Z:!\u0011\u001d!\u0004A1A\u0005\u0002)\n\u0001B\\;n!\u0006\u0014Ho\u001d\u0005\u0007m\u0001\u0001\u000b\u0011B\u0016\u0002\u00139,X\u000eU1siN\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%\tAK\u0001\r[N<\u0017+^3vKNK'0\u001a\u0005\u0007u\u0001\u0001\u000b\u0011B\u0016\u0002\u001b5\u001cx-U;fk\u0016\u001c\u0016N_3!\u0011\u001da\u0004A1A\u0005\u0002u\nQ\u0001^8qS\u000e,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\"1q\t\u0001Q\u0001\ny\na\u0001^8qS\u000e\u0004\u0003bB%\u0001\u0005\u0004%\tAS\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0005\u0006!Q\u000f^5m\u0013\t\u0001VJ\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u0015\u0001!\u0002\u0013Y\u0015\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u001d!\u0006A1A\u0005\u0002U\u000bq!\\3ue&\u001c7/F\u0001W!\t9F,D\u0001Y\u0015\t!\u0016L\u0003\u0002[7\u000611m\\7n_:T!!\u0002\u0011\n\u0005uC&aB'fiJL7m\u001d\u0005\u0007?\u0002\u0001\u000b\u0011\u0002,\u0002\u00115,GO]5dg\u0002BQ!\u0019\u0001\u0005B\t\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002GB\u0019AmZ5\u000e\u0003\u0015T!AZ\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002iK\n\u00191+Z9\u0011\u0005)lW\"A6\u000b\u00051$\u0011AB:feZ,'/\u0003\u0002oW\nY1*\u00194lC\u000e{gNZ5h\u0011\u0015\u0001\b\u0001\"\u0011r\u0003!!X-\u0019:E_^tG#\u0001:\u0011\u00051\u001a\u0018B\u0001;.\u0005\u0011)f.\u001b;)\u0005=4\bCA<{\u001b\u0005A(BA=#\u0003\u0015QWO\\5u\u0013\tY\bPA\u0003BMR,'\u000fC\u0003~\u0001\u0011\u0005\u0011/A\u0010uKN$\b*\u00198eY\u0016LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:D#\u0001`@\u0011\u0007]\f\t!C\u0002\u0002\u0004a\u0014A\u0001V3ti\u0002")
public class ControllerFailoverTest
extends KafkaServerTestHarness {
    private final Logger log = Logger.getLogger(ControllerFailoverTest.class);
    private final int numNodes;
    private final int numParts;
    private final int msgQueueSize;
    private final String topic;
    private final Properties overridingProps = new Properties();
    private final Metrics metrics = new Metrics();

    public Logger log() {
        return this.log;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public int msgQueueSize() {
        return this.msgQueueSize;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerFailoverTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.metrics().close();
    }

    @Test
    public void testHandleIllegalStateException() {
        KafkaController initialController = (KafkaController)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$2) {
                return x$2.kafkaController().isActive();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaController apply(KafkaServer x$3) {
                return x$3.kafkaController();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail("Could not find controller", new Position("ControllerFailoverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            }
        });
        int initialEpoch = initialController.epoch();
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4());
        TopicPartition topicPartition = new TopicPartition("topic1", 0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialController, topicPartition){
            public static final long serialVersionUID = 0L;
            private final KafkaController initialController$1;
            private final TopicPartition topicPartition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialController$1.controllerContext().partitionsInState((PartitionState)OnlinePartition$.MODULE$).contains((Object)this.topicPartition$1);
            }
            {
                this.initialController$1 = initialController$1;
                this.topicPartition$1 = topicPartition$1;
            }
        }, (Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " did not transition to online state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exceptionThrown = new AtomicReference();
        MockEvent illegalStateEvent = new MockEvent(this, initialController, latch, exceptionThrown){
            private final KafkaController initialController$1;
            private final CountDownLatch latch$1;
            private final AtomicReference exceptionThrown$1;

            public void process() {
                try {
                    throw this.initialController$1.handleIllegalState(new IllegalStateException("Thrown for test purposes"));
                }
                catch (Throwable throwable) {
                    this.exceptionThrown$1.set(throwable);
                    this.latch$1.await();
                    return;
                }
            }
            {
                this.initialController$1 = initialController$1;
                this.latch$1 = latch$1;
                this.exceptionThrown$1 = exceptionThrown$1;
                super((ControllerState)ControllerState.BrokerChange$.MODULE$);
            }
        };
        initialController.eventManager().put((ControllerEvent)illegalStateEvent);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialController){
            public static final long serialVersionUID = 0L;
            private final KafkaController initialController$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.initialController$1.kafkaScheduler().isStarted();
            }
            {
                this.initialController$1 = initialController$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Scheduler was not shutdown";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialController){
            public static final long serialVersionUID = 0L;
            private final KafkaController initialController$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.initialController$1.isActive();
            }
            {
                this.initialController$1 = initialController$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller did not become inactive";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, exceptionThrown){
            public static final long serialVersionUID = 0L;
            private final AtomicReference exceptionThrown$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return Option$.MODULE$.apply(this.exceptionThrown$1.get()).isDefined();
            }
            {
                this.exceptionThrown$1 = exceptionThrown$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "handleIllegalState did not throw an exception";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"handleIllegalState should throw an IllegalStateException, but ", " was thrown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exceptionThrown})), (boolean)(exceptionThrown.get() instanceof IllegalStateException));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerFailoverTest $outer;
            public final int initialEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testHandleIllegalStateException$5 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.kafkaController().isActive() && server.kafkaController().epoch() > this.$outer.initialEpoch$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialEpoch$1 = initialEpoch$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to find controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public ControllerFailoverTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.msgQueueSize = 1;
        this.topic = "topic1";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
    }
}

