/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerIntegrationTest$;
import kafka.controller.ControllerIntegrationTest$$anonfun$testMetadataPropagationOnBrokerChange$1$;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockEvent;
import kafka.controller.ReplicaAssignment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileBooleanRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8oiJ|G\u000e\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012aB:feZ,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0003EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0013\u0001\u0001\u0004%\tAJ\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\u0005+:LG\u000fC\u0004-I\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAF\u0001\tg\u0016\u0014h/\u001a:tA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u00064jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.F\u00013!\tA3'\u0003\u000255\t\u0019\u0011J\u001c;\t\rY\u0002\u0001\u0015!\u00033\u0003U1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011'A\u000fgSJ\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8o\u0011\u0019Q\u0004\u0001)A\u0005e\u0005qb-\u001b:ti\u000e{g\u000e\u001e:pY2,'/\u00129pG\"T6NV3sg&|g\u000e\t\u0005\u0006y\u0001!\t%P\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002O!\u00121h\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bQA[;oSRT\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$B\u0005\u0019\u0011UMZ8sK\")\u0001\n\u0001C!{\u0005AA/Z1s\t><h\u000e\u000b\u0002H\u0015B\u0011\u0001iS\u0005\u0003\u0019\u0006\u0013Q!\u00114uKJDQA\u0014\u0001\u0005\u0002u\n\u0001\u0003^3ti\u0016k\u0007\u000f^=DYV\u001cH/\u001a:)\u00055\u0003\u0006C\u0001!R\u0013\t\u0011\u0016I\u0001\u0003UKN$\b\"\u0002+\u0001\t\u0003i\u0014!\f;fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007+\u001a:tSN$8o\u00165f]\u0006cGN\u0011:pW\u0016\u00148\u000fR8x]\"\u00121\u000b\u0015\u0005\u0006/\u0002!\t!P\u0001,i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4X-\u00138de\u0016lWM\u001c;t\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"\u0012a\u000b\u0015\u0005\u00065\u0002!\t!P\u0001&i\u0016\u001cH/T3uC\u0012\fG/\u0019)s_B\fw-\u0019;j_:|enQ8oiJ|G\u000e\u00157b]\u0016D#!\u0017)\t\u000bu\u0003A\u0011A\u001f\u0002KQ,7\u000f^'fi\u0006$\u0017\r^1Qe>\u0004\u0018mZ1uS>twJ\u001c\"s_.,'o\u00115b]\u001e,\u0007F\u0001/Q\u0011\u0015\u0001\u0007\u0001\"\u0001>\u0003%\"Xm\u001d;NKR\fG-\u0019;b!J|\u0007/Y4bi&|gNR8s\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2bg\"\u0012q\f\u0015\u0005\u0006G\u0002!\t!P\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0007F\u00012Q\u0011\u00151\u0007\u0001\"\u0001>\u0003\r\"Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#!\u001a)\t\u000b%\u0004A\u0011A\u001f\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\tA\u0007\u000bC\u0003m\u0001\u0011\u0005Q(A\u0017uKN$Hk\u001c9jGB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#a\u001b)\t\u000b=\u0004A\u0011A\u001f\u00023Q,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003]BCQA\u001d\u0001\u0005\u0002u\n!\b^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019%bYRLgn\u001a)s_\u001e\u0014Xm]:)\u0005E\u0004\u0006\"B;\u0001\t\u0003i\u0014a\u000e;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u0014Vm];nKN\fe\r^3s%\u0016\u0004H.[2b\u0007>lWm](oY&tW\r\u000b\u0002u!\")\u0001\u0010\u0001C\u0001{\u0005\u0011C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:D#a\u001e)\t\u000bm\u0004A\u0011A\u001f\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000f\u000b\u0002{!\")a\u0010\u0001C\u0001{\u0005iD/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\"\u0012Q\u0010\u0015\u0005\u0007\u0003\u0007\u0001A\u0011A\u001f\u0002MQ,7\u000f^!vi>\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017\rT3bI\u0016\u0014X\t\\3di&|g\u000eK\u0002\u0002\u0002ACa!!\u0003\u0001\t\u0003i\u0014\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007fAA\u0004!\"1\u0011q\u0002\u0001\u0005\u0002u\n1\t^3ti2+\u0017\rZ3s\u0003:$\u0017j\u001d:XQ\u0016tWI\u001c;je\u0016L5O](gM2Lg.Z!oIVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\u001a\u0011Q\u0002)\t\r\u0005U\u0001\u0001\"\u0001>\u0003Y!Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007fAA\n!\"1\u00111\u0004\u0001\u0005\u0002u\n\u0011\t^3ti\u000e{g\u000e\u001e:pY2,'OU3kK\u000e$8i\u001c8ue>dG.\u001a3TQV$Hm\\<o%\u0016\fX/Z:u/&$\bn\u0015;bY\u0016\u0014%o\\6fe\u0016\u0003xn\u00195)\u0007\u0005e\u0001\u000b\u0003\u0004\u0002\"\u0001!\t!P\u0001\"i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4Xm\u00148U_BL7m\u0011:fCRLwN\u001c\u0015\u0004\u0003?\u0001\u0006BBA\u0014\u0001\u0011\u0005Q(A\u0011uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c+pa&\u001cG)\u001a7fi&|g\u000eK\u0002\u0002&ACa!!\f\u0001\t\u0003i\u0014\u0001\f;fgR\u001cuN\u001c;s_2dWM]'pm\u0016|e\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\r\tY\u0003\u0015\u0005\u0007\u0003g\u0001A\u0011A\u001f\u0002SQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r\t\t\u0004\u0015\u0005\u0007\u0003s\u0001A\u0011A\u001f\u0002GQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0012+G/Z2ug\n{WO\\2fI\n\u0013xn[3sg\"\u001a\u0011q\u0007)\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005\u0011B/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f)\r9\u00131\t\u0005\t\u0003\u000b\ni\u00041\u0001\u0002H\u0005\u0019a-\u001e8\u0011\t!\nIeJ\u0005\u0004\u0003\u0017R\"!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\ty\u0005\u0001C\u0005\u0003#\na\u0004\u001d:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8\u0015\u0017\u001d\n\u0019&a\u0016\u0002\\\u0005E\u00141\u0011\u0005\b\u0003+\ni\u00051\u00013\u00031\u0019wN\u001c;s_2dWM]%e\u0011\u001d\tI&!\u0014A\u0002y\t1b\u001c;iKJ\u0014%o\\6fe\"A\u0011QLA'\u0001\u0004\ty&\u0001\u0002uaB!\u0011\u0011MA7\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AB2p[6|gNC\u0002\u0006\u0003SR1!a\u001bD\u0003\u0019\t\u0007/Y2iK&!\u0011qNA2\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\u001d\u0002N\u0001\u0007\u0011QO\u0001\te\u0016\u0004H.[2bgB)\u0011qOA?e9\u0019\u0001&!\u001f\n\u0007\u0005m$$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\n\tIA\u0002TKRT1!a\u001f\u001b\u0011\u001d\t))!\u0014A\u0002I\n1\u0002\\3bI\u0016\u0014X\t]8dQ\"9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0015\u0001G<bSR,f\u000e^5m\u0007>tGO]8mY\u0016\u0014X\t]8dQR)q%!$\u0002\u0012\"9\u0011qRAD\u0001\u0004\u0011\u0014!B3q_\u000eD\u0007\u0002CAJ\u0003\u000f\u0003\r!!&\u0002\u000f5,7o]1hKB!\u0011qOAL\u0013\u0011\tI*!!\u0003\rM#(/\u001b8h\u0011\u001d\ti\n\u0001C\u0005\u0003?\u000bQc^1ji\u001a{'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rF\u0006(\u0003C\u000b\u0019+a*\u0002,\u00065\u0006\u0002CA/\u00037\u0003\r!a\u0018\t\u000f\u0005\u0015\u00161\u0014a\u0001e\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002*\u0006m\u0005\u0019\u0001\u001a\u0002\r1,\u0017\rZ3s\u0011\u001d\t))a'A\u0002IB\u0001\"a%\u0002\u001c\u0002\u0007\u0011Q\u0013\u0005\b\u0003c\u0003A\u0011BAZ\u0003aI7/\u0012=qK\u000e$X\r\u001a)beRLG/[8o'R\fG/\u001a\u000b\u000b\u0003k\u000bY,!2\u0002H\u0006%\u0007c\u0001\u0015\u00028&\u0019\u0011\u0011\u0018\u000e\u0003\u000f\t{w\u000e\\3b]\"A\u0011QXAX\u0001\u0004\ty,A\u000emK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\t\u0004%\u0005\u0005\u0017bAAb\u0005\tYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"Dq!!*\u00020\u0002\u0007!\u0007C\u0004\u0002*\u0006=\u0006\u0019\u0001\u001a\t\u000f\u0005\u0015\u0015q\u0016a\u0001e!9\u0011Q\u001a\u0001\u0005\n\u0005=\u0017aC7bW\u0016\u001cVM\u001d<feN$rBFAi\u0003+\fI.!8\u0002b\u0006-\u0018q\u001e\u0005\b\u0003'\fY\r1\u00013\u0003)qW/\\\"p]\u001aLwm\u001d\u0005\u000b\u0003/\fY\r%AA\u0002\u0005U\u0016!G1vi>dU-\u00193feJ+'-\u00197b]\u000e,WI\\1cY\u0016D!\"a7\u0002LB\u0005\t\u0019AA[\u0003m)hn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\"Q\u0011q\\Af!\u0003\u0005\r!!.\u00021\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000e\u0003\u0006\u0002d\u0006-\u0007\u0013!a\u0001\u0003K\f\u0011\u0002\\5ti\u0016tWM]:\u0011\u000b!\n9/!&\n\u0007\u0005%(D\u0001\u0004PaRLwN\u001c\u0005\u000b\u0003[\fY\r%AA\u0002\u0005\u0015\u0018a\u00077jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pY6\u000b\u0007\u000f\u0003\u0006\u0002r\u0006-\u0007\u0013!a\u0001\u0003K\f\u0001dY8oiJ|G\u000e\u00157b]\u0016d\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\t)\u0010\u0001C\u0005\u0003o\fQ\u0001^5nKJ$B!!?\u0003\u0012A!\u00111 B\u0007\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011\u0001B2pe\u0016TAAa\u0001\u0003\u0006\u00059Q.\u001a;sS\u000e\u001c(\u0002\u0002B\u0004\u0005\u0013\ta!_1n[\u0016\u0014(B\u0001B\u0006\u0003\r\u0019w.\\\u0005\u0005\u0005\u001f\tiPA\u0003US6,'\u000f\u0003\u0005\u0003\u0014\u0005M\b\u0019AAK\u0003)iW\r\u001e:jG:\u000bW.\u001a\u0005\b\u0005/\u0001A\u0011\u0002B\r\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\ta\u0004C\u0005\u0003\u001e\u0001\t\n\u0011\"\u0003\u0003 \u0005)R.Y6f'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0011U\u0011\t)La\t,\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005ci!A!\u000b\u000b\t\t-\"QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\f\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005g\u0011ICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u000e\u0001#\u0003%IAa\b\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I!1\b\u0001\u0012\u0002\u0013%!qD\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\u0011y\u0004AI\u0001\n\u0013\u0011\t%A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\r#\u0006BAs\u0005GA\u0011Ba\u0012\u0001#\u0003%IA!\u0011\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I!1\n\u0001\u0012\u0002\u0013%!\u0011I\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0001")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to kill controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerId().isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to elect a controller";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        int x$33 = 1;
        Some x$34 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
        Some x$35 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$36 = new Some((Object)"CONTROLLER");
        boolean x$37 = this.makeServers$default$2();
        boolean x$38 = this.makeServers$default$3();
        boolean x$39 = this.makeServers$default$4();
        this.servers_$eq(this.makeServers(x$33, x$37, x$38, x$39, (Option<String>)x$34, (Option<String>)x$35, (Option<String>)x$36));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((KafkaServer)this.servers().head()).metrics().metrics().values()).asScala()).foreach((Function1)new Serializable(this, controlPlaneMetricMap, dataPlaneMetricMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map controlPlaneMetricMap$1;
            private final scala.collection.mutable.Map dataPlaneMetricMap$1;

            public final Object apply(KafkaMetric kafkaMetric) {
                Object object = kafkaMetric.metricName().tags().values().contains("CONTROLLER") ? this.controlPlaneMetricMap$1.put((Object)kafkaMetric.metricName().name(), (Object)kafkaMetric) : BoxedUnit.UNIT;
                return kafkaMetric.metricName().tags().values().contains("PLAINTEXT") ? this.dataPlaneMetricMap$1.put((Object)kafkaMetric.metricName().name(), (Object)kafkaMetric) : BoxedUnit.UNIT;
            }
            {
                this.controlPlaneMetricMap$1 = controlPlaneMetricMap$1;
                this.dataPlaneMetricMap$1 = dataPlaneMetricMap$1;
            }
        });
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetadataPropagationOnBrokerChange() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer testBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$1;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() != this.controllerId$1;
            }
            {
                this.controllerId$1 = controllerId$1;
            }
        })).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1)new Serializable(this, testBroker){
            public static final long serialVersionUID = 0L;
            private final KafkaServer testBroker$1;

            public final boolean apply(KafkaServer x$1) {
                return x$1.config().brokerId() != this.testBroker$1.config().brokerId();
            }
            {
                this.testBroker$1 = testBroker$1;
            }
        });
        String topic = "topic1";
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), remainingBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$2) {
                return x$2.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom()))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment2, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)remainingBrokers, TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        remainingBrokers.foreach((Function1)new Serializable(this, testBroker, remainingBrokers, topic, assignment2){
            public static final long serialVersionUID = 0L;
            private final KafkaServer testBroker$1;
            private final Seq remainingBrokers$1;
            private final String topic$1;
            private final scala.collection.immutable.Map assignment$1;

            public final void apply(KafkaServer server) {
                UpdateMetadataRequestData.UpdateMetadataPartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(this.topic$1, 0).get();
                Assert.assertEquals((long)1L, (long)offlineReplicaPartitionInfo.offlineReplicas().size());
                Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.testBroker$1.config().brokerId()), offlineReplicaPartitionInfo.offlineReplicas().get(0));
                Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).asJava(), (Object)offlineReplicaPartitionInfo.replicas());
                Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)this.remainingBrokers$1.head()).config().brokerId()}))).asJava(), (Object)offlineReplicaPartitionInfo.isr());
                UpdateMetadataRequestData.UpdateMetadataPartitionState onlinePartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(this.topic$1, 1).get();
                Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)1))).asJava(), (Object)onlinePartitionInfo.replicas());
                Assert.assertTrue((boolean)onlinePartitionInfo.offlineReplicas().isEmpty());
            }
            {
                this.testBroker$1 = testBroker$1;
                this.remainingBrokers$1 = remainingBrokers$1;
                this.topic$1 = topic$1;
                this.assignment$1 = assignment$1;
            }
        });
        testBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, assignment2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            public final String topic$1;
            public final scala.collection.immutable.Map assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.servers().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMetadataPropagationOnBrokerChange$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.assignment$1.exists((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testMetadataPropagationOnBrokerChange$1$$anonfun$apply$mcZ$sp$1 $outer;
                            private final KafkaServer server$1;

                            public final boolean apply(Tuple2<Object, Seq<Object>> x0$1) {
                                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
                                    int partitionId = tuple2._1$mcI$sp();
                                    Seq replicas = (Seq)tuple2._2();
                                    Option partitionInfoOpt = this.server$1.metadataCache().getPartitionInfo(this.$outer.kafka$controller$ControllerIntegrationTest$$anonfun$$anonfun$$$outer().topic$1, partitionId);
                                    boolean bl = partitionInfoOpt.isDefined() ? !(partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || !((GenSeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionInfo.replicas()).asScala()).equals((Object)replicas) : true;
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.server$1 = server$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$testMetadataPropagationOnBrokerChange$1 kafka$controller$ControllerIntegrationTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.assignment$1 = assignment$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Inconsistent metadata after broker startup";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testMetadataPropagationForOfflineReplicas() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer replicaBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() != this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() == this.controllerId$2;
            }
            {
                this.controllerId$2 = controllerId$2;
            }
        })).head();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId, replicaBroker){
            public static final long serialVersionUID = 0L;
            private final int controllerId$2;
            private final KafkaServer replicaBroker$1;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() != this.controllerId$2 && e.config().brokerId() != this.replicaBroker$1.config().brokerId();
            }
            {
                this.controllerId$2 = controllerId$2;
                this.replicaBroker$1 = replicaBroker$1;
            }
        })).head();
        String topic = "topic1";
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment2, this.servers());
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        controllerBroker.shutdown();
        controllerBroker.awaitShutdown();
        this.verifyMetadata$1(controllerBroker, topic);
        this.verifyMetadata$1(otherBroker, topic);
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$3) {
                return x$3.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$3;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 != this.controllerId$3;
            }
            {
                this.controllerId$3 = controllerId$3;
            }
        })).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), (Map)expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$5) {
                return x$5.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$4;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 != this.controllerId$4;
            }
            {
                this.controllerId$4 = controllerId$4;
            }
        })).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), (Map)expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=ControllerStats,name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ControllerState.AlterPartitionReassignment$.MODULE$.rateAndTimeMetricName().get()}));
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$7) {
                return x$7.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$5;

            public final boolean apply(int x$8) {
                return this.apply$mcZI$sp(x$8);
            }

            public boolean apply$mcZI$sp(int x$8) {
                return x$8 != this.controllerId$5;
            }
            {
                this.controllerId$5 = controllerId$5;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$9) {
                return x$9.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$2;
            private final scala.collection.immutable.Map reassignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map map = this.$outer.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$2.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$1;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.reassignment$1 = reassignment$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer count ", " should be greater than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updatedTimerCount), BoxesRunTime.boxToLong((long)timerCount)})), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$10) {
                return x$10.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$6;

            public final boolean apply(int x$11) {
                return this.apply$mcZI$sp(x$11);
            }

            public boolean apply$mcZI$sp(int x$11) {
                return x$11 != this.controllerId$6;
            }
            {
                this.controllerId$6 = controllerId$6;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "partition reassignment path should remain while reassignment in progress";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$12) {
                return x$12.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$7;

            public final boolean apply(int x$13) {
                return this.apply$mcZI$sp(x$13);
            }

            public boolean apply$mcZI$sp(int x$13) {
                return x$13 != this.controllerId$7;
            }
            {
                this.controllerId$7 = controllerId$7;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment((Map)reassignment.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReplicaAssignment x$14) {
                return x$14.replicas();
            }
        }).toMap(Predef$.MODULE$.$conforms()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$3;
            private final scala.collection.immutable.Map reassignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map map = this.$outer.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp$3.topic()})));
                scala.collection.immutable.Map map2 = this.reassignment$2;
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$3 = tp$3;
                this.reassignment$2 = reassignment$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get updated partition assignment on topic znode after partition reassignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove reassign partitions path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$8;

            public final boolean apply(KafkaServer x$15) {
                return x$15.config().brokerId() != this.controllerId$8;
            }
            {
                this.controllerId$8 = controllerId$8;
            }
        }).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$9;

            public final boolean apply(KafkaServer x$16) {
                return x$16.config().brokerId() != this.controllerId$9;
            }
            {
                this.controllerId$9 = controllerId$9;
            }
        }).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment2.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$17) {
                return x$17.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$10;

            public final boolean apply(int x$18) {
                return this.apply$mcZI$sp(x$18);
            }

            public boolean apply$mcZI$sp(int x$18) {
                return x$18 != this.controllerId$10;
            }
            {
                this.controllerId$10 = controllerId$10;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after giving up";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$19) {
                return x$19.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$11;

            public final boolean apply(int x$20) {
                return this.apply$mcZI$sp(x$20);
            }

            public boolean apply$mcZI$sp(int x$20) {
                return x$20 != this.controllerId$11;
            }
            {
                this.controllerId$11 = controllerId$11;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$21) {
                return x$21.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$12;

            public final boolean apply(int x$22) {
                return this.apply$mcZI$sp(x$22);
            }

            public boolean apply$mcZI$sp(int x$22) {
                return x$22 != this.controllerId$12;
            }
            {
                this.controllerId$12 = controllerId$12;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$1;
            private final TopicPartition tp$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$5})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$5)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5), this.$outer.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$5)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$1}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$1 = otherBrokerId$1;
                this.tp$5 = tp$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$40 = 2;
        boolean x$41 = true;
        boolean x$42 = this.makeServers$default$2();
        boolean x$43 = this.makeServers$default$4();
        Option<String> x$44 = this.makeServers$default$5();
        Option<String> x$45 = this.makeServers$default$6();
        Option<String> x$46 = this.makeServers$default$7();
        this.servers_$eq(this.makeServers(x$40, x$42, x$41, x$43, x$44, x$45, x$46));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$23) {
                return x$23.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$13;

            public final boolean apply(int x$24) {
                return this.apply$mcZI$sp(x$24);
            }

            public boolean apply$mcZI$sp(int x$24) {
                return x$24 != this.controllerId$13;
            }
            {
                this.controllerId$13 = controllerId$13;
            }
        })).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBrokerId, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int otherBrokerId$2;
            private final TopicPartition tp$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$6})));
                if (!leaderIsrAndControllerEpochMap.contains((Object)this.tp$6)) return false;
                if (!this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6), this.$outer.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
                List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$6)).leaderAndIsr().isr();
                List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.otherBrokerId$2}));
                if (list != null) {
                    if (!list.equals(list2)) return false;
                    return true;
                }
                if (list2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.otherBrokerId$2 = otherBrokerId$2;
                this.tp$6 = tp$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to get expected partition state after entire isr went offline";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testControlledShutdown() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$14;

            public final boolean apply(KafkaServer p) {
                return p.config().brokerId() == this.controllerId$14;
            }
            {
                this.controllerId$14 = controllerId$14;
            }
        }).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Serializable controlledShutdownCallback = new Serializable(this, resultQueue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue resultQueue$1;

            public final void apply(Try<Set<TopicPartition>> controlledShutdownResult) {
                this.resultQueue$1.put(controlledShutdownResult);
            }
            {
                this.resultQueue$1 = resultQueue$1;
            }
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$25) {
                return x$25.config().brokerId() == 2;
            }
        }).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() != 2;
            }
        })));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, partition, activeServers){
            public static final long serialVersionUID = 0L;
            public final String topic$3;
            public final int partition$1;
            private final ObjectRef activeServers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Seq)this.activeServers$1.elem).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testControlledShutdown$1 $outer;

                    public final boolean apply(KafkaServer x$26) {
                        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$26.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(this.$outer.topic$3, this.$outer.partition$1).get()).isr().size() != 3;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topic$3 = topic$3;
                this.partition$1 = partition$1;
                this.activeServers$1 = activeServers$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Topic test not created after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leader();
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.isr().size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.isr()).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$27) {
                return x$27.config().brokerId() == 1;
            }
        }).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Try try_ = (Try)resultQueue.take();
        if (try_ instanceof Success) {
            Set partitions;
            Set set;
            Success success = (Success)try_;
            partitionsRemaining = set = (partitions = (Set)success.value());
            Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
            activeServers.elem = (Seq)this.servers().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer s) {
                    return s.config().brokerId() == 0;
                }
            });
            partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
            leaderAfterShutdown = partitionStateInfo.leader();
            Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
            Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$3;
                private final int partition$1;

                public final boolean apply(KafkaServer x$28) {
                    return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$28.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(this.topic$3, this.partition$1).get()).leader() == 0;
                }
                {
                    this.topic$3 = topic$3;
                    this.partition$1 = partition$1;
                }
            }));
            controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$29) {
                    return x$29.config().brokerId() == 0;
                }
            }).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
            partitionsRemaining = (Set)((Try)resultQueue.take()).get();
            Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
            Assert.assertTrue((boolean)this.servers().forall((Function1)new Serializable(this, topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$3;
                private final int partition$1;

                public final boolean apply(KafkaServer x$30) {
                    return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$30.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(this.topic$3, this.partition$1).get()).leader() == 0;
                }
                {
                    this.topic$3 = topic$3;
                    this.partition$1 = partition$1;
                }
            }));
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw Assertions$.MODULE$.fail("Controlled shutdown failed due to error", exception, new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }
        throw new MatchError((Object)try_);
    }

    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controller){
            public static final long serialVersionUID = 0L;
            private final KafkaController controller$1;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() != this.controller$1.config().brokerId();
            }
            {
                this.controller$1 = controller$1;
            }
        }).get();
        VolatileBooleanRef staleBrokerEpochDetected = VolatileBooleanRef.create((boolean)false);
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1)new Serializable(this, staleBrokerEpochDetected){
            public static final long serialVersionUID = 0L;
            private final VolatileBooleanRef staleBrokerEpochDetected$1;

            public final void apply(Try<Set<TopicPartition>> x0$2) {
                Failure failure;
                Throwable exception;
                Try<Set<TopicPartition>> try_ = x0$2;
                if (try_ instanceof Failure && (exception = (failure = (Failure)try_).exception()) instanceof StaleBrokerEpochException) {
                    this.staleBrokerEpochDetected$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.staleBrokerEpochDetected$1 = staleBrokerEpochDetected$1;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, staleBrokerEpochDetected){
            public static final long serialVersionUID = 0L;
            private final VolatileBooleanRef staleBrokerEpochDetected$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.staleBrokerEpochDetected$1.elem;
            }
            {
                this.staleBrokerEpochDetected$1 = staleBrokerEpochDetected$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Fail to detect stale broker epoch";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp, assignment2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$7;
            private final scala.collection.immutable.Map assignment$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient adminZkClient = new AdminZkClient(this.$outer.zkClient());
                adminZkClient.createTopicWithAssignment(this.tp$7.topic(), new Properties(), (Map)this.assignment$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$7 = tp$7;
                this.assignment$2 = assignment$2;
            }
        });
    }

    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$8;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminZkClient adminZkClient = new AdminZkClient(this.$outer.zkClient());
                adminZkClient.deleteTopic(this.tp$8.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$8 = tp$8;
            }
        });
    }

    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$9;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$9})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$9 = tp$9;
            }
        });
    }

    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)new Serializable(this, reassignment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final scala.collection.immutable.Map reassignment$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkClient().createPartitionReassignment((Map)this.reassignment$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.reassignment$3 = reassignment$3;
            }
        });
    }

    @Test
    public void testControllerDetectsBouncedBrokers() {
        int x$47 = 2;
        boolean x$48 = false;
        boolean x$49 = this.makeServers$default$2();
        boolean x$50 = this.makeServers$default$3();
        Option<String> x$51 = this.makeServers$default$5();
        Option<String> x$52 = this.makeServers$default$6();
        Option<String> x$53 = this.makeServers$default$7();
        this.servers_$eq(this.makeServers(x$47, x$49, x$50, x$48, x$51, x$52, x$53));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1)new Serializable(this, controller){
            public static final long serialVersionUID = 0L;
            private final KafkaController controller$2;

            public final boolean apply(KafkaServer e) {
                return e.config().brokerId() != this.controller$2.config().brokerId();
            }
            {
                this.controller$2 = controller$2;
            }
        }).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controller){
            public static final long serialVersionUID = 0L;
            private final KafkaController controller$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ControllerState controllerState = this.controller$2.eventManager().state();
                ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
            }
            {
                this.controller$2 = controller$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller event thread is still busy";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(this, latch){
            private final CountDownLatch latch$1;

            public void process() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        otherBroker.shutdown();
        otherBroker.startup();
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, otherBroker){
            public static final long serialVersionUID = 0L;
            private final KafkaServer otherBroker$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToInt((Object)this.otherBroker$1.replicaManager().partitionCount().value()) == 1 && this.otherBroker$1.replicaManager().metadataCache().getAllTopics().size() == 1 && this.otherBroker$1.replicaManager().metadataCache().getAliveBrokers().size() == 2;
            }
            {
                this.otherBroker$1 = otherBroker$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Broker fail to initialize after restart";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.getClass(), Level.INFO);
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controller){
                public static final long serialVersionUID = 0L;
                private final KafkaController controller$3;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    ControllerState controllerState = this.controller$3.eventManager().state();
                    ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                    return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
                }
                {
                    this.controller$3 = controller$3;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller event thread is still busy";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new MockEvent(this, latch){
                private final CountDownLatch latch$2;

                public void process() {
                    this.latch$2.await();
                }
                {
                    this.latch$2 = latch$2;
                    super((ControllerState)ControllerState.TopicChange$.MODULE$);
                }
            });
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controller){
                public static final long serialVersionUID = 0L;
                private final KafkaController controller$3;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return !this.controller$3.isActive();
                }
                {
                    this.controller$3 = controller$3;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller fails to resign";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Option event = appender.getMessages().find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(LoggingEvent e) {
                    Level level = e.getLevel();
                    Level level2 = Level.INFO;
                    if (level == null) {
                        if (level2 != null) {
                            return false;
                        }
                    } else if (!level.equals(level2)) return false;
                    if (e.getThrowableInformation() == null) return false;
                    if (!e.getThrowableInformation().getThrowable().getClass().getName().equals(ControllerMovedException.class.getName())) return false;
                    return true;
                }
            });
            Assert.assertTrue((boolean)event.isDefined());
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
        catch (Throwable throwable) {
            void var4_4;
            void var2_2;
            void var3_3;
            LogCaptureAppender$.MODULE$.unregister((LogCaptureAppender)var3_3);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(var2_2.eventManager().thread().getClass(), (Level)var4_4);
            throw throwable;
        }
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, replicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$4;
            private final scala.collection.immutable.Set replicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Set set = ((TraversableOnce)this.$outer.zkClient().getInSyncReplicasForPartition(new TopicPartition(this.tp$4.topic(), this.tp$4.partition())).get()).toSet();
                scala.collection.immutable.Set set2 = this.replicas$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$4 = tp$4;
                this.replicas$1 = replicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "restarted broker failed to join in-sync replicas";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failed to remove preferred replica leader election path after completion";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final int epoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.zkClient().getControllerEpoch().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Stat> x$31) {
                        return x$31._1$mcI$sp();
                    }
                }).contains((Object)BoxesRunTime.boxToInteger((int)this.epoch$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader2, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, controllerEpoch, leader2, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerIntegrationTest $outer;
            private final TopicPartition tp$1;
            private final int controllerEpoch$1;
            private final int leader$1;
            private final int leaderEpoch$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map leaderIsrAndControllerEpochMap = this.$outer.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
                return leaderIsrAndControllerEpochMap.contains((Object)this.tp$1) && this.$outer.kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)this.tp$1), this.controllerEpoch$1, this.leader$1, this.leaderEpoch$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leader$1 = leader$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        }, (Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$2;

            public final String apply() {
                return this.message$2;
            }
            {
                this.message$2 = message$2;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public boolean kafka$controller$ControllerIntegrationTest$$isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader2, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader2 && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), enableControlledShutdown, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        configs.foreach((Function1)new Serializable(this, autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName){
            public static final long serialVersionUID = 0L;
            private final boolean autoLeaderRebalanceEnable$1;
            private final boolean uncleanLeaderElectionEnable$1;
            private final Option listeners$1;
            private final Option listenerSecurityProtocolMap$1;
            private final Option controlPlaneListenerName$1;

            public final void apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.autoLeaderRebalanceEnable$1)).toString());
                config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)this.uncleanLeaderElectionEnable$1)).toString());
                config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
                this.listeners$1.foreach((Function1)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final Properties config$1;

                    public final Object apply(String listener) {
                        return this.config$1.setProperty(KafkaConfig$.MODULE$.ListenersProp(), listener);
                    }
                    {
                        this.config$1 = config$1;
                    }
                });
                this.listenerSecurityProtocolMap$1.foreach((Function1)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final Properties config$1;

                    public final Object apply(String listenerMap) {
                        return this.config$1.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), listenerMap);
                    }
                    {
                        this.config$1 = config$1;
                    }
                });
                this.controlPlaneListenerName$1.foreach((Function1)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final Properties config$1;

                    public final Object apply(String controlPlaneListener) {
                        return this.config$1.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), controlPlaneListener);
                    }
                    {
                        this.config$1 = config$1;
                    }
                });
            }
            {
                this.autoLeaderRebalanceEnable$1 = autoLeaderRebalanceEnable$1;
                this.uncleanLeaderElectionEnable$1 = uncleanLeaderElectionEnable$1;
                this.listeners$1 = listeners$1;
                this.listenerSecurityProtocolMap$1 = listenerSecurityProtocolMap$1;
                this.controlPlaneListenerName$1 = controlPlaneListenerName$1;
            }
        });
        return (Seq)configs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties config) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$32) {
                String string = x$32.getMBeanName();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final Nothing$ apply() {
                return Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            }
            {
                this.metricName$1 = metricName$1;
            }
        });
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, controllerId){
            public static final long serialVersionUID = 0L;
            private final int controllerId$15;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == this.controllerId$15;
            }
            {
                this.controllerId$15 = controllerId$15;
            }
        })).head();
    }

    private final void verifyMetadata$1(KafkaServer broker, String topic$2) {
        broker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic$2, broker){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final KafkaServer broker$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
                Option partitionInfoOpt = this.broker$1.metadataCache().getPartitionInfo(this.topic$2, 0);
                return partitionInfoOpt.isDefined() ? !((partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || partitionInfo.leader() != -1 || partitionInfo.replicas().isEmpty() || partitionInfo.isr().isEmpty()) : false;
            }
            {
                this.topic$2 = topic$2;
                this.broker$1 = broker$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Inconsistent metadata after broker startup";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }
}

