/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001%\u0011Q\u0006\u0016:b]N\f7\r^5p]6\u000b'o[3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000fY\u0001!\u0019!C\u0005/\u0005A!M]8lKJLE-F\u0001\u0019!\tY\u0011$\u0003\u0002\u001b\u0019\t\u0019\u0011J\u001c;\t\rq\u0001\u0001\u0015!\u0003\u0019\u0003%\u0011'o\\6fe&#\u0007\u0005C\u0004\u001f\u0001\t\u0007I\u0011B\f\u0002#QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004!\u0001\u0001\u0006I\u0001G\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012\u0001\n\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019\u0019FO]5oO\"1Q\u0006\u0001Q\u0001\n\u0011\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003E\u0002\"a\u0003\u001a\n\u0005Mb!\u0001\u0002'p]\u001eDa!\u000e\u0001!\u0002\u0013\t\u0014a\u00039s_\u0012,8-\u001a:JI\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(A\u0007qe>$WoY3s\u000bB|7\r[\u000b\u0002sA\u00111BO\u0005\u0003w1\u0011Qa\u00155peRDa!\u0010\u0001!\u0002\u0013I\u0014A\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003\u0018\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0011\u0019\t\u0005\u0001)A\u00051\u0005iA\u000f\u001f8US6,w.\u001e;Ng\u0002Bqa\u0011\u0001C\u0002\u0013%q#\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"1Q\t\u0001Q\u0001\na\t\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0011\u001d9\u0005A1A\u0005\n!\u000b\u0011\u0002\u001e=o%\u0016\u001cX\u000f\u001c;\u0016\u0003%\u0003\"A\u0013+\u000e\u0003-S!\u0001T'\u0002\u0011I,\u0017/^3tiNT!AT(\u0002\r\r|W.\\8o\u0015\t9\u0001K\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<\u0017BA+L\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B%\u0002\u0015QDhNU3tk2$\b\u0005C\u0004Z\u0001\t\u0007I\u0011\u0002.\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\f\u0005\u0002];6\tQ*\u0003\u0002_\u001b\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00021\u0001A\u0003%1,A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001d\u0011\u0007A1A\u0005\n\r\fq\u0002\u001e=o\u0013\u0012\fe\u000eZ'be.,'o]\u000b\u0002IB\u0019Q\r\u001b6\u000e\u0003\u0019T!a\u001a\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003S\u001a\u0014A\u0001T5tiB\u0011Ac[\u0005\u0003Y\n\u00111\u0003\u0016=o\u0013\u0012\fe\u000eZ'be.,'/\u00128uefDaA\u001c\u0001!\u0002\u0013!\u0017\u0001\u0005;y]&#\u0017I\u001c3NCJ\\WM]:!\u0011\u001d\u0001\bA1A\u0005\nE\f1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCV\t!\u000f\u0005\u0002\u0015g&\u0011AO\u0001\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\u0002\u0019QDh.T3uC\u0012\fG/\u0019\u0011\t\u000fa\u0004!\u0019!C\u0005s\u0006!R.\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\u0012A\u001f\t\u0003)mL!\u0001 \u0002\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA_\u0001\u0016[\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019!A\buq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s+\t\t)\u0001E\u0002\u0015\u0003\u000fI1!!\u0003\u0003\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'\u000f\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0003\u0003A!\bP\\*uCR,W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014\u00059\u0001.\u00198eY\u0016\u0014XCAA\u000b!\r!\u0012qC\u0005\u0004\u00033\u0011!!\u000b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6feJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000f\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u000b\u0003!A\u0017M\u001c3mKJ\u0004\u0003bBA\u0011\u0001\u0011%\u00111E\u0001\n[>\u001c7nQ1dQ\u0016$\"!!\n\u0011\u0007-\t9#C\u0002\u0002*1\u0011A!\u00168ji\"9\u0011Q\u0006\u0001\u0005\u0002\u0005\r\u0012aL:i_VdGMU3F]F,X-^3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8Ce>\\WM\u001d#jg\u000e|gN\\3di\u0016$\u0007\u0006BA\u0016\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0011\u0016!\u00026v]&$\u0018\u0002BA\u001e\u0003k\u0011A\u0001V3ti\"9\u0011q\b\u0001\u0005\u0002\u0005\r\u0012!P:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Le-\u0012:s_J\u001cu\u000eZ3O_R\fe/Y5mC\ndWMR8s!&$\u0007\u0006BA\u001f\u0003cAq!!\u0012\u0001\t\u0003\t\u0019#\u0001\u0016tQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\u001c(p\u000bJ\u0014xN]:)\t\u0005\r\u0013\u0011\u0007\u0005\b\u0003\u0017\u0002A\u0011AA\u0012\u0003A\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u00165f]:{GoQ8pe\u0012Lg.\u0019;pe\"\"\u0011\u0011JA\u0019\u0011\u001d\t\t\u0006\u0001C\u0001\u0003G\tAg\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016t7i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8hQ\u0011\ty%!\r\t\u000f\u0005]\u0003\u0001\"\u0001\u0002$\u0005I4\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK:\u001cun\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u00115b]\u001e,G\r\u000b\u0003\u0002V\u0005E\u0002bBA/\u0001\u0011\u0005\u00111E\u00017g\"|W\u000f\u001c3D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:<\u0006.\u001a8J]Z\fG.\u001b3Qe>$WoY3s\u000bB|7\r\u001b\u0015\u0005\u00037\n\t\u0004C\u0004\u0002d\u0001!\t!a\t\u0002oMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u001a+gnY3eQ\u0011\t\t'!\r\t\u000f\u0005%\u0004\u0001\"\u0001\u0002$\u0005\u00014\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",g.\u00168l]><h.\u0012:s_JDC!a\u001a\u00022!9\u0011q\u000e\u0001\u0005\u0002\u0005\r\u0012aN:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3FeJ|'\u000f\u000b\u0003\u0002n\u0005E\u0002bBA;\u0001\u0011\u0005\u00111E\u00019g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|gn\u00165f]6+7o]1hKR{w\u000eT1sO\u0016,%O]8sQ\u0011\t\u0019(!\r\t\u000f\u0005m\u0004\u0001\"\u0001\u0002$\u0005Y4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",gNU3d_J$G*[:u)>|G*\u0019:hK\u0016\u0013(o\u001c:)\t\u0005e\u0014\u0011\u0007\u0005\b\u0003\u0003\u0003A\u0011AA\u0012\u0003q\u001a\bn\\;mIRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8XQ\u0016t\u0017J\u001c<bY&$'+Z9vSJ,G-Q2lg\u0016\u0013(o\u001c:)\t\u0005}\u0014\u0011\u0007\u0005\b\u0003\u000f\u0003A\u0011AA\u0012\u0003Q\u001a\bn\\;mIJ+GO]=QCJ$\u0018\u000e^5p]^CWM\\+oW:|wO\u001c+pa&\u001cwJ\u001d)beRLG/[8o\u000bJ\u0014xN\u001d\u0015\u0005\u0003\u000b\u000b\t\u0004C\u0004\u0002\u000e\u0002!\t!a\t\u0002eMDw.\u001e7e%\u0016$(/\u001f)beRLG/[8o/\",gNT8u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|g.\u0012:s_JDC!a#\u00022!9\u00111\u0013\u0001\u0005\u0002\u0005\r\u0012AL:i_VdGMU3uef\u0004\u0016M\u001d;ji&|gn\u00165f]:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u0012:s_JDC!!%\u00022!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005\r\u0012!O:i_VdGMU3uef\u0004\u0016M\u001d;ji&|gn\u00165f]:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u00114uKJ\f\u0005\u000f]3oI\u0016\u0013(o\u001c:)\t\u0005]\u0015\u0011\u0007\u0005\b\u0003?\u0003A\u0011AA\u0012\u0003\u0015\u001b\bn\\;mIJ+Wn\u001c<f)>\u0004\u0018n\u0019)beRLG/[8o\rJ|WnV1ji&twmU3u\u001f:,fn];qa>\u0014H/\u001a3G_JlUm]:bO\u00164uN]7bi\"\"\u0011QTA\u0019\u0011\u001d\t)\u000b\u0001C\u0005\u0003O\u000bQD^3sS\u001aL(+\u001a;sS\u0016\u001c\b+\u0019:uSRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003K\tI\u000b\u0003\u0005\u0002,\u0006\r\u0006\u0019AAW\u0003\u0015)'O]8s!\u0011\ty+!.\u000e\u0005\u0005E&bAAZ\u001b\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u00028\u0006E&AB#se>\u00148\u000fC\u0004\u0002<\u0002!I!!0\u0002OY,'/\u001b4z)\"\u0014xn^%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003K\ty\f\u0003\u0005\u0002,\u0006e\u0006\u0019AAW\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b\fQE^3sS\u001aL8i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005\u0015\u0012q\u0019\u0005\t\u0003W\u000b\t\r1\u0001\u0002.\"9\u00111\u001a\u0001\u0005\n\u00055\u0017a\t<fe&4\u0017PU3n_Z,G)\u001a7bs\u0016$w\n]3sCRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003K\ty\r\u0003\u0005\u0002,\u0006%\u0007\u0019AAW\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'/\u00133FeJ|'/T1q)\u0011\t9.a:\u0011\u000f\u0015\fI.!8\u0002b&\u0019\u00111\u001c4\u0003\u000f!\u000b7\u000f['baB\u0019Q%a8\n\u0005M2\u0003CB3\u0002dn\u000bi+C\u0002\u0002f\u001a\u00141!T1q\u0011!\tI/!5A\u0002\u00055\u0016AB3se>\u00148\u000f")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkers = Arrays.asList((Object[])new TxnIdAndMarkerEntry[]{new TxnIdAndMarkerEntry(this.transactionalId(), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.txnIdAndMarkers());

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private List<TxnIdAndMarkerEntry> txnIdAndMarkers() {
        return this.txnIdAndMarkers;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal argument exception");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWheCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderForPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    private void verifyThrowIllegalStateExceptionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().completeSendMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, completed){
            private final BooleanRef completed$1;

            public void answer() {
                this.completed$1.elem = true;
            }
            {
                this.completed$1 = completed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assert.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        this.markerChannelManager().removeMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, removed){
            private final BooleanRef removed$1;

            public void answer() {
                this.removed$1.elem = true;
            }
            {
                this.removed$1 = removed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)removed.elem);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return var2_2;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

