/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u0007i6\u0004H)\u001b:\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u0005%|'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011AAR5mK\"1Q\u0005\u0001Q\u0001\nq\tq\u0001^7q\t&\u0014\b\u0005C\u0004(\u0001\t\u0007I\u0011A\u000e\u0002\r1|w\rR5s\u0011\u0019I\u0003\u0001)A\u00059\u00059An\\4ESJ\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003\u0019\u0019w.\\7p]*\u0011QA\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028_\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001d\u0001A\u0003%Q&A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001dY\u0004A1A\u0005\u0002q\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tI\u0001\u0005kRLG.\u0003\u0002C\u007f\tQ\u0001K]8qKJ$\u0018.Z:\t\r\u0011\u0003\u0001\u0015!\u0003>\u0003%awn\u001a)s_B\u001c\b\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\u00131|wmQ8oM&<W#\u0001%\u0011\u0005aI\u0015B\u0001&\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004M\u0001\u0001\u0006I\u0001S\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\u0005i&lW-F\u0001Q!\ty\u0011+\u0003\u0002S!\tAQj\\2l)&lW\r\u0003\u0004U\u0001\u0001\u0006I\u0001U\u0001\u0006i&lW\r\t\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0003I\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0003a\u0003B!\u00170.A6\t!L\u0003\u0002\\9\u00069Q.\u001e;bE2,'BA/\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?j\u00131!T1q!\tI\u0011-\u0003\u0002c\u0015\t!Aj\u001c8h\u0011\u0019!\u0007\u0001)A\u00051\u0006\u00192\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;tA\u0019!a\r\u0001\u0001h\u0005UaunZ\"mK\u0006tWM]'b]\u0006<WM]'pG.\u001c\"!\u001a5\u0011\u0005aI\u0017B\u00016\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\nY\u0016\u0014\t\u0011)A\u0005[f\fq\u0001\\8h\t&\u00148\u000fE\u0002omrq!a\u001c;\u000f\u0005A\u001cX\"A9\u000b\u0005I4\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t)(\"A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(aA*fc*\u0011QOC\u0005\u0003Y&D!b_3\u0003\u0002\u0003\u0006I\u0001`A\u0003\u0003\u0011awnZ:\u0011\t=iXf`\u0005\u0003}B\u0011A\u0001U8pYB\u0019\u0001$!\u0001\n\u0007\u0005\r!AA\u0002M_\u001eL!a_5\t\u0019\u0005%QM!A!\u0002\u0013\tY!a\u0006\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\t\u000511/\u001a:wKJLA!!\u0006\u0002\u0010\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2L1!!\u0003j\u0011\u0019)R\r\"\u0001\u0002\u001cQA\u0011QDA\u0011\u0003G\t)\u0003E\u0002\u0002 \u0015l\u0011\u0001\u0001\u0005\u0007Y\u0006e\u0001\u0019A7\t\rm\fI\u00021\u0001}\u0011!\tI!!\u0007A\u0002\u0005-\u0001bBA\u0015K\u0012\u0005\u00131F\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\ti\u0003\u0005\u0004\u00020\u0005UR\u0006\u0019\b\u0004\u0013\u0005E\u0012bAA\u001a\u0015\u00051\u0001K]3eK\u001aL1aXA\u001c\u0015\r\t\u0019D\u0003\u0005\b\u0003w)G\u0011IA\u001f\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0007\u0003\u007f\t)%!\u0013\u0011\u0007%\t\t%C\u0002\u0002D)\u0011A!\u00168ji\"9\u0011qIA\u001d\u0001\u0004a\u0012a\u00023bi\u0006$\u0015N\u001d\u0005\t\u0003\u0017\nI\u00041\u0001\u0002N\u00051Q\u000f\u001d3bi\u0016\u0004R!CA(\u0003'J1!!\u0015\u000b\u0005\u0019y\u0005\u000f^5p]B)\u0011\"!\u0016.A&\u0019\u0011q\u000b\u0006\u0003\rQ+\b\u000f\\33\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u007fAC!!\u0017\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002hQ\nQA[;oSRLA!a\u001b\u0002f\t)\u0011I\u001a;fe\"9\u0011q\u000e\u0001\u0005\n\u0005E\u0014aG:fiV\u0004\u0018J\\2sK\u0006\u001c\u0018N\\4ms\u001aKG\u000e\u001e5z\u0019><7\u000fF\u0004}\u0003g\nI(a!\t\u0011\u0005U\u0014Q\u000ea\u0001\u0003o\n!\u0002]1si&$\u0018n\u001c8t!\rqg/\f\u0005\t\u0003w\ni\u00071\u0001\u0002~\u0005y1\u000f^1si:+XNQ1uG\",7\u000fE\u0002\n\u0003\u007fJ1!!!\u000b\u0005\rIe\u000e\u001e\u0005\t\u0003\u000b\u000bi\u00071\u0001\u0002~\u0005q!-\u0019;dQ&s7M]3nK:$\bbBAE\u0001\u0011\u0005\u0011QL\u0001-i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pORC'o\\<t\u000bb\u001cW\r\u001d;j_:DC!a\"\u0002\u000eB!\u00111MAH\u0013\u0011\t\t*!\u001a\u0003\tQ+7\u000f\u001e\u0005\b\u0003+\u0003A\u0011AA/\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><'+\u001a;ve:\u001cHj\\4XSRDG)\u001b:uS\u0016\u001cHOU1uS>DC!a%\u0002\u000e\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0013!\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\t\u0005e\u0015Q\u0012\u0005\b\u0003C\u0003A\u0011AA/\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]NDC!a(\u0002\u000e\"9\u0011q\u0015\u0001\u0005\u0002\u0005u\u0013\u0001\u0016;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:C_RD\u0017J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]N\fe\u000eZ+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003K\u000bi\tC\u0004\u0002.\u0002!\t!!\u0018\u0002SQ,7\u000f\u001e#jeRLxJ\u001a4tKR\u0014Vm]3u\u0013\u001ad\u0015M]4feRC\u0017M\\#oI>3gm]3uQ\u0011\tY+!$\t\u000f\u0005M\u0006\u0001\"\u0001\u0002^\u0005aC/Z:u\t&\u0014H/_(gMN,GOU3tKRLemU7bY2,'\u000f\u00165b]N#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u0005\u0003c\u000bi\tC\u0004\u0002:\u0002!\t!!\u0018\u0002gQ,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e'be\u001e,'\u000f\u00165b]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$\b\u0006BA\\\u0003\u001bCq!a0\u0001\t\u0003\ti&\u0001\u0019uKN$H)\u001b:us>3gm]3u\u0019\u0006\u0014x-\u001a:UQ\u0006t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0005\u0003{\u000bi\tC\u0004\u0002F\u0002!\t!!\u0018\u0002\tR,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u001d>$8i\u001c8tS\u0012,'o\u00117fC:,\b\u000fU8mS\u000eLH)\u001a7fi\u0016dunZ:)\t\u0005\r\u0017Q\u0012\u0005\b\u0003\u0017\u0004A\u0011AA/\u0003!#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di\u0012+G.\u001a;f\u0019><7\u000f\u000b\u0003\u0002J\u00065\u0005bBAi\u0001\u0011\u0005\u0011QL\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\b\u0006BAh\u0003\u001bCq!a6\u0001\t\u0003\ti&A\u0016uKN$Hj\\4t+:$WM]\"mK\u0006tW\u000f]%oK2Lw-\u001b2mK\u001a{'oQ8na\u0006\u001cG/[8oQ\u0011\t).!$\t\u000f\u0005u\u0007\u0001\"\u0001\u0002^\u0005AC/Z:u\u0007>t7-\u001e:sK:$Hj\\4DY\u0016\fg.\u001e9B]\u0012dun\u001a+sk:\u001c\u0017\r^5p]\"\"\u00111\\AG\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003;\n\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gk\u001c9jG\u0012+G.\u001a;j_:DC!!9\u0002\u000e\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005u\u0013A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3feVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\"\u0011q]AG\u0011\u001d\ty\u000f\u0001C\u0001\u0003;\n1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:O_:,\u0007\u0006BAw\u0003\u001bCq!!>\u0001\t\u0003\ti&A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peRKW.\u001a\u0015\u0005\u0003g\fi\tC\u0004\u0002|\u0002!\t!!\u0018\u0002AQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u00148\u000b[8siRKW.\u001a\u0015\u0005\u0003s\fi\tC\u0004\u0003\u0002\u0001!\t!!\u0018\u0002QQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u001d\u0016,Gm]\"iK\u000e\\\u0007o\\5oiJ+7/\u001a;)\t\u0005}\u0018Q\u0012\u0005\b\u0005\u000f\u0001A\u0011AA/\u0003)\"Xm\u001d;V]\u0012,7-\u001b3fIR\u0013\u0018M\\:bGRLwN\\1m\t\u0006$\u0018MT8u\u00072,\u0017M\\1cY\u0016DCA!\u0002\u0002\u000e\"9!Q\u0002\u0001\u0005\u0002\u0005u\u0013\u0001\u0005;fgR$uN\\3DY\u0016\fg.\u001b8hQ\u0011\u0011Y!!$\t\u000f\tM\u0001\u0001\"\u0001\u0002^\u0005\u0001B/Z:u\t>tW\rR3mKRLgn\u001a\u0015\u0005\u0005#\ti\tC\u0004\u0003\u001a\u0001!\t!!\u0018\u0002_Q,7\u000f^\"iK\u000e\\\u0007o\\5oiV\u0003H-\u0019;fI\u001a{'/\u00138wC2LGm\u00144gg\u0016$hj\\\"mK\u0006t\u0017N\\4)\t\t]\u0011Q\u0012\u0005\b\u0005?\u0001A\u0011AA/\u0003A\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8u'\u0016dWm\u0019;fI\"\"!QDAG\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005O\tAc\u0019:fCR,7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Hc\u00015\u0003*!11Aa\tA\u0002}DqA!\f\u0001\t\u0013\u0011y#\u0001\rde\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM]'pG.$B!!\b\u00032!9!1\u0007B\u0016\u0001\u0004a\u0018\u0001\u00029p_2DqAa\u000e\u0001\t\u0013\u0011I$A\u0005de\u0016\fG/\u001a'pOR9qPa\u000f\u0003@\t%\u0003\u0002\u0003B\u001f\u0005k\u0001\r!! \u0002\u0017M,w-\\3oiNK'0\u001a\u0005\t\u0005\u0003\u0012)\u00041\u0001\u0003D\u0005i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a\f\u0003F%!!qIA\u001c\u0005\u0019\u0019FO]5oO\"A1F!\u000e\u0011\u0002\u0003\u0007Q\u0006C\u0004\u0003N\u0001!IAa\u0014\u00027\r\u0014X-\u0019;f\u0019><(+\u001a;f]RLwN\u001c'pO\u000e{gNZ5h)\u0015A%\u0011\u000bB*\u0011!\u0011iDa\u0013A\u0002\u0005u\u0004\u0002\u0003B!\u0005\u0017\u0002\rAa\u0011\t\u000f\t]\u0003\u0001\"\u0003\u0003Z\u0005aqO]5uKJ+7m\u001c:egRQ\u0011q\bB.\u0005;\u0012\tG!\u001a\t\r\r\u0011)\u00061\u0001\u0000\u0011!\u0011yF!\u0016A\u0002\u0005u\u0014A\u00038v[\n\u000bGo\u00195fg\"A!1\rB+\u0001\u0004\ti(A\bsK\u000e|'\u000fZ:QKJ\u0014\u0015\r^2i\u0011!\u00119G!\u0016A\u0002\u0005u\u0014!\u00052bi\u000eDWm\u001d)feN+w-\\3oi\"9!1\u000e\u0001\u0005\n\t5\u0014!D1qa\u0016tGMU3d_J$7\u000f\u0006\u0004\u0002@\t=$\u0011\u000f\u0005\u0007\u0007\t%\u0004\u0019A@\t\u0011\tM$\u0011\u000ea\u0001\u0003{\n!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\u00119\b\u0001C\u0005\u0005s\nq!\\1lK2{w\rF\u0003\u0000\u0005w\u0012y\bC\u0005\u0003~\tU\u0004\u0013!a\u00019\u0005\u0019A-\u001b:\t\u000f\t\u0005%Q\u000fa\u0001\u0011\u000611m\u001c8gS\u001eDqA!\"\u0001\t\u0013\u00119)A\u0004sK\u000e|'\u000fZ:\u0015\u0011\t%%Q\u0013BM\u0005;\u0003BAa#\u0003\u00126\u0011!Q\u0012\u0006\u0004\u0005\u001f{\u0013A\u0002:fG>\u0014H-\u0003\u0003\u0003\u0014\n5%!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0003\u0018\n\r\u0005\u0019AA?\u0003\rYW-\u001f\u0005\t\u00057\u0013\u0019\t1\u0001\u0002~\u0005)a/\u00197vK\"9!q\u0014BB\u0001\u0004\u0001\u0017!\u0003;j[\u0016\u001cH/Y7q\u0011%\u0011\u0019\u000bAI\u0001\n\u0013\u0011)+A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003(*\u001aQF!+,\u0005\t-\u0006\u0003\u0002BW\u0005ok!Aa,\u000b\t\tE&1W\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!.\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0013yKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!0\u0001#\u0003%IAa0\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003B*\u001aAD!+")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, Log> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1)new Serializable(this, batchIncrement, logs, numBatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final int batchIncrement$1;
            private final Pool logs$1;
            private final IntRef numBatches$1;

            public final void apply(TopicPartition tp) {
                Log log2 = this.$outer.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
                this.logs$1.put((Object)tp, (Object)log2);
                this.$outer.kafka$log$LogCleanerManagerTest$$writeRecords(log2, this.numBatches$1.elem, 1, 5);
                this.numBatches$1.elem += this.batchIncrement$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchIncrement$1 = batchIncrement$1;
                this.logs$1 = logs$1;
                this.numBatches$1 = numBatches$1;
            }
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends Log {
            public final /* synthetic */ LogCleanerManagerTest $outer;

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogMock$$$outer() {
                return this.$outer;
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, File dir, LogConfig config, TopicPartition tp$1, File tpDir$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(dir, config, 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), $outer.topicPartition(), new ProducerStateManager(tp$1, tpDir$1, 3600000), new LogDirFailureChannel(10));
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log2 = new Kafka_log_LogCleanerManagerTest$LogMock$1(this, tpDir, this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact()), tp, tpDir);
        this.kafka$log$LogCleanerManagerTest$$writeRecords(log2, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log2);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final LogCleanerManagerMock cleanerManager$1;

            public final LogToClean apply() {
                return (LogToClean)this.cleanerManager$1.grabFilthiestCompactedLog((Time)this.$outer.time(), this.cleanerManager$1.grabFilthiestCompactedLog$default$2()).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cleanerManager$1 = cleanerManager$1;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        Assert.assertEquals((Object)((Object)log2), (Object)thrownException.log());
        Assert.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log2);
        this.kafka$log$LogCleanerManagerTest$$appendRecords(log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords(log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords(log2, 3);
        Assert.assertEquals((long)1L, (long)log2.logSegments().size());
        log2.maybeIncrementLogStartOffset(2L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)2L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log2);
        this.kafka$log$LogCleanerManagerTest$$appendRecords(log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords(log2, 3);
        Assert.assertEquals((long)1L, (long)log2.logSegments().size());
        Assert.assertEquals((long)0L, (long)log2.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)3L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log2.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log2.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$2) {
                return (TopicPartition)x$2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log2.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$3) {
                return (TopicPartition)x$3._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Log> x$4) {
                return (TopicPartition)x$4._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$15 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$16 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$16, x$15);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$17 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$18 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$18, x$17);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t1), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$19 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$20 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$20, x$19);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertFalse((String)"Checkpoint offset should not be reset if valid", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if less than log start offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if greater than log end offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$21 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$22, x$21);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        log2.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$23 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$24 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$24, x$23);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$2;
            private final LogCleanerManager cleanerManager$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneCleaning(this.$outer.topicPartition(), this.log$2.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.cleanerManager$2 = cleanerManager$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$2;
            private final LogCleanerManager cleanerManager$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneCleaning(this.$outer.topicPartition(), this.log$2.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.cleanerManager$2 = cleanerManager$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$3;
            private final TopicPartition tp$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$3.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$2})));
            }
            {
                this.cleanerManager$3 = cleanerManager$3;
                this.tp$2 = tp$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$3;
            private final TopicPartition tp$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$3.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$2})));
            }
            {
                this.cleanerManager$3 = cleanerManager$3;
                this.tp$2 = tp$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"Log should not be selected for cleaning", (Object)None$.MODULE$, (Object)filthiestLog);
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp).get()));
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((Log)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((String)"Dirtier log should be selected", (Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp0).get()));
    }

    private LogCleanerManager createCleanerManager(Log log2) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log2);
        return new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, Log> pool) {
        return new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    public Log kafka$log$LogCleanerManagerTest$$createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        File partitionDir;
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File x$25 = partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        LogConfig x$26 = config;
        long x$27 = 0L;
        long x$28 = 0L;
        MockScheduler x$29 = this.time().scheduler();
        MockTime x$30 = this.time();
        BrokerTopicStats x$31 = new BrokerTopicStats();
        int x$32 = 3600000;
        int x$33 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$34 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$25, x$26, x$27, x$28, (Scheduler)x$29, x$31, (Time)x$30, x$32, x$33, x$34);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public void kafka$log$LogCleanerManagerTest$$writeRecords(Log log2, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)new Serializable(this, log2, recordsPerBatch, batchesPerSegment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final Log log$1;
            private final int recordsPerBatch$1;
            private final int batchesPerSegment$1;

            public final Object apply(int i) {
                this.$outer.kafka$log$LogCleanerManagerTest$$appendRecords(this.log$1, this.recordsPerBatch$1);
                return i % this.batchesPerSegment$1 == 0 ? this.log$1.roll(this.log$1.roll$default$1()) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.recordsPerBatch$1 = recordsPerBatch$1;
                this.batchesPerSegment$1 = batchesPerSegment$1;
            }
        });
        log2.roll(log2.roll$default$1());
    }

    public void kafka$log$LogCleanerManagerTest$$appendRecords(Log log2, int numRecords) {
        long startOffset = log2.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records2 = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1)new Serializable(this, endOffset, lastTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final long endOffset$1;
            private final LongRef lastTimestamp$1;

            public final SimpleRecord apply(long offset) {
                long currentTimestamp = this.$outer.time().milliseconds();
                if (offset == this.endOffset$1 - 1L) {
                    this.lastTimestamp$1.elem = currentTimestamp;
                }
                return new SimpleRecord(currentTimestamp, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})).getBytes(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})).getBytes());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.endOffset$1 = endOffset$1;
                this.lastTimestamp$1 = lastTimestamp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.maybeIncrementHighWatermark(log2.logEndOffsetMetadata());
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$5 = dir;
        LogConfig x$6 = config;
        long x$7 = 0L;
        long x$8 = 0L;
        MockScheduler x$9 = this.time().scheduler();
        MockTime x$10 = this.time();
        BrokerTopicStats x$11 = new BrokerTopicStats();
        int x$12 = 3600000;
        int x$13 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$14 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$5, x$6, x$7, x$8, (Scheduler)x$9, x$11, (Time)x$10, x$12, x$13, x$14);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.class.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
            Tuple2 tuple2 = (Tuple2)update.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("update=None argument not yet handled");
                }
            });
            if (tuple2 != null) {
                Tuple2 tuple22;
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)tp, (Object)BoxesRunTime.boxToLong((long)offset));
                TopicPartition tp2 = (TopicPartition)tuple23._1();
                long offset2 = tuple23._2$mcJ$sp();
                this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)offset2));
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

