/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.nio.charset.StandardCharsets;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.utils.Json$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u0013\t9\u0011i\u00197UKN$(BA\u0002\u0005\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BE\u0007\u0002\u0019)\u0011QBD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001fA\tQb]2bY\u0006$Xm\u001d;qYV\u001c(\"A\t\u0002\u0007=\u0014x-\u0003\u0002\u0014\u0019\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\b\u0003\u000ed'j]8o+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007'R\u0014\u0018N\\4\t\r\u0015\u0002\u0001\u0015!\u0003\u001d\u0003!\t5\r\u001c&t_:\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013!\u0006;fgR\f5\r\u001c&t_:\u001cuN\u001c<feNLwN\u001c\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\t1\u0003\u0007\u0005\u00022g5\t!G\u0003\u0002\u000e!%\u0011AG\r\u0002\u0005)\u0016\u001cH\u000f")
public class AclTest
extends JUnitSuite {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3}));
        byte[] jsonAcls = Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Acl$.MODULE$.toJsonCompatibleMap(acls)).asJava());
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(jsonAcls));
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8)));
    }

    public AclTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },  {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },  {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}  ]}";
    }
}

