/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.SimpleAclAuthorizerTest$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B\u0001\u0003\u0001%\u0011qcU5na2,\u0017i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\tA\"\u00197m_^\u0014V-\u00193BG2,\u0012\u0001\u0007\t\u0003)eI!A\u0007\u0002\u0003\u0007\u0005\u001bG\u000e\u0003\u0004\u001d\u0001\u0001\u0006I\u0001G\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\t\u000fy\u0001!\u0019!C\u0005/\u0005i\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2Da\u0001\t\u0001!\u0002\u0013A\u0012AD1mY><xK]5uK\u0006\u001bG\u000e\t\u0005\bE\u0001\u0011\r\u0011\"\u0003\u0018\u0003-!WM\\=SK\u0006$\u0017i\u00197\t\r\u0011\u0002\u0001\u0015!\u0003\u0019\u00031!WM\\=SK\u0006$\u0017i\u00197!\u0011\u001d1\u0003A1A\u0005\n\u001d\n\u0001c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3\u0016\u0003!\u0002\"\u0001F\u0015\n\u0005)\u0012!\u0001\u0003*fg>,(oY3\t\r1\u0002\u0001\u0015!\u0003)\u0003E9\u0018\u000e\u001c3DCJ$'+Z:pkJ\u001cW\r\t\u0005\b]\u0001\u0011\r\u0011\"\u0003(\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW\r\u0003\u00041\u0001\u0001\u0006I\u0001K\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\u0014g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM]\u000b\u0002iA\u0011A#N\u0005\u0003m\t\u00111cU5na2,\u0017i\u00197BkRDwN]5{KJDa\u0001\u000f\u0001!\u0002\u0013!\u0014\u0001F:j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014\b\u0005C\u0004;\u0001\t\u0007I\u0011B\u001a\u0002)MLW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:3\u0011\u0019a\u0004\u0001)A\u0005i\u0005)2/[7qY\u0016\f5\r\\!vi\"|'/\u001b>feJ\u0002\u0003\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0003(\u0003!\u0011Xm]8ve\u000e,\u0007\"\u0003!\u0001\u0001\u0004\u0005\r\u0011\"\u0003B\u00031\u0011Xm]8ve\u000e,w\fJ3r)\t\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0003V]&$\bbB%@\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004BB&\u0001A\u0003&\u0001&A\u0005sKN|WO]2fA!9Q\n\u0001b\u0001\n\u0013q\u0015AC:va\u0016\u0014Xk]3sgV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A.\u00198h\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\rM#(/\u001b8h\u0011\u0019A\u0006\u0001)A\u0005\u001f\u0006Y1/\u001e9feV\u001bXM]:!\u0011\u001dQ\u0006A1A\u0005\n9\u000b\u0001\"^:fe:\fW.\u001a\u0005\u00079\u0002\u0001\u000b\u0011B(\u0002\u0013U\u001cXM\u001d8b[\u0016\u0004\u0003b\u00020\u0001\u0005\u0004%IaX\u0001\naJLgnY5qC2,\u0012\u0001\u0019\t\u0003C.l\u0011A\u0019\u0006\u0003\u0007\rT!!\u00023\u000b\u0005\u00154\u0017AB2p[6|gN\u0003\u0002\bO*\u0011\u0001.[\u0001\u0007CB\f7\r[3\u000b\u0003)\f1a\u001c:h\u0013\ta'M\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\r9\u0004\u0001\u0015!\u0003a\u0003)\u0001(/\u001b8dSB\fG\u000e\t\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0003\u001d\u0019Xm]:j_:,\u0012A\u001d\t\u0003g~t!\u0001\u001e?\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=\t\u0003\u0019a$o\\8u}%\tq!\u0003\u0002|\r\u00059a.\u001a;x_J\\\u0017BA?\u007f\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2T!a\u001f\u0004\n\t\u0005\u0005\u00111\u0001\u0002\b'\u0016\u001c8/[8o\u0015\tih\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002:\u0002\u0011M,7o]5p]\u0002B1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e\u000511m\u001c8gS\u001e,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011DA\n\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011qD\u0001\u000bG>tg-[4`I\u0015\fHc\u0001\"\u0002\"!I\u0011*a\u0007\u0002\u0002\u0003\u0007\u0011q\u0002\u0005\t\u0003K\u0001\u0001\u0015)\u0003\u0002\u0010\u000591m\u001c8gS\u001e\u0004\u0003bCA\u0015\u0001\u0001\u0007\t\u0019!C\u0005\u0003W\tqB_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e^\u000b\u0003\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g1\u0011!\u0003>p_.,W\r]3s\u0013\u0011\t9$!\r\u0003\u001fi{wnS3fa\u0016\u00148\t\\5f]RD1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>\u0005\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0019!)a\u0010\t\u0013%\u000bI$!AA\u0002\u00055\u0002\u0002CA\"\u0001\u0001\u0006K!!\f\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004cABA$\u0001\u0001\tIEA\bDkN$x.\u001c)sS:\u001c\u0017\u000e]1m'\r\t)\u0005\u0019\u0005\f\u0003\u001b\n)E!A!\u0002\u0013\ty%A\u0007qe&t7-\u001b9bYRK\b/\u001a\t\u0005\u0003#\n9FD\u0002D\u0003'J1!!\u0016E\u0003\u0019\u0001&/\u001a3fM&\u0019a+!\u0017\u000b\u0007\u0005UC\tC\u0006\u0002^\u0005\u0015#\u0011!Q\u0001\n\u0005=\u0013\u0001\u00028b[\u0016Dq!EA#\t\u0003\t\t\u0007\u0006\u0004\u0002d\u0005\u001d\u0014\u0011\u000e\t\u0005\u0003K\n)%D\u0001\u0001\u0011!\ti%a\u0018A\u0002\u0005=\u0003\u0002CA/\u0003?\u0002\r!a\u0014\t\u0011\u00055\u0014Q\tC!\u0003_\na!Z9vC2\u001cH\u0003BA9\u0003o\u00022aQA:\u0013\r\t)\b\u0012\u0002\b\u0005>|G.Z1o\u0011!\tI(a\u001bA\u0002\u0005m\u0014!A8\u0011\u0007\r\u000bi(C\u0002\u0002\u0000\u0011\u00131!\u00118z\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000bQa]3u+B$\u0012A\u0011\u0015\u0005\u0003\u0003\u000bI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty)[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003'\u000biI\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003/\u0003A\u0011IAC\u0003!!X-\u0019:E_^t\u0007\u0006BAK\u00037\u0003B!a#\u0002\u001e&!\u0011qTAG\u0005\u0015\te\r^3s\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u000b\u000bq\u0005^3ti\u0006+H\u000f[8sSj,G\u000b\u001b:poN|eNT8o\u0019&$XM]1m%\u0016\u001cx.\u001e:dK\"B\u0011\u0011UAT\u0003[\u000by\u000b\u0005\u0003\u0002\f\u0006%\u0016\u0002BAV\u0003\u001b\u0013A\u0001V3ti\u0006AQ\r\u001f9fGR,Gm\t\u0002\u00022B!\u00111WA_\u001d\u0011\t),!/\u000f\u0007Y\f9,C\u0001F\u0013\r\tY\fR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty,!1\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gNC\u0002\u0002<\u0012Cq!!2\u0001\t\u0003\t))\u0001\u0012uKN$\u0018)\u001e;i_JL'0Z,ji\",U\u000e\u001d;z%\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u0015\u0005\u0003\u0007\f9\u000bC\u0004\u0002L\u0002!\t!!\"\u00027Q,7\u000f^#naRL\u0018i\u00197UQJ|wo]#yG\u0016\u0004H/[8oQ!\tI-a*\u0002.\u0006=\u0006bBAi\u0001\u0011\u0005\u0011QQ\u0001\ri\u0016\u001cH\u000fV8qS\u000e\f5\r\u001c\u0015\u0005\u0003\u001f\f9\u000bC\u0004\u0002X\u0002!\t!!\"\u0002EQ,7\u000f^!mY><\u0018iY2fgN<\u0016\u000e\u001e5DkN$x.\u001c)sS:\u001c\u0017\u000e]1mQ\u0011\t).a*\t\u000f\u0005u\u0007\u0001\"\u0001\u0002\u0006\u00069B/Z:u\t\u0016t\u0017\u0010V1lKN\u0004&/Z2fI\u0016t7-\u001a\u0015\u0005\u00037\f9\u000bC\u0004\u0002d\u0002!\t!!\"\u0002%Q,7\u000f^!mY><\u0018\t\u001c7BG\u000e,7o\u001d\u0015\u0005\u0003C\f9\u000bC\u0004\u0002j\u0002!\t!!\"\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgNDC!a:\u0002(\"9\u0011q\u001e\u0001\u0005\u0002\u0005\u0015\u0015!\u000b;fgR\u001cV\u000f]3s+N,'oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D\u0015m]!dG\u0016\u001c8\u000f\u000b\u0003\u0002n\u0006\u001d\u0006bBA{\u0001\u0011\u0005\u0011QQ\u0001\u0011i\u0016\u001cHoV5mI\u000e\u000b'\u000fZ!dYNDC!a=\u0002(\"9\u00111 \u0001\u0005\u0002\u0005\u0015\u0015A\u0004;fgRtu.Q2m\r>,h\u000e\u001a\u0015\u0005\u0003s\f9\u000bC\u0004\u0003\u0002\u0001!\t!!\"\u0002-Q,7\u000f\u001e(p\u0003\u000edgi\\;oI>3XM\u001d:jI\u0016DC!a@\u0002(\"9!q\u0001\u0001\u0005\u0002\u0005\u0015\u0015!\u0006;fgR\f5\r\\'b]\u0006<W-\\3oi\u0006\u0003\u0016j\u001d\u0015\u0005\u0005\u000b\t9\u000bC\u0004\u0003\u000e\u0001!\t!!\"\u0002\u001bQ,7\u000f\u001e'pC\u0012\u001c\u0015m\u00195fQ\u0011\u0011Y!a*\t\u000f\tM\u0001\u0001\"\u0001\u0002\u0006\u0006iC/Z:u\u0019>\u001c\u0017\r\\\"p]\u000e,(O]3oi6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\t\tE\u0011q\u0015\u0005\b\u00053\u0001A\u0011AAC\u0003M\"Xm\u001d;ESN$(/\u001b2vi\u0016$7i\u001c8dkJ\u0014XM\u001c;N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000f\u000b\u0003\u0003\u0018\u0005\u001d\u0006b\u0002B\u0010\u0001\u0011\u0005\u0011QQ\u0001.i\u0016\u001cH\u000fS5hQ\u000e{gnY;se\u0016t7-_'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006\u0002B\u000f\u0003OCqA!\n\u0001\t\u0003\t))\u0001\nuKN$\u0018i\u00197J]\",'/\u001b;b]\u000e,\u0007\u0006\u0002B\u0012\u0003OCqAa\u000b\u0001\t\u0013\u0011i#A\fuKN$\u0018*\u001c9mS\u000e\fG/[8og>3\u0017\t\u001c7poR)!Ia\f\u0003:!A!\u0011\u0007B\u0015\u0001\u0004\u0011\u0019$\u0001\u0005qCJ,g\u000e^(q!\r!\"QG\u0005\u0004\u0005o\u0011!!C(qKJ\fG/[8o\u0011!\u0011YD!\u000bA\u0002\tu\u0012AC1mY><X\rZ(qgB1\u0011\u0011\u000bB \u0005gIAA!\u0011\u0002Z\t\u00191+\u001a;\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u00051B/Z:u\u00136\u0004H.[2bi&|gn](g\t\u0016t\u0017\u0010F\u0003C\u0005\u0013\u0012Y\u0005\u0003\u0005\u00032\t\r\u0003\u0019\u0001B\u001a\u0011!\u0011iEa\u0011A\u0002\tu\u0012!\u00033f]&,Gm\u00149t\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0003\u000b\u000b\u0011\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGf$U\r\\3uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006\u0002B(\u0003OCqAa\u0016\u0001\t\u0003\t))A\u001auKN$\u0018iY2fgN\fE\u000e\\8xK\u0012Le-\u00117m_^\f5\r\\#ySN$8o\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\"!QKAT\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003\u000b\u000bq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\u0011\u0011Y&a*\t\u000f\t\r\u0004\u0001\"\u0001\u0002\u0006\u0006\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016DCA!\u0019\u0002(\"9!\u0011\u000e\u0001\u0005\u0002\u0005\u0015\u0015a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\u0011\u00119'a*\t\u000f\t=\u0004\u0001\"\u0001\u0002\u0006\u0006yB/Z:u\t\u0016dW\r^3BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\t\t5\u0014q\u0015\u0005\b\u0005k\u0002A\u0011AAC\u0003\t\"Xm\u001d;EK2,G/Z!mY\u0006\u001bGn\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\"!1OAT\u0011\u001d\u0011Y\b\u0001C\u0001\u0003\u000b\u000bA\u0004^3ti\u0006#G-Q2mg>sG*\u001b;fe\u0006d'+Z:pkJ\u001cW\r\u000b\u0003\u0003z\u0005\u001d\u0006b\u0002BA\u0001\u0011\u0005\u0011QQ\u0001\u001ei\u0016\u001cH/\u00113e\u0003\u000ed7o\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\"!qPAT\u0011\u001d\u00119\t\u0001C\u0001\u0003\u000b\u000ba\u0004^3ti\u0006#G-Q2mg>s\u0007K]3gS\u0016DX\r\u001a*fg>,(oY3)\t\t\u0015\u0015q\u0015\u0005\b\u0005\u001b\u0003A\u0011AAC\u0003\u0005\"Xm\u001d;BkRDwN]5{K^KG\u000f\u001b)sK\u001aL\u00070\u001a3SKN|WO]2fQ\u0011\u0011Y)a*\t\u000f\tM\u0005\u0001\"\u0001\u0002\u0006\u0006yB/Z:u'&tw\r\\3DQ\u0006\u0014\u0018m\u0019;feJ+7o\\;sG\u0016\f5\r\\:)\t\tE\u0015q\u0015\u0005\b\u00053\u0003A\u0011AAC\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bY\"\"!qSAT\u0011\u001d\u0011y\n\u0001C\u0001\u0003\u000b\u000bA\b^3tiRC'o\\<t\u001f:\fE\r\u001a)sK\u001aL\u00070\u001a3BG2Le-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:$vn\u001c'po\"B!QTAT\u0003[\u0013\u0019k\t\u0002\u0003&B!!q\u0015BW\u001b\t\u0011IKC\u0002\u0003,\u0012\fa!\u001a:s_J\u001c\u0018\u0002\u0002BX\u0005S\u00131$\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>t\u0007b\u0002BZ\u0001\u0011\u0005\u0011QQ\u0001<i\u0016\u001cHo\u0016:ji\u0016\u001cX\t\u001f;f]\u0012,G-Q2m\u0007\"\fgnZ3Fm\u0016tG/\u00134J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'\u0016$\b\u0006\u0002BY\u0003OCqA!/\u0001\t\u0003\t))A#uKN$xK]5uKN,\u0005\u0010^3oI\u0016$\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\\!u\u0019\u0016\f7\u000f^&bM.\fgK\r\u0015\u0005\u0005o\u000b9\u000bC\u0004\u0003@\u0002!\t!!\"\u0002qR,7\u000f^,sSR,7\u000fT5uKJ\fGn\u0016:ji\u0016\u001cH*\u001b;fe\u0006d\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c'fgN$\u0006.\u00198LC\u001a\\\u0017M\u0016\u001afe\u0006d\u0017i\u00197DQ\u0006tw-Z:G_J|E\u000eZ3s!J|Go\\2pYZ+'o]5p]NDCA!0\u0002(\"9!Q\u0019\u0001\u0005\u0002\u0005\u0015\u0015a\u0010;fgR<&/\u001b;fg2KG/\u001a:bY\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017j]&bM.\fgK\r\u0015\u0005\u0005\u0007\f9\u000bC\u0004\u0003L\u0002!IA!4\u0002E\u001dLg/\u001a8BkRDwN]5{KJ<\u0016\u000e\u001e5Qe>$xnY8m-\u0016\u00148/[8o)\r\u0011%q\u001a\u0005\t\u0005#\u0014I\r1\u0001\u0003T\u0006y\u0001O]8u_\u000e|GNV3sg&|g\u000eE\u0003D\u0005+\u0014I.C\u0002\u0003X\u0012\u0013aa\u00149uS>t\u0007\u0003\u0002Bn\u0005Cl!A!8\u000b\u0007\t}g!A\u0002ba&LAAa9\u0003^\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\t\u000f\t\u001d\b\u0001\"\u0003\u0003j\u0006Ir-\u001a;BG2\u001c\u0005.\u00198hK\u00163XM\u001c;BgN#(/\u001b8h)\ry%1\u001e\u0005\t\u0005[\u0014)\u000f1\u0001\u0003p\u0006Y\u0001/\u0019;uKJtG+\u001f9f!\u0011\u0011\tP!>\u000e\u0005\tM(B\u0001 e\u0013\u0011\u00119Pa=\u0003\u0017A\u000bG\u000f^3s]RK\b/\u001a\u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0003I\u0019\u0007.\u00198hK\u0006\u001bG.\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\t}8\u0011AB\u0003\u0007\u0013\u0019i\u0001E\u0003\u0002R\t}\u0002\u0004\u0003\u0005\u0004\u0004\te\b\u0019\u0001B\u0000\u00031y'/[4j]\u0006d\u0017i\u00197t\u0011!\u00199A!?A\u0002\t}\u0018!C1eI\u0016$\u0017i\u00197t\u0011!\u0019YA!?A\u0002\t}\u0018a\u0003:f[>4X\rZ!dYND\u0001B\u0010B}!\u0003\u0005\r\u0001\u000b\u0005\n\u0007#\u0001\u0011\u0013!C\u0005\u0007'\tAd\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0016)\u001a\u0001fa\u0006,\u0005\re\u0001\u0003BB\u000e\u0007Ki!a!\b\u000b\t\r}1\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\tE\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007O\u0019iBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Ds\u0001AB\u0016\u0007c\u0019)\u0004E\u0002D\u0007[I1aa\fE\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0007g\t\u0011#V:fA\u0005\u001bG.Q;uQ>\u0014\u0018N_3sC\t\u00199$A\u0005TS:\u001cW\r\t\u001a/i\u0001")
public class SimpleAclAuthorizerTest
extends ZooKeeperTestHarness {
    private final Acl allowReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Acl allowWriteAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
    private final Acl denyReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Resource wildCardResource = new Resource((ResourceType)Topic$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.PREFIXED);
    private final SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer = new SimpleAclAuthorizer();
    private final SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2 = new SimpleAclAuthorizer();
    private Resource kafka$security$auth$SimpleAclAuthorizerTest$$resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestChannel.Session session = new RequestChannel.Session(this.principal(), InetAddress.getByName("192.168.0.1"));
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private Acl allowReadAcl() {
        return this.allowReadAcl;
    }

    private Acl allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private Acl denyReadAcl() {
        return this.denyReadAcl;
    }

    private Resource wildCardResource() {
        return this.wildCardResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    public SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer() {
        return this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer;
    }

    public SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2() {
        return this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2;
    }

    public Resource kafka$security$auth$SimpleAclAuthorizerTest$$resource() {
        return this.kafka$security$auth$SimpleAclAuthorizerTest$$resource;
    }

    private void kafka$security$auth$SimpleAclAuthorizerTest$$resource_$eq(Resource x$1) {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestChannel.Session session() {
        return this.session;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().configure(this.config().originals());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().configure(this.config().originals());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$resource_$eq(new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "SimpleAclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().close();
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL));
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyAclThrowsException() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session((KafkaPrincipal)new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Set<Acl> acls = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        SimpleAclAuthorizer testAuthorizer = new SimpleAclAuthorizer();
        try {
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthorizer.authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        testAuthorizer.close();
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user1, acl1, acl2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user1$1;
            private final Acl acl1$1;
            private final Acl acl2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl1$1, this.acl2$1})))}));
                Map map = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.user1$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user1$1 = user1$1;
                this.acl1$1 = acl1$1;
                this.acl2$1 = acl2$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user2, acl3, acl4, acl5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final KafkaPrincipal user2$1;
            private final Acl acl3$1;
            private final Acl acl4$1;
            private final Acl acl5$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl3$1, this.acl4$1, this.acl5$1})))}));
                Map map = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.user2$1);
                return !(genMap != null ? !genMap.equals(map) : map != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user2$1 = user2$1;
                this.acl3$1 = acl3$1;
                this.acl4$1 = acl4$1;
                this.acl5$1 = acl5$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup", PatternType.LITERAL)), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;

            public final Set<Acl> apply(Tuple2<Resource, Set<Acl>> x0$1) {
                Tuple2<Resource, Set<Acl>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Resource key = (Resource)tuple2._1();
                    Set value = (Set)tuple2._2();
                    Set<Acl> set = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
                    return set;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, acls, resourceToAcls){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final ObjectRef acls$1;
            private final Map resourceToAcls$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Map map = this.resourceToAcls$1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$resource()), (Object)((Set)this.acls$1.elem)));
                Map map2 = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls();
                return !(map != null ? !map.equals(map2) : map2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.acls$1 = acls$1;
                this.resourceToAcls$1 = resourceToAcls$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        Assert.assertTrue((!this.zkClient().resourceExists(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()) ? 1 : 0) != 0);
        acls.elem = this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls(acls, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL);
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();
        try {
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
            Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
        }
        catch (Throwable throwable) {
            void var8_8;
            var8_8.close();
            throw throwable;
        }
        authorizer.close();
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        boolean deleted = this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Acl apply(int i) {
                KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1)new Serializable(this, commonResource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            public final Resource commonResource$1;

            public final Function0<Object> apply(Acl acl) {
                return new Serializable(this, acl){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Acl acl$2;

                    public final Object apply() {
                        int aclId = new StringOps(Predef$.MODULE$.augmentString(this.acl$2.principal().getName())).toInt();
                        if (aclId % 2 == 0) {
                            this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$2})), this.$outer.commonResource$1);
                        } else {
                            this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$2})), this.$outer.commonResource$1);
                        }
                        return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.acl$2})), this.$outer.commonResource$1)) : BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.acl$2 = acl$2;
                    }
                };
            }

            public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commonResource$1 = commonResource$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Acl acl) {
                int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
                return aclId % 10 != 0;
            }
        })).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Read$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Write$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Delete$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Alter$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)Describe$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow((Operation)AlterConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)DescribeConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(Operation parentOp, Set<Operation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session hostSession = new RequestChannel.Session(user, host);
        Acl acl = new Acl(user, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1)new Serializable(this, parentOp, allowedOps, hostSession){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final Operation parentOp$1;
            private final Set allowedOps$1;
            private final RequestChannel.Session hostSession$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(Operation op) {
                boolean authorized;
                block3: {
                    block2: {
                        authorized = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.hostSession$1, op, Resource$.MODULE$.ClusterResource());
                        if (this.allowedOps$1.contains((Object)op)) break block2;
                        Operation operation = op;
                        Operation operation2 = this.parentOp$1;
                        if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
                    }
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$1, op})), (boolean)authorized);
                    return;
                }
                Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should not imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$1, op})), (boolean)authorized);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parentOp$1 = parentOp$1;
                this.allowedOps$1 = allowedOps$1;
                this.hostSession$1 = hostSession$1;
            }
        });
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
    }

    private void testImplicationsOfDeny(Operation parentOp, Set<Operation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp), new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)}));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls(acls, Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1)new Serializable(this, parentOp, deniedOps, host1Session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            private final Operation parentOp$2;
            private final Set deniedOps$1;
            private final RequestChannel.Session host1Session$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(Operation op) {
                boolean authorized;
                block3: {
                    block2: {
                        authorized = this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.host1Session$1, op, Resource$.MODULE$.ClusterResource());
                        if (this.deniedOps$1.contains((Object)op)) break block2;
                        Operation operation = op;
                        Operation operation2 = this.parentOp$2;
                        if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
                    }
                    Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$2, op})), (boolean)authorized);
                    return;
                }
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should not imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$2, op})), (boolean)authorized);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parentOp$2 = parentOp$2;
                this.deniedOps$1 = deniedOps$1;
                this.host1Session$1 = host1Session$1;
            }
        });
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(acls, Resource$.MODULE$.ClusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this, acl){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizerTest $outer;
            public final Acl acl$1;

            public final Function0<Object> apply(int x$1) {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.$outer.acl$1})), this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$resource());
                        return this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.$outer.acl$1})), this.$outer.kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizerTest$$resource());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.acl$1 = acl$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer2(), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefiexedResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.LITERAL));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).append((Object)"-zzz").toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"fooo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"fo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"fop-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder().append((Object)"fon-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "fon-", PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.kafka$security$auth$SimpleAclAuthorizerTest$$resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.LITERAL)));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        Acl aclOnSpecificPrincipal = new Acl(this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnSpecificPrincipal})), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        Acl aclOnWildcardPrincipal = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnWildcardPrincipal})), this.kafka$security$auth$SimpleAclAuthorizerTest$$resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().getAcls(this.principal()).size());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(ApiVersion version) {
                return this.props$1.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString());
            }
            {
                this.props$1 = props$1;
            }
        });
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{store.changeStore().aclChangePath(), children.children().head()})), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    public Set<Acl> kafka$security$auth$SimpleAclAuthorizerTest$$changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.kafka$security$auth$SimpleAclAuthorizerTest$$simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.kafka$security$auth$SimpleAclAuthorizerTest$$resource();
    }

    public SimpleAclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$CustomPrincipal$$$outer() {
            return SimpleAclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (SimpleAclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

