/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011\u001dQ\u0003\u00011A\u0005\n-\nA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001L\u0018\u0011\u0005\u0005j\u0013B\u0001\u0018#\u0005\u0011)f.\u001b;\t\u000fAJ\u0013\u0011!a\u0001'\u0005\u0019\u0001\u0010J\u0019\t\rI\u0002\u0001\u0015)\u0003\u0014\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u00035\u0001\u0011\u0005S'\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005a\u0003\"B\u001c\u0001\t\u0013A\u0014AE2sK\u0006$XMR3uG\"\u0014V-];fgR$R!O!G\u0011R\u0003\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0011I,\u0017/^3tiNT!A\u0010\r\u0002\r\r|W.\\8o\u0013\t\u00015H\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0003Cm\u0001\u00071)\u0001\tnCb\u0014Vm\u001d9p]N,')\u001f;fgB\u0011\u0011\u0005R\u0005\u0003\u000b\n\u00121!\u00138u\u0011\u00159e\u00071\u0001D\u0003Ei\u0017\r\u001f)beRLG/[8o\u0005f$Xm\u001d\u0005\u0006\u0013Z\u0002\rAS\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB\u00191J\u0014)\u000e\u00031S!!\u0014\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0019\n\u00191+Z9\u0011\u0005E\u0013V\"A\u001f\n\u0005Mk$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006+Z\u0002\rAV\u0001\n_\u001a47/\u001a;NCB\u0004B\u0001I,Q3&\u0011\u0001\f\u000b\u0002\u0004\u001b\u0006\u0004\bCA\u0011[\u0013\tY&E\u0001\u0003M_:<\u0007\"B/\u0001\t\u0013q\u0016AE2sK\u0006$X\rU1si&$\u0018n\u001c8NCB$Ba\u00188paB!\u0001-\u001a)h\u001b\u0005\t'B\u00012d\u0003\u0011)H/\u001b7\u000b\u0003\u0011\fAA[1wC&\u0011a-\u0019\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005!\\gB\u0001\u001ej\u0013\tQ7(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002m[\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!A[\u001e\t\u000b\u001dc\u0006\u0019A\"\t\u000b%c\u0006\u0019\u0001&\t\u000fUc\u0006\u0013!a\u0001-\")!\u000f\u0001C\u0005g\u0006\u00012/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0004iv|\bc\u0001\u001evo&\u0011ao\u000f\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\u0011\u0005a\\X\"A=\u000b\u0005il\u0014A\u0002:fG>\u0014H-\u0003\u0002}s\niQ*Z7pef\u0014VmY8sINDQA`9A\u0002\r\u000b\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003\u0003\t\b\u0019A\u001d\u0002\u000fI,\u0017/^3ti\"1\u0011Q\u0001\u0001\u0005\nU\nA\"\u001b8jiB\u0013x\u000eZ;dKJDa!!\u0003\u0001\t\u0003)\u0014A\f;fgR\u0014%o\\6feJ+7\u000f]3diN\u0004\u0016M\u001d;ji&|gn](sI\u0016\u0014\u0018I\u001c3TSj,G*[7jiNDC!a\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014m\tQA[;oSRLA!a\u0006\u0002\u0012\t!A+Z:u\u0011\u0019\tY\u0002\u0001C\u0001k\u00051C/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e,3/&$\bn\u0014<feNL'0\u001a3NKN\u001c\u0018mZ3)\t\u0005e\u0011Q\u0002\u0005\u0007\u0003C\u0001A\u0011A\u001b\u0002GQ,7\u000f\u001e$fi\u000eD'+Z9vKN$h\u000bN,ji\"\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\"\"\u0011qDA\u0007\u0011\u0019\t9\u0003\u0001C\u0001k\u0005aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\f\u0007\u0006BA\u0013\u0003\u001bAa!!\f\u0001\t\u0003)\u0014A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007\u0006BA\u0016\u0003\u001bAa!a\r\u0001\t\u0003)\u0014a\n;fgR$un\u001e8D_:4XM]:j_:<\u0016\u000e\u001e5D_:tWm\u0019;j_:4\u0015-\u001b7ve\u0016DC!!\r\u0002\u000e!1\u0011\u0011\b\u0001\u0005\u0002U\na\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]\u001a\u0013x.\u001c\"bi\u000eDW\r\u001a+p+:\u0014\u0017\r^2iK\u0012\u0014Vm\u001d9fGR\u001cxJ\u001a4tKRDC!a\u000e\u0002\u000e!1\u0011q\b\u0001\u0005\u0002U\nq\u0006^3ti\u000e\u0013X-\u0019;f\u0013:\u001c'/Z7f]R\fGNR3uG\"<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NLe.\u0012:s_JDC!!\u0010\u0002\u000e!1\u0011Q\t\u0001\u0005\u0002U\nq\u0003^3tij\u001bF\u000fZ\"p[B\u0014Xm]:fIR{\u0007/[2)\t\u0005\r\u0013Q\u0002\u0005\u0007\u0003\u0017\u0002A\u0011A\u001b\u00023Q,7\u000f\u001e.Ti\u0012\u001cu.\u001c9sKN\u001cX\r\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003\u0013\ni\u0001C\u0004\u0002R\u0001!I!a\u0015\u0002\u000fI,7m\u001c:egR!\u0011QKA/!\u0011Ye*a\u0016\u0011\u0007a\fI&C\u0002\u0002\\e\u0014aAU3d_J$\u0007\u0002CA0\u0003\u001f\u0002\r!!\u0019\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0015\t\u0019'!\u001bx\u001d\rQ\u0014QM\u0005\u0004\u0003OZ\u0014!\u0004$fi\u000eD'+Z:q_:\u001cX-C\u0002m\u0003WR1!a\u001a<\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\n!c\u00195fG.4U\r^2i%\u0016\u001c\bo\u001c8tKRYA&a\u001d\u0002x\u0005m\u0014QPA@\u0011\u001d\t)(!\u001cA\u0002)\u000b!#\u001a=qK\u000e$X\r\u001a)beRLG/[8og\"9\u0011\u0011PA7\u0001\u0004!\u0018!\u00044fi\u000eD'+Z:q_:\u001cX\r\u0003\u0004H\u0003[\u0002\ra\u0011\u0005\u0007\u0005\u00065\u0004\u0019A\"\t\u000f\u0005\u0005\u0015Q\u000ea\u0001\u0007\u00069b.^7NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u0005\b\u0003\u000b\u0003A\u0011BAD\u00031\u0019'/Z1uKR{\u0007/[2t)!\tI)a#\u0002\u0010\u0006M\u0005\u0003\u0002\u0011X!\u000eCq!!$\u0002\u0004\u0002\u00071)A\u0005ok6$v\u000e]5dg\"9\u0011\u0011SAB\u0001\u0004\u0019\u0015!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0003\u0006\u0002\u0016\u0006\r\u0005\u0013!a\u0001\u0003/\u000bqaY8oM&<7\u000f\u0005\u0003!/~y\u0002bBAN\u0001\u0011%\u0011QT\u0001\faJ|G-^2f\t\u0006$\u0018\r\u0006\u0004\u0002 \u0006\u001d\u0016\u0011\u0019\t\u0005\u0017:\u000b\t\u000bE\u0003\u0015\u0003G{r$C\u0002\u0002&V\u0011a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rC\u0004J\u00033\u0003\r!!+\u0011\u000b\u0005-\u00161\u0018)\u000f\t\u00055\u0016q\u0017\b\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013bAA]E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA_\u0003\u007f\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003s\u0013\u0003bBAA\u00033\u0003\ra\u0011\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0005\u0003\u000f\fAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3'\u0006\u0002\u0002J*\u001aa+a3,\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a6#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a8\u0001#\u0003%I!!9\u0002-\r\u0014X-\u0019;f)>\u0004\u0018nY:%I\u00164\u0017-\u001e7uIM*\"!a9+\t\u0005]\u00151\u001a")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer = null;

    public KafkaProducer<String, String> kafka$server$FetchRequestTest$$producer() {
        return this.kafka$server$FetchRequestTest$$producer;
    }

    private void kafka$server$FetchRequestTest$$producer_$eq(KafkaProducer<String, String> x$1) {
        this.kafka$server$FetchRequestTest$$producer = x$1;
    }

    @Override
    public void tearDown() {
        if (this.kafka$server$FetchRequestTest$$producer() != null) {
            this.kafka$server$FetchRequestTest$$producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1)new Serializable(this, maxPartitionBytes, offsetMap, partitionMap){
            public static final long serialVersionUID = 0L;
            private final int maxPartitionBytes$1;
            private final scala.collection.immutable.Map offsetMap$1;
            private final LinkedHashMap partitionMap$1;

            public final FetchRequest.PartitionData apply(TopicPartition tp) {
                return this.partitionMap$1.put(tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)this.offsetMap$1.getOrElse((Object)tp, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })), 0L, this.maxPartitionBytes$1, Optional.<T>empty()));
            }
            {
                this.maxPartitionBytes$1 = maxPartitionBytes$1;
                this.offsetMap$1 = offsetMap$1;
                this.partitionMap$1 = partitionMap$1;
            }
        });
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$21 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$22 = new StringSerializer();
        StringSerializer x$23 = new StringSerializer();
        int x$24 = TestUtils$.MODULE$.createProducer$default$2();
        long x$25 = TestUtils$.MODULE$.createProducer$default$3();
        long x$26 = TestUtils$.MODULE$.createProducer$default$4();
        int x$27 = TestUtils$.MODULE$.createProducer$default$5();
        int x$28 = TestUtils$.MODULE$.createProducer$default$6();
        int x$29 = TestUtils$.MODULE$.createProducer$default$7();
        int x$30 = TestUtils$.MODULE$.createProducer$default$8();
        String x$31 = TestUtils$.MODULE$.createProducer$default$9();
        int x$32 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$33 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$34 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$35 = TestUtils$.MODULE$.createProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$22, x$23));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1)new Serializable(this, partitionsWithLargeMessages){
            public static final long serialVersionUID = 0L;
            private final Vector partitionsWithLargeMessages$1;

            public final boolean apply(Object elem) {
                return this.partitionsWithLargeMessages$1.contains(elem);
            }
            {
                this.partitionsWithLargeMessages$1 = partitionsWithLargeMessages$1;
            }
        });
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, this.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final int apply(FetchResponse.PartitionData<MemoryRecords> partitionData) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records(partitionData).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$1) {
                        return x$1.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$2) {
                return x$2.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be smaller than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size3), BoxesRunTime.boxToInteger((int)maxPartitionBytes)})), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Record x$3) {
                            return x$3.sizeInBytes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)tuple2._2())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Record x$3) {
                        return x$3.sizeInBytes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$4) {
                return x$4.sizeInBytes();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be larger than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size4), BoxesRunTime.boxToInteger((int)maxResponseBytes)})), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records).sizeInBytes());
            Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$6) {
                    return x$6.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.lastStableOffset > 0L ? 1 : 0) != 0);
            Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Record x$8) {
                    return x$8.sizeInBytes();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        });
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(nonReplicaId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionData.error);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple22;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$36 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$37 = Integer.MAX_VALUE;
        int x$38 = Integer.MAX_VALUE;
        int x$39 = batchSize;
        StringSerializer x$40 = new StringSerializer();
        ByteArraySerializer x$41 = new ByteArraySerializer();
        int x$42 = TestUtils$.MODULE$.createProducer$default$2();
        long x$43 = TestUtils$.MODULE$.createProducer$default$3();
        long x$44 = TestUtils$.MODULE$.createProducer$default$4();
        int x$45 = TestUtils$.MODULE$.createProducer$default$5();
        String x$46 = TestUtils$.MODULE$.createProducer$default$9();
        int x$47 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$48 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$49 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$50 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$36, x$42, x$43, x$44, x$45, x$38, x$37, x$39, x$46, x$47, x$48, x$49, x$50, x$40, x$41);
        byte[] bytes = new byte[msgValueLen];
        try {
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this, topicPartition2, producer, bytes){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;
                private final KafkaProducer producer$1;
                private final byte[] bytes$1;

                public final Future<RecordMetadata> apply(int x$11) {
                    return this.producer$1.send(new ProducerRecord(this.topicPartition$2.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$2.partition()), (Object)"key", (Object)this.bytes$1));
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                    this.producer$1 = producer$1;
                    this.bytes$1 = bytes$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var10_25;
            var10_25.close();
            throw throwable;
        }
        producer.close();
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$12) {
                return x$12.get();
            }
        });
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, topicPartition2, leaderId2, msgValueLen, batchSize, version){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final TopicPartition topicPartition$2;
            private final int leaderId$2;
            private final int msgValueLen$1;
            private final int batchSize$1;
            private final short version$1;

            public final Option<FetchResponse<MemoryRecords>> apply(int x$13) {
                return this.$outer.kafka$server$FetchRequestTest$$fetch$1(this.version$1, this.msgValueLen$1 * 1000, true, this.topicPartition$2, this.leaderId$2, this.batchSize$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.leaderId$2 = leaderId$2;
                this.msgValueLen$1 = msgValueLen$1;
                this.batchSize$1 = batchSize$1;
                this.version$1 = version$1;
            }
        });
        Option response = this.kafka$server$FetchRequestTest$$fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No fetch response");
            }
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$51 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$52 = 5;
        StringSerializer x$53 = new StringSerializer();
        StringSerializer x$54 = new StringSerializer();
        int x$55 = 30000;
        int x$56 = 60000;
        int x$57 = TestUtils$.MODULE$.createProducer$default$2();
        long x$58 = TestUtils$.MODULE$.createProducer$default$3();
        long x$59 = TestUtils$.MODULE$.createProducer$default$4();
        int x$60 = TestUtils$.MODULE$.createProducer$default$8();
        String x$61 = TestUtils$.MODULE$.createProducer$default$9();
        int x$62 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$63 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$64 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$65 = TestUtils$.MODULE$.createProducer$default$13();
        this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$51, x$57, x$58, x$59, x$52, x$56, x$55, x$60, x$61, x$62, x$63, x$64, x$65, x$53, x$54));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String topic = topicPartition2.topic();
            IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchRequestTest $outer;
                private final String topic$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(this.topic$1, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            this.kafka$server$FetchRequestTest$$producer().flush();
            firstBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$15) {
                    return x$15.get();
                }
            });
            secondBatchFutures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$16) {
                    return x$16.get();
                }
            });
            long x$66 = 3L;
            long x$67 = 3L;
            short x$68 = 1;
            int x$69 = 22;
            byte x$70 = 0;
            this.check$1(x$66, x$68, x$67, x$69, x$70, topicPartition2, leaderId2);
            long x$71 = 15L;
            long x$72 = 15L;
            short x$73 = 1;
            int x$74 = 10;
            byte x$75 = 0;
            this.check$1(x$71, x$73, x$72, x$74, x$75, topicPartition2, leaderId2);
            long x$76 = 3L;
            long x$77 = 3L;
            short x$78 = 3;
            int x$79 = 22;
            byte x$80 = 1;
            this.check$1(x$76, x$78, x$77, x$79, x$80, topicPartition2, leaderId2);
            long x$81 = 15L;
            long x$82 = 15L;
            short x$83 = 3;
            int x$84 = 10;
            byte x$85 = 1;
            this.check$1(x$81, x$83, x$82, x$84, x$85, topicPartition2, leaderId2);
            long x$86 = 3L;
            long x$87 = 0L;
            short x$88 = 4;
            int x$89 = 2;
            byte x$90 = 2;
            this.check$1(x$86, x$88, x$87, x$89, x$90, topicPartition2, leaderId2);
            long x$91 = 15L;
            long x$92 = 10L;
            short x$93 = 4;
            int x$94 = 1;
            byte x$95 = 2;
            this.check$1(x$91, x$93, x$92, x$94, x$95, topicPartition2, leaderId2);
            long x$96 = 10L;
            long x$97 = 10L;
            short x$98 = 4;
            int x$99 = 1;
            byte x$100 = 2;
            this.check$1(x$96, x$98, x$97, x$99, x$100, topicPartition2, leaderId2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1, bar0})), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)new Serializable(this, resp1){
            public static final long serialVersionUID = 0L;
            private final FetchResponse resp1$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test created an incremental fetch session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.resp1$1.sessionId())}));
            }
            {
                this.resp1$1 = resp1$1;
            }
        });
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo0)).error);
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo1)).error);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)bar0)).error);
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get((Object)bar0)).error);
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get((Object)bar0)).error);
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    @Test
    public void testZStdCompressedTopic() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String x$101 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            StringSerializer x$102 = new StringSerializer();
            StringSerializer x$103 = new StringSerializer();
            int x$104 = TestUtils$.MODULE$.createProducer$default$2();
            long x$105 = TestUtils$.MODULE$.createProducer$default$3();
            long x$106 = TestUtils$.MODULE$.createProducer$default$4();
            int x$107 = TestUtils$.MODULE$.createProducer$default$5();
            int x$108 = TestUtils$.MODULE$.createProducer$default$6();
            int x$109 = TestUtils$.MODULE$.createProducer$default$7();
            int x$110 = TestUtils$.MODULE$.createProducer$default$8();
            String x$111 = TestUtils$.MODULE$.createProducer$default$9();
            int x$112 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$113 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$114 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$115 = TestUtils$.MODULE$.createProducer$default$13();
            this.kafka$server$FetchRequestTest$$producer_$eq(TestUtils$.MODULE$.createProducer(x$101, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$102, x$103));
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
            this.kafka$server$FetchRequestTest$$producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
            this.kafka$server$FetchRequestTest$$producer().close();
            FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
            FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error);
            FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
            FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data1.error);
            Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1).size());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testZStdCompressedRecords() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)"2.0.0")}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            int leaderId = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            int leaderId2 = tuple23._2$mcI$sp();
            String x$116 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            String x$117 = GZIPCompressionCodec$.MODULE$.name();
            StringSerializer x$118 = new StringSerializer();
            StringSerializer x$119 = new StringSerializer();
            int x$120 = TestUtils$.MODULE$.createProducer$default$2();
            long x$121 = TestUtils$.MODULE$.createProducer$default$3();
            long x$122 = TestUtils$.MODULE$.createProducer$default$4();
            int x$123 = TestUtils$.MODULE$.createProducer$default$5();
            int x$124 = TestUtils$.MODULE$.createProducer$default$6();
            int x$125 = TestUtils$.MODULE$.createProducer$default$7();
            int x$126 = TestUtils$.MODULE$.createProducer$default$8();
            int x$127 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$128 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$129 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$130 = TestUtils$.MODULE$.createProducer$default$13();
            KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$116, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$117, x$127, x$128, x$129, x$130, x$118, x$119);
            producer1.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
            producer1.close();
            String x$131 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            String x$132 = ZStdCompressionCodec$.MODULE$.name();
            StringSerializer x$133 = new StringSerializer();
            StringSerializer x$134 = new StringSerializer();
            int x$135 = TestUtils$.MODULE$.createProducer$default$2();
            long x$136 = TestUtils$.MODULE$.createProducer$default$3();
            long x$137 = TestUtils$.MODULE$.createProducer$default$4();
            int x$138 = TestUtils$.MODULE$.createProducer$default$5();
            int x$139 = TestUtils$.MODULE$.createProducer$default$6();
            int x$140 = TestUtils$.MODULE$.createProducer$default$7();
            int x$141 = TestUtils$.MODULE$.createProducer$default$8();
            int x$142 = TestUtils$.MODULE$.createProducer$default$10();
            SecurityProtocol x$143 = TestUtils$.MODULE$.createProducer$default$11();
            Option<File> x$144 = TestUtils$.MODULE$.createProducer$default$12();
            Option<Properties> x$145 = TestUtils$.MODULE$.createProducer$default$13();
            KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$131, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$132, x$142, x$143, x$144, x$145, x$133, x$134);
            producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
            producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
            producer2.close();
            FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
            FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data0.error);
            Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0).size());
            FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
            FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error);
            FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res2 = this.sendFetchRequest(leaderId2, req2);
            FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)res2.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data2.error);
            Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2).size());
            FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res3 = this.sendFetchRequest(leaderId2, req3);
            FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)res3.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error);
            FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
            FetchResponse<MemoryRecords> res4 = this.sendFetchRequest(leaderId2, req4);
            FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)res4.responseData().get(topicPartition2);
            Assert.assertEquals((Object)Errors.NONE, (Object)data4.error);
            Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4).size());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records).records()).asScala()).toBuffer();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1)new Serializable(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize){
            public static final long serialVersionUID = 0L;
            private final FetchResponse fetchResponse$1;
            private final int maxPartitionBytes$3;
            private final int numMessagesPerPartition$2;
            private final BooleanRef emptyResponseSeen$1;
            private final IntRef responseSize$1;
            private final IntRef responseBufferSize$1;

            public final void apply(TopicPartition tp) {
                FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.fetchResponse$1.responseData().get(tp);
                Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
                Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
                MemoryRecords records2 = (MemoryRecords)partitionData.records;
                this.responseBufferSize$1.elem += records2.sizeInBytes();
                Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).toBuffer();
                Assert.assertTrue((batches.size() < this.numMessagesPerPartition$2 ? 1 : 0) != 0);
                int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MutableRecordBatch x$19) {
                        return x$19.sizeInBytes();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.responseSize$1.elem += batchesSize;
                if (batchesSize == 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertEquals((long)0L, (long)records2.sizeInBytes());
                    this.emptyResponseSeen$1.elem = true;
                } else if (batchesSize != 0 && !this.emptyResponseSeen$1.elem) {
                    Assert.assertTrue((batchesSize <= this.maxPartitionBytes$3 ? 1 : 0) != 0);
                    Assert.assertEquals((long)this.maxPartitionBytes$3, (long)records2.sizeInBytes());
                } else if (batchesSize != 0 && this.emptyResponseSeen$1.elem) {
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)batchesSize)})));
                } else if (records2.sizeInBytes() != 0 && this.emptyResponseSeen$1.elem) {
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition buffer with size 0, but found ", " with size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToInteger((int)records2.sizeInBytes())})));
                }
            }
            {
                this.fetchResponse$1 = fetchResponse$1;
                this.maxPartitionBytes$3 = maxPartitionBytes$3;
                this.numMessagesPerPartition$2 = numMessagesPerPartition$2;
                this.emptyResponseSeen$1 = emptyResponseSeen$1;
                this.responseSize$1 = responseSize$1;
                this.responseBufferSize$1 = responseBufferSize$1;
            }
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.topicConfig$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        });
        return ((TraversableOnce)topics.flatMap((Function1)new Serializable(this, numPartitions, topicConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;
            private final int numPartitions$1;
            private final Properties topicConfig$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(String topic) {
                scala.collection.immutable.Map<Object, Object> partitionToLeader = this.$outer.createTopic(topic, this.numPartitions$1, 2, this.topicConfig$1);
                return (scala.collection.immutable.Map)partitionToLeader.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            int leader2 = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic$2, partition)), (Object)BoxesRunTime.boxToInteger((int)leader2));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numPartitions$1 = numPartitions$1;
                this.topicConfig$1 = topicConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records2 = (Seq)topicPartitions.toSeq().flatMap((Function1)new Serializable(this, numMessagesPerPartition){
            public static final long serialVersionUID = 0L;
            private final int numMessagesPerPartition$1;

            public final IndexedSeq<ProducerRecord<String, String>> apply(TopicPartition tp) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numMessagesPerPartition$1).map((Function1)new Serializable(this, tp){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition tp$1;

                    public final ProducerRecord<String, String> apply(int messageIndex) {
                        String suffix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToInteger((int)messageIndex)}));
                        return new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix})));
                    }
                    {
                        this.tp$1 = tp$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numMessagesPerPartition$1 = numMessagesPerPartition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final RecordMetadata apply(ProducerRecord<String, String> x$20) {
                return (RecordMetadata)this.$outer.kafka$server$FetchRequestTest$$producer().send(x$20).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(brokerId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$1);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
    }

    /*
     * WARNING - void declaration
     */
    public final Option kafka$server$FetchRequestTest$$fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$2, int leaderId$2, int batchSize$1) {
        Some some;
        Socket socket;
        block3: {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$2}))), this.createPartitionMap$default$3())).build(version);
            socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());
            try {
                this.send((AbstractRequest)fetchRequest, ApiKeys.FETCH, socket, fetchRequest.version());
                if (closeAfterPartialResponse) {
                    int size2 = new DataInputStream(socket.getInputStream()).readInt();
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch size too small ", ", broker may have run out of memory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})), (size2 > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                    some = None$.MODULE$;
                    break block3;
                }
                some = new Some((Object)FetchResponse.parse((ByteBuffer)this.receive(socket, ApiKeys.FETCH.responseHeaderVersion(version)), (short)version));
            }
            catch (Throwable throwable) {
                void var8_8;
                var8_8.close();
                throw throwable;
            }
        }
        socket.close();
        return some;
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$3, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$3}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$3), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$3);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((List)JavaConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }
}

