/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.controller;

import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import unit.kafka.controller.ControllerContextTest$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u0013\t)2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;UKN$(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0003\u000b\u0019\tQa[1gW\u0006T\u0011aB\u0001\u0005k:LGo\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!9a\u0003\u0001a\u0001\n\u00039\u0012aB2p]R,\u0007\u0010^\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111a\u0007\u0006\u0002\u000b%\u0011QD\u0007\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bbB\u0010\u0001\u0001\u0004%\t\u0001I\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002\"IA\u00111BI\u0005\u0003G1\u0011A!\u00168ji\"9QEHA\u0001\u0002\u0004A\u0012a\u0001=%c!1q\u0005\u0001Q!\na\t\u0001bY8oi\u0016DH\u000f\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0003\u001d\u0011'o\\6feN,\u0012a\u000b\t\u0004YQ:dBA\u00173\u001d\tq\u0013'D\u00010\u0015\t\u0001\u0004\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0007D\u0001\ba\u0006\u001c7.Y4f\u0013\t)dGA\u0002TKFT!a\r\u0007\u0011\u0005-A\u0014BA\u001d\r\u0005\rIe\u000e\u001e\u0005\u0007w\u0001\u0001\u000b\u0011B\u0016\u0002\u0011\t\u0014xn[3sg\u0002Bq!\u0010\u0001C\u0002\u0013\u0005a(A\u0002uaF*\u0012a\u0010\t\u0003\u0001\"k\u0011!\u0011\u0006\u0003\u0005\u000e\u000baaY8n[>t'BA\u0003E\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0017\u0002\u0001\u000b\u0011B \u0002\tQ\u0004\u0018\u0007\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001?\u0003\r!\bO\r\u0005\u0007\u001f\u0002\u0001\u000b\u0011B \u0002\tQ\u0004(\u0007\t\u0005\b#\u0002\u0011\r\u0011\"\u0001?\u0003\r!\bo\r\u0005\u0007'\u0002\u0001\u000b\u0011B \u0002\tQ\u00048\u0007\t\u0005\u0006+\u0002!\tAV\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002C!\u0012A\u000b\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\u001a\u000bQA[;oSRL!!\u0018.\u0003\r\t+gm\u001c:f\u0011\u0015y\u0006\u0001\"\u0001W\u0003\u0001#Xm\u001d;Va\u0012\fG/\u001a)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;P]2L\bF\u00010b!\tI&-\u0003\u0002d5\n!A+Z:u\u0011\u0015)\u0007\u0001\"\u0001W\u0003M#Xm\u001d;Va\u0012\fG/\u001a)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;P]2L\u0018I\u001c3E_\u0016\u001chj\u001c;Pm\u0016\u0014xO]5uK\"\u0012A-\u0019\u0005\u0006Q\u0002!\tAV\u0001Ai\u0016\u001cH/\u00169eCR,\u0007+\u0019:uSRLwN\u001c$vY2\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^+qI\u0006$Xm\u001d*fa2L7-Y!tg&<g.\\3oi\"\u0012q-\u0019\u0005\u0006W\u0002!\tAV\u0001Li\u0016\u001cH\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R\u0014V\r^;s]N,U\u000e\u001d;z'\u0016\f\u0018J\u001a+pa&\u001cwJ\u001d)beRLG/[8o\t>,7OT8u\u000bbL7\u000f\u001e\u0015\u0003U\u0006DQA\u001c\u0001\u0005\u0002Y\u000ba\u000b^3tiB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9us\u0006\u001b8/[4o[\u0016tG/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u00055\f\u0007\"B9\u0001\t\u00031\u0016\u0001\u0013;fgR\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\r>\u0014Hk\u001c9jGJ+G/\u001e:og\u0016k\u0007\u000f^=NCBLe\rV8qS\u000e$u.Z:O_R,\u00050[:uQ\t\u0001\u0018\rC\u0003u\u0001\u0011\u0005a+A$uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\u001a{'\u000fV8qS\u000e\u0014V\r^;s]N,\u0005\u0010]3di\u0016$'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;tQ\t\u0019\u0018\rC\u0003x\u0001\u0011\u0005a+\u0001\u0010uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\"\u0012a/\u0019\u0005\u0006u\u0002!\tAV\u0001\u000fi\u0016\u001cHOU3bgNLwM\u001c+pQ\tI\u0018\r")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @Before
    public void setUp() {
        this.context_$eq(new ControllerContext());
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Broker, Object> apply(int brokerId) {
                EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.context().setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2(), this.tp3()}))).foreach((Function1)new Serializable(this, leaderIndex){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ControllerContextTest $outer;
            public final IntRef leaderIndex$1;

            public final void apply(TopicPartition partition) {
                IndexedSeq replicas = (IndexedSeq)this.$outer.brokers().indices().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setUp$1 $outer;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply$mcII$sp(int i) {
                        void var2_2;
                        int replica = BoxesRunTime.unboxToInt((Object)this.$outer.unit$kafka$controller$ControllerContextTest$$anonfun$$$outer().brokers().apply((i + this.$outer.leaderIndex$1.elem) % this.$outer.unit$kafka$controller$ControllerContextTest$$anonfun$$$outer().brokers().size()));
                        return (int)var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.context().updatePartitionReplicaAssignment(partition, (Seq)replicas);
                ++this.leaderIndex$1.elem;
            }

            public /* synthetic */ ControllerContextTest unit$kafka$controller$ControllerContextTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderIndex$1 = leaderIndex$1;
            }
        });
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionReplicaAssignment(this.tp1(), expectedReplicas);
        Seq assignment2 = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedReplicas, (Object)assignment2);
        Assert.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnlyAndDoesNotOverwrite() {
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        this.context().updatePartitionReplicaAssignment(this.tp1(), expectedReplicas);
        Seq assignment2 = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedReplicas, (Object)assignment2);
        Assert.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionReplicaAssignment(this.tp1(), initialReplicas);
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assert.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assert.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        scala.collection.immutable.Map expectedAssignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assert.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})));
        Assert.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassigningPartition.targetReplicas());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassigningPartition2.targetReplicas());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Assert.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Object)reassigningPartition3.targetReplicas());
        ReplicaAssignment partition = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Assert.assertFalse((boolean)partition.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Object)partition.targetReplicas());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.fromOldAndNewReplicas((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Object)reassigningPartition4.targetReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.fromOldAndNewReplicas((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.targetReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.fromOldAndNewReplicas((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.targetReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assert.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment2 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        ReplicaAssignment firstReassign = assignment2.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign);
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assert.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)assignment2.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assert.assertEquals((Object)assignment2, (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
    }
}

