/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=e!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011A\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0003'1\t!![8\n\u0005U\u0011\"!C\"m_N,\u0017M\u00197f\u0011!9\u0002A!a\u0001\n\u0003A\u0012\u0001\u00024jY\u0016,\u0012!\u0007\t\u0003#iI!a\u0007\n\u0003\t\u0019KG.\u001a\u0005\t;\u0001\u0011\t\u0019!C\u0001=\u0005Aa-\u001b7f?\u0012*\u0017\u000f\u0006\u0002 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5u\u0011\u001d1C$!AA\u0002e\t1\u0001\u001f\u00132\u0011!A\u0003A!A!B\u0013I\u0012!\u00024jY\u0016\u0004\u0003FA\u0014+!\t\u00013&\u0003\u0002-C\tAao\u001c7bi&dW\r\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002aA\u0011\u0001%M\u0005\u0003e\u0005\u0012A\u0001T8oO\"AA\u0007\u0001B\u0001B\u0003%\u0001'A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\u0016\u0003a\u0002\"\u0001I\u001d\n\u0005i\n#aA%oi\"AA\b\u0001B\u0001B\u0003%\u0001(A\u0007nCbLe\u000eZ3y'&TX\r\t\u0005\t}\u0001\u0011)\u0019!C\u0001\u007f\u0005AqO]5uC\ndW-F\u0001A!\t\u0001\u0013)\u0003\u0002CC\t9!i\\8mK\u0006t\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u0013]\u0014\u0018\u000e^1cY\u0016\u0004\u0003\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\bF\u0003I\u0015.cU\n\u0005\u0002J\u00015\t!\u0001C\u0003\u0018\u000b\u0002\u0007\u0011\u0004C\u0003/\u000b\u0002\u0007\u0001\u0007C\u00047\u000bB\u0005\t\u0019\u0001\u001d\t\u000by*\u0005\u0019\u0001!\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013y\u0013aB0mK:<G\u000f\u001b\u0005\n#\u0002\u0001\r\u00111A\u0005\nI\u000b1b\u00187f]\u001e$\bn\u0018\u0013fcR\u0011qd\u0015\u0005\bMA\u000b\t\u00111\u00011\u0011\u0019)\u0006\u0001)Q\u0005a\u0005Aq\f\\3oORD\u0007\u0005\u000b\u0002UU!)\u0001\f\u0001D\to\u0005IQM\u001c;ssNK'0\u001a\u0005\u00065\u0002!\tbN\u0001\r?^\f'/\\#oiJLWm\u001d\u0005\b9\u0002\u0011\r\u0011\"\u0005^\u0003\u0011awnY6\u0016\u0003y\u0003\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u000b1|7m[:\u000b\u0005\r$\u0017AC2p]\u000e,(O]3oi*\u0011Q\rD\u0001\u0005kRLG.\u0003\u0002hA\ni!+Z3oiJ\fg\u000e\u001e'pG.Da!\u001b\u0001!\u0002\u0013q\u0016!\u00027pG.\u0004\u0003bB6\u0001\u0001\u0004%\t\u0002\\\u0001\u0005[6\f\u0007/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001H\"A\u0002oS>L!A]8\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\bb\u0002;\u0001\u0001\u0004%\t\"^\u0001\t[6\f\u0007o\u0018\u0013fcR\u0011qD\u001e\u0005\bMM\f\t\u00111\u0001n\u0011\u0019A\b\u0001)Q\u0005[\u0006)Q.\\1qA!\u0012qO\u000b\u0005\u0007w\u0002\u0001\u000b\u0015\u0002\u001d\u0002\u0017}k\u0017\r_#oiJLWm\u001d\u0015\u0003u*BqA \u0001A\u0002\u0013Eq'\u0001\u0005`K:$(/[3t\u0011%\t\t\u0001\u0001a\u0001\n#\t\u0019!\u0001\u0007`K:$(/[3t?\u0012*\u0017\u000fF\u0002 \u0003\u000bAqAJ@\u0002\u0002\u0003\u0007\u0001\bC\u0004\u0002\n\u0001\u0001\u000b\u0015\u0002\u001d\u0002\u0013}+g\u000e\u001e:jKN\u0004\u0003fAA\u0004U!1\u0011q\u0002\u0001\u0005\u0002}\na![:Gk2d\u0007BBA\n\u0001\u0011\u0005q'\u0001\u0006nCb,e\u000e\u001e:jKNDa!a\u0006\u0001\t\u00039\u0014aB3oiJLWm\u001d\u0005\u0007\u00037\u0001A\u0011A\u0018\u0002\r1,gn\u001a;i\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\taA]3tSj,Gc\u0001!\u0002$!9\u0011QEA\u000f\u0001\u0004A\u0014a\u00028foNK'0\u001a\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003!\u0011XM\\1nKR{GcA\u0010\u0002.!9\u0011qFA\u0014\u0001\u0004I\u0012!\u00014\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005)a\r\\;tQR\tq\u0004C\u0004\u0002:\u0001!\t!a\u000f\u0002\u001d\u0011,G.\u001a;f\u0013\u001a,\u00050[:ugR\t\u0001\tC\u0004\u0002@\u0001!\t!!\u000e\u0002\u001fQ\u0014\u0018.\u001c+p-\u0006d\u0017\u000eZ*ju\u0016Da!a\u0011\u0001\t\u00039\u0014aC:ju\u0016LeNQ=uKNDq!a\u0012\u0001\t\u0003\t)$A\u0003dY>\u001cX\rC\u0004\u0002L\u0001!\t!!\u000e\u0002\u0019\rdwn]3IC:$G.\u001a:\t\u000f\u0005=\u0003A\"\u0001\u00026\u0005Y1/\u00198jif\u001c\u0005.Z2l\u0011\u001d\t\u0019\u0006\u0001D\t\u0003k\t\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0005\b\u0003/\u0002a\u0011AA-\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004?\u0005m\u0003bBA/\u0003+\u0002\r\u0001M\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u00026\u0005)!/Z:fi\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014A\u0004:fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0004q\u0005%\u0004bBA/\u0003G\u0002\r\u0001\r\u0005\b\u0003[\u0002A\u0011AA8\u0003=\u0019\u0017M\\!qa\u0016tGm\u00144gg\u0016$Hc\u0001!\u0002r!9\u0011QLA6\u0001\u0004\u0001\u0004bBA;\u0001\u0011E\u0011QG\u0001\u000fg\u00064WMR8sG\u0016,f.\\1q\u0011!\tI\b\u0001C\t\u0005\u0005U\u0012A\u00034pe\u000e,WK\\7ba\"9\u0011Q\u0010\u0001\u0005\u0012\u0005}\u0014!C7bs\n,Gj\\2l+\u0011\t\t)!#\u0015\t\u0005\r\u0015Q\u0015\u000b\u0005\u0003\u000b\u000bY\n\u0005\u0003\u0002\b\u0006%E\u0002\u0001\u0003\t\u0003\u0017\u000bYH1\u0001\u0002\u000e\n\tA+\u0005\u0003\u0002\u0010\u0006U\u0005c\u0001\u0011\u0002\u0012&\u0019\u00111S\u0011\u0003\u000f9{G\u000f[5oOB\u0019\u0001%a&\n\u0007\u0005e\u0015EA\u0002B]fD\u0011\"!(\u0002|\u0011\u0005\r!a(\u0002\u0007\u0019,h\u000eE\u0003!\u0003C\u000b))C\u0002\u0002$\u0006\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b9\u0006m\u0004\u0019AAT!\ry\u0016\u0011V\u0005\u0004\u0003W\u0003'\u0001\u0002'pG.Dq!a,\u0001\r#\t\t,\u0001\u0006qCJ\u001cX-\u00128uef$b!a-\u0002:\u0006\r\u0007cA%\u00026&\u0019\u0011q\u0017\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010\u0003\u0005\u0002<\u00065\u0006\u0019AA_\u0003\u0019\u0011WO\u001a4feB\u0019a.a0\n\u0007\u0005\u0005wN\u0001\u0006CsR,')\u001e4gKJDq!!2\u0002.\u0002\u0007\u0001(A\u0001o\u0011\u001d\tI\r\u0001C\t\u0003\u0017\f\u0001\u0004\\1sO\u0016\u001cH\u000fT8xKJ\u0014u.\u001e8e'2|GOR8s)\u001dA\u0014QZAi\u0003+D\u0001\"a4\u0002H\u0002\u0007\u0011QX\u0001\u0004S\u0012D\bbBAj\u0003\u000f\u0004\r\u0001M\u0001\u0007i\u0006\u0014x-\u001a;\t\u0011\u0005]\u0017q\u0019a\u0001\u00033\fAb]3be\u000eDWI\u001c;jif\u0004B!a7\u0002p:!\u0011Q\\Av\u001d\u0011\ty.!;\u000f\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:\u0007\u0003\u0019a$o\\8u}%\tQ!\u0003\u0002\u0004\t%\u0019\u0011Q\u001e\u0002\u0002\u001f%sG-\u001a=TK\u0006\u00148\r\u001b+za\u0016LA!!=\u0002t\n\t\u0012J\u001c3fqN+\u0017M]2i\u000b:$\u0018\u000e^=\u000b\u0007\u00055(\u0001C\u0004\u0002x\u0002!\t\"!?\u00023Ml\u0017\r\u001c7fgR,\u0006\u000f]3s\u0005>,h\u000eZ*m_R4uN\u001d\u000b\bq\u0005m\u0018Q`A\u0000\u0011!\ty-!>A\u0002\u0005u\u0006bBAj\u0003k\u0004\r\u0001\r\u0005\t\u0003/\f)\u00101\u0001\u0002Z\"9!1\u0001\u0001\u0005\n\t\u0015\u0011!E5oI\u0016D8\u000b\\8u%\u0006tw-\u001a$peRA!q\u0001B\u0007\u0005\u001f\u0011\t\u0002E\u0003!\u0005\u0013A\u0004(C\u0002\u0003\f\u0005\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAh\u0005\u0003\u0001\r!!0\t\u000f\u0005M'\u0011\u0001a\u0001a!A\u0011q\u001bB\u0001\u0001\u0004\tI\u000eC\u0004\u0003\u0016\u0001!IAa\u0006\u0002#\r|W\u000e]1sK&sG-\u001a=F]R\u0014\u0018\u0010F\u00049\u00053\u0011iBa\b\t\u0011\tm!1\u0003a\u0001\u0003g\u000b!\"\u001b8eKb,e\u000e\u001e:z\u0011\u001d\t\u0019Na\u0005A\u0002AB\u0001\"a6\u0003\u0014\u0001\u0007\u0011\u0011\u001c\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0003a\u0011x.\u001e8e\t><h\u000eV8Fq\u0006\u001cG/T;mi&\u0004H.\u001a\u000b\u0006q\t\u001d\"1\u0006\u0005\b\u0005S\u0011\t\u00031\u00019\u0003\u0019qW/\u001c2fe\"9!Q\u0006B\u0011\u0001\u0004A\u0014A\u00024bGR|'\u000fC\u0004\u00032\u0001!IAa\r\u0002\u0015Q|'+\u001a7bi&4X\r\u0006\u0003\u00036\tm\u0002\u0003\u0002\u0011\u00038aJ1A!\u000f\"\u0005\u0019y\u0005\u000f^5p]\"9\u0011Q\fB\u0018\u0001\u0004\u0001ta\u0002B \u0005!\u0005!\u0011I\u0001\u000e\u0003\n\u001cHO]1di&sG-\u001a=\u0011\u0007%\u0013\u0019E\u0002\u0004\u0002\u0005!\u0005!QI\n\u0007\u0005\u0007\u00129E!\u0014\u0011\u0007\u0001\u0012I%C\u0002\u0003L\u0005\u0012a!\u00118z%\u00164\u0007\u0003\u0002B(\u0005+j!A!\u0015\u000b\u0007\tMC!A\u0003vi&d7/\u0003\u0003\u0003X\tE#a\u0002'pO\u001eLgn\u001a\u0005\b\r\n\rC\u0011\u0001B.)\t\u0011\t\u0005\u0003\u0006\u0003`\t\r#\u0019!C!\u0005C\n!\u0002\\8hO\u0016\u0014h*Y7f+\t\u0011\u0019\u0007\u0005\u0003\u0003f\t-db\u0001\u0011\u0003h%\u0019!\u0011N\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iGa\u001c\u0003\rM#(/\u001b8h\u0015\r\u0011I'\t\u0005\n\u0005g\u0012\u0019\u0005)A\u0005\u0005G\n1\u0002\\8hO\u0016\u0014h*Y7fA!Q!q\u000fB\"#\u0003%\tA!\u001f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YHK\u00029\u0005{Z#Aa \u0011\t\t\u0005%1R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0013\u000b\u0013AC1o]>$\u0018\r^5p]&!!Q\u0012BB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class AbstractIndex
implements Closeable {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long kafka$log$AbstractIndex$$_length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        AbstractIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        AbstractIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        AbstractIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        AbstractIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        AbstractIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return AbstractIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return AbstractIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        AbstractIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return AbstractIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        AbstractIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return AbstractIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return AbstractIndex$.MODULE$.logger();
    }

    public static int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public long kafka$log$AbstractIndex$$_length() {
        return this.kafka$log$AbstractIndex$$_length;
    }

    public void kafka$log$AbstractIndex$$_length_$eq(long x$1) {
        this.kafka$log$AbstractIndex$$_length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this.kafka$log$AbstractIndex$$_length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                boolean bl;
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                if (this.$outer.kafka$log$AbstractIndex$$_length() == (long)roundedNewSize) {
                    AbstractIndex$.MODULE$.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " was not resized because it already has size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    return false;
                }
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                try {
                    int position = this.$outer.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.$outer.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$AbstractIndex$$_length_$eq(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    this.$outer.mmap().position(position);
                    AbstractIndex$.MODULE$.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resized ", " to ", ", position is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().position())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and limit is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().limit())}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    bl = true;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
                    throw throwable;
                }
                return bl;
            }

            public /* synthetic */ AbstractIndex kafka$log$AbstractIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset2) {
        Option<Object> relativeOffset = this.toRelative(offset2);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow for offset: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.file().getAbsoluteFile()})));
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset2) {
        return this.toRelative(offset2).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            AbstractIndex$.MODULE$.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Long.compare(indexEntry.indexKey(), target);
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Long.compare(indexEntry.indexValue(), target);
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset2) {
        long relativeOffset = offset2 - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this.kafka$log$AbstractIndex$$_length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.kafka$log$AbstractIndex$$_length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.kafka$log$AbstractIndex$$_length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

